/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class DeleteMethodArgument
extends Recipe {
    private final String methodPattern;
    private final Integer argumentIndex;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new DeleteMethodArgumentVisitor(new MethodMatcher(this.methodPattern));
    }

    @ConstructorProperties(value={"methodPattern", "argumentIndex"})
    public DeleteMethodArgument(String methodPattern, Integer argumentIndex) {
        this.methodPattern = methodPattern;
        this.argumentIndex = argumentIndex;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public Integer getArgumentIndex() {
        return this.argumentIndex;
    }

    public String toString() {
        return "DeleteMethodArgument(methodPattern=" + this.getMethodPattern() + ", argumentIndex=" + this.getArgumentIndex() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteMethodArgument)) {
            return false;
        }
        DeleteMethodArgument other = (DeleteMethodArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$argumentIndex = this.getArgumentIndex();
        Integer other$argumentIndex = other.getArgumentIndex();
        if (this$argumentIndex == null ? other$argumentIndex != null : !((Object)this$argumentIndex).equals(other$argumentIndex)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteMethodArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $argumentIndex = this.getArgumentIndex();
        result = result * 59 + ($argumentIndex == null ? 43 : ((Object)$argumentIndex).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private class DeleteMethodArgumentVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public DeleteMethodArgumentVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            List<JRightPadded<Expression>> originalArgs = ((J.MethodInvocation)m).getArgs().getElem();
            if (this.methodMatcher.matches((J.MethodInvocation)m) && originalArgs.stream().filter(a -> !(a.getElem() instanceof J.Empty)).count() >= (long)(DeleteMethodArgument.this.argumentIndex + 1)) {
                List<JRightPadded<Object>> args = new ArrayList(((J.MethodInvocation)m).getArgs().getElem());
                args.remove(DeleteMethodArgument.this.argumentIndex);
                if (args.isEmpty()) {
                    args = Collections.singletonList(new JRightPadded<J.Empty>(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), Space.EMPTY, Markers.EMPTY));
                }
                m = ((J.MethodInvocation)m).withArgs(((J.MethodInvocation)m).getArgs().withElem(args));
            }
            return m;
        }
    }
}

