/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.Objects;
import org.openrewrite.Incubating;
import org.openrewrite.java.JavaProcessor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

@Incubating(since="6.0.0")
public class SemanticallyEqual {
    private SemanticallyEqual() {
    }

    public static boolean areEqual(J firstElem, J secondElem) {
        SemanticallyEqualProcessor sep = new SemanticallyEqualProcessor();
        sep.visit(firstElem, secondElem);
        return sep.isEqual;
    }

    private static class SemanticallyEqualProcessor
    extends JavaProcessor<J> {
        boolean isEqual = true;

        SemanticallyEqualProcessor() {
        }

        @Override
        public J visitAnnotation(J.Annotation firstAnnotation, J second) {
            if (!(second instanceof J.Annotation)) {
                this.isEqual = false;
                return null;
            }
            J.Annotation secondAnnotation = (J.Annotation)second;
            if (firstAnnotation.getArgs() != null && secondAnnotation.getArgs() != null) {
                if (firstAnnotation.getArgs().getElem() != null && secondAnnotation.getArgs().getElem() != null && firstAnnotation.getArgs().getElem().size() == secondAnnotation.getArgs().getElem().size()) {
                    List<JRightPadded<Expression>> firstArgs = firstAnnotation.getArgs().getElem();
                    List<JRightPadded<Expression>> secondArgs = secondAnnotation.getArgs().getElem();
                    for (int i = 0; i < firstArgs.size(); ++i) {
                        this.visit(firstArgs.get(i).getElem(), secondArgs.get(i).getElem());
                    }
                } else {
                    this.isEqual = false;
                    return null;
                }
                this.visitTypeName(firstAnnotation.getAnnotationType(), secondAnnotation.getAnnotationType());
            }
            return null;
        }

        @Override
        public J visitIdentifier(J.Ident firstIdent, J second) {
            if (!(second instanceof J.Ident)) {
                this.isEqual = false;
                return null;
            }
            J.Ident secondIdent = (J.Ident)second;
            this.isEqual = this.isEqual && Objects.equals(firstIdent.getType(), secondIdent.getType()) && firstIdent.getSimpleName().equals(secondIdent.getSimpleName());
            return null;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess firstFieldAccess, J second) {
            if (!(second instanceof J.FieldAccess)) {
                this.isEqual = false;
                return null;
            }
            J.FieldAccess secondFieldAccess = (J.FieldAccess)second;
            if (firstFieldAccess.getSimpleName().equals("class")) {
                if (!secondFieldAccess.getSimpleName().equals("class")) {
                    this.isEqual = false;
                    return null;
                }
                this.isEqual = this.isEqual && SemanticallyEqualProcessor.typeEquals(firstFieldAccess.getType(), secondFieldAccess.getType()) && SemanticallyEqualProcessor.typeEquals(firstFieldAccess.getTarget().getType(), secondFieldAccess.getTarget().getType());
            }
            return null;
        }

        @Override
        public J visitAssign(J.Assign firstAssign, J second) {
            if (!(second instanceof J.Assign)) {
                this.isEqual = false;
                return null;
            }
            J.Assign secondAssign = (J.Assign)second;
            this.isEqual = this.isEqual && Objects.equals(firstAssign.getType(), secondAssign.getType()) && SemanticallyEqual.areEqual(firstAssign.getVariable(), secondAssign.getVariable()) && SemanticallyEqual.areEqual(firstAssign.getAssignment().getElem(), secondAssign.getAssignment().getElem());
            return null;
        }

        @Override
        public J visitLiteral(J.Literal firstLiteral, J second) {
            if (!(second instanceof J.Literal)) {
                this.isEqual = false;
                return null;
            }
            J.Literal secondLiteral = (J.Literal)second;
            this.isEqual = this.isEqual && Objects.equals(firstLiteral.getValue(), secondLiteral.getValue());
            return null;
        }

        @Override
        public NameTree visitTypeName(NameTree firstTypeName, J second) {
            if (!(second instanceof NameTree)) {
                this.isEqual = false;
                return null;
            }
            NameTree secondTypeName = (NameTree)second;
            this.isEqual = this.isEqual && SemanticallyEqualProcessor.identEquals((J.Ident)firstTypeName, (J.Ident)secondTypeName);
            return null;
        }

        private static boolean identEquals(J.Ident thisIdent, J.Ident otherIdent) {
            return Objects.equals(thisIdent.getSimpleName(), otherIdent.getSimpleName()) && SemanticallyEqualProcessor.typeEquals(thisIdent.getType(), otherIdent.getType());
        }

        private static boolean typeEquals(JavaType thisType, JavaType otherType) {
            if (thisType == null) {
                return otherType == null;
            }
            if (thisType instanceof JavaType.FullyQualified) {
                if (!(otherType instanceof JavaType.FullyQualified)) {
                    return false;
                }
                return ((JavaType.FullyQualified)thisType).getFullyQualifiedName().equals(((JavaType.FullyQualified)otherType).getFullyQualifiedName());
            }
            return thisType.deepEquals(otherType);
        }
    }
}

