/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindMethod
extends Recipe {
    private String signature;

    public FindMethod() {
        this.processor = () -> new FindMethodProcessor(this.signature);
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Validated validate() {
        return Validated.required((String)"signature", (Object)this.signature);
    }

    public static Set<J.MethodInvocation> find(J j, String clazz) {
        return ((J)new FindMethodProcessor(clazz).visit(j, ExecutionContext.builder().build())).findMarkedWith(SearchResult.class);
    }

    private static class FindMethodProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final MethodMatcher matcher;

        public FindMethodProcessor(String signature) {
            this.matcher = new MethodMatcher(signature);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.matcher.matches(method)) {
                return ((J.MethodInvocation)m).withMarkers(((J.MethodInvocation)m).getMarkers().add((Marker)new SearchResult()));
            }
            return super.visitMethodInvocation((J.MethodInvocation)m, ctx);
        }
    }
}

