/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class FindField
extends Recipe {
    private String fullyQualifiedName;

    public FindField() {
        this.processor = () -> new FindFieldsProcessor(this.fullyQualifiedName);
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Validated validate() {
        return Validated.required((String)"fullyQualifiedName", (Object)this.fullyQualifiedName);
    }

    public static Set<J.VariableDecls> find(J j, String clazz) {
        return ((J)new FindFieldsProcessor(clazz).visit(j, ExecutionContext.builder().build())).findMarkedWith(SearchResult.class);
    }

    private static final class FindFieldsProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final String fullyQualifiedName;

        public FindFieldsProcessor(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public J.VariableDecls visitMultiVariable(J.VariableDecls multiVariable, ExecutionContext ctx) {
            if (multiVariable.getTypeExpr() instanceof J.MultiCatch) {
                return multiVariable;
            }
            if (multiVariable.getTypeExpr() != null && TypeUtils.hasElementType(multiVariable.getTypeExpr().getType(), this.fullyQualifiedName)) {
                return multiVariable.withMarkers(multiVariable.getMarkers().add((Marker)new SearchResult()));
            }
            return multiVariable;
        }
    }
}

