/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class JavaPrinter<P>
implements JavaVisitor<String, P> {
    private final TreePrinter<P> treePrinter;

    public JavaPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    public String defaultValue(@Nullable Tree tree, P p) {
        return "";
    }

    public String visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return this.defaultValue((Tree)null, (Object)p);
        }
        J t = (J)this.treePrinter.doFirst((Tree)((J)tree), p);
        if (t == null) {
            return this.defaultValue((Tree)null, (Object)p);
        }
        return this.treePrinter.doLast(tree, (String)t.accept(this, p), p);
    }

    public String visit(@Nullable List<? extends J> nodes, P p) {
        if (nodes == null) {
            return "";
        }
        StringBuilder acc = new StringBuilder();
        for (J j : nodes) {
            acc.append((String)this.visit((Tree)j, (Object)p));
        }
        return acc.toString();
    }

    protected String visit(List<? extends JRightPadded<? extends J>> nodes, String suffixBetween, P p) {
        StringBuilder acc = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            acc.append((String)this.visit((Tree)node.getElem(), (Object)p)).append(this.visit(node.getAfter()));
            if (i >= nodes.size() - 1) continue;
            acc.append(suffixBetween);
        }
        return acc.toString();
    }

    protected String visit(String before, @Nullable JContainer<? extends J> container, String suffixBetween, @Nullable String after, P p) {
        if (container == null) {
            return "";
        }
        return this.visit(container.getBefore()) + before + this.visit(container.getElem(), suffixBetween, p) + (after == null ? "" : after);
    }

    protected String visit(@Nullable Space space) {
        if (space == null) {
            return "";
        }
        StringBuilder fmt = new StringBuilder(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            switch (comment.getStyle()) {
                case LINE: {
                    fmt.append("//").append(comment.getText());
                    break;
                }
                case BLOCK: {
                    fmt.append("/*").append(comment.getText()).append("*/");
                    break;
                }
                case JAVADOC: {
                    fmt.append("/**").append(comment.getText()).append("*/");
                }
            }
            fmt.append(comment.getSuffix());
        }
        return fmt.toString();
    }

    protected String fmt(@Nullable J tree, @Nullable String code) {
        return tree == null || code == null ? "" : this.visit(tree.getPrefix()) + code;
    }

    protected String visit(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, P p) {
        return leftPadded == null ? "" : this.visit(leftPadded.getBefore()) + (prefix == null ? "" : prefix) + (String)this.visit((Tree)leftPadded.getElem(), (Object)p);
    }

    protected String visit(@Nullable JRightPadded<? extends J> rightPadded, @Nullable String suffix, P p) {
        return rightPadded == null ? "" : (String)this.visit((Tree)rightPadded.getElem(), (Object)p) + this.visit(rightPadded.getAfter()) + (suffix == null ? "" : suffix);
    }

    protected String visitModifiers(Iterable<J.Modifier> modifiers) {
        StringBuilder acc = new StringBuilder();
        for (J.Modifier mod : modifiers) {
            String keyword = "";
            switch (mod.getType()) {
                case Default: {
                    keyword = "default";
                    break;
                }
                case Public: {
                    keyword = "public";
                    break;
                }
                case Protected: {
                    keyword = "protected";
                    break;
                }
                case Private: {
                    keyword = "private";
                    break;
                }
                case Abstract: {
                    keyword = "abstract";
                    break;
                }
                case Static: {
                    keyword = "static";
                    break;
                }
                case Final: {
                    keyword = "final";
                    break;
                }
                case Native: {
                    keyword = "native";
                    break;
                }
                case Strictfp: {
                    keyword = "strictfp";
                    break;
                }
                case Synchronized: {
                    keyword = "synchronized";
                    break;
                }
                case Transient: {
                    keyword = "transient";
                    break;
                }
                case Volatile: {
                    keyword = "volatile";
                }
            }
            acc.append(this.fmt(mod, keyword));
        }
        return acc.toString();
    }

    @Override
    public String visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        return this.fmt(annotatedType, this.visit(annotatedType.getAnnotations(), p) + (String)this.visit((Tree)annotatedType.getTypeExpr(), (Object)p));
    }

    @Override
    public String visitAnnotation(J.Annotation annotation, P p) {
        String args = annotation.getArgs() == null ? "" : this.visit("(", annotation.getArgs(), ",", ")", p);
        return this.fmt(annotation, "@" + (String)this.visit((Tree)annotation.getAnnotationType(), (Object)p) + args);
    }

    @Override
    public String visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        return this.fmt(arrayAccess, (String)this.visit((Tree)arrayAccess.getIndexed(), (Object)p) + (String)this.visit((Tree)arrayAccess.getDimension(), (Object)p));
    }

    @Override
    public String visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        return this.fmt(arrayDimension, "[" + this.visit(arrayDimension.getIndex(), "]", p));
    }

    @Override
    public String visitArrayType(J.ArrayType arrayType, P p) {
        StringBuilder dimensions = new StringBuilder();
        for (JRightPadded<Space> d : arrayType.getDimensions()) {
            dimensions.append(this.visit(d.getElem())).append('[').append(this.visit(d.getAfter())).append(']');
        }
        return this.fmt(arrayType, (String)this.visit((Tree)arrayType.getElementType(), (Object)p) + dimensions.toString());
    }

    @Override
    public String visitAssert(J.Assert azzert, P p) {
        return this.fmt(azzert, "assert" + (String)this.visit((Tree)azzert.getCondition(), (Object)p));
    }

    @Override
    public String visitAssign(J.Assign assign, P p) {
        return this.fmt(assign, (String)this.visit((Tree)assign.getVariable(), (Object)p) + this.visit("=", assign.getAssignment(), p));
    }

    @Override
    public String visitAssignOp(J.AssignOp assignOp, P p) {
        String keyword = "";
        switch (assignOp.getOperator().getElem()) {
            case Addition: {
                keyword = "+=";
                break;
            }
            case Subtraction: {
                keyword = "-=";
                break;
            }
            case Multiplication: {
                keyword = "*=";
                break;
            }
            case Division: {
                keyword = "/=";
                break;
            }
            case Modulo: {
                keyword = "%=";
                break;
            }
            case BitAnd: {
                keyword = "&=";
                break;
            }
            case BitOr: {
                keyword = "|=";
                break;
            }
            case BitXor: {
                keyword = "^=";
                break;
            }
            case LeftShift: {
                keyword = "<<=";
                break;
            }
            case RightShift: {
                keyword = ">>=";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>=";
            }
        }
        return this.fmt(assignOp, (String)this.visit((Tree)assignOp.getVariable(), (Object)p) + this.visit(assignOp.getOperator().getBefore()) + keyword + (String)this.visit((Tree)assignOp.getAssignment(), (Object)p));
    }

    @Override
    public String visitBinary(J.Binary binary, P p) {
        String keyword = "";
        switch (binary.getOperator().getElem()) {
            case Addition: {
                keyword = "+";
                break;
            }
            case Subtraction: {
                keyword = "-";
                break;
            }
            case Multiplication: {
                keyword = "*";
                break;
            }
            case Division: {
                keyword = "/";
                break;
            }
            case Modulo: {
                keyword = "%";
                break;
            }
            case LessThan: {
                keyword = "<";
                break;
            }
            case GreaterThan: {
                keyword = ">";
                break;
            }
            case LessThanOrEqual: {
                keyword = "<=";
                break;
            }
            case GreaterThanOrEqual: {
                keyword = ">=";
                break;
            }
            case Equal: {
                keyword = "==";
                break;
            }
            case NotEqual: {
                keyword = "!=";
                break;
            }
            case BitAnd: {
                keyword = "&";
                break;
            }
            case BitOr: {
                keyword = "|";
                break;
            }
            case BitXor: {
                keyword = "^";
                break;
            }
            case LeftShift: {
                keyword = "<<";
                break;
            }
            case RightShift: {
                keyword = ">>";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>";
                break;
            }
            case Or: {
                keyword = "||";
                break;
            }
            case And: {
                keyword = "&&";
            }
        }
        return this.fmt(binary, (String)this.visit((Tree)binary.getLeft(), (Object)p) + this.visit(binary.getOperator().getBefore()) + keyword + (String)this.visit((Tree)binary.getRight(), (Object)p));
    }

    @Override
    public String visitBlock(J.Block block, P p) {
        StringBuilder acc = new StringBuilder();
        if (block.getStatic() != null) {
            acc.append("static").append(this.visit(block.getStatic()));
        }
        acc.append('{').append(this.visitStatements(block.getStatements(), p)).append(this.visit(block.getEnd())).append('}');
        return this.fmt(block, acc.toString());
    }

    private String visitStatements(List<JRightPadded<Statement>> statements, P p) {
        StringBuilder acc = new StringBuilder();
        for (JRightPadded<Statement> paddedStat : statements) {
            acc.append(this.visitStatement(paddedStat, p));
        }
        return acc.toString();
    }

    private String visitStatement(@Nullable JRightPadded<Statement> paddedStat, P p) {
        if (paddedStat == null) {
            return "";
        }
        String acc = (String)this.visit((Tree)paddedStat.getElem(), (Object)p) + this.visit(paddedStat.getAfter());
        Statement s = paddedStat.getElem();
        while (true) {
            if (s instanceof J.Assert || s instanceof J.Assign || s instanceof J.AssignOp || s instanceof J.Break || s instanceof J.Continue || s instanceof J.DoWhileLoop || s instanceof J.Empty || s instanceof J.MethodInvocation || s instanceof J.NewClass || s instanceof J.Return || s instanceof J.Throw || s instanceof J.Unary || s instanceof J.VariableDecls) {
                return acc + ';';
            }
            if (s instanceof J.MethodDecl && ((J.MethodDecl)s).getBody() == null) {
                return acc + ';';
            }
            if (!(s instanceof J.Label)) break;
            s = ((J.Label)s).getStatement();
        }
        return acc;
    }

    @Override
    public String visitBreak(J.Break breakStatement, P p) {
        return this.fmt(breakStatement, "break" + (String)this.visit((Tree)breakStatement.getLabel(), (Object)p));
    }

    @Override
    public String visitCase(J.Case caze, P p) {
        Expression elem = caze.getPattern();
        String pattern = elem instanceof J.Ident && ((J.Ident)elem).getSimpleName().equals("default") ? "default" : "case" + (String)this.visit((Tree)elem, (Object)p);
        return this.fmt(caze, pattern + this.visit(caze.getStatements().getBefore()) + ":" + this.visitStatements(caze.getStatements().getElem(), p));
    }

    @Override
    public String visitCatch(J.Try.Catch catzh, P p) {
        return this.fmt(catzh, "catch" + (String)this.visit((Tree)catzh.getParam(), (Object)p) + (String)this.visit((Tree)catzh.getBody(), (Object)p));
    }

    @Override
    public String visitClassDecl(J.ClassDecl classDecl, P p) {
        String modifiers = this.visitModifiers(classDecl.getModifiers());
        String kind = "";
        switch (classDecl.getKind().getElem()) {
            case Class: {
                kind = "class";
                break;
            }
            case Enum: {
                kind = "enum";
                break;
            }
            case Interface: {
                kind = "interface";
                break;
            }
            case Annotation: {
                kind = "@interface";
            }
        }
        return this.fmt(classDecl, this.visit(classDecl.getAnnotations(), p) + modifiers + this.visit(classDecl.getKind().getBefore()) + kind + (String)this.visit((Tree)classDecl.getName(), (Object)p) + this.visit("<", classDecl.getTypeParameters(), ",", ">", p) + this.visit("extends", classDecl.getExtends(), p) + this.visit(classDecl.getKind().getElem().equals((Object)J.ClassDecl.Kind.Interface) ? "extends" : "implements", classDecl.getImplements(), ",", null, p) + (String)this.visit((Tree)classDecl.getBody(), (Object)p));
    }

    @Override
    public String visitCompilationUnit(J.CompilationUnit cu, P p) {
        return this.fmt(cu, this.visit(cu.getPackageDecl(), ";", p) + this.visit(cu.getImports(), ";", p) + (cu.getImports().isEmpty() ? "" : ";") + this.visit(cu.getClasses(), p) + this.visit(cu.getEof()));
    }

    @Override
    public String visitContinue(J.Continue continueStatement, P p) {
        return this.fmt(continueStatement, "continue" + (String)this.visit((Tree)continueStatement.getLabel(), (Object)p));
    }

    @Override
    public <T extends J> String visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
        return this.fmt(controlParens, "(" + this.visit(controlParens.getTree(), ")", p));
    }

    @Override
    public String visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        return this.fmt(doWhileLoop, "do" + this.visitStatement(doWhileLoop.getBody(), p) + this.visit("while", doWhileLoop.getWhileCondition(), p));
    }

    @Override
    public String visitElse(J.If.Else elze, P p) {
        return this.fmt(elze, "else" + this.visitStatement(elze.getBody(), p));
    }

    @Override
    public String visitEmpty(J.Empty empty, P p) {
        return this.fmt(empty, "");
    }

    @Override
    public String visitEnumValue(J.EnumValue enoom, P p) {
        String init = "";
        J.NewClass initializer = enoom.getInitializer();
        if (initializer != null) {
            init = this.fmt(initializer, this.visit("(", initializer.getArgs(), ",", ")", p) + (String)this.visit((Tree)initializer.getBody(), (Object)p));
        }
        return this.fmt(enoom, (String)this.visit((Tree)enoom.getName(), (Object)p) + init);
    }

    @Override
    public String visitEnumValueSet(J.EnumValueSet enums, P p) {
        return this.fmt(enums, this.visit(enums.getEnums(), ",", p) + (enums.isTerminatedWithSemicolon() ? ";" : ""));
    }

    @Override
    public String visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        return this.fmt(fieldAccess, (String)this.visit((Tree)fieldAccess.getTarget(), (Object)p) + this.visit(".", fieldAccess.getName(), p));
    }

    @Override
    public String visitForLoop(J.ForLoop forLoop, P p) {
        J.ForLoop.Control ctrl = forLoop.getControl();
        String expr = this.fmt(ctrl, "(" + this.visit(ctrl.getInit(), ";", p) + this.visit(ctrl.getCondition(), ";", p) + this.visit(ctrl.getUpdate(), ",", p) + ")");
        return this.fmt(forLoop, "for" + expr + this.visitStatement(forLoop.getBody(), p));
    }

    @Override
    public String visitForEachLoop(J.ForEachLoop forEachLoop, P p) {
        J.ForEachLoop.Control ctrl = forEachLoop.getControl();
        String expr = this.fmt(ctrl, "(" + this.visit(ctrl.getVariable(), ":", p) + this.visit(ctrl.getIterable(), "", p) + ")");
        return this.fmt(forEachLoop, "for" + expr + this.visitStatement(forEachLoop.getBody(), p));
    }

    @Override
    public String visitIdentifier(J.Ident ident, P p) {
        return this.fmt(ident, ident.getSimpleName());
    }

    @Override
    public String visitIf(J.If iff, P p) {
        return this.fmt(iff, "if" + (String)this.visit((Tree)iff.getIfCondition(), (Object)p) + this.visitStatement(iff.getThenPart(), p) + (String)this.visit((Tree)iff.getElsePart(), (Object)p));
    }

    @Override
    public String visitImport(J.Import impoort, P p) {
        return this.fmt(impoort, "import" + (impoort.isStatic() ? this.visit(impoort.getStatic()) + "static" : "") + (String)this.visit((Tree)impoort.getQualid(), (Object)p));
    }

    @Override
    public String visitInstanceOf(J.InstanceOf instanceOf, P p) {
        return this.fmt(instanceOf, this.visit(instanceOf.getExpr(), "instanceof", p) + (String)this.visit((Tree)instanceOf.getClazz(), (Object)p));
    }

    @Override
    public String visitLabel(J.Label label, P p) {
        return this.fmt(label, this.visit(label.getLabel(), ":", p) + (String)this.visit((Tree)label.getStatement(), (Object)p));
    }

    @Override
    public String visitLambda(J.Lambda lambda, P p) {
        String params = this.visit(lambda.getParameters().getParams(), ",", p);
        String paramSet = this.fmt(lambda.getParameters(), lambda.getParameters().isParenthesized() ? "(" + params + ")" : params);
        return this.fmt(lambda, paramSet + this.visit(lambda.getArrow()) + "->") + (String)this.visit((Tree)lambda.getBody(), (Object)p);
    }

    @Override
    public String visitLiteral(J.Literal literal, P p) {
        return this.fmt(literal, literal.getValueSource());
    }

    @Override
    public String visitMemberReference(J.MemberReference memberRef, P p) {
        return this.fmt(memberRef, (String)this.visit((Tree)memberRef.getContaining(), (Object)p) + this.visit("<", memberRef.getTypeParameters(), ",", ">", p) + this.visit("::", memberRef.getReference(), p));
    }

    @Override
    public String visitMethod(J.MethodDecl method, P p) {
        return this.fmt(method, this.visit(method.getAnnotations(), p) + this.visitModifiers(method.getModifiers()) + this.visit("<", method.getTypeParameters(), ",", ">", p) + (String)this.visit((Tree)method.getReturnTypeExpr(), (Object)p) + (String)this.visit((Tree)method.getName(), (Object)p) + this.visit("(", method.getParams(), ",", ")", p) + this.visit("throws", method.getThrows(), ",", null, p) + (String)this.visit((Tree)method.getBody(), (Object)p) + this.visit("default", method.getDefaultValue(), p));
    }

    @Override
    public String visitMethodInvocation(J.MethodInvocation method, P p) {
        return this.fmt(method, this.visit(method.getSelect(), ".", p) + this.visit("<", method.getTypeParameters(), ",", ">", p) + (String)this.visit((Tree)method.getName(), (Object)p) + this.visit("(", method.getArgs(), ",", ")", p));
    }

    @Override
    public String visitMultiCatch(J.MultiCatch multiCatch, P p) {
        return this.fmt(multiCatch, this.visit(multiCatch.getAlternatives(), "|", p));
    }

    @Override
    public String visitMultiVariable(J.VariableDecls multiVariable, P p) {
        StringBuilder acc = new StringBuilder(this.visit(multiVariable.getAnnotations(), p));
        acc.append(this.visitModifiers(multiVariable.getModifiers()));
        acc.append((String)this.visit((Tree)multiVariable.getTypeExpr(), (Object)p));
        for (JLeftPadded<Space> dim : multiVariable.getDimensionsBeforeName()) {
            acc.append(this.visit(dim.getBefore())).append('[').append(dim.getElem().getWhitespace()).append(']');
        }
        if (multiVariable.getVarargs() != null) {
            acc.append(this.visit(multiVariable.getVarargs())).append("...");
        }
        acc.append(this.visit(multiVariable.getVars(), ",", p));
        return this.fmt(multiVariable, acc.toString());
    }

    @Override
    public String visitNewArray(J.NewArray newArray, P p) {
        return this.fmt(newArray, (newArray.getTypeExpr() != null ? "new" : "") + (String)this.visit((Tree)newArray.getTypeExpr(), (Object)p) + this.visit(newArray.getDimensions(), p) + this.visit("{", newArray.getInitializer(), ",", "}", p));
    }

    @Override
    public String visitNewClass(J.NewClass newClass, P p) {
        return this.fmt(newClass, this.visit(newClass.getEncl(), ".", p) + this.visit(newClass.getNew()) + "new" + (String)this.visit((Tree)newClass.getClazz(), (Object)p) + this.visit("(", newClass.getArgs(), ",", ")", p) + (String)this.visit((Tree)newClass.getBody(), (Object)p));
    }

    @Override
    public String visitPackage(J.Package pkg, P p) {
        return this.fmt(pkg, "package" + (String)this.visit((Tree)pkg.getExpr(), (Object)p));
    }

    @Override
    public String visitParameterizedType(J.ParameterizedType type, P p) {
        return this.fmt(type, (String)this.visit((Tree)type.getClazz(), (Object)p) + this.visit("<", type.getTypeParameters(), ",", ">", p));
    }

    @Override
    public String visitPrimitive(J.Primitive primitive, P p) {
        String keyword;
        switch (primitive.getType()) {
            case Boolean: {
                keyword = "boolean";
                break;
            }
            case Byte: {
                keyword = "byte";
                break;
            }
            case Char: {
                keyword = "char";
                break;
            }
            case Double: {
                keyword = "double";
                break;
            }
            case Float: {
                keyword = "float";
                break;
            }
            case Int: {
                keyword = "int";
                break;
            }
            case Long: {
                keyword = "long";
                break;
            }
            case Short: {
                keyword = "short";
                break;
            }
            case Void: {
                keyword = "void";
                break;
            }
            case String: {
                keyword = "String";
                break;
            }
            case Wildcard: {
                keyword = "*";
                break;
            }
            case None: {
                throw new IllegalStateException("Unable to print None primitive");
            }
            case Null: {
                throw new IllegalStateException("Unable to print Null primitive");
            }
            default: {
                throw new IllegalStateException("Unable to print non-primitive type");
            }
        }
        return this.fmt(primitive, keyword);
    }

    @Override
    public <T extends J> String visitParentheses(J.Parentheses<T> parens, P p) {
        return this.fmt(parens, "(" + this.visit(parens.getTree(), ")", p));
    }

    @Override
    public String visitReturn(J.Return retrn, P p) {
        return this.fmt(retrn, "return" + (String)this.visit((Tree)retrn.getExpr(), (Object)p));
    }

    @Override
    public String visitSwitch(J.Switch switzh, P p) {
        return this.fmt(switzh, "switch" + (String)this.visit((Tree)switzh.getSelector(), (Object)p) + (String)this.visit((Tree)switzh.getCases(), (Object)p));
    }

    @Override
    public String visitSynchronized(J.Synchronized synch, P p) {
        return this.fmt(synch, "synchronized" + (String)this.visit((Tree)synch.getLock(), (Object)p) + (String)this.visit((Tree)synch.getBody(), (Object)p));
    }

    @Override
    public String visitTernary(J.Ternary ternary, P p) {
        return this.fmt(ternary, (String)this.visit((Tree)ternary.getCondition(), (Object)p) + this.visit("?", ternary.getTruePart(), p) + this.visit(":", ternary.getFalsePart(), p));
    }

    @Override
    public String visitThrow(J.Throw thrown, P p) {
        return this.fmt(thrown, "throw" + (String)this.visit((Tree)thrown.getException(), (Object)p));
    }

    @Override
    public String visitTry(J.Try tryable, P p) {
        StringBuilder acc = new StringBuilder("try");
        if (tryable.getResources() != null) {
            acc.append(this.visit(tryable.getResources().getBefore())).append('(');
            List<JRightPadded<J.Try.Resource>> resources = tryable.getResources().getElem();
            for (int i = 0; i < resources.size(); ++i) {
                JRightPadded<J.Try.Resource> resource = resources.get(i);
                acc.append(this.visit(resource.getElem().getPrefix())).append((String)this.visit((Tree)resource.getElem().getVariableDecls(), (Object)p));
                if (i < resources.size() - 1 || resource.getElem().isTerminatedWithSemicolon()) {
                    acc.append(';');
                }
                acc.append(this.visit(resource.getAfter()));
            }
            acc.append(')');
        }
        acc.append((String)this.visit((Tree)tryable.getBody(), (Object)p));
        acc.append(this.visit(tryable.getCatches(), p));
        acc.append(this.visit("finally", tryable.getFinally(), p));
        return this.fmt(tryable, acc.toString());
    }

    @Override
    public String visitTypeCast(J.TypeCast typeCast, P p) {
        return this.fmt(typeCast, (String)this.visit((Tree)typeCast.getClazz(), (Object)p) + (String)this.visit((Tree)typeCast.getExpr(), (Object)p));
    }

    @Override
    public String visitTypeParameter(J.TypeParameter typeParam, P p) {
        return this.fmt(typeParam, this.visit(typeParam.getAnnotations(), p) + (String)this.visit((Tree)typeParam.getName(), (Object)p) + this.visit("extends", typeParam.getBounds(), "&", "", p));
    }

    @Override
    public String visitUnary(J.Unary unary, P p) {
        switch (unary.getOperator().getElem()) {
            case PreIncrement: {
                return this.fmt(unary, "++" + (String)this.visit((Tree)unary.getExpr(), (Object)p));
            }
            case PreDecrement: {
                return this.fmt(unary, "--" + (String)this.visit((Tree)unary.getExpr(), (Object)p));
            }
            case PostIncrement: {
                return this.fmt(unary, (String)this.visit((Tree)unary.getExpr(), (Object)p) + this.visit(unary.getOperator().getBefore()) + "++");
            }
            case PostDecrement: {
                return this.fmt(unary, (String)this.visit((Tree)unary.getExpr(), (Object)p) + this.visit(unary.getOperator().getBefore()) + "--");
            }
            case Positive: {
                return this.fmt(unary, "+" + (String)this.visit((Tree)unary.getExpr(), (Object)p));
            }
            case Negative: {
                return this.fmt(unary, "-" + (String)this.visit((Tree)unary.getExpr(), (Object)p));
            }
            case Complement: {
                return this.fmt(unary, "~" + (String)this.visit((Tree)unary.getExpr(), (Object)p));
            }
        }
        return this.fmt(unary, "!" + (String)this.visit((Tree)unary.getExpr(), (Object)p));
    }

    @Override
    public String visitVariable(J.VariableDecls.NamedVar variable, P p) {
        StringBuilder dimensions = new StringBuilder();
        for (JLeftPadded<Space> dimension : variable.getDimensionsAfterName()) {
            dimensions.append(this.visit(dimension.getBefore())).append('[').append(dimension.getElem().getWhitespace()).append(']');
        }
        return this.fmt(variable, (String)this.visit((Tree)variable.getName(), (Object)p) + dimensions.toString() + this.visit("=", variable.getInitializer(), p));
    }

    @Override
    public String visitWhileLoop(J.WhileLoop whileLoop, P p) {
        return this.fmt(whileLoop, "while" + (String)this.visit((Tree)whileLoop.getCondition(), (Object)p) + this.visitStatement(whileLoop.getBody(), p));
    }

    @Override
    public String visitWildcard(J.Wildcard wildcard, P p) {
        String bound = "";
        if (wildcard.getBound() != null) {
            switch (wildcard.getBound().getElem()) {
                case Extends: {
                    bound = this.visit(wildcard.getBound().getBefore()) + "extends";
                    break;
                }
                case Super: {
                    bound = this.visit(wildcard.getBound().getBefore()) + "super";
                }
            }
        }
        return this.fmt(wildcard, "?" + bound + (String)this.visit((Tree)wildcard.getBoundedType(), (Object)p));
    }
}

