/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.java.internal.JavaPrinter;
import org.openrewrite.java.tree.J;

public class ClassDeclToString {
    private static final JavaPrinter<Void> CLASS_DECL_PRINTER = new JavaPrinter<Void>(TreePrinter.identity()){

        @Override
        public String visitClassDecl(J.ClassDecl classDecl, Void unused) {
            String modifiers = this.visitModifiers(classDecl.getModifiers()).trim();
            String kind = "";
            switch (classDecl.getKind().getElem()) {
                case Class: {
                    kind = "class ";
                    break;
                }
                case Enum: {
                    kind = "enum ";
                    break;
                }
                case Interface: {
                    kind = "interface ";
                    break;
                }
                case Annotation: {
                    kind = "@interface ";
                }
            }
            return (modifiers.isEmpty() ? "" : modifiers + " ") + kind + classDecl.getName().printTrimmed() + (classDecl.getTypeParameters() == null ? "" : this.visit("<", classDecl.getTypeParameters(), ",", ">", unused) + " ") + this.visit("extends", classDecl.getExtends(), unused) + (classDecl.getImplements() == null ? "" : (J.ClassDecl.Kind.Interface.equals((Object)classDecl.getKind().getElem()) ? "extends" : "implements") + this.visit("", classDecl.getImplements(), ",", "", unused));
        }
    };

    public static String toString(J.ClassDecl clazz) {
        return CLASS_DECL_PRINTER.visit((Tree)clazz, (Object)null);
    }
}

