/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class WrappingAndBracesProcessor<P>
extends JavaIsoProcessor<P> {
    private final WrappingAndBracesStyle style;
    @Nullable
    private final List<? extends J> limitToTrees;

    public WrappingAndBracesProcessor(WrappingAndBracesStyle style, @Nullable List<? extends J> limitToTrees) {
        this.style = style;
        this.limitToTrees = limitToTrees;
        this.setCursoringOn();
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        J j = super.visitStatement(statement, (Object)p);
        if (this.shouldNotFormat()) {
            return j;
        }
        J parentTree = (J)this.getCursor().getParentOrThrow().getTree();
        if (parentTree instanceof J.Block && !j.getPrefix().getWhitespace().contains("\n")) {
            j = (Statement)j.withPrefix(j.getPrefix().withWhitespace("\n" + j.getPrefix().getWhitespace()));
        }
        return j;
    }

    private boolean shouldNotFormat() {
        return this.limitToTrees != null && this.limitToTrees.stream().noneMatch(t -> this.getCursor().isScopeInPath((Tree)t));
    }
}

