/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Iterator;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeProcessor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

public class JavaProcessor<P>
extends TreeProcessor<J, P>
implements JavaVisitor<J, P> {
    public void maybeAddImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeAddImport(clazz.getFullyQualifiedName());
        }
    }

    public void maybeAddImport(String fullyQualifiedName) {
        AddImport op = new AddImport(fullyQualifiedName, null, true);
        if (!this.getAfterVisit().contains(op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeAddImport(String fullyQualifiedName, String statik) {
        AddImport op = new AddImport(fullyQualifiedName, statik, true);
        if (!this.getAfterVisit().contains(op)) {
            this.doAfterVisit(op);
        }
    }

    public void maybeRemoveImport(@Nullable JavaType.FullyQualified clazz) {
        if (clazz != null) {
            this.maybeRemoveImport(clazz.getFullyQualifiedName());
        }
    }

    public void maybeRemoveImport(String fullyQualifiedName) {
        RemoveImport op = new RemoveImport(fullyQualifiedName);
        if (!this.getAfterVisit().contains(op)) {
            this.doAfterVisit(op);
        }
    }

    public J visitExpression(Expression expression, P p) {
        return expression;
    }

    public J visitStatement(Statement statement, P p) {
        return statement;
    }

    public Space visitSpace(Space space, P p) {
        return space;
    }

    public <N extends NameTree> N visitTypeName(N nameTree, P p) {
        return nameTree;
    }

    @Nullable
    private <N extends NameTree> JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElem(this.visitTypeName((NameTree)nameTree.getElem(), p));
    }

    @Nullable
    private <N extends NameTree> JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElem(this.visitTypeName((NameTree)nameTree.getElem(), p));
    }

    @Nullable
    private <J2 extends J> JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, P p) {
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map(nameTrees.getElem(), t -> t.getElem() instanceof NameTree ? this.visitTypeName((JRightPadded)t, p) : t);
        return js == nameTrees.getElem() ? nameTrees : JContainer.build(nameTrees.getBefore(), js);
    }

    @Override
    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        J.AnnotatedType a = (J.AnnotatedType)this.call(annotatedType, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.AnnotatedType)this.call(a, p, this::visitExpression);
        a = a.withAnnotations(this.call(a.getAnnotations(), p));
        a = a.withTypeExpr((TypeTree)this.call(a.getTypeExpr(), p));
        return a.withTypeExpr(this.visitTypeName(a.getTypeExpr(), p));
    }

    @Override
    public J visitAnnotation(J.Annotation annotation, P p) {
        J.Annotation a = (J.Annotation)this.call(annotation, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.Annotation)this.call(a, p, this::visitExpression);
        a = a.withArgs(this.call(a.getArgs(), p));
        a = a.withAnnotationType((NameTree)this.call(a.getAnnotationType(), p));
        return a.withAnnotationType(this.visitTypeName(a.getAnnotationType(), p));
    }

    @Override
    public J visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        J.ArrayAccess a = (J.ArrayAccess)this.call(arrayAccess, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.ArrayAccess)this.call(a, p, this::visitExpression);
        a = a.withIndexed((Expression)this.call(a.getIndexed(), p));
        a = a.withDimension((J.ArrayDimension)this.call(a.getDimension(), p));
        return a;
    }

    @Override
    public J visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        J.ArrayDimension a = (J.ArrayDimension)this.call(arrayDimension, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = a.withIndex(this.call(a.getIndex(), p));
        return a;
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType, P p) {
        J.ArrayType a = (J.ArrayType)this.call(arrayType, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.ArrayType)this.call(a, p, this::visitExpression);
        a.withElementType((TypeTree)this.call(a.getElementType(), p));
        return a.withElementType(this.visitTypeName(a.getElementType(), p));
    }

    @Override
    public J visitAssert(J.Assert azzert, P p) {
        J.Assert a = (J.Assert)this.call(azzert, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.Assert)this.call(a, p, this::visitStatement);
        return a.withCondition((Expression)this.call(a.getCondition(), p));
    }

    @Override
    public J visitAssign(J.Assign assign, P p) {
        J.Assign a = (J.Assign)this.call(assign, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.Assign)this.call(a, p, this::visitStatement);
        a = (J.Assign)this.call(a, p, this::visitExpression);
        a = a.withVariable((Expression)this.call(a.getVariable(), p));
        return a.withAssignment(this.call(a.getAssignment(), p));
    }

    @Override
    public J visitAssignOp(J.AssignOp assignOp, P p) {
        J.AssignOp a = (J.AssignOp)this.call(assignOp, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = (J.AssignOp)this.call(a, p, this::visitStatement);
        a = (J.AssignOp)this.call(a, p, this::visitExpression);
        a = a.withVariable((Expression)this.call(a.getVariable(), p));
        return a.withAssignment((Expression)this.call(a.getAssignment(), p));
    }

    @Override
    public J visitBinary(J.Binary binary, P p) {
        J.Binary b = (J.Binary)this.call(binary, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        b = b.withPrefix(this.visitSpace(b.getPrefix(), p));
        b = (J.Binary)this.call(b, p, this::visitExpression);
        b = b.withLeft((Expression)this.call(b.getLeft(), p));
        return b.withRight((Expression)this.call(b.getRight(), p));
    }

    @Override
    public J visitBlock(J.Block block, P p) {
        J.Block b;
        b = b.withStatik((b = (J.Block)this.call(block, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1))).getStatic() == null ? null : this.visitSpace(b.getStatic(), p));
        b = b.withPrefix(this.visitSpace(b.getPrefix(), p));
        b = (J.Block)this.call(b, p, this::visitStatement);
        b = b.withStatements(ListUtils.map(b.getStatements(), t -> this.call((JRightPadded)t, p)));
        return b.withEnd(this.visitSpace(b.getEnd(), p));
    }

    @Override
    public J visitBreak(J.Break breakStatement, P p) {
        J.Break b = (J.Break)this.call(breakStatement, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        b = b.withPrefix(this.visitSpace(b.getPrefix(), p));
        b = (J.Break)this.call(b, p, this::visitStatement);
        return b.withLabel((J.Ident)this.call(b.getLabel(), p));
    }

    @Override
    public J visitCase(J.Case caze, P p) {
        J.Case c = (J.Case)this.call(caze, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = (J.Case)this.call(c, p, this::visitStatement);
        c = c.withPattern((Expression)this.call(c.getPattern(), p));
        return c.withStatements(this.call(c.getStatements(), p));
    }

    @Override
    public J visitCatch(J.Try.Catch catzh, P p) {
        J.Try.Catch c = (J.Try.Catch)this.call(catzh, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = c.withParam((J.ControlParentheses)this.call(c.getParam(), p));
        return c.withBody((J.Block)this.call(c.getBody(), p));
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl, P p) {
        J.ClassDecl c = (J.ClassDecl)this.call(classDecl, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = (J.ClassDecl)this.call(c, p, this::visitStatement);
        c = c.withAnnotations(this.call(c.getAnnotations(), p));
        c = c.withModifiers(this.call(c.getModifiers(), p));
        c = c.withModifiers(ListUtils.map(c.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), p))));
        c = c.withTypeParameters(this.call(c.getTypeParameters(), p));
        c = c.withName((J.Ident)this.call(c.getName(), p));
        c = c.withExtends(this.call(c.getExtends(), p));
        c = c.withExtends(this.visitTypeName(c.getExtends(), p));
        c = c.withImplements(this.call(c.getImplements(), p));
        c = c.withImplements(this.visitTypeNames(c.getImplements(), p));
        return c.withBody((J.Block)this.call(c.getBody(), p));
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        J.CompilationUnit c = (J.CompilationUnit)this.call(cu, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = c.withPackageDecl(this.call(c.getPackageDecl(), p));
        c = c.withImports(ListUtils.map(c.getImports(), t -> this.call((JRightPadded)t, p)));
        c = c.withClasses(this.call(c.getClasses(), p));
        return c.withEof(this.visitSpace(c.getEof(), p));
    }

    @Override
    public J visitContinue(J.Continue continueStatement, P p) {
        J.Continue c = (J.Continue)this.call(continueStatement, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        c = c.withPrefix(this.visitSpace(c.getPrefix(), p));
        c = (J.Continue)this.call(c, p, this::visitStatement);
        return c.withLabel((J.Ident)this.call(c.getLabel(), p));
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
        J cpa = (J.ControlParentheses)this.call(controlParens, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        cpa = ((J.ControlParentheses)cpa).withPrefix(this.visitSpace(((J.ControlParentheses)cpa).getPrefix(), p));
        cpa = (J.ControlParentheses)this.call(cpa, p, this::visitExpression);
        return ((J.ControlParentheses)cpa).withTree(this.call(((J.ControlParentheses)cpa).getTree(), p));
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J.DoWhileLoop d = (J.DoWhileLoop)this.call(doWhileLoop, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        d = d.withPrefix(this.visitSpace(d.getPrefix(), p));
        d = (J.DoWhileLoop)this.call(d, p, this::visitStatement);
        d = d.withWhileCondition(this.call(d.getWhileCondition(), p));
        return d.withBody(this.call(d.getBody(), p));
    }

    @Override
    public J visitEmpty(J.Empty empty, P p) {
        J.Empty e = (J.Empty)this.call(empty, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = (J.Empty)this.call(e, p, this::visitStatement);
        e = (J.Empty)this.call(e, p, this::visitExpression);
        return e;
    }

    @Override
    public J visitEnumValue(J.EnumValue enoom, P p) {
        J.EnumValue e = (J.EnumValue)this.call(enoom, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withName((J.Ident)this.call(e.getName(), p));
        return e.withInitializer((J.NewClass)this.call(e.getInitializer(), p));
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums, P p) {
        J.EnumValueSet e = (J.EnumValueSet)this.call(enums, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = (J.EnumValueSet)this.call(e, p, this::visitStatement);
        return e.withEnums(ListUtils.map(e.getEnums(), t -> this.call((JRightPadded)t, p)));
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J.FieldAccess f = (J.FieldAccess)this.call(fieldAccess, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = this.visitTypeName(f, p);
        f = (J.FieldAccess)this.call(f, p, this::visitExpression);
        f = f.withTarget((Expression)this.call(f.getTarget(), p));
        return f.withName(this.call(f.getName(), p));
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forLoop, P p) {
        J.ForEachLoop f = (J.ForEachLoop)this.call(forLoop, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = (J.ForEachLoop)this.call(f, p, this::visitStatement);
        f = f.withControl(f.getControl().withVariable(this.call(f.getControl().getVariable(), p)));
        f = f.withControl(f.getControl().withIterable(this.call(f.getControl().getIterable(), p)));
        return f.withBody(this.call(f.getBody(), p));
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, P p) {
        J.ForLoop f = (J.ForLoop)this.call(forLoop, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        f = f.withPrefix(this.visitSpace(f.getPrefix(), p));
        f = (J.ForLoop)this.call(f, p, this::visitStatement);
        f = f.withControl(f.getControl().withInit(this.call(f.getControl().getInit(), p)));
        f = f.withControl(f.getControl().withCondition(this.call(f.getControl().getCondition(), p)));
        f = f.withControl(f.getControl().withUpdate(ListUtils.map(f.getControl().getUpdate(), t -> this.call((JRightPadded)t, p))));
        return f.withBody(this.call(f.getBody(), p));
    }

    @Override
    public J visitIdentifier(J.Ident ident, P p) {
        J.Ident i = (J.Ident)this.call(ident, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        return (J)this.call(i, p, this::visitExpression);
    }

    @Override
    public J visitElse(J.If.Else elze, P p) {
        J.If.Else e = (J.If.Else)this.call(elze, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        return e.withBody(this.call(e.getBody(), p));
    }

    @Override
    public J visitIf(J.If iff, P p) {
        J.If i = (J.If)this.call(iff, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = (J.If)this.call(i, p, this::visitStatement);
        i = i.withIfCondition((J.ControlParentheses)this.call(i.getIfCondition(), p));
        i = i.withThenPart(this.call(i.getThenPart(), p));
        i = i.withElsePart((J.If.Else)this.call(i.getElsePart(), p));
        return i;
    }

    @Override
    public J visitImport(J.Import impoort, P p) {
        J.Import i = (J.Import)this.call(impoort, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        i = i.withStatik((i = i.withPrefix(this.visitSpace(i.getPrefix(), p))).getStatic() == null ? null : this.visitSpace(i.getStatic(), p));
        return i.withQualid((J.FieldAccess)this.call(i.getQualid(), p));
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, P p) {
        J.InstanceOf i = (J.InstanceOf)this.call(instanceOf, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = (J.InstanceOf)this.call(i, p, this::visitExpression);
        i = i.withExpr(this.call(i.getExpr(), p));
        return i.withClazz((J)this.call(i.getClazz(), p));
    }

    @Override
    public J visitLabel(J.Label label, P p) {
        J.Label l = (J.Label)this.call(label, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        l = (J.Label)this.call(l, p, this::visitStatement);
        return l.withStatement((Statement)this.call(l.getStatement(), p));
    }

    @Override
    public J visitLambda(J.Lambda lambda, P p) {
        J.Lambda l = (J.Lambda)this.call(lambda, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        l = (J.Lambda)this.call(l, p, this::visitExpression);
        l = l.withParameters((J.Lambda.Parameters)this.call(l.getParameters(), p));
        l = l.withArrow(this.visitSpace(l.getArrow(), p));
        return l.withBody((J)this.call(l.getBody(), p));
    }

    @Override
    public J visitLiteral(J.Literal literal, P p) {
        J.Literal l = (J.Literal)this.call(literal, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        return (J)this.call(l, p, this::visitExpression);
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, P p) {
        J.MemberReference m = (J.MemberReference)this.call(memberRef, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = m.withContaining((Expression)this.call(m.getContaining(), p));
        m = m.withTypeParameters(this.call(m.getTypeParameters(), p));
        return m.withReference(this.call(m.getReference(), p));
    }

    @Override
    public J visitMethod(J.MethodDecl method, P p) {
        J.MethodDecl m = (J.MethodDecl)this.call(method, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = (J.MethodDecl)this.call(m, p, this::visitStatement);
        m = m.withAnnotations(this.call(m.getAnnotations(), p));
        m = m.withModifiers(this.call(m.getModifiers(), p));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), p))));
        m = m.withTypeParameters(this.call(m.getTypeParameters(), p));
        m = m.withReturnTypeExpr((m = m.withReturnTypeExpr((TypeTree)this.call(m.getReturnTypeExpr(), p))).getReturnTypeExpr() == null ? null : this.visitTypeName(m.getReturnTypeExpr(), p));
        m = m.withName((J.Ident)this.call(m.getName(), p));
        m = m.withParams(this.call(m.getParams(), p));
        m = m.withParams(this.call(m.getParams(), p));
        m = m.withThrows(this.call(m.getThrows(), p));
        m = m.withThrows(this.visitTypeNames(m.getThrows(), p));
        return m.withBody((J.Block)this.call(m.getBody(), p));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = (J.MethodInvocation)this.call(method, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = (J.MethodInvocation)this.call(m, p, this::visitStatement);
        if ((m = (J.MethodInvocation)this.call(m, p, this::visitExpression)).getSelect() != null && m.getSelect().getElem() instanceof NameTree && method.getType() != null && method.getType().hasFlags(Flag.Static)) {
            m = m.withSelect(this.visitTypeName(m.getSelect(), p));
        }
        m = m.withSelect(this.call(m.getSelect(), p));
        m = m.withTypeParameters(this.call(m.getTypeParameters(), p));
        m = m.withTypeParameters(this.visitTypeNames(m.getTypeParameters(), p));
        m = m.withName((J.Ident)this.call(m.getName(), p));
        return m.withArgs(this.call(m.getArgs(), p));
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, P p) {
        J.MultiCatch m = (J.MultiCatch)this.call(multiCatch, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        return m.withAlternatives(ListUtils.map(m.getAlternatives(), t -> this.visitTypeName(this.call((JRightPadded)t, p), p)));
    }

    @Override
    public J visitMultiVariable(J.VariableDecls multiVariable, P p) {
        J.VariableDecls m = (J.VariableDecls)this.call(multiVariable, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = (J.VariableDecls)this.call(m, p, this::visitStatement);
        m = m.withModifiers(this.call(m.getModifiers(), p));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), p))));
        m = m.withAnnotations(this.call(m.getAnnotations(), p));
        m = m.withTypeExpr((m = m.withTypeExpr((TypeTree)this.call(m.getTypeExpr(), p))).getTypeExpr() == null ? null : this.visitTypeName(m.getTypeExpr(), p));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), p));
        return m.withVars(ListUtils.map(m.getVars(), t -> this.call((JRightPadded)t, p)));
    }

    @Override
    public J visitNewArray(J.NewArray newArray, P p) {
        J.NewArray n = (J.NewArray)this.call(newArray, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        n = n.withPrefix(this.visitSpace(n.getPrefix(), p));
        n = (J.NewArray)this.call(n, p, this::visitExpression);
        n = n.withTypeExpr((n = n.withTypeExpr((TypeTree)this.call(n.getTypeExpr(), p))).getTypeExpr() == null ? null : this.visitTypeName(n.getTypeExpr(), p));
        n = n.withDimensions(this.call(n.getDimensions(), p));
        return n.withInitializer(this.call(n.getInitializer(), p));
    }

    @Override
    public J visitNewClass(J.NewClass newClass, P p) {
        J.NewClass n = (J.NewClass)this.call(newClass, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        n = n.withPrefix(this.visitSpace(n.getPrefix(), p));
        n = (J.NewClass)this.call(n, p, this::visitStatement);
        n = (J.NewClass)this.call(n, p, this::visitExpression);
        n = n.withNew(this.visitSpace(n.getNew(), p));
        n = n.withClazz((n = n.withClazz((TypeTree)this.call(n.getClazz(), p))).getClazz() == null ? null : this.visitTypeName(n.getClazz(), p));
        n = n.withArgs(this.call(n.getArgs(), p));
        return n.withBody((J.Block)this.call(n.getBody(), p));
    }

    @Override
    public J visitPackage(J.Package pkg, P p) {
        J.Package pa = (J.Package)this.call(pkg, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), p));
        return pa.withExpr((Expression)this.call(pa.getExpr(), p));
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type, P p) {
        J.ParameterizedType pt = (J.ParameterizedType)this.call(type, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), p));
        pt = (J.ParameterizedType)this.call(pt, p, this::visitExpression);
        pt = pt.withClazz((NameTree)this.call(pt.getClazz(), p));
        pt = pt.withClazz(this.visitTypeName(pt.getClazz(), p));
        pt = pt.withTypeParameters(this.call(pt.getTypeParameters(), p));
        return pt.withTypeParameters(this.visitTypeNames(pt.getTypeParameters(), p));
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        J pa = (J.Parentheses)this.call(parens, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        pa = ((J.Parentheses)pa).withPrefix(this.visitSpace(((J.Parentheses)pa).getPrefix(), p));
        pa = (J.Parentheses)this.call(pa, p, this::visitExpression);
        return ((J.Parentheses)pa).withTree(this.call(((J.Parentheses)pa).getTree(), p));
    }

    @Override
    public J visitPrimitive(J.Primitive primitive, P p) {
        J.Primitive pr = (J.Primitive)this.call(primitive, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), p));
        return (J)this.call(pr, p, this::visitExpression);
    }

    @Override
    public J visitReturn(J.Return retrn, P p) {
        J.Return r = (J.Return)this.call(retrn, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        r = r.withPrefix(this.visitSpace(r.getPrefix(), p));
        r = (J.Return)this.call(r, p, this::visitStatement);
        return r.withExpr((Expression)this.call(r.getExpr(), p));
    }

    @Override
    public J visitSwitch(J.Switch switzh, P p) {
        J.Switch s = (J.Switch)this.call(switzh, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        s = s.withPrefix(this.visitSpace(s.getPrefix(), p));
        s = (J.Switch)this.call(s, p, this::visitStatement);
        s = s.withSelector((J.ControlParentheses)this.call(s.getSelector(), p));
        return s.withCases((J.Block)this.call(s.getCases(), p));
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, P p) {
        J.Synchronized s = (J.Synchronized)this.call(synch, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        s = s.withPrefix(this.visitSpace(s.getPrefix(), p));
        s = (J.Synchronized)this.call(s, p, this::visitStatement);
        s = s.withLock((J.ControlParentheses)this.call(s.getLock(), p));
        return s.withBody((J.Block)this.call(s.getBody(), p));
    }

    @Override
    public J visitTernary(J.Ternary ternary, P p) {
        J.Ternary t = (J.Ternary)this.call(ternary, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = (J.Ternary)this.call(t, p, this::visitExpression);
        t = t.withCondition((Expression)this.call(t.getCondition(), p));
        t = t.withTruePart(this.call(t.getTruePart(), p));
        return t.withFalsePart(this.call(t.getFalsePart(), p));
    }

    @Override
    public J visitThrow(J.Throw thrown, P p) {
        J.Throw t = (J.Throw)this.call(thrown, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = (J.Throw)this.call(t, p, this::visitStatement);
        return t.withException((Expression)this.call(t.getException(), p));
    }

    @Override
    public J visitTry(J.Try tryable, P p) {
        J.Try t = (J.Try)this.call(tryable, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = (J.Try)this.call(t, p, this::visitStatement);
        t = t.withResources(this.call(t.getResources(), p));
        t = t.withBody((J.Block)this.call(t.getBody(), p));
        t = t.withCatches(this.call(t.getCatches(), p));
        return t.withFinally(this.call(t.getFinally(), p));
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast, P p) {
        J.TypeCast t = (J.TypeCast)this.call(typeCast, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = (J.TypeCast)this.call(t, p, this::visitExpression);
        t = t.withClazz((J.ControlParentheses)this.call(t.getClazz(), p));
        t = t.withClazz(t.getClazz().withTree(this.visitTypeName(t.getClazz().getTree(), p)));
        return t.withExpr((Expression)this.call(t.getExpr(), p));
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam, P p) {
        J.TypeParameter t = (J.TypeParameter)this.call(typeParam, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        t = t.withPrefix(this.visitSpace(t.getPrefix(), p));
        t = t.withAnnotations(this.call(t.getAnnotations(), p));
        if ((t = t.withName((Expression)this.call(t.getName(), p))).getName() instanceof NameTree) {
            t = t.withName((Expression)((Object)this.visitTypeName((NameTree)((Object)t.getName()), p)));
        }
        t = t.withBounds(this.call(t.getBounds(), p));
        return t.withBounds(this.visitTypeNames(t.getBounds(), p));
    }

    @Override
    public J visitUnary(J.Unary unary, P p) {
        J.Unary u = (J.Unary)this.call(unary, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        u = u.withPrefix(this.visitSpace(u.getPrefix(), p));
        u = (J.Unary)this.call(u, p, this::visitStatement);
        u = (J.Unary)this.call(u, p, this::visitExpression);
        return u.withExpr((Expression)this.call(u.getExpr(), p));
    }

    @Override
    public J visitVariable(J.VariableDecls.NamedVar variable, P p) {
        J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.call(variable, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        v = v.withPrefix(this.visitSpace(v.getPrefix(), p));
        v = v.withName((J.Ident)this.call(v.getName(), p));
        return v.withInitializer(this.call(v.getInitializer(), p));
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J.WhileLoop w = (J.WhileLoop)this.call(whileLoop, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        w = w.withPrefix(this.visitSpace(w.getPrefix(), p));
        w = (J.WhileLoop)this.call(w, p, this::visitStatement);
        w = w.withCondition((J.ControlParentheses)this.call(w.getCondition(), p));
        return w.withBody(this.call(w.getBody(), p));
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard, P p) {
        J.Wildcard w = (J.Wildcard)this.call(wildcard, p, (arg_0, arg_1) -> ((JavaProcessor)this).visitEach(arg_0, arg_1));
        w = w.withPrefix(this.visitSpace(w.getPrefix(), p));
        w = (J.Wildcard)this.call(w, p, this::visitExpression);
        if ((w = w.withBoundedType((NameTree)this.call(w.getBoundedType(), p))).getBoundedType() != null) {
            w = w.withBoundedType(this.visitTypeName(w.getBoundedType(), p));
        }
        return w;
    }

    @Nullable
    protected <J2 extends J> JRightPadded<J2> call(@Nullable JRightPadded<J2> right, P p) {
        if (right == null) {
            return null;
        }
        J j = (J)this.call((Tree)right.getElem(), p);
        Space space = this.visitSpace(right.getAfter(), p);
        return space == right.getAfter() && j == right.getElem() ? right : new JRightPadded<J2>((J)j, space);
    }

    @Nullable
    protected <J2 extends J> JLeftPadded<J2> call(@Nullable JLeftPadded<J2> left, P p) {
        if (left == null) {
            return null;
        }
        Space space = this.visitSpace(left.getBefore(), p);
        J j = (J)this.call((Tree)left.getElem(), p);
        return space == left.getBefore() && j == left.getElem() ? left : new JLeftPadded<J2>(space, (J)j);
    }

    @Nullable
    protected <J2 extends J> JContainer<J2> call(@Nullable JContainer<J2> container, P p) {
        if (container == null) {
            return null;
        }
        List js = ListUtils.map(container.getElem(), t -> this.call((JRightPadded)t, p));
        return js == container.getElem() ? container : JContainer.build(container.getBefore(), js);
    }

    protected boolean isInSameNameScope(Cursor base, Cursor child) {
        J.ClassDecl childClass;
        Tree childScope;
        Tree baseScope = base.getPathAsStream().filter(t -> t instanceof J.Block || t instanceof J.MethodDecl || t instanceof J.Try || t instanceof J.ForLoop || t instanceof J.ForEachLoop).findFirst().orElseThrow(() -> new IllegalArgumentException("The base cursor does not have an scoped context."));
        Iterator it = child.getPath();
        while (it.hasNext() && (!((childScope = (Tree)it.next()) instanceof J.ClassDecl) || (childClass = (J.ClassDecl)childScope).getKind().getElem().equals((Object)J.ClassDecl.Kind.Class) && !childClass.hasModifier("static"))) {
            if (!baseScope.isScope(childScope)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInSameNameScope(Cursor child) {
        return this.isInSameNameScope(this.getCursor(), child);
    }
}

