/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.LinkedHashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ChangeMethodTargetToVariable
extends Recipe {
    private MethodMatcher methodMatcher;
    private String variable;
    private JavaType.Class variableType;

    public ChangeMethodTargetToVariable() {
        this.processor = () -> new ChangeMethodTargetToVariableProcessor(this.methodMatcher, this.variable, this.variableType);
    }

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void setVariableType(String variableType) {
        this.variableType = JavaType.Class.build(variableType);
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"variable", (Object)this.variable)).and(Validated.required((String)"variableType", (Object)this.variableType.getFullyQualifiedName()));
    }

    private static class ChangeMethodTargetToVariableProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final String variable;
        private final JavaType.Class variableType;

        private ChangeMethodTargetToVariableProcessor(MethodMatcher methodMatcher, String variable, JavaType.Class variableType) {
            this.methodMatcher = methodMatcher;
            this.variable = variable;
            this.variableType = variableType;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((J.MethodInvocation)m)) {
                JavaType.Method methodType = null;
                if (((J.MethodInvocation)m).getType() != null) {
                    LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(((J.MethodInvocation)m).getType().getFlags());
                    flags.remove((Object)Flag.Static);
                    methodType = ((J.MethodInvocation)m).getType().withDeclaringType(this.variableType).withFlags(flags);
                }
                m = ((J.MethodInvocation)m).withSelect(new JRightPadded<Expression>(J.Ident.build(Tree.randomId(), ((J.MethodInvocation)m).getSelect() == null ? Space.EMPTY : ((J.MethodInvocation)m).getSelect().getElem().getPrefix(), Markers.EMPTY, this.variable, this.variableType), Space.EMPTY)).withType(methodType);
                this.doAfterVisit(new OrderImports());
            }
            return m;
        }
    }
}

