/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.koloboke.collect.map.hash.HashObjObjMaps;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.internal.ClassDeclToString;
import org.openrewrite.java.internal.MethodDeclToString;
import org.openrewrite.java.internal.PrintJava;
import org.openrewrite.java.internal.VariableDeclsToString;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.FindFields;
import org.openrewrite.java.search.FindInheritedFields;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.FindType;
import org.openrewrite.java.search.HasImport;
import org.openrewrite.java.search.HasType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface J
extends Serializable,
Tree {
    default public <R> R accept(SourceVisitor<R> v) {
        return (R)(v instanceof JavaSourceVisitor ? this.acceptJava((JavaSourceVisitor)v) : v.defaultTo(null));
    }

    default public <R> R acceptJava(JavaSourceVisitor<R> v) {
        return (R)v.defaultTo(null);
    }

    default public String print() {
        return (String)new PrintJava().visit(this);
    }

    default public J withComments(List<Comment> comments) {
        return this;
    }

    public List<Comment> getComments();

    public static final class Wildcard
    implements J,
    Expression {
        private final UUID id;
        @Nullable
        private final Bound bound;
        @Nullable
        private final NameTree boundedType;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return null;
        }

        public Wildcard withType(JavaType type) {
            return this;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitWildcard(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wildcard)) {
                return false;
            }
            Wildcard other = (Wildcard)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "bound", "boundedType", "comments", "formatting", "markers"})
        public Wildcard(UUID id, Bound bound, NameTree boundedType, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.bound = bound;
            this.boundedType = boundedType;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Bound getBound() {
            return this.bound;
        }

        public NameTree getBoundedType() {
            return this.boundedType;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Wildcard(id=" + this.getId() + ", bound=" + this.getBound() + ", boundedType=" + this.getBoundedType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Wildcard withBound(Bound bound) {
            return this.bound == bound ? this : new Wildcard(this.id, bound, this.boundedType, this.comments, this.formatting, this.markers);
        }

        public Wildcard withBoundedType(NameTree boundedType) {
            return this.boundedType == boundedType ? this : new Wildcard(this.id, this.bound, boundedType, this.comments, this.formatting, this.markers);
        }

        @Override
        public Wildcard withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Wildcard(this.id, this.bound, this.boundedType, comments, this.formatting, this.markers);
        }

        public Wildcard withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Wildcard(this.id, this.bound, this.boundedType, this.comments, formatting, this.markers);
        }

        public Wildcard withMarkers(Markers markers) {
            return this.markers == markers ? this : new Wildcard(this.id, this.bound, this.boundedType, this.comments, this.formatting, markers);
        }

        public static abstract class Bound
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bound)) {
                    return false;
                }
                Bound other = (Bound)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Bound;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static final class Super
            extends Bound {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Super)) {
                        return false;
                    }
                    Super other = (Super)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Super;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Super(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Wildcard.Bound.Super(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Super withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Super(this.id, comments, this.formatting, this.markers);
                }

                public Super withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Super(this.id, this.comments, formatting, this.markers);
                }

                public Super withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Super(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Extends
            extends Bound {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Extends)) {
                        return false;
                    }
                    Extends other = (Extends)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Extends;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Extends(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Wildcard.Bound.Extends(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Extends withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Extends(this.id, comments, this.formatting, this.markers);
                }

                public Extends withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Extends(this.id, this.comments, formatting, this.markers);
                }

                public Extends withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Extends(this.id, this.comments, this.formatting, markers);
                }
            }
        }
    }

    public static final class WhileLoop
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> condition;
        private final Statement body;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitWhileLoop(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhileLoop)) {
                return false;
            }
            WhileLoop other = (WhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "condition", "body", "comments", "formatting", "markers"})
        public WhileLoop(UUID id, Parentheses<Expression> condition, Statement body, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.condition = condition;
            this.body = body;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getCondition() {
            return this.condition;
        }

        public Statement getBody() {
            return this.body;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.WhileLoop(id=" + this.getId() + ", condition=" + this.getCondition() + ", body=" + this.getBody() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public WhileLoop withCondition(Parentheses<Expression> condition) {
            return this.condition == condition ? this : new WhileLoop(this.id, condition, this.body, this.comments, this.formatting, this.markers);
        }

        public WhileLoop withBody(Statement body) {
            return this.body == body ? this : new WhileLoop(this.id, this.condition, body, this.comments, this.formatting, this.markers);
        }

        @Override
        public WhileLoop withComments(List<Comment> comments) {
            return this.comments == comments ? this : new WhileLoop(this.id, this.condition, this.body, comments, this.formatting, this.markers);
        }

        public WhileLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new WhileLoop(this.id, this.condition, this.body, this.comments, formatting, this.markers);
        }

        public WhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new WhileLoop(this.id, this.condition, this.body, this.comments, this.formatting, markers);
        }
    }

    public static final class VariableDecls
    implements J,
    Statement {
        private final UUID id;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeTree typeExpr;
        @Nullable
        private final Varargs varargs;
        private final List<Dimension> dimensionsBeforeName;
        private final List<NamedVar> vars;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public VariableDecls withModifiers(List<Modifier> modifiers) {
            if (modifiers == this.modifiers) {
                return this;
            }
            return new VariableDecls(this.id, this.annotations, modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.comments, this.formatting, this.markers);
        }

        public VariableDecls withModifiers(String ... modifierKeywords) {
            if (this.typeExpr == null) {
                return this;
            }
            List<Modifier> fixedModifiers = Modifier.withModifiers(this.modifiers, modifierKeywords);
            if (fixedModifiers == this.modifiers) {
                return this;
            }
            if (this.modifiers.isEmpty()) {
                return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.typeExpr.getPrefix())).withTypeExpr((TypeTree)this.typeExpr.withPrefix(" "));
            }
            return this.withModifiers(fixedModifiers);
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMultiVariable(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public List<Annotation> findAnnotations(String signature) {
            return (List)new FindAnnotations(signature).visit(this);
        }

        @JsonIgnore
        public JavaType.Class getTypeAsClass() {
            return this.typeExpr == null ? null : TypeUtils.asClass(this.typeExpr.getType());
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "VariableDecls{" + VariableDeclsToString.toString(this) + "}";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableDecls)) {
                return false;
            }
            VariableDecls other = (VariableDecls)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "modifiers", "typeExpr", "varargs", "dimensionsBeforeName", "vars", "comments", "formatting", "markers"})
        public VariableDecls(UUID id, List<Annotation> annotations, List<Modifier> modifiers, TypeTree typeExpr, Varargs varargs, List<Dimension> dimensionsBeforeName, List<NamedVar> vars, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeExpr = typeExpr;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.vars = vars;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public Varargs getVarargs() {
            return this.varargs;
        }

        public List<Dimension> getDimensionsBeforeName() {
            return this.dimensionsBeforeName;
        }

        public List<NamedVar> getVars() {
            return this.vars;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public VariableDecls withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new VariableDecls(this.id, annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.comments, this.formatting, this.markers);
        }

        public VariableDecls withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new VariableDecls(this.id, this.annotations, this.modifiers, typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.comments, this.formatting, this.markers);
        }

        public VariableDecls withVarargs(Varargs varargs) {
            return this.varargs == varargs ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, varargs, this.dimensionsBeforeName, this.vars, this.comments, this.formatting, this.markers);
        }

        public VariableDecls withDimensionsBeforeName(List<Dimension> dimensionsBeforeName) {
            return this.dimensionsBeforeName == dimensionsBeforeName ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, dimensionsBeforeName, this.vars, this.comments, this.formatting, this.markers);
        }

        public VariableDecls withVars(List<NamedVar> vars) {
            return this.vars == vars ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, vars, this.comments, this.formatting, this.markers);
        }

        @Override
        public VariableDecls withComments(List<Comment> comments) {
            return this.comments == comments ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, comments, this.formatting, this.markers);
        }

        public VariableDecls withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.comments, formatting, this.markers);
        }

        public VariableDecls withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableDecls(this.id, this.annotations, this.modifiers, this.typeExpr, this.varargs, this.dimensionsBeforeName, this.vars, this.comments, this.formatting, markers);
        }

        public static final class NamedVar
        implements J,
        NameTree {
            private final UUID id;
            private final Ident name;
            private final List<Dimension> dimensionsAfterName;
            @Nullable
            private final Expression initializer;
            @Nullable
            private final JavaType type;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @JsonIgnore
            public String getSimpleName() {
                return this.name.getSimpleName();
            }

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitVariable(this);
            }

            @JsonIgnore
            public boolean isField(Cursor cursor) {
                return cursor.getParentOrThrow().getParentOrThrow().getParentOrThrow().getTree() instanceof ClassDecl;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NamedVar)) {
                    return false;
                }
                NamedVar other = (NamedVar)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "name", "dimensionsAfterName", "initializer", "type", "comments", "formatting", "markers"})
            public NamedVar(UUID id, Ident name, List<Dimension> dimensionsAfterName, Expression initializer, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.type = type;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Ident getName() {
                return this.name;
            }

            public List<Dimension> getDimensionsAfterName() {
                return this.dimensionsAfterName;
            }

            public Expression getInitializer() {
                return this.initializer;
            }

            @Override
            public JavaType getType() {
                return this.type;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.VariableDecls.NamedVar(id=" + this.getId() + ", name=" + this.getName() + ", dimensionsAfterName=" + this.getDimensionsAfterName() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public NamedVar withName(Ident name) {
                return this.name == name ? this : new NamedVar(this.id, name, this.dimensionsAfterName, this.initializer, this.type, this.comments, this.formatting, this.markers);
            }

            public NamedVar withDimensionsAfterName(List<Dimension> dimensionsAfterName) {
                return this.dimensionsAfterName == dimensionsAfterName ? this : new NamedVar(this.id, this.name, dimensionsAfterName, this.initializer, this.type, this.comments, this.formatting, this.markers);
            }

            public NamedVar withInitializer(Expression initializer) {
                return this.initializer == initializer ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, initializer, this.type, this.comments, this.formatting, this.markers);
            }

            public NamedVar withType(JavaType type) {
                return this.type == type ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, this.initializer, type, this.comments, this.formatting, this.markers);
            }

            @Override
            public NamedVar withComments(List<Comment> comments) {
                return this.comments == comments ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, this.initializer, this.type, comments, this.formatting, this.markers);
            }

            public NamedVar withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, this.initializer, this.type, this.comments, formatting, this.markers);
            }

            public NamedVar withMarkers(Markers markers) {
                return this.markers == markers ? this : new NamedVar(this.id, this.name, this.dimensionsAfterName, this.initializer, this.type, this.comments, this.formatting, markers);
            }
        }

        public static final class Dimension
        implements J {
            private final UUID id;
            private final Empty whitespace;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "whitespace", "comments", "formatting", "markers"})
            public Dimension(UUID id, Empty whitespace, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.whitespace = whitespace;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Empty getWhitespace() {
                return this.whitespace;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.VariableDecls.Dimension(id=" + this.getId() + ", whitespace=" + this.getWhitespace() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Dimension withWhitespace(Empty whitespace) {
                return this.whitespace == whitespace ? this : new Dimension(this.id, whitespace, this.comments, this.formatting, this.markers);
            }

            @Override
            public Dimension withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Dimension(this.id, this.whitespace, comments, this.formatting, this.markers);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.whitespace, this.comments, formatting, this.markers);
            }

            public Dimension withMarkers(Markers markers) {
                return this.markers == markers ? this : new Dimension(this.id, this.whitespace, this.comments, this.formatting, markers);
            }
        }

        public static final class Varargs
        implements J {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Varargs)) {
                    return false;
                }
                Varargs other = (Varargs)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Varargs(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.VariableDecls.Varargs(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Varargs withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Varargs(this.id, comments, this.formatting, this.markers);
            }

            public Varargs withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Varargs(this.id, this.comments, formatting, this.markers);
            }

            public Varargs withMarkers(Markers markers) {
                return this.markers == markers ? this : new Varargs(this.id, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class UnparsedSource
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final String source;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return null;
        }

        public UnparsedSource withType(JavaType type) {
            return null;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitUnparsedSource(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnparsedSource)) {
                return false;
            }
            UnparsedSource other = (UnparsedSource)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "source", "comments", "formatting", "markers"})
        public UnparsedSource(UUID id, String source, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.source = source;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSource() {
            return this.source;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.UnparsedSource(id=" + this.getId() + ", source=" + this.getSource() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public UnparsedSource withSource(String source) {
            return this.source == source ? this : new UnparsedSource(this.id, source, this.comments, this.formatting, this.markers);
        }

        @Override
        public UnparsedSource withComments(List<Comment> comments) {
            return this.comments == comments ? this : new UnparsedSource(this.id, this.source, comments, this.formatting, this.markers);
        }

        public UnparsedSource withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new UnparsedSource(this.id, this.source, this.comments, formatting, this.markers);
        }

        public UnparsedSource withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnparsedSource(this.id, this.source, this.comments, this.formatting, markers);
        }
    }

    public static final class Unary
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Operator operator;
        private final Expression expr;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitUnary(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.expr.getSideEffects();
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "operator", "expr", "type", "comments", "formatting", "markers"})
        public Unary(UUID id, Operator operator, Expression expr, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.operator = operator;
            this.expr = expr;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Expression getExpr() {
            return this.expr;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Unary(id=" + this.getId() + ", operator=" + this.getOperator() + ", expr=" + this.getExpr() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Unary withOperator(Operator operator) {
            return this.operator == operator ? this : new Unary(this.id, operator, this.expr, this.type, this.comments, this.formatting, this.markers);
        }

        public Unary withExpr(Expression expr) {
            return this.expr == expr ? this : new Unary(this.id, this.operator, expr, this.type, this.comments, this.formatting, this.markers);
        }

        public Unary withType(JavaType type) {
            return this.type == type ? this : new Unary(this.id, this.operator, this.expr, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public Unary withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Unary(this.id, this.operator, this.expr, this.type, comments, this.formatting, this.markers);
        }

        public Unary withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Unary(this.id, this.operator, this.expr, this.type, this.comments, formatting, this.markers);
        }

        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.id, this.operator, this.expr, this.type, this.comments, this.formatting, markers);
        }

        public static abstract class Operator
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Operator)) {
                    return false;
                }
                Operator other = (Operator)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Operator;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public String toString() {
                return "J.Unary.Operator()";
            }

            public static final class Not
            extends Operator {
                private final UUID id;
                private final List<Comment> comments = Collections.emptyList();
                private final Formatting formatting = Formatting.EMPTY;
                private final Markers markers;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Not)) {
                        return false;
                    }
                    Not other = (Not)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Not;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "markers"})
                public Not(UUID id, Markers markers) {
                    this.id = id;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Not(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                public Not withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Not(this.id, markers);
                }
            }

            public static final class Complement
            extends Operator {
                private final UUID id;
                private final List<Comment> comments = Collections.emptyList();
                private final Formatting formatting = Formatting.EMPTY;
                private final Markers markers;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Complement)) {
                        return false;
                    }
                    Complement other = (Complement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Complement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "markers"})
                public Complement(UUID id, Markers markers) {
                    this.id = id;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Complement(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                public Complement withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Complement(this.id, markers);
                }
            }

            public static final class Negative
            extends Operator {
                private final UUID id;
                private final List<Comment> comments = Collections.emptyList();
                private final Formatting formatting = Formatting.EMPTY;
                private final Markers markers;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Negative)) {
                        return false;
                    }
                    Negative other = (Negative)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Negative;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "markers"})
                public Negative(UUID id, Markers markers) {
                    this.id = id;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Negative(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                public Negative withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Negative(this.id, markers);
                }
            }

            public static final class Positive
            extends Operator {
                private final UUID id;
                private final List<Comment> comments = Collections.emptyList();
                private final Formatting formatting = Formatting.EMPTY;
                private final Markers markers;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Positive)) {
                        return false;
                    }
                    Positive other = (Positive)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Positive;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "markers"})
                public Positive(UUID id, Markers markers) {
                    this.id = id;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.Positive(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                public Positive withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Positive(this.id, markers);
                }
            }

            public static final class PostDecrement
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PostDecrement)) {
                        return false;
                    }
                    PostDecrement other = (PostDecrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PostDecrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public PostDecrement(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PostDecrement(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public PostDecrement withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new PostDecrement(this.id, comments, this.formatting, this.markers);
                }

                public PostDecrement withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new PostDecrement(this.id, this.comments, formatting, this.markers);
                }

                public PostDecrement withMarkers(Markers markers) {
                    return this.markers == markers ? this : new PostDecrement(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class PostIncrement
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PostIncrement)) {
                        return false;
                    }
                    PostIncrement other = (PostIncrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PostIncrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public PostIncrement(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PostIncrement(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public PostIncrement withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new PostIncrement(this.id, comments, this.formatting, this.markers);
                }

                public PostIncrement withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new PostIncrement(this.id, this.comments, formatting, this.markers);
                }

                public PostIncrement withMarkers(Markers markers) {
                    return this.markers == markers ? this : new PostIncrement(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class PreDecrement
            extends Operator {
                private final UUID id;
                private final List<Comment> comments = Collections.emptyList();
                private final Formatting formatting = Formatting.EMPTY;
                private final Markers markers;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PreDecrement)) {
                        return false;
                    }
                    PreDecrement other = (PreDecrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PreDecrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "markers"})
                public PreDecrement(UUID id, Markers markers) {
                    this.id = id;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PreDecrement(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                public PreDecrement withMarkers(Markers markers) {
                    return this.markers == markers ? this : new PreDecrement(this.id, markers);
                }
            }

            public static final class PreIncrement
            extends Operator {
                private final UUID id;
                private final List<Comment> comments = Collections.emptyList();
                private final Formatting formatting = Formatting.EMPTY;
                private final Markers markers;

                public <T extends Tree> T withFormatting(Formatting fmt) {
                    return (T)this;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PreIncrement)) {
                        return false;
                    }
                    PreIncrement other = (PreIncrement)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof PreIncrement;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "markers"})
                public PreIncrement(UUID id, Markers markers) {
                    this.id = id;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                @Override
                public String toString() {
                    return "J.Unary.Operator.PreIncrement(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                public PreIncrement withMarkers(Markers markers) {
                    return this.markers == markers ? this : new PreIncrement(this.id, markers);
                }
            }
        }
    }

    public static final class TypeParameters
    implements J {
        private final UUID id;
        private final List<TypeParameter> params;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTypeParameters(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameters)) {
                return false;
            }
            TypeParameters other = (TypeParameters)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "params", "comments", "formatting", "markers"})
        public TypeParameters(UUID id, List<TypeParameter> params, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.params = params;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public List<TypeParameter> getParams() {
            return this.params;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.TypeParameters(id=" + this.getId() + ", params=" + this.getParams() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public TypeParameters withParams(List<TypeParameter> params) {
            return this.params == params ? this : new TypeParameters(this.id, params, this.comments, this.formatting, this.markers);
        }

        @Override
        public TypeParameters withComments(List<Comment> comments) {
            return this.comments == comments ? this : new TypeParameters(this.id, this.params, comments, this.formatting, this.markers);
        }

        public TypeParameters withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new TypeParameters(this.id, this.params, this.comments, formatting, this.markers);
        }

        public TypeParameters withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameters(this.id, this.params, this.comments, this.formatting, markers);
        }
    }

    public static final class TypeParameter
    implements J {
        private final UUID id;
        private final List<Annotation> annotations;
        private final Expression name;
        @Nullable
        private final Bounds bounds;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTypeParameter(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameter)) {
                return false;
            }
            TypeParameter other = (TypeParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "name", "bounds", "comments", "formatting", "markers"})
        public TypeParameter(UUID id, List<Annotation> annotations, Expression name, Bounds bounds, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.annotations = annotations;
            this.name = name;
            this.bounds = bounds;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Expression getName() {
            return this.name;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.TypeParameter(id=" + this.getId() + ", annotations=" + this.getAnnotations() + ", name=" + this.getName() + ", bounds=" + this.getBounds() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public TypeParameter withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameter(this.id, annotations, this.name, this.bounds, this.comments, this.formatting, this.markers);
        }

        public TypeParameter withName(Expression name) {
            return this.name == name ? this : new TypeParameter(this.id, this.annotations, name, this.bounds, this.comments, this.formatting, this.markers);
        }

        public TypeParameter withBounds(Bounds bounds) {
            return this.bounds == bounds ? this : new TypeParameter(this.id, this.annotations, this.name, bounds, this.comments, this.formatting, this.markers);
        }

        @Override
        public TypeParameter withComments(List<Comment> comments) {
            return this.comments == comments ? this : new TypeParameter(this.id, this.annotations, this.name, this.bounds, comments, this.formatting, this.markers);
        }

        public TypeParameter withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new TypeParameter(this.id, this.annotations, this.name, this.bounds, this.comments, formatting, this.markers);
        }

        public TypeParameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameter(this.id, this.annotations, this.name, this.bounds, this.comments, this.formatting, markers);
        }

        public static final class Bounds
        implements J {
            private final UUID id;
            private final List<TypeTree> types;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bounds)) {
                    return false;
                }
                Bounds other = (Bounds)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "types", "comments", "formatting", "markers"})
            public Bounds(UUID id, List<TypeTree> types, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.types = types;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<TypeTree> getTypes() {
                return this.types;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.TypeParameter.Bounds(id=" + this.getId() + ", types=" + this.getTypes() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Bounds withTypes(List<TypeTree> types) {
                return this.types == types ? this : new Bounds(this.id, types, this.comments, this.formatting, this.markers);
            }

            @Override
            public Bounds withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Bounds(this.id, this.types, comments, this.formatting, this.markers);
            }

            public Bounds withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Bounds(this.id, this.types, this.comments, formatting, this.markers);
            }

            public Bounds withMarkers(Markers markers) {
                return this.markers == markers ? this : new Bounds(this.id, this.types, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class TypeCast
    implements J,
    Expression {
        private final UUID id;
        private final Parentheses<TypeTree> clazz;
        private final Expression expr;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public TypeCast withType(JavaType type) {
            return this.withClazz((Parentheses<TypeTree>)this.clazz.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTypeCast(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCast)) {
                return false;
            }
            TypeCast other = (TypeCast)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "clazz", "expr", "comments", "formatting", "markers"})
        public TypeCast(UUID id, Parentheses<TypeTree> clazz, Expression expr, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.clazz = clazz;
            this.expr = expr;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<TypeTree> getClazz() {
            return this.clazz;
        }

        public Expression getExpr() {
            return this.expr;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.TypeCast(id=" + this.getId() + ", clazz=" + this.getClazz() + ", expr=" + this.getExpr() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public TypeCast withClazz(Parentheses<TypeTree> clazz) {
            return this.clazz == clazz ? this : new TypeCast(this.id, clazz, this.expr, this.comments, this.formatting, this.markers);
        }

        public TypeCast withExpr(Expression expr) {
            return this.expr == expr ? this : new TypeCast(this.id, this.clazz, expr, this.comments, this.formatting, this.markers);
        }

        @Override
        public TypeCast withComments(List<Comment> comments) {
            return this.comments == comments ? this : new TypeCast(this.id, this.clazz, this.expr, comments, this.formatting, this.markers);
        }

        public TypeCast withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new TypeCast(this.id, this.clazz, this.expr, this.comments, formatting, this.markers);
        }

        public TypeCast withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeCast(this.id, this.clazz, this.expr, this.comments, this.formatting, markers);
        }
    }

    public static final class Try
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Resources resources;
        private final Block<Statement> body;
        private final List<Catch> catches;
        @Nullable
        private final Finally finallie;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public Try withFinally(Finally finallie) {
            if (finallie == this.finallie) {
                return this;
            }
            return new Try(this.id, this.resources, this.body, this.catches, finallie, this.comments, this.formatting, this.markers);
        }

        @Nullable
        public Finally getFinally() {
            return this.finallie;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTry(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Try)) {
                return false;
            }
            Try other = (Try)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "resources", "body", "catches", "finallie", "comments", "formatting", "markers"})
        public Try(UUID id, Resources resources, Block<Statement> body, List<Catch> catches, Finally finallie, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Try withResources(Resources resources) {
            return this.resources == resources ? this : new Try(this.id, resources, this.body, this.catches, this.finallie, this.comments, this.formatting, this.markers);
        }

        public Resources getResources() {
            return this.resources;
        }

        public Try withBody(Block<Statement> body) {
            return this.body == body ? this : new Try(this.id, this.resources, body, this.catches, this.finallie, this.comments, this.formatting, this.markers);
        }

        public Block<Statement> getBody() {
            return this.body;
        }

        public Try withCatches(List<Catch> catches) {
            return this.catches == catches ? this : new Try(this.id, this.resources, this.body, catches, this.finallie, this.comments, this.formatting, this.markers);
        }

        public List<Catch> getCatches() {
            return this.catches;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        @Override
        public Try withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Try(this.id, this.resources, this.body, this.catches, this.finallie, comments, this.formatting, this.markers);
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Try withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Try(this.id, this.resources, this.body, this.catches, this.finallie, this.comments, formatting, this.markers);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Try withMarkers(Markers markers) {
            return this.markers == markers ? this : new Try(this.id, this.resources, this.body, this.catches, this.finallie, this.comments, this.formatting, markers);
        }

        public static final class Finally
        implements J {
            private final UUID id;
            private final Block<Statement> body;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitFinally(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Finally)) {
                    return false;
                }
                Finally other = (Finally)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "body", "comments", "formatting", "markers"})
            public Finally(UUID id, Block<Statement> body, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.body = body;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Block<Statement> getBody() {
                return this.body;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Try.Finally(id=" + this.getId() + ", body=" + this.getBody() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Finally withBody(Block<Statement> body) {
                return this.body == body ? this : new Finally(this.id, body, this.comments, this.formatting, this.markers);
            }

            @Override
            public Finally withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Finally(this.id, this.body, comments, this.formatting, this.markers);
            }

            public Finally withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Finally(this.id, this.body, this.comments, formatting, this.markers);
            }

            public Finally withMarkers(Markers markers) {
                return this.markers == markers ? this : new Finally(this.id, this.body, this.comments, this.formatting, markers);
            }
        }

        public static final class Catch
        implements J {
            private final UUID id;
            private final Parentheses<VariableDecls> param;
            private final Block<Statement> body;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitCatch(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Catch)) {
                    return false;
                }
                Catch other = (Catch)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "param", "body", "comments", "formatting", "markers"})
            public Catch(UUID id, Parentheses<VariableDecls> param, Block<Statement> body, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.param = param;
                this.body = body;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Parentheses<VariableDecls> getParam() {
                return this.param;
            }

            public Block<Statement> getBody() {
                return this.body;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Try.Catch(id=" + this.getId() + ", param=" + this.getParam() + ", body=" + this.getBody() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Catch withParam(Parentheses<VariableDecls> param) {
                return this.param == param ? this : new Catch(this.id, param, this.body, this.comments, this.formatting, this.markers);
            }

            public Catch withBody(Block<Statement> body) {
                return this.body == body ? this : new Catch(this.id, this.param, body, this.comments, this.formatting, this.markers);
            }

            @Override
            public Catch withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Catch(this.id, this.param, this.body, comments, this.formatting, this.markers);
            }

            public Catch withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Catch(this.id, this.param, this.body, this.comments, formatting, this.markers);
            }

            public Catch withMarkers(Markers markers) {
                return this.markers == markers ? this : new Catch(this.id, this.param, this.body, this.comments, this.formatting, markers);
            }
        }

        public static final class Resources
        implements J {
            private final UUID id;
            private final List<VariableDecls> decls;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resources)) {
                    return false;
                }
                Resources other = (Resources)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "decls", "comments", "formatting", "markers"})
            public Resources(UUID id, List<VariableDecls> decls, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.decls = decls;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<VariableDecls> getDecls() {
                return this.decls;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Try.Resources(id=" + this.getId() + ", decls=" + this.getDecls() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Resources withDecls(List<VariableDecls> decls) {
                return this.decls == decls ? this : new Resources(this.id, decls, this.comments, this.formatting, this.markers);
            }

            @Override
            public Resources withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Resources(this.id, this.decls, comments, this.formatting, this.markers);
            }

            public Resources withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Resources(this.id, this.decls, this.comments, formatting, this.markers);
            }

            public Resources withMarkers(Markers markers) {
                return this.markers == markers ? this : new Resources(this.id, this.decls, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class Throw
    implements J,
    Statement {
        private final UUID id;
        private final Expression exception;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitThrow(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throw)) {
                return false;
            }
            Throw other = (Throw)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "exception", "comments", "formatting", "markers"})
        public Throw(UUID id, Expression exception, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.exception = exception;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getException() {
            return this.exception;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Throw(id=" + this.getId() + ", exception=" + this.getException() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Throw withException(Expression exception) {
            return this.exception == exception ? this : new Throw(this.id, exception, this.comments, this.formatting, this.markers);
        }

        @Override
        public Throw withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Throw(this.id, this.exception, comments, this.formatting, this.markers);
        }

        public Throw withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Throw(this.id, this.exception, this.comments, formatting, this.markers);
        }

        public Throw withMarkers(Markers markers) {
            return this.markers == markers ? this : new Throw(this.id, this.exception, this.comments, this.formatting, markers);
        }
    }

    public static final class Ternary
    implements J,
    Expression {
        private final UUID id;
        private final Expression condition;
        private final Expression truePart;
        private final Expression falsePart;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitTernary(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ternary)) {
                return false;
            }
            Ternary other = (Ternary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "condition", "truePart", "falsePart", "type", "comments", "formatting", "markers"})
        public Ternary(UUID id, Expression condition, Expression truePart, Expression falsePart, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public Expression getTruePart() {
            return this.truePart;
        }

        public Expression getFalsePart() {
            return this.falsePart;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Ternary(id=" + this.getId() + ", condition=" + this.getCondition() + ", truePart=" + this.getTruePart() + ", falsePart=" + this.getFalsePart() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Ternary withCondition(Expression condition) {
            return this.condition == condition ? this : new Ternary(this.id, condition, this.truePart, this.falsePart, this.type, this.comments, this.formatting, this.markers);
        }

        public Ternary withTruePart(Expression truePart) {
            return this.truePart == truePart ? this : new Ternary(this.id, this.condition, truePart, this.falsePart, this.type, this.comments, this.formatting, this.markers);
        }

        public Ternary withFalsePart(Expression falsePart) {
            return this.falsePart == falsePart ? this : new Ternary(this.id, this.condition, this.truePart, falsePart, this.type, this.comments, this.formatting, this.markers);
        }

        public Ternary withType(JavaType type) {
            return this.type == type ? this : new Ternary(this.id, this.condition, this.truePart, this.falsePart, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public Ternary withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Ternary(this.id, this.condition, this.truePart, this.falsePart, this.type, comments, this.formatting, this.markers);
        }

        public Ternary withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Ternary(this.id, this.condition, this.truePart, this.falsePart, this.type, this.comments, formatting, this.markers);
        }

        public Ternary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ternary(this.id, this.condition, this.truePart, this.falsePart, this.type, this.comments, this.formatting, markers);
        }
    }

    public static final class Synchronized
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> lock;
        private final Block<Statement> body;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitSynchronized(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Synchronized)) {
                return false;
            }
            Synchronized other = (Synchronized)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "lock", "body", "comments", "formatting", "markers"})
        public Synchronized(UUID id, Parentheses<Expression> lock, Block<Statement> body, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.lock = lock;
            this.body = body;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getLock() {
            return this.lock;
        }

        public Block<Statement> getBody() {
            return this.body;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Synchronized(id=" + this.getId() + ", lock=" + this.getLock() + ", body=" + this.getBody() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Synchronized withLock(Parentheses<Expression> lock) {
            return this.lock == lock ? this : new Synchronized(this.id, lock, this.body, this.comments, this.formatting, this.markers);
        }

        public Synchronized withBody(Block<Statement> body) {
            return this.body == body ? this : new Synchronized(this.id, this.lock, body, this.comments, this.formatting, this.markers);
        }

        @Override
        public Synchronized withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Synchronized(this.id, this.lock, this.body, comments, this.formatting, this.markers);
        }

        public Synchronized withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Synchronized(this.id, this.lock, this.body, this.comments, formatting, this.markers);
        }

        public Synchronized withMarkers(Markers markers) {
            return this.markers == markers ? this : new Synchronized(this.id, this.lock, this.body, this.comments, this.formatting, markers);
        }
    }

    public static final class Switch
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> selector;
        private final Block<Case> cases;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitSwitch(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Switch)) {
                return false;
            }
            Switch other = (Switch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "selector", "cases", "comments", "formatting", "markers"})
        public Switch(UUID id, Parentheses<Expression> selector, Block<Case> cases, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.selector = selector;
            this.cases = cases;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getSelector() {
            return this.selector;
        }

        public Block<Case> getCases() {
            return this.cases;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Switch(id=" + this.getId() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Switch withSelector(Parentheses<Expression> selector) {
            return this.selector == selector ? this : new Switch(this.id, selector, this.cases, this.comments, this.formatting, this.markers);
        }

        public Switch withCases(Block<Case> cases) {
            return this.cases == cases ? this : new Switch(this.id, this.selector, cases, this.comments, this.formatting, this.markers);
        }

        @Override
        public Switch withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Switch(this.id, this.selector, this.cases, comments, this.formatting, this.markers);
        }

        public Switch withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Switch(this.id, this.selector, this.cases, this.comments, formatting, this.markers);
        }

        public Switch withMarkers(Markers markers) {
            return this.markers == markers ? this : new Switch(this.id, this.selector, this.cases, this.comments, this.formatting, markers);
        }
    }

    public static final class Return
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Expression expr;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitReturn(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "expr", "comments", "formatting", "markers"})
        public Return(UUID id, Expression expr, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.expr = expr;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getExpr() {
            return this.expr;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Return(id=" + this.getId() + ", expr=" + this.getExpr() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Return withExpr(Expression expr) {
            return this.expr == expr ? this : new Return(this.id, expr, this.comments, this.formatting, this.markers);
        }

        @Override
        public Return withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Return(this.id, this.expr, comments, this.formatting, this.markers);
        }

        public Return withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Return(this.id, this.expr, this.comments, formatting, this.markers);
        }

        public Return withMarkers(Markers markers) {
            return this.markers == markers ? this : new Return(this.id, this.expr, this.comments, this.formatting, markers);
        }
    }

    public static final class Primitive
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final JavaType.Primitive type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public Primitive withType(JavaType type) {
            if (!(type instanceof JavaType.Primitive)) {
                throw new IllegalArgumentException("Cannot apply a non-primitive type to Primitive");
            }
            return new Primitive(this.id, (JavaType.Primitive)type, this.comments, this.formatting, this.markers);
        }

        @Override
        @NonNull
        public JavaType.Primitive getType() {
            return this.type;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitPrimitive(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primitive)) {
                return false;
            }
            Primitive other = (Primitive)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "type", "comments", "formatting", "markers"})
        public Primitive(UUID id, JavaType.Primitive type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        @Override
        public Primitive withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Primitive(this.id, this.type, comments, this.formatting, this.markers);
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Primitive withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Primitive(this.id, this.type, this.comments, formatting, this.markers);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Primitive withMarkers(Markers markers) {
            return this.markers == markers ? this : new Primitive(this.id, this.type, this.comments, this.formatting, markers);
        }
    }

    public static final class Parentheses<T extends J>
    implements J,
    Expression {
        private final UUID id;
        private final T tree;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitParentheses(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.tree instanceof Expression ? ((Expression)this.tree).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree instanceof Expression ? ((Expression)this.tree).getType() : (this.tree instanceof NameTree ? ((NameTree)this.tree).getType() : null);
        }

        public Parentheses<T> withType(JavaType type) {
            return this.tree instanceof Expression ? (Parentheses)((Expression)this.tree).withType(type) : (this.tree instanceof NameTree ? (Parentheses)((NameTree)this.tree).withType(type) : this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "tree", "comments", "formatting", "markers"})
        public Parentheses(UUID id, T tree, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.tree = tree;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public T getTree() {
            return this.tree;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Parentheses(id=" + this.getId() + ", tree=" + this.getTree() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Parentheses<T> withTree(T tree) {
            return this.tree == tree ? this : new Parentheses<T>(this.id, tree, this.comments, this.formatting, this.markers);
        }

        @Override
        public Parentheses<T> withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Parentheses<T>(this.id, this.tree, comments, this.formatting, this.markers);
        }

        public Parentheses<T> withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Parentheses<T>(this.id, this.tree, this.comments, formatting, this.markers);
        }

        public Parentheses<T> withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parentheses<T>(this.id, this.tree, this.comments, this.formatting, markers);
        }
    }

    public static final class ParameterizedType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final NameTree clazz;
        @Nullable
        private final TypeParameters typeParameters;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public ParameterizedType withType(JavaType type) {
            return this.withClazz((NameTree)this.clazz.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitParameterizedType(this);
        }

        public static ParameterizedType build(String typeName, String ... genericTypeNames) {
            JavaType.Class typeNameType = JavaType.Class.build(typeName);
            return new ParameterizedType(Tree.randomId(), Ident.build(Tree.randomId(), typeNameType.getClassName(), typeNameType, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), new TypeParameters(Tree.randomId(), Formatting.formatFirstPrefix(Arrays.stream(genericTypeNames).map(generic -> {
                JavaType.Class genericType = JavaType.Class.build(generic);
                return new TypeParameter(Tree.randomId(), Collections.emptyList(), Ident.build(Tree.randomId(), genericType.getClassName(), genericType, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), null, Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY);
            }).collect(Collectors.toList()), (String)""), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "clazz", "typeParameters", "comments", "formatting", "markers"})
        public ParameterizedType(UUID id, NameTree clazz, TypeParameters typeParameters, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public NameTree getClazz() {
            return this.clazz;
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.ParameterizedType(id=" + this.getId() + ", clazz=" + this.getClazz() + ", typeParameters=" + this.getTypeParameters() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public ParameterizedType withClazz(NameTree clazz) {
            return this.clazz == clazz ? this : new ParameterizedType(this.id, clazz, this.typeParameters, this.comments, this.formatting, this.markers);
        }

        public ParameterizedType withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new ParameterizedType(this.id, this.clazz, typeParameters, this.comments, this.formatting, this.markers);
        }

        @Override
        public ParameterizedType withComments(List<Comment> comments) {
            return this.comments == comments ? this : new ParameterizedType(this.id, this.clazz, this.typeParameters, comments, this.formatting, this.markers);
        }

        public ParameterizedType withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ParameterizedType(this.id, this.clazz, this.typeParameters, this.comments, formatting, this.markers);
        }

        public ParameterizedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ParameterizedType(this.id, this.clazz, this.typeParameters, this.comments, this.formatting, markers);
        }
    }

    public static final class Package
    implements J {
        private final UUID id;
        private final Expression expr;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitPackage(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Package)) {
                return false;
            }
            Package other = (Package)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "expr", "comments", "formatting", "markers"})
        public Package(UUID id, Expression expr, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.expr = expr;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getExpr() {
            return this.expr;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Package(id=" + this.getId() + ", expr=" + this.getExpr() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Package withExpr(Expression expr) {
            return this.expr == expr ? this : new Package(this.id, expr, this.comments, this.formatting, this.markers);
        }

        @Override
        public Package withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Package(this.id, this.expr, comments, this.formatting, this.markers);
        }

        public Package withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Package(this.id, this.expr, this.comments, formatting, this.markers);
        }

        public Package withMarkers(Markers markers) {
            return this.markers == markers ? this : new Package(this.id, this.expr, this.comments, this.formatting, markers);
        }
    }

    public static final class NewClass
    implements J,
    Statement,
    Expression {
        private final UUID id;
        @Nullable
        private final Expression encl;
        private final New nooh;
        @Nullable
        private final TypeTree clazz;
        @Nullable
        private final Arguments args;
        @Nullable
        private final Block<? extends Tree> body;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public NewClass withNew(New nooh) {
            return new NewClass(this.id, this.encl, nooh, this.clazz, this.args, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitNewClass(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewClass)) {
                return false;
            }
            NewClass other = (NewClass)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "encl", "nooh", "clazz", "args", "body", "type", "comments", "formatting", "markers"})
        public NewClass(UUID id, Expression encl, New nooh, TypeTree clazz, Arguments args, Block<? extends Tree> body, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.encl = encl;
            this.nooh = nooh;
            this.clazz = clazz;
            this.args = args;
            this.body = body;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getEncl() {
            return this.encl;
        }

        public New getNooh() {
            return this.nooh;
        }

        public TypeTree getClazz() {
            return this.clazz;
        }

        public Arguments getArgs() {
            return this.args;
        }

        public Block<? extends Tree> getBody() {
            return this.body;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.NewClass(id=" + this.getId() + ", encl=" + this.getEncl() + ", nooh=" + this.getNooh() + ", clazz=" + this.getClazz() + ", args=" + this.getArgs() + ", body=" + this.getBody() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public NewClass withEncl(Expression encl) {
            return this.encl == encl ? this : new NewClass(this.id, encl, this.nooh, this.clazz, this.args, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public NewClass withClazz(TypeTree clazz) {
            return this.clazz == clazz ? this : new NewClass(this.id, this.encl, this.nooh, clazz, this.args, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public NewClass withArgs(Arguments args) {
            return this.args == args ? this : new NewClass(this.id, this.encl, this.nooh, this.clazz, args, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public NewClass withBody(Block<? extends Tree> body) {
            return this.body == body ? this : new NewClass(this.id, this.encl, this.nooh, this.clazz, this.args, body, this.type, this.comments, this.formatting, this.markers);
        }

        public NewClass withType(JavaType type) {
            return this.type == type ? this : new NewClass(this.id, this.encl, this.nooh, this.clazz, this.args, this.body, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public NewClass withComments(List<Comment> comments) {
            return this.comments == comments ? this : new NewClass(this.id, this.encl, this.nooh, this.clazz, this.args, this.body, this.type, comments, this.formatting, this.markers);
        }

        public NewClass withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new NewClass(this.id, this.encl, this.nooh, this.clazz, this.args, this.body, this.type, this.comments, formatting, this.markers);
        }

        public NewClass withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewClass(this.id, this.encl, this.nooh, this.clazz, this.args, this.body, this.type, this.comments, this.formatting, markers);
        }

        public static final class New
        implements J {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof New)) {
                    return false;
                }
                New other = (New)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public New(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.NewClass.New(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public New withComments(List<Comment> comments) {
                return this.comments == comments ? this : new New(this.id, comments, this.formatting, this.markers);
            }

            public New withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new New(this.id, this.comments, formatting, this.markers);
            }

            public New withMarkers(Markers markers) {
                return this.markers == markers ? this : new New(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Arguments
        implements J {
            private final UUID id;
            private final List<Expression> args;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arguments)) {
                    return false;
                }
                Arguments other = (Arguments)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "args", "comments", "formatting", "markers"})
            public Arguments(UUID id, List<Expression> args, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.args = args;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getArgs() {
                return this.args;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.NewClass.Arguments(id=" + this.getId() + ", args=" + this.getArgs() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Arguments withArgs(List<Expression> args) {
                return this.args == args ? this : new Arguments(this.id, args, this.comments, this.formatting, this.markers);
            }

            @Override
            public Arguments withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Arguments(this.id, this.args, comments, this.formatting, this.markers);
            }

            public Arguments withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arguments(this.id, this.args, this.comments, formatting, this.markers);
            }

            public Arguments withMarkers(Markers markers) {
                return this.markers == markers ? this : new Arguments(this.id, this.args, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class NewArray
    implements J,
    Expression {
        private final UUID id;
        @Nullable
        private final TypeTree typeExpr;
        private final List<Dimension> dimensions;
        @Nullable
        private final Initializer initializer;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitNewArray(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewArray)) {
                return false;
            }
            NewArray other = (NewArray)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "typeExpr", "dimensions", "initializer", "type", "comments", "formatting", "markers"})
        public NewArray(UUID id, TypeTree typeExpr, List<Dimension> dimensions, Initializer initializer, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.typeExpr = typeExpr;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        public List<Dimension> getDimensions() {
            return this.dimensions;
        }

        public Initializer getInitializer() {
            return this.initializer;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.NewArray(id=" + this.getId() + ", typeExpr=" + this.getTypeExpr() + ", dimensions=" + this.getDimensions() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public NewArray withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new NewArray(this.id, typeExpr, this.dimensions, this.initializer, this.type, this.comments, this.formatting, this.markers);
        }

        public NewArray withDimensions(List<Dimension> dimensions) {
            return this.dimensions == dimensions ? this : new NewArray(this.id, this.typeExpr, dimensions, this.initializer, this.type, this.comments, this.formatting, this.markers);
        }

        public NewArray withInitializer(Initializer initializer) {
            return this.initializer == initializer ? this : new NewArray(this.id, this.typeExpr, this.dimensions, initializer, this.type, this.comments, this.formatting, this.markers);
        }

        public NewArray withType(JavaType type) {
            return this.type == type ? this : new NewArray(this.id, this.typeExpr, this.dimensions, this.initializer, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public NewArray withComments(List<Comment> comments) {
            return this.comments == comments ? this : new NewArray(this.id, this.typeExpr, this.dimensions, this.initializer, this.type, comments, this.formatting, this.markers);
        }

        public NewArray withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new NewArray(this.id, this.typeExpr, this.dimensions, this.initializer, this.type, this.comments, formatting, this.markers);
        }

        public NewArray withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewArray(this.id, this.typeExpr, this.dimensions, this.initializer, this.type, this.comments, this.formatting, markers);
        }

        public static final class Initializer
        implements J {
            private final UUID id;
            private final List<Expression> elements;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Initializer)) {
                    return false;
                }
                Initializer other = (Initializer)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "elements", "comments", "formatting", "markers"})
            public Initializer(UUID id, List<Expression> elements, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.elements = elements;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getElements() {
                return this.elements;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.NewArray.Initializer(id=" + this.getId() + ", elements=" + this.getElements() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Initializer withElements(List<Expression> elements) {
                return this.elements == elements ? this : new Initializer(this.id, elements, this.comments, this.formatting, this.markers);
            }

            @Override
            public Initializer withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Initializer(this.id, this.elements, comments, this.formatting, this.markers);
            }

            public Initializer withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Initializer(this.id, this.elements, this.comments, formatting, this.markers);
            }

            public Initializer withMarkers(Markers markers) {
                return this.markers == markers ? this : new Initializer(this.id, this.elements, this.comments, this.formatting, markers);
            }
        }

        public static final class Dimension
        implements J {
            private final UUID id;
            private final Expression size;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "size", "comments", "formatting", "markers"})
            public Dimension(UUID id, Expression size, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.size = size;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Expression getSize() {
                return this.size;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.NewArray.Dimension(id=" + this.getId() + ", size=" + this.getSize() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Dimension withSize(Expression size) {
                return this.size == size ? this : new Dimension(this.id, size, this.comments, this.formatting, this.markers);
            }

            @Override
            public Dimension withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Dimension(this.id, this.size, comments, this.formatting, this.markers);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.size, this.comments, formatting, this.markers);
            }

            public Dimension withMarkers(Markers markers) {
                return this.markers == markers ? this : new Dimension(this.id, this.size, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class MultiCatch
    implements J,
    TypeTree {
        private final UUID id;
        private final List<NameTree> alternatives;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMultiCatch(this);
        }

        public MultiCatch withType(JavaType type) {
            return this;
        }

        @Override
        @JsonIgnore
        public JavaType getType() {
            return new JavaType.MultiCatch(this.alternatives.stream().filter(Objects::nonNull).map(NameTree::getType).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "alternatives", "comments", "formatting", "markers"})
        public MultiCatch(UUID id, List<NameTree> alternatives, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.alternatives = alternatives;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public List<NameTree> getAlternatives() {
            return this.alternatives;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.MultiCatch(id=" + this.getId() + ", alternatives=" + this.getAlternatives() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public MultiCatch withAlternatives(List<NameTree> alternatives) {
            return this.alternatives == alternatives ? this : new MultiCatch(this.id, alternatives, this.comments, this.formatting, this.markers);
        }

        @Override
        public MultiCatch withComments(List<Comment> comments) {
            return this.comments == comments ? this : new MultiCatch(this.id, this.alternatives, comments, this.formatting, this.markers);
        }

        public MultiCatch withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MultiCatch(this.id, this.alternatives, this.comments, formatting, this.markers);
        }

        public MultiCatch withMarkers(Markers markers) {
            return this.markers == markers ? this : new MultiCatch(this.id, this.alternatives, this.comments, this.formatting, markers);
        }
    }

    public static abstract class Modifier
    implements J {
        public static boolean hasModifier(Collection<Modifier> modifiers, String modifier) {
            return modifiers.stream().anyMatch(m -> m.getClass().getSimpleName().toLowerCase().equals(modifier));
        }

        public static List<Modifier> withVisibility(List<Modifier> existing, String visibility) {
            List<Modifier> modifiers = new ArrayList<Modifier>(existing);
            Modifier actualModifier = null;
            if (!visibility.equals("package")) {
                Modifier desiredModifier = Modifier.buildModifier(visibility, Formatting.EMPTY);
                actualModifier = existing.stream().filter(modifier -> modifier.getClass().equals(desiredModifier.getClass())).findAny().orElse(desiredModifier);
            }
            modifiers = Stream.concat(Stream.of(actualModifier), modifiers.stream().filter(mod -> !(mod instanceof Protected) && !(mod instanceof Private) && !(mod instanceof Public))).filter(Objects::nonNull).collect(Collectors.toList());
            return modifiers;
        }

        public static List<Modifier> withModifiers(List<Modifier> existing, String ... modifierKeywords) {
            boolean visibilityChanged = false;
            ArrayList<Modifier> modifiers = new ArrayList<Modifier>(existing);
            for (String modifier : modifierKeywords) {
                Modifier m;
                int i;
                int sizeBeforeAdd = modifiers.size();
                if ("final".equals(modifier) && !Modifier.hasModifier(existing, "final")) {
                    boolean finalAdded = false;
                    for (i = 0; i < sizeBeforeAdd; ++i) {
                        m = (Modifier)modifiers.get(i);
                        if (m instanceof Static) {
                            modifiers.add(i + 1, new Final(Tree.randomId(), Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY));
                            finalAdded = true;
                            break;
                        }
                        if (i != modifiers.size() - 1) continue;
                        modifiers.set(i, (Modifier)m.withSuffix(""));
                        modifiers.add(i + 1, new Final(Tree.randomId(), Collections.emptyList(), Formatting.format((String)" ", (String)m.getSuffix()), Markers.EMPTY));
                        finalAdded = true;
                    }
                    if (finalAdded) continue;
                    modifiers.add(0, new Final(Tree.randomId(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY));
                    continue;
                }
                if ("static".equals(modifier) && !Modifier.hasModifier(existing, "static")) {
                    boolean staticAdded = false;
                    int afterAccessModifier = 0;
                    for (int i2 = 0; i2 < sizeBeforeAdd; ++i2) {
                        Modifier m2 = (Modifier)modifiers.get(i2);
                        if (m2 instanceof Private || m2 instanceof Protected || m2 instanceof Public) {
                            afterAccessModifier = i2 + 1;
                        } else if (m2 instanceof Final) {
                            modifiers.set(i2, (Modifier)m2.withFormatting(Formatting.format((String)" ", (String)m2.getSuffix())));
                            modifiers.add(i2, new Static(Tree.randomId(), Collections.emptyList(), Formatting.format((String)m2.getPrefix()), Markers.EMPTY));
                            staticAdded = true;
                            break;
                        }
                        if (i2 != modifiers.size() - 1) continue;
                        modifiers.set(i2, (Modifier)m2.withSuffix(""));
                        modifiers.add(afterAccessModifier, new Static(Tree.randomId(), Collections.emptyList(), Formatting.format((String)" ", (String)m2.getSuffix()), Markers.EMPTY));
                        staticAdded = true;
                    }
                    if (staticAdded) continue;
                    modifiers.add(0, new Static(Tree.randomId(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY));
                    continue;
                }
                if (!"public".equals(modifier) && !"protected".equals(modifier) && !"private".equals(modifier) || Modifier.hasModifier(existing, modifier)) continue;
                boolean accessModifierAdded = false;
                for (i = 0; i < sizeBeforeAdd; ++i) {
                    m = (Modifier)modifiers.get(i);
                    if (m instanceof Private || m instanceof Protected || m instanceof Public) {
                        modifiers.set(i, Modifier.buildModifier(modifier, m.getFormatting()));
                        accessModifierAdded = true;
                        visibilityChanged = true;
                        break;
                    }
                    if (i != modifiers.size() - 1) continue;
                    modifiers.add(0, Modifier.buildModifier(modifier, Formatting.format((String)((Modifier)modifiers.get(0)).getPrefix(), (String)m.getSuffix())));
                    modifiers.set(i + 1, (Modifier)m.withFormatting(Formatting.format((String)" ", (String)"")));
                    accessModifierAdded = true;
                }
                if (accessModifierAdded) continue;
                modifiers.add(0, Modifier.buildModifier(modifier, Formatting.EMPTY));
            }
            return visibilityChanged || modifiers.size() > existing.size() ? modifiers : existing;
        }

        public static Modifier buildModifier(String modifier, Formatting formatting) {
            Modifier access;
            switch (modifier) {
                case "public": {
                    access = new Public(Tree.randomId(), Collections.emptyList(), formatting, Markers.EMPTY);
                    break;
                }
                case "protected": {
                    access = new Protected(Tree.randomId(), Collections.emptyList(), formatting, Markers.EMPTY);
                    break;
                }
                default: {
                    access = new Private(Tree.randomId(), Collections.emptyList(), formatting, Markers.EMPTY);
                }
            }
            return access;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof Modifier;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public static final class Volatile
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Volatile)) {
                    return false;
                }
                Volatile other = (Volatile)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Volatile;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Volatile(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Volatile(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Volatile withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Volatile(this.id, comments, this.formatting, this.markers);
            }

            public Volatile withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Volatile(this.id, this.comments, formatting, this.markers);
            }

            public Volatile withMarkers(Markers markers) {
                return this.markers == markers ? this : new Volatile(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Transient
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Transient)) {
                    return false;
                }
                Transient other = (Transient)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Transient;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Transient(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Transient(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Transient withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Transient(this.id, comments, this.formatting, this.markers);
            }

            public Transient withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Transient(this.id, this.comments, formatting, this.markers);
            }

            public Transient withMarkers(Markers markers) {
                return this.markers == markers ? this : new Transient(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Synchronized
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Synchronized)) {
                    return false;
                }
                Synchronized other = (Synchronized)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Synchronized;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Synchronized(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Synchronized(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Synchronized withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Synchronized(this.id, comments, this.formatting, this.markers);
            }

            public Synchronized withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Synchronized(this.id, this.comments, formatting, this.markers);
            }

            public Synchronized withMarkers(Markers markers) {
                return this.markers == markers ? this : new Synchronized(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Strictfp
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Strictfp)) {
                    return false;
                }
                Strictfp other = (Strictfp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Strictfp;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Strictfp(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Strictfp(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Strictfp withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Strictfp(this.id, comments, this.formatting, this.markers);
            }

            public Strictfp withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Strictfp(this.id, this.comments, formatting, this.markers);
            }

            public Strictfp withMarkers(Markers markers) {
                return this.markers == markers ? this : new Strictfp(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Native
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Native)) {
                    return false;
                }
                Native other = (Native)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Native;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Native(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Native(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Native withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Native(this.id, comments, this.formatting, this.markers);
            }

            public Native withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Native(this.id, this.comments, formatting, this.markers);
            }

            public Native withMarkers(Markers markers) {
                return this.markers == markers ? this : new Native(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Final
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Final)) {
                    return false;
                }
                Final other = (Final)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Final;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Final(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Final(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Final withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Final(this.id, comments, this.formatting, this.markers);
            }

            public Final withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Final(this.id, this.comments, formatting, this.markers);
            }

            public Final withMarkers(Markers markers) {
                return this.markers == markers ? this : new Final(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Static
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Static)) {
                    return false;
                }
                Static other = (Static)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Static;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Static(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Static(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Static withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Static(this.id, comments, this.formatting, this.markers);
            }

            public Static withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Static(this.id, this.comments, formatting, this.markers);
            }

            public Static withMarkers(Markers markers) {
                return this.markers == markers ? this : new Static(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Abstract
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Abstract)) {
                    return false;
                }
                Abstract other = (Abstract)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Abstract;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Abstract(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Abstract(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Abstract withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Abstract(this.id, comments, this.formatting, this.markers);
            }

            public Abstract withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Abstract(this.id, this.comments, formatting, this.markers);
            }

            public Abstract withMarkers(Markers markers) {
                return this.markers == markers ? this : new Abstract(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Private
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Private)) {
                    return false;
                }
                Private other = (Private)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Private;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Private(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Private(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Private withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Private(this.id, comments, this.formatting, this.markers);
            }

            public Private withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Private(this.id, this.comments, formatting, this.markers);
            }

            public Private withMarkers(Markers markers) {
                return this.markers == markers ? this : new Private(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Protected
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Protected)) {
                    return false;
                }
                Protected other = (Protected)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Protected;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Protected(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Protected(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Protected withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Protected(this.id, comments, this.formatting, this.markers);
            }

            public Protected withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Protected(this.id, this.comments, formatting, this.markers);
            }

            public Protected withMarkers(Markers markers) {
                return this.markers == markers ? this : new Protected(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Public
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Public)) {
                    return false;
                }
                Public other = (Public)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Public;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Public(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Public(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Public withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Public(this.id, comments, this.formatting, this.markers);
            }

            public Public withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Public(this.id, this.comments, formatting, this.markers);
            }

            public Public withMarkers(Markers markers) {
                return this.markers == markers ? this : new Public(this.id, this.comments, this.formatting, markers);
            }
        }

        public static final class Default
        extends Modifier {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Default)) {
                    return false;
                }
                Default other = (Default)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Override
            protected boolean canEqual(Object other) {
                return other instanceof Default;
            }

            @Override
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Default(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Modifier.Default(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Default withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Default(this.id, comments, this.formatting, this.markers);
            }

            public Default withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Default(this.id, this.comments, formatting, this.markers);
            }

            public Default withMarkers(Markers markers) {
                return this.markers == markers ? this : new Default(this.id, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class MethodInvocation
    implements J,
    Statement,
    Expression {
        private final UUID id;
        @Nullable
        private final Expression select;
        @Nullable
        private final TypeParameters typeParameters;
        private final Ident name;
        private final Arguments args;
        @Nullable
        private final JavaType.Method type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public MethodInvocation withType(JavaType type) {
            if (type instanceof JavaType.Method) {
                return new MethodInvocation(this.id, this.select, this.typeParameters, this.name, this.args, (JavaType.Method)type, this.comments, this.formatting, this.markers);
            }
            return this;
        }

        public MethodInvocation withDeclaringType(JavaType.FullyQualified type) {
            if (this.type == null) {
                return this;
            }
            return this.withType(this.type.withDeclaringType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMethodInvocation(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        @JsonIgnore
        @Nullable
        public JavaType getReturnType() {
            return this.type == null ? null : (this.type.getResolvedSignature() == null ? null : this.type.getResolvedSignature().getReturnType());
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInvocation)) {
                return false;
            }
            MethodInvocation other = (MethodInvocation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "select", "typeParameters", "name", "args", "type", "comments", "formatting", "markers"})
        public MethodInvocation(UUID id, Expression select, TypeParameters typeParameters, Ident name, Arguments args, JavaType.Method type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.args = args;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getSelect() {
            return this.select;
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public Ident getName() {
            return this.name;
        }

        public Arguments getArgs() {
            return this.args;
        }

        @Override
        public JavaType.Method getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.MethodInvocation(id=" + this.getId() + ", select=" + this.getSelect() + ", typeParameters=" + this.getTypeParameters() + ", name=" + this.getName() + ", args=" + this.getArgs() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public MethodInvocation withSelect(Expression select) {
            return this.select == select ? this : new MethodInvocation(this.id, select, this.typeParameters, this.name, this.args, this.type, this.comments, this.formatting, this.markers);
        }

        public MethodInvocation withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodInvocation(this.id, this.select, typeParameters, this.name, this.args, this.type, this.comments, this.formatting, this.markers);
        }

        public MethodInvocation withName(Ident name) {
            return this.name == name ? this : new MethodInvocation(this.id, this.select, this.typeParameters, name, this.args, this.type, this.comments, this.formatting, this.markers);
        }

        public MethodInvocation withArgs(Arguments args) {
            return this.args == args ? this : new MethodInvocation(this.id, this.select, this.typeParameters, this.name, args, this.type, this.comments, this.formatting, this.markers);
        }

        @Override
        public MethodInvocation withComments(List<Comment> comments) {
            return this.comments == comments ? this : new MethodInvocation(this.id, this.select, this.typeParameters, this.name, this.args, this.type, comments, this.formatting, this.markers);
        }

        public MethodInvocation withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MethodInvocation(this.id, this.select, this.typeParameters, this.name, this.args, this.type, this.comments, formatting, this.markers);
        }

        public MethodInvocation withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodInvocation(this.id, this.select, this.typeParameters, this.name, this.args, this.type, this.comments, this.formatting, markers);
        }

        public static final class Arguments
        implements J {
            private final UUID id;
            private final List<Expression> args;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arguments)) {
                    return false;
                }
                Arguments other = (Arguments)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "args", "comments", "formatting", "markers"})
            public Arguments(UUID id, List<Expression> args, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.args = args;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getArgs() {
                return this.args;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.MethodInvocation.Arguments(id=" + this.getId() + ", args=" + this.getArgs() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Arguments withArgs(List<Expression> args) {
                return this.args == args ? this : new Arguments(this.id, args, this.comments, this.formatting, this.markers);
            }

            @Override
            public Arguments withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Arguments(this.id, this.args, comments, this.formatting, this.markers);
            }

            public Arguments withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arguments(this.id, this.args, this.comments, formatting, this.markers);
            }

            public Arguments withMarkers(Markers markers) {
                return this.markers == markers ? this : new Arguments(this.id, this.args, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class MethodDecl
    implements J {
        private final UUID id;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeParameters typeParameters;
        @Nullable
        private final TypeTree returnTypeExpr;
        private final Ident name;
        private final Parameters params;
        @Nullable
        private final Throws throwz;
        @Nullable
        private final Block<Statement> body;
        @Nullable
        private final Default defaultValue;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public MethodDecl withModifiers(List<Modifier> modifiers) {
            if (modifiers == this.modifiers) {
                return this;
            }
            return new MethodDecl(this.id, this.annotations, modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        public MethodDecl withModifiers(String ... modifierKeywords) {
            List<Modifier> fixedModifiers = Modifier.withModifiers(this.modifiers, modifierKeywords);
            if (fixedModifiers == this.modifiers) {
                return this;
            }
            if (this.modifiers.isEmpty()) {
                if (this.typeParameters != null) {
                    return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.typeParameters.getPrefix())).withTypeParameters((TypeParameters)this.typeParameters.withPrefix(" "));
                }
                if (this.returnTypeExpr != null) {
                    return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.returnTypeExpr.getPrefix())).withReturnTypeExpr((TypeTree)this.returnTypeExpr.withPrefix(" "));
                }
                return this.withModifiers(Formatting.formatFirstPrefix(fixedModifiers, (String)this.name.getPrefix())).withName((Ident)this.name.withPrefix(" "));
            }
            return this.withModifiers(fixedModifiers);
        }

        public MethodDecl withThrows(Throws throwz) {
            if (throwz == this.throwz) {
                return this;
            }
            return new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, throwz, this.body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        @JsonProperty(value="throwz")
        @Nullable
        public Throws getThrows() {
            return this.throwz;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMethod(this);
        }

        @JsonIgnore
        public boolean isAbstract() {
            return this.body == null;
        }

        public boolean hasType(String clazz) {
            return (Boolean)new HasType(clazz).visit(this);
        }

        public List<Annotation> findAnnotations(String signature) {
            return (List)new FindAnnotations(signature).visit(this);
        }

        @JsonIgnore
        public boolean isConstructor() {
            return this.getReturnTypeExpr() == null;
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public String toString() {
            return "MethodDecl{" + MethodDeclToString.toString(this) + "}";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDecl)) {
                return false;
            }
            MethodDecl other = (MethodDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "modifiers", "typeParameters", "returnTypeExpr", "name", "params", "throwz", "body", "defaultValue", "comments", "formatting", "markers"})
        public MethodDecl(UUID id, List<Annotation> annotations, List<Modifier> modifiers, TypeParameters typeParameters, TypeTree returnTypeExpr, Ident name, Parameters params, Throws throwz, Block<Statement> body, Default defaultValue, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpr = returnTypeExpr;
            this.name = name;
            this.params = params;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public MethodDecl withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new MethodDecl(this.id, annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public MethodDecl withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodDecl(this.id, this.annotations, this.modifiers, typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public MethodDecl withReturnTypeExpr(TypeTree returnTypeExpr) {
            return this.returnTypeExpr == returnTypeExpr ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        public TypeTree getReturnTypeExpr() {
            return this.returnTypeExpr;
        }

        public MethodDecl withName(Ident name) {
            return this.name == name ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, name, this.params, this.throwz, this.body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        public Ident getName() {
            return this.name;
        }

        public MethodDecl withParams(Parameters params) {
            return this.params == params ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, params, this.throwz, this.body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        public Parameters getParams() {
            return this.params;
        }

        public MethodDecl withBody(Block<Statement> body) {
            return this.body == body ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, body, this.defaultValue, this.comments, this.formatting, this.markers);
        }

        public Block<Statement> getBody() {
            return this.body;
        }

        public MethodDecl withDefaultValue(Default defaultValue) {
            return this.defaultValue == defaultValue ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, defaultValue, this.comments, this.formatting, this.markers);
        }

        public Default getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        @Override
        public MethodDecl withComments(List<Comment> comments) {
            return this.comments == comments ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, comments, this.formatting, this.markers);
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public MethodDecl withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.comments, formatting, this.markers);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public MethodDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodDecl(this.id, this.annotations, this.modifiers, this.typeParameters, this.returnTypeExpr, this.name, this.params, this.throwz, this.body, this.defaultValue, this.comments, this.formatting, markers);
        }

        public static final class Default
        implements J {
            private final UUID id;
            private final Expression value;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Default)) {
                    return false;
                }
                Default other = (Default)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "value", "comments", "formatting", "markers"})
            public Default(UUID id, Expression value, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.value = value;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Expression getValue() {
                return this.value;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.MethodDecl.Default(id=" + this.getId() + ", value=" + this.getValue() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Default withValue(Expression value) {
                return this.value == value ? this : new Default(this.id, value, this.comments, this.formatting, this.markers);
            }

            @Override
            public Default withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Default(this.id, this.value, comments, this.formatting, this.markers);
            }

            public Default withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Default(this.id, this.value, this.comments, formatting, this.markers);
            }

            public Default withMarkers(Markers markers) {
                return this.markers == markers ? this : new Default(this.id, this.value, this.comments, this.formatting, markers);
            }
        }

        public static final class Throws
        implements J {
            private final UUID id;
            private final List<NameTree> exceptions;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Throws)) {
                    return false;
                }
                Throws other = (Throws)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "exceptions", "comments", "formatting", "markers"})
            public Throws(UUID id, List<NameTree> exceptions, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.exceptions = exceptions;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<NameTree> getExceptions() {
                return this.exceptions;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.MethodDecl.Throws(id=" + this.getId() + ", exceptions=" + this.getExceptions() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Throws withExceptions(List<NameTree> exceptions) {
                return this.exceptions == exceptions ? this : new Throws(this.id, exceptions, this.comments, this.formatting, this.markers);
            }

            @Override
            public Throws withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Throws(this.id, this.exceptions, comments, this.formatting, this.markers);
            }

            public Throws withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Throws(this.id, this.exceptions, this.comments, formatting, this.markers);
            }

            public Throws withMarkers(Markers markers) {
                return this.markers == markers ? this : new Throws(this.id, this.exceptions, this.comments, this.formatting, markers);
            }
        }

        public static final class Parameters
        implements J {
            private final UUID id;
            private final List<Statement> params;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean isEmpty() {
                return this.params.stream().allMatch(p -> p instanceof Empty);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "params", "comments", "formatting", "markers"})
            public Parameters(UUID id, List<Statement> params, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.params = params;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Statement> getParams() {
                return this.params;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.MethodDecl.Parameters(id=" + this.getId() + ", params=" + this.getParams() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Parameters withParams(List<Statement> params) {
                return this.params == params ? this : new Parameters(this.id, params, this.comments, this.formatting, this.markers);
            }

            @Override
            public Parameters withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Parameters(this.id, this.params, comments, this.formatting, this.markers);
            }

            public Parameters withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Parameters(this.id, this.params, this.comments, formatting, this.markers);
            }

            public Parameters withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameters(this.id, this.params, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class MemberReference
    implements J,
    Expression {
        private final UUID id;
        private final Expression containing;
        @Nullable
        private final TypeParameters typeParameters;
        private final Ident reference;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitMemberReference(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberReference)) {
                return false;
            }
            MemberReference other = (MemberReference)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "containing", "typeParameters", "reference", "type", "comments", "formatting", "markers"})
        public MemberReference(UUID id, Expression containing, TypeParameters typeParameters, Ident reference, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getContaining() {
            return this.containing;
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public Ident getReference() {
            return this.reference;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.MemberReference(id=" + this.getId() + ", containing=" + this.getContaining() + ", typeParameters=" + this.getTypeParameters() + ", reference=" + this.getReference() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public MemberReference withContaining(Expression containing) {
            return this.containing == containing ? this : new MemberReference(this.id, containing, this.typeParameters, this.reference, this.type, this.comments, this.formatting, this.markers);
        }

        public MemberReference withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new MemberReference(this.id, this.containing, typeParameters, this.reference, this.type, this.comments, this.formatting, this.markers);
        }

        public MemberReference withReference(Ident reference) {
            return this.reference == reference ? this : new MemberReference(this.id, this.containing, this.typeParameters, reference, this.type, this.comments, this.formatting, this.markers);
        }

        public MemberReference withType(JavaType type) {
            return this.type == type ? this : new MemberReference(this.id, this.containing, this.typeParameters, this.reference, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public MemberReference withComments(List<Comment> comments) {
            return this.comments == comments ? this : new MemberReference(this.id, this.containing, this.typeParameters, this.reference, this.type, comments, this.formatting, this.markers);
        }

        public MemberReference withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new MemberReference(this.id, this.containing, this.typeParameters, this.reference, this.type, this.comments, formatting, this.markers);
        }

        public MemberReference withMarkers(Markers markers) {
            return this.markers == markers ? this : new MemberReference(this.id, this.containing, this.typeParameters, this.reference, this.type, this.comments, this.formatting, markers);
        }
    }

    public static final class Literal
    implements J,
    Expression {
        private final UUID id;
        @Nullable
        private final Object value;
        private final String valueSource;
        private final JavaType.Primitive type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public Literal withType(JavaType type) {
            if (type instanceof JavaType.Primitive) {
                return new Literal(this.id, this.value, this.valueSource, (JavaType.Primitive)type, this.comments, this.formatting, this.markers);
            }
            return this;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitLiteral(this);
        }

        public <T> String transformValue(Function<T, Object> transform) {
            Matcher valueMatcher = Pattern.compile("(.*)" + Pattern.quote(this.value == null ? "null" : this.value.toString()) + "(.*)").matcher(this.printTrimmed().replace("\\", ""));
            if (valueMatcher.find()) {
                String prefix = valueMatcher.group(1);
                String suffix = valueMatcher.group(2);
                return prefix + transform.apply(this.value) + suffix;
            }
            throw new IllegalStateException("Encountered a literal `" + this + "` that could not be transformed");
        }

        public static Literal buildString(String value) {
            return new Literal(Tree.randomId(), value, "\"" + value + "\"", JavaType.Primitive.String, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "value", "valueSource", "type", "comments", "formatting", "markers"})
        public Literal(UUID id, Object value, String valueSource, JavaType.Primitive type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.value = value;
            this.valueSource = valueSource;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueSource() {
            return this.valueSource;
        }

        @Override
        public JavaType.Primitive getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Literal(id=" + this.getId() + ", value=" + this.getValue() + ", valueSource=" + this.getValueSource() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Literal withValue(Object value) {
            return this.value == value ? this : new Literal(this.id, value, this.valueSource, this.type, this.comments, this.formatting, this.markers);
        }

        public Literal withValueSource(String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.value, valueSource, this.type, this.comments, this.formatting, this.markers);
        }

        @Override
        public Literal withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Literal(this.id, this.value, this.valueSource, this.type, comments, this.formatting, this.markers);
        }

        public Literal withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Literal(this.id, this.value, this.valueSource, this.type, this.comments, formatting, this.markers);
        }

        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.value, this.valueSource, this.type, this.comments, this.formatting, markers);
        }
    }

    public static final class Lambda
    implements J,
    Expression {
        private final UUID id;
        private final Parameters paramSet;
        private final Arrow arrow;
        private final Tree body;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitLambda(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lambda)) {
                return false;
            }
            Lambda other = (Lambda)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "paramSet", "arrow", "body", "type", "comments", "formatting", "markers"})
        public Lambda(UUID id, Parameters paramSet, Arrow arrow, Tree body, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.paramSet = paramSet;
            this.arrow = arrow;
            this.body = body;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Parameters getParamSet() {
            return this.paramSet;
        }

        public Arrow getArrow() {
            return this.arrow;
        }

        public Tree getBody() {
            return this.body;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Lambda(id=" + this.getId() + ", paramSet=" + this.getParamSet() + ", arrow=" + this.getArrow() + ", body=" + this.getBody() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Lambda withParamSet(Parameters paramSet) {
            return this.paramSet == paramSet ? this : new Lambda(this.id, paramSet, this.arrow, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public Lambda withArrow(Arrow arrow) {
            return this.arrow == arrow ? this : new Lambda(this.id, this.paramSet, arrow, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public Lambda withBody(Tree body) {
            return this.body == body ? this : new Lambda(this.id, this.paramSet, this.arrow, body, this.type, this.comments, this.formatting, this.markers);
        }

        public Lambda withType(JavaType type) {
            return this.type == type ? this : new Lambda(this.id, this.paramSet, this.arrow, this.body, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public Lambda withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Lambda(this.id, this.paramSet, this.arrow, this.body, this.type, comments, this.formatting, this.markers);
        }

        public Lambda withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Lambda(this.id, this.paramSet, this.arrow, this.body, this.type, this.comments, formatting, this.markers);
        }

        public Lambda withMarkers(Markers markers) {
            return this.markers == markers ? this : new Lambda(this.id, this.paramSet, this.arrow, this.body, this.type, this.comments, this.formatting, markers);
        }

        public static final class Parameters
        implements J {
            private final UUID id;
            private final boolean parenthesized;
            private final List<? extends Tree> params;
            private final List<Comment> comments = Collections.emptyList();
            private final Formatting formatting = Formatting.EMPTY;
            private final Markers markers;

            public <T extends Tree> T withFormatting(Formatting fmt) {
                return (T)this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "parenthesized", "params", "markers"})
            public Parameters(UUID id, boolean parenthesized, List<? extends Tree> params, Markers markers) {
                this.id = id;
                this.parenthesized = parenthesized;
                this.params = params;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public boolean isParenthesized() {
                return this.parenthesized;
            }

            public List<? extends Tree> getParams() {
                return this.params;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Lambda.Parameters(id=" + this.getId() + ", parenthesized=" + this.isParenthesized() + ", params=" + this.getParams() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Parameters withParenthesized(boolean parenthesized) {
                return this.parenthesized == parenthesized ? this : new Parameters(this.id, parenthesized, this.params, this.markers);
            }

            public Parameters withParams(List<? extends Tree> params) {
                return this.params == params ? this : new Parameters(this.id, this.parenthesized, params, this.markers);
            }

            public Parameters withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameters(this.id, this.parenthesized, this.params, markers);
            }
        }

        public static final class Arrow
        implements J {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arrow)) {
                    return false;
                }
                Arrow other = (Arrow)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public Arrow(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Lambda.Arrow(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public Arrow withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Arrow(this.id, comments, this.formatting, this.markers);
            }

            public Arrow withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arrow(this.id, this.comments, formatting, this.markers);
            }

            public Arrow withMarkers(Markers markers) {
                return this.markers == markers ? this : new Arrow(this.id, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class Label
    implements J,
    Statement {
        private final UUID id;
        private final Ident label;
        private final Statement statement;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitLabel(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Label)) {
                return false;
            }
            Label other = (Label)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "label", "statement", "comments", "formatting", "markers"})
        public Label(UUID id, Ident label, Statement statement, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.label = label;
            this.statement = statement;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getLabel() {
            return this.label;
        }

        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Label(id=" + this.getId() + ", label=" + this.getLabel() + ", statement=" + this.getStatement() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Label withLabel(Ident label) {
            return this.label == label ? this : new Label(this.id, label, this.statement, this.comments, this.formatting, this.markers);
        }

        public Label withStatement(Statement statement) {
            return this.statement == statement ? this : new Label(this.id, this.label, statement, this.comments, this.formatting, this.markers);
        }

        @Override
        public Label withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Label(this.id, this.label, this.statement, comments, this.formatting, this.markers);
        }

        public Label withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Label(this.id, this.label, this.statement, this.comments, formatting, this.markers);
        }

        public Label withMarkers(Markers markers) {
            return this.markers == markers ? this : new Label(this.id, this.label, this.statement, this.comments, this.formatting, markers);
        }
    }

    public static final class InstanceOf
    implements J,
    Expression {
        private final UUID id;
        private final Expression expr;
        private final Tree clazz;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitInstanceOf(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOf)) {
                return false;
            }
            InstanceOf other = (InstanceOf)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "expr", "clazz", "type", "comments", "formatting", "markers"})
        public InstanceOf(UUID id, Expression expr, Tree clazz, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.expr = expr;
            this.clazz = clazz;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public Tree getClazz() {
            return this.clazz;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.InstanceOf(id=" + this.getId() + ", expr=" + this.getExpr() + ", clazz=" + this.getClazz() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public InstanceOf withExpr(Expression expr) {
            return this.expr == expr ? this : new InstanceOf(this.id, expr, this.clazz, this.type, this.comments, this.formatting, this.markers);
        }

        public InstanceOf withClazz(Tree clazz) {
            return this.clazz == clazz ? this : new InstanceOf(this.id, this.expr, clazz, this.type, this.comments, this.formatting, this.markers);
        }

        public InstanceOf withType(JavaType type) {
            return this.type == type ? this : new InstanceOf(this.id, this.expr, this.clazz, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public InstanceOf withComments(List<Comment> comments) {
            return this.comments == comments ? this : new InstanceOf(this.id, this.expr, this.clazz, this.type, comments, this.formatting, this.markers);
        }

        public InstanceOf withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new InstanceOf(this.id, this.expr, this.clazz, this.type, this.comments, formatting, this.markers);
        }

        public InstanceOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new InstanceOf(this.id, this.expr, this.clazz, this.type, this.comments, this.formatting, markers);
        }
    }

    public static final class Import
    implements J,
    Comparable<Import> {
        private final UUID id;
        private final FieldAccess qualid;
        private final boolean statik;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitImport(this);
        }

        public boolean isStatic() {
            return this.statik;
        }

        @JsonIgnore
        public boolean isFromType(String clazz) {
            if ("*".equals(this.qualid.getSimpleName())) {
                return this.qualid.target.printTrimmed().equals(Arrays.stream(clazz.split("\\.")).filter(pkgOrNam -> Character.isLowerCase(pkgOrNam.charAt(0))).collect(Collectors.joining(".")));
            }
            return (this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed()).equals(clazz);
        }

        public String getTypeName() {
            return this.isStatic() ? this.qualid.getTarget().printTrimmed() : this.qualid.printTrimmed();
        }

        @JsonIgnore
        public String getPackageName() {
            JavaType.Class importType = TypeUtils.asClass(this.qualid.getType());
            if (importType != null) {
                return importType.getPackageName();
            }
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            return Arrays.stream(this.qualid.getTarget().printTrimmed().split("\\.")).filter(pkg -> {
                takeWhile.set(takeWhile.get() && !pkg.isEmpty() && Character.isLowerCase(pkg.charAt(0)));
                return takeWhile.get();
            }).collect(Collectors.joining("."));
        }

        @Override
        public int compareTo(Import o) {
            String p1 = this.getPackageName();
            String p2 = o.getPackageName();
            String[] p1s = p1.split("\\.");
            String[] p2s = p2.split("\\.");
            for (int i = 0; i < p1s.length; ++i) {
                String s = p1s[i];
                if (p2s.length < i + 1) {
                    return 1;
                }
                if (s.equals(p2s[i])) continue;
                return s.compareTo(p2s[i]);
            }
            return p1s.length < p2s.length ? -1 : this.getQualid().getSimpleName().compareTo(o.getQualid().getSimpleName());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "qualid", "statik", "comments", "formatting", "markers"})
        public Import(UUID id, FieldAccess qualid, boolean statik, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.qualid = qualid;
            this.statik = statik;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Import withQualid(FieldAccess qualid) {
            return this.qualid == qualid ? this : new Import(this.id, qualid, this.statik, this.comments, this.formatting, this.markers);
        }

        public FieldAccess getQualid() {
            return this.qualid;
        }

        public Import withStatik(boolean statik) {
            return this.statik == statik ? this : new Import(this.id, this.qualid, statik, this.comments, this.formatting, this.markers);
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        @Override
        public Import withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Import(this.id, this.qualid, this.statik, comments, this.formatting, this.markers);
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Import withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Import(this.id, this.qualid, this.statik, this.comments, formatting, this.markers);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Import withMarkers(Markers markers) {
            return this.markers == markers ? this : new Import(this.id, this.qualid, this.statik, this.comments, this.formatting, markers);
        }
    }

    public static final class If
    implements J,
    Statement {
        private final UUID id;
        private final Parentheses<Expression> ifCondition;
        private final Statement thenPart;
        @Nullable
        private final Else elsePart;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitIf(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof If)) {
                return false;
            }
            If other = (If)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "ifCondition", "thenPart", "elsePart", "comments", "formatting", "markers"})
        public If(UUID id, Parentheses<Expression> ifCondition, Statement thenPart, Else elsePart, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<Expression> getIfCondition() {
            return this.ifCondition;
        }

        public Statement getThenPart() {
            return this.thenPart;
        }

        public Else getElsePart() {
            return this.elsePart;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.If(id=" + this.getId() + ", ifCondition=" + this.getIfCondition() + ", thenPart=" + this.getThenPart() + ", elsePart=" + this.getElsePart() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public If withIfCondition(Parentheses<Expression> ifCondition) {
            return this.ifCondition == ifCondition ? this : new If(this.id, ifCondition, this.thenPart, this.elsePart, this.comments, this.formatting, this.markers);
        }

        public If withThenPart(Statement thenPart) {
            return this.thenPart == thenPart ? this : new If(this.id, this.ifCondition, thenPart, this.elsePart, this.comments, this.formatting, this.markers);
        }

        public If withElsePart(Else elsePart) {
            return this.elsePart == elsePart ? this : new If(this.id, this.ifCondition, this.thenPart, elsePart, this.comments, this.formatting, this.markers);
        }

        @Override
        public If withComments(List<Comment> comments) {
            return this.comments == comments ? this : new If(this.id, this.ifCondition, this.thenPart, this.elsePart, comments, this.formatting, this.markers);
        }

        public If withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new If(this.id, this.ifCondition, this.thenPart, this.elsePart, this.comments, formatting, this.markers);
        }

        public If withMarkers(Markers markers) {
            return this.markers == markers ? this : new If(this.id, this.ifCondition, this.thenPart, this.elsePart, this.comments, this.formatting, markers);
        }

        public static final class Else
        implements J {
            private final UUID id;
            private final Statement statement;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            @Override
            public <R> R acceptJava(JavaSourceVisitor<R> v) {
                return v.visitElse(this);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Else)) {
                    return false;
                }
                Else other = (Else)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "statement", "comments", "formatting", "markers"})
            public Else(UUID id, Statement statement, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.statement = statement;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Statement getStatement() {
                return this.statement;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.If.Else(id=" + this.getId() + ", statement=" + this.getStatement() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Else withStatement(Statement statement) {
                return this.statement == statement ? this : new Else(this.id, statement, this.comments, this.formatting, this.markers);
            }

            @Override
            public Else withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Else(this.id, this.statement, comments, this.formatting, this.markers);
            }

            public Else withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Else(this.id, this.statement, this.comments, formatting, this.markers);
            }

            public Else withMarkers(Markers markers) {
                return this.markers == markers ? this : new Else(this.id, this.statement, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class Ident
    implements J,
    TypeTree,
    Expression {
        private static final Map<String, Map<JavaType, IdentFlyweight>> flyweights = HashObjObjMaps.newMutableMap();
        private final UUID id;
        private final IdentFlyweight ident;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        private Ident(UUID id, IdentFlyweight ident, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.ident = ident;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        @Override
        public JavaType getType() {
            return this.ident.getType();
        }

        public Ident withType(JavaType type) {
            return Ident.build(this.id, this.getSimpleName(), type, this.comments, this.formatting, this.markers);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.ident.getSimpleName();
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitIdentifier(this);
        }

        public Ident withName(String name) {
            return Ident.build(this.id, name, this.getType(), this.comments, this.formatting, this.markers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Ident build(@JsonProperty(value="id") UUID id, @JsonProperty(value="simpleName") String simpleName, @JsonProperty(value="type") @Nullable JavaType type, @JsonProperty(value="comments") List<Comment> comments, @JsonProperty(value="formatting") Formatting formatting, @JsonProperty(value="metadata") Markers markers) {
            Map<String, Map<JavaType, IdentFlyweight>> map = flyweights;
            synchronized (map) {
                return new Ident(id, flyweights.computeIfAbsent(simpleName, n -> HashObjObjMaps.newMutableMap()).computeIfAbsent(type, t -> new IdentFlyweight(simpleName, (JavaType)t)), comments, formatting, markers);
            }
        }

        public static Ident buildClassName(String fullyQualifiedName) {
            JavaType.Class classType = JavaType.Class.build(fullyQualifiedName);
            return Ident.build(Tree.randomId(), classType.getClassName(), classType, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY);
        }

        public String toString() {
            return "Ident(" + this.printTrimmed() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ident)) {
                return false;
            }
            Ident other = (Ident)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public UUID getId() {
            return this.id;
        }

        public IdentFlyweight getIdent() {
            return this.ident;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        public Ident withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Ident(this.id, this.ident, comments, this.formatting, this.markers);
        }

        public Ident withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Ident(this.id, this.ident, this.comments, formatting, this.markers);
        }

        public Ident withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ident(this.id, this.ident, this.comments, this.formatting, markers);
        }

        public static final class IdentFlyweight
        implements Serializable {
            private final String simpleName;
            @Nullable
            private final JavaType type;

            @ConstructorProperties(value={"simpleName", "type"})
            public IdentFlyweight(String simpleName, JavaType type) {
                this.simpleName = simpleName;
                this.type = type;
            }

            public String getSimpleName() {
                return this.simpleName;
            }

            public JavaType getType() {
                return this.type;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdentFlyweight)) {
                    return false;
                }
                IdentFlyweight other = (IdentFlyweight)o;
                String this$simpleName = this.getSimpleName();
                String other$simpleName = other.getSimpleName();
                if (this$simpleName == null ? other$simpleName != null : !this$simpleName.equals(other$simpleName)) {
                    return false;
                }
                JavaType this$type = this.getType();
                JavaType other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $simpleName = this.getSimpleName();
                result = result * 59 + ($simpleName == null ? 43 : $simpleName.hashCode());
                JavaType $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public String toString() {
                return "J.Ident.IdentFlyweight(simpleName=" + this.getSimpleName() + ", type=" + this.getType() + ")";
            }
        }
    }

    public static final class ForLoop
    implements J,
    Statement {
        private final UUID id;
        private final Control control;
        private final Statement body;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitForLoop(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForLoop)) {
                return false;
            }
            ForLoop other = (ForLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "control", "body", "comments", "formatting", "markers"})
        public ForLoop(UUID id, Control control, Statement body, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.control = control;
            this.body = body;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Control getControl() {
            return this.control;
        }

        public Statement getBody() {
            return this.body;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.ForLoop(id=" + this.getId() + ", control=" + this.getControl() + ", body=" + this.getBody() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public ForLoop withControl(Control control) {
            return this.control == control ? this : new ForLoop(this.id, control, this.body, this.comments, this.formatting, this.markers);
        }

        public ForLoop withBody(Statement body) {
            return this.body == body ? this : new ForLoop(this.id, this.control, body, this.comments, this.formatting, this.markers);
        }

        @Override
        public ForLoop withComments(List<Comment> comments) {
            return this.comments == comments ? this : new ForLoop(this.id, this.control, this.body, comments, this.formatting, this.markers);
        }

        public ForLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ForLoop(this.id, this.control, this.body, this.comments, formatting, this.markers);
        }

        public ForLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForLoop(this.id, this.control, this.body, this.comments, this.formatting, markers);
        }

        public static final class Control
        implements J {
            private final UUID id;
            private final Statement init;
            private final Expression condition;
            private final List<Statement> update;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "init", "condition", "update", "comments", "formatting", "markers"})
            public Control(UUID id, Statement init, Expression condition, List<Statement> update, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.init = init;
                this.condition = condition;
                this.update = update;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Statement getInit() {
                return this.init;
            }

            public Expression getCondition() {
                return this.condition;
            }

            public List<Statement> getUpdate() {
                return this.update;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.ForLoop.Control(id=" + this.getId() + ", init=" + this.getInit() + ", condition=" + this.getCondition() + ", update=" + this.getUpdate() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Control withInit(Statement init) {
                return this.init == init ? this : new Control(this.id, init, this.condition, this.update, this.comments, this.formatting, this.markers);
            }

            public Control withCondition(Expression condition) {
                return this.condition == condition ? this : new Control(this.id, this.init, condition, this.update, this.comments, this.formatting, this.markers);
            }

            public Control withUpdate(List<Statement> update) {
                return this.update == update ? this : new Control(this.id, this.init, this.condition, update, this.comments, this.formatting, this.markers);
            }

            @Override
            public Control withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Control(this.id, this.init, this.condition, this.update, comments, this.formatting, this.markers);
            }

            public Control withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Control(this.id, this.init, this.condition, this.update, this.comments, formatting, this.markers);
            }

            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.id, this.init, this.condition, this.update, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class ForEachLoop
    implements J,
    Statement {
        private final UUID id;
        private final Control control;
        private final Statement body;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitForEachLoop(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForEachLoop)) {
                return false;
            }
            ForEachLoop other = (ForEachLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "control", "body", "comments", "formatting", "markers"})
        public ForEachLoop(UUID id, Control control, Statement body, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.control = control;
            this.body = body;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Control getControl() {
            return this.control;
        }

        public Statement getBody() {
            return this.body;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.ForEachLoop(id=" + this.getId() + ", control=" + this.getControl() + ", body=" + this.getBody() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public ForEachLoop withControl(Control control) {
            return this.control == control ? this : new ForEachLoop(this.id, control, this.body, this.comments, this.formatting, this.markers);
        }

        public ForEachLoop withBody(Statement body) {
            return this.body == body ? this : new ForEachLoop(this.id, this.control, body, this.comments, this.formatting, this.markers);
        }

        @Override
        public ForEachLoop withComments(List<Comment> comments) {
            return this.comments == comments ? this : new ForEachLoop(this.id, this.control, this.body, comments, this.formatting, this.markers);
        }

        public ForEachLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ForEachLoop(this.id, this.control, this.body, this.comments, formatting, this.markers);
        }

        public ForEachLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForEachLoop(this.id, this.control, this.body, this.comments, this.formatting, markers);
        }

        public static final class Control
        implements J {
            private final UUID id;
            private final VariableDecls variable;
            private final Expression iterable;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "variable", "iterable", "comments", "formatting", "markers"})
            public Control(UUID id, VariableDecls variable, Expression iterable, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.variable = variable;
                this.iterable = iterable;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public VariableDecls getVariable() {
                return this.variable;
            }

            public Expression getIterable() {
                return this.iterable;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.ForEachLoop.Control(id=" + this.getId() + ", variable=" + this.getVariable() + ", iterable=" + this.getIterable() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Control withVariable(VariableDecls variable) {
                return this.variable == variable ? this : new Control(this.id, variable, this.iterable, this.comments, this.formatting, this.markers);
            }

            public Control withIterable(Expression iterable) {
                return this.iterable == iterable ? this : new Control(this.id, this.variable, iterable, this.comments, this.formatting, this.markers);
            }

            @Override
            public Control withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Control(this.id, this.variable, this.iterable, comments, this.formatting, this.markers);
            }

            public Control withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Control(this.id, this.variable, this.iterable, this.comments, formatting, this.markers);
            }

            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.id, this.variable, this.iterable, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class FieldAccess
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Expression target;
        private final Ident name;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitFieldAccess(this);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return this.target.getSideEffects();
        }

        public String toString() {
            return "FieldAccess(" + this.printTrimmed() + ")";
        }

        @Nullable
        public NameTree asClassReference() {
            if (this.target instanceof NameTree) {
                String fqn = null;
                if (this.type instanceof JavaType.Class) {
                    fqn = ((JavaType.Class)this.type).getFullyQualifiedName();
                } else if (this.type instanceof JavaType.ShallowClass) {
                    fqn = ((JavaType.ShallowClass)this.type).getFullyQualifiedName();
                }
                return "java.lang.Class".equals(fqn) ? (NameTree)((Object)this.target) : null;
            }
            return null;
        }

        public boolean isFullyQualifiedClassReference(String className) {
            return this.isFullyQualifiedClassReference(this, className);
        }

        public boolean isFullyQualifiedClassReference(MethodMatcher methodMatcher) {
            String hopefullyFullyQualifiedMethod = methodMatcher.getTargetTypePattern().pattern() + "." + methodMatcher.getMethodNamePattern().pattern();
            return this.isFullyQualifiedClassReference(this, hopefullyFullyQualifiedMethod);
        }

        private boolean isFullyQualifiedClassReference(FieldAccess fieldAccess, String className) {
            if (!className.contains(".")) {
                return false;
            }
            if (!fieldAccess.getName().getSimpleName().equals(className.substring(className.lastIndexOf(46) + 1))) {
                return false;
            }
            if (fieldAccess.getTarget() instanceof FieldAccess) {
                return this.isFullyQualifiedClassReference((FieldAccess)fieldAccess.getTarget(), className.substring(0, className.lastIndexOf(46)));
            }
            if (fieldAccess.getTarget() instanceof Ident) {
                return ((Ident)fieldAccess.getTarget()).getSimpleName().equals(className.substring(0, className.lastIndexOf(46)));
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAccess)) {
                return false;
            }
            FieldAccess other = (FieldAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "target", "name", "type", "comments", "formatting", "markers"})
        public FieldAccess(UUID id, Expression target, Ident name, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.target = target;
            this.name = name;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getTarget() {
            return this.target;
        }

        public Ident getName() {
            return this.name;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public FieldAccess withTarget(Expression target) {
            return this.target == target ? this : new FieldAccess(this.id, target, this.name, this.type, this.comments, this.formatting, this.markers);
        }

        public FieldAccess withName(Ident name) {
            return this.name == name ? this : new FieldAccess(this.id, this.target, name, this.type, this.comments, this.formatting, this.markers);
        }

        public FieldAccess withType(JavaType type) {
            return this.type == type ? this : new FieldAccess(this.id, this.target, this.name, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public FieldAccess withComments(List<Comment> comments) {
            return this.comments == comments ? this : new FieldAccess(this.id, this.target, this.name, this.type, comments, this.formatting, this.markers);
        }

        public FieldAccess withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new FieldAccess(this.id, this.target, this.name, this.type, this.comments, formatting, this.markers);
        }

        public FieldAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new FieldAccess(this.id, this.target, this.name, this.type, this.comments, this.formatting, markers);
        }
    }

    public static final class EnumValueSet
    implements J,
    Statement {
        private final UUID id;
        private final List<EnumValue> enums;
        private final boolean terminatedWithSemicolon;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitEnumValueSet(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValueSet)) {
                return false;
            }
            EnumValueSet other = (EnumValueSet)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "enums", "terminatedWithSemicolon", "comments", "formatting", "markers"})
        public EnumValueSet(UUID id, List<EnumValue> enums, boolean terminatedWithSemicolon, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public List<EnumValue> getEnums() {
            return this.enums;
        }

        public boolean isTerminatedWithSemicolon() {
            return this.terminatedWithSemicolon;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.EnumValueSet(id=" + this.getId() + ", enums=" + this.getEnums() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public EnumValueSet withEnums(List<EnumValue> enums) {
            return this.enums == enums ? this : new EnumValueSet(this.id, enums, this.terminatedWithSemicolon, this.comments, this.formatting, this.markers);
        }

        @Override
        public EnumValueSet withComments(List<Comment> comments) {
            return this.comments == comments ? this : new EnumValueSet(this.id, this.enums, this.terminatedWithSemicolon, comments, this.formatting, this.markers);
        }

        public EnumValueSet withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new EnumValueSet(this.id, this.enums, this.terminatedWithSemicolon, this.comments, formatting, this.markers);
        }

        public EnumValueSet withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValueSet(this.id, this.enums, this.terminatedWithSemicolon, this.comments, this.formatting, markers);
        }
    }

    public static final class EnumValue
    implements J,
    Statement {
        private final UUID id;
        private final Ident name;
        @Nullable
        private final NewClass initializer;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitEnumValue(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue other = (EnumValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "name", "initializer", "comments", "formatting", "markers"})
        public EnumValue(UUID id, Ident name, NewClass initializer, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.name = name;
            this.initializer = initializer;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getName() {
            return this.name;
        }

        public NewClass getInitializer() {
            return this.initializer;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.EnumValue(id=" + this.getId() + ", name=" + this.getName() + ", initializer=" + this.getInitializer() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public EnumValue withName(Ident name) {
            return this.name == name ? this : new EnumValue(this.id, name, this.initializer, this.comments, this.formatting, this.markers);
        }

        public EnumValue withInitializer(NewClass initializer) {
            return this.initializer == initializer ? this : new EnumValue(this.id, this.name, initializer, this.comments, this.formatting, this.markers);
        }

        @Override
        public EnumValue withComments(List<Comment> comments) {
            return this.comments == comments ? this : new EnumValue(this.id, this.name, this.initializer, comments, this.formatting, this.markers);
        }

        public EnumValue withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new EnumValue(this.id, this.name, this.initializer, this.comments, formatting, this.markers);
        }

        public EnumValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValue(this.id, this.name, this.initializer, this.comments, this.formatting, markers);
        }
    }

    public static final class Empty
    implements J,
    Statement,
    Expression,
    TypeTree {
        private final UUID id;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return null;
        }

        public Empty withType(JavaType type) {
            return this;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitEmpty(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
        public Empty(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Empty(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        @Override
        public Empty withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Empty(this.id, comments, this.formatting, this.markers);
        }

        public Empty withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Empty(this.id, this.comments, formatting, this.markers);
        }

        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.comments, this.formatting, markers);
        }
    }

    public static final class DoWhileLoop
    implements J,
    Statement {
        private final UUID id;
        private final Statement body;
        private final While whileCondition;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitDoWhileLoop(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoWhileLoop)) {
                return false;
            }
            DoWhileLoop other = (DoWhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "body", "whileCondition", "comments", "formatting", "markers"})
        public DoWhileLoop(UUID id, Statement body, While whileCondition, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.body = body;
            this.whileCondition = whileCondition;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Statement getBody() {
            return this.body;
        }

        public While getWhileCondition() {
            return this.whileCondition;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.DoWhileLoop(id=" + this.getId() + ", body=" + this.getBody() + ", whileCondition=" + this.getWhileCondition() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public DoWhileLoop withBody(Statement body) {
            return this.body == body ? this : new DoWhileLoop(this.id, body, this.whileCondition, this.comments, this.formatting, this.markers);
        }

        public DoWhileLoop withWhileCondition(While whileCondition) {
            return this.whileCondition == whileCondition ? this : new DoWhileLoop(this.id, this.body, whileCondition, this.comments, this.formatting, this.markers);
        }

        @Override
        public DoWhileLoop withComments(List<Comment> comments) {
            return this.comments == comments ? this : new DoWhileLoop(this.id, this.body, this.whileCondition, comments, this.formatting, this.markers);
        }

        public DoWhileLoop withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new DoWhileLoop(this.id, this.body, this.whileCondition, this.comments, formatting, this.markers);
        }

        public DoWhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new DoWhileLoop(this.id, this.body, this.whileCondition, this.comments, this.formatting, markers);
        }

        public static final class While
        implements J {
            private final UUID id;
            private final Parentheses<Expression> condition;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof While)) {
                    return false;
                }
                While other = (While)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "condition", "comments", "formatting", "markers"})
            public While(UUID id, Parentheses<Expression> condition, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.condition = condition;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Parentheses<Expression> getCondition() {
                return this.condition;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.DoWhileLoop.While(id=" + this.getId() + ", condition=" + this.getCondition() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public While withCondition(Parentheses<Expression> condition) {
                return this.condition == condition ? this : new While(this.id, condition, this.comments, this.formatting, this.markers);
            }

            @Override
            public While withComments(List<Comment> comments) {
                return this.comments == comments ? this : new While(this.id, this.condition, comments, this.formatting, this.markers);
            }

            public While withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new While(this.id, this.condition, this.comments, formatting, this.markers);
            }

            public While withMarkers(Markers markers) {
                return this.markers == markers ? this : new While(this.id, this.condition, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class Continue
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Ident label;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitContinue(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Continue)) {
                return false;
            }
            Continue other = (Continue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "label", "comments", "formatting", "markers"})
        public Continue(UUID id, Ident label, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.label = label;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getLabel() {
            return this.label;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Continue(id=" + this.getId() + ", label=" + this.getLabel() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Continue withLabel(Ident label) {
            return this.label == label ? this : new Continue(this.id, label, this.comments, this.formatting, this.markers);
        }

        @Override
        public Continue withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Continue(this.id, this.label, comments, this.formatting, this.markers);
        }

        public Continue withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Continue(this.id, this.label, this.comments, formatting, this.markers);
        }

        public Continue withMarkers(Markers markers) {
            return this.markers == markers ? this : new Continue(this.id, this.label, this.comments, this.formatting, markers);
        }
    }

    public static final class CompilationUnit
    implements J,
    SourceFile {
        private final UUID id;
        private final String sourcePath;
        @Nullable
        private final Package packageDecl;
        private final List<Import> imports;
        private final List<ClassDecl> classes;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;
        private final Collection<JavaStyle> styles;

        public Collection<JavaStyle> getStyles() {
            return this.styles;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitCompilationUnit(this);
        }

        public boolean hasImport(String clazz) {
            return (Boolean)new HasImport(clazz).visit(this);
        }

        public boolean hasType(String clazz) {
            return (Boolean)new HasType(clazz).visit(this);
        }

        public List<MethodInvocation> findMethodCalls(String signature) {
            return (List)new FindMethods(signature).visit(this);
        }

        public Set<NameTree> findType(String clazz) {
            return (Set)new FindType(clazz).visit(this);
        }

        @JsonIgnore
        public Path getSourceSet() {
            int packageLevelsUp = this.getPackageDecl() == null ? 0 : (int)this.getPackageDecl().printTrimmed().chars().filter(c -> c == 46).count();
            return Paths.get(this.sourcePath, new String[0]).getParent().resolve(IntStream.range(0, packageLevelsUp + 1).mapToObj(n -> "../").collect(Collectors.joining(""))).normalize();
        }

        public JavaParser buildParser(String ... artifactNames) {
            return ((JavaParser.Builder)((JavaParser.Builder)JavaParser.fromJavaVersion().classpath(JavaParser.dependenciesFromClasspath(artifactNames))).styles(this.styles)).build();
        }

        @Incubating(since="6.1.0")
        public JavaParser buildRuntimeParser() {
            return ((JavaParser.Builder)((JavaParser.Builder)JavaParser.fromJavaVersion().classpath(JavaParser.allDependenciesFromClasspath())).styles(this.styles)).build();
        }

        public static CompilationUnit buildEmptyClass(Path sourceSet, String packageName, String className) {
            String sourcePath = sourceSet.resolve(packageName.replace(".", "/")).resolve(className + ".java").toString();
            return new CompilationUnit(Tree.randomId(), sourcePath, new Package(Tree.randomId(), (Expression)TreeBuilder.buildName(packageName).withPrefix(" "), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), Collections.emptyList(), Collections.singletonList(new ClassDecl(Tree.randomId(), Collections.emptyList(), Collections.emptyList(), new ClassDecl.Kind.Class(Tree.randomId(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), (Ident)TreeBuilder.buildName(className).withPrefix(" "), null, null, null, new Block<J>(Tree.randomId(), null, Collections.emptyList(), Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY, new Block.End(Tree.randomId(), Collections.emptyList(), Formatting.format((String)"\n"), Markers.EMPTY)), JavaType.Class.build(packageName + "." + className), Collections.emptyList(), Formatting.format((String)"\n\n"), Markers.EMPTY).withModifiers("public")), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY, Collections.emptyList());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "sourcePath", "packageDecl", "imports", "classes", "comments", "formatting", "markers", "styles"})
        public CompilationUnit(UUID id, String sourcePath, Package packageDecl, List<Import> imports, List<ClassDecl> classes, List<Comment> comments, Formatting formatting, Markers markers, Collection<JavaStyle> styles) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.packageDecl = packageDecl;
            this.imports = imports;
            this.classes = classes;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
            this.styles = styles;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public Package getPackageDecl() {
            return this.packageDecl;
        }

        public List<Import> getImports() {
            return this.imports;
        }

        public List<ClassDecl> getClasses() {
            return this.classes;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.CompilationUnit(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", packageDecl=" + this.getPackageDecl() + ", imports=" + this.getImports() + ", classes=" + this.getClasses() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ", styles=" + this.getStyles() + ")";
        }

        public CompilationUnit withSourcePath(String sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.id, sourcePath, this.packageDecl, this.imports, this.classes, this.comments, this.formatting, this.markers, this.styles);
        }

        public CompilationUnit withPackageDecl(Package packageDecl) {
            return this.packageDecl == packageDecl ? this : new CompilationUnit(this.id, this.sourcePath, packageDecl, this.imports, this.classes, this.comments, this.formatting, this.markers, this.styles);
        }

        public CompilationUnit withImports(List<Import> imports) {
            return this.imports == imports ? this : new CompilationUnit(this.id, this.sourcePath, this.packageDecl, imports, this.classes, this.comments, this.formatting, this.markers, this.styles);
        }

        public CompilationUnit withClasses(List<ClassDecl> classes) {
            return this.classes == classes ? this : new CompilationUnit(this.id, this.sourcePath, this.packageDecl, this.imports, classes, this.comments, this.formatting, this.markers, this.styles);
        }

        @Override
        public CompilationUnit withComments(List<Comment> comments) {
            return this.comments == comments ? this : new CompilationUnit(this.id, this.sourcePath, this.packageDecl, this.imports, this.classes, comments, this.formatting, this.markers, this.styles);
        }

        public CompilationUnit withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new CompilationUnit(this.id, this.sourcePath, this.packageDecl, this.imports, this.classes, this.comments, formatting, this.markers, this.styles);
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.id, this.sourcePath, this.packageDecl, this.imports, this.classes, this.comments, this.formatting, markers, this.styles);
        }

        public CompilationUnit withStyles(Collection<JavaStyle> styles) {
            return this.styles == styles ? this : new CompilationUnit(this.id, this.sourcePath, this.packageDecl, this.imports, this.classes, this.comments, this.formatting, this.markers, styles);
        }
    }

    public static final class Comment
    implements J,
    Statement {
        private final UUID id;
        private final CommentStyle style;
        private final String text;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public List<Comment> getComments() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "style", "text", "formatting", "markers"})
        public Comment(UUID id, CommentStyle style, String text, Formatting formatting, Markers markers) {
            this.id = id;
            this.style = style;
            this.text = text;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public CommentStyle getStyle() {
            return this.style;
        }

        public String getText() {
            return this.text;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Comment(id=" + this.getId() + ", style=" + (Object)((Object)this.getStyle()) + ", text=" + this.getText() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Comment withStyle(CommentStyle style) {
            return this.style == style ? this : new Comment(this.id, style, this.text, this.formatting, this.markers);
        }

        public Comment withText(String text) {
            return this.text == text ? this : new Comment(this.id, this.style, text, this.formatting, this.markers);
        }

        public Comment withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Comment(this.id, this.style, this.text, formatting, this.markers);
        }

        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.style, this.text, this.formatting, markers);
        }

        static enum CommentStyle {
            LINE,
            BLOCK,
            JAVADOC,
            WHITESPACE;

        }
    }

    public static final class ClassDecl
    implements J,
    Statement {
        private final UUID id;
        private final List<Annotation> annotations;
        private final List<Modifier> modifiers;
        private final Kind kind;
        private final Ident name;
        @Nullable
        private final TypeParameters typeParameters;
        @Nullable
        private final Extends extendings;
        @Nullable
        private final Implements implementings;
        private final Block<J> body;
        @Nullable
        private final JavaType.Class type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        public ClassDecl withModifiers(List<Modifier> modifiers) {
            if (modifiers == this.modifiers) {
                return this;
            }
            return new ClassDecl(this.id, this.annotations, modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public ClassDecl withModifiers(String ... modifierKeywords) {
            List<Modifier> fixedModifiers = Modifier.withModifiers(this.modifiers, modifierKeywords);
            if (fixedModifiers == this.modifiers) {
                return this;
            }
            if (this.modifiers.isEmpty()) {
                return this.withModifiers(fixedModifiers).withKind((Kind)this.kind.withPrefix(" "));
            }
            return this.withModifiers(fixedModifiers);
        }

        public ClassDecl withExtends(@Nullable Extends extendings) {
            if (extendings == this.extendings) {
                return this;
            }
            return new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, extendings, this.implementings, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        @JsonProperty(value="extendings")
        @Nullable
        public Extends getExtends() {
            return this.extendings;
        }

        public ClassDecl withImplements(@Nullable Implements implementings) {
            if (implementings == this.implementings) {
                return this;
            }
            return new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, implementings, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        @JsonProperty(value="implementings")
        @Nullable
        public Implements getImplements() {
            return this.implementings;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitClassDecl(this);
        }

        @JsonIgnore
        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Nullable
        public EnumValueSet getEnumValues() {
            return this.body.getStatements().stream().filter(EnumValueSet.class::isInstance).map(EnumValueSet.class::cast).findAny().orElse(null);
        }

        @JsonIgnore
        public List<VariableDecls> getFields() {
            return this.body.getStatements().stream().filter(VariableDecls.class::isInstance).map(VariableDecls.class::cast).collect(Collectors.toList());
        }

        @JsonIgnore
        public List<MethodDecl> getMethods() {
            return this.body.getStatements().stream().filter(MethodDecl.class::isInstance).map(MethodDecl.class::cast).collect(Collectors.toList());
        }

        public List<VariableDecls> findFields(String clazz) {
            return (List)new FindFields(clazz).visit(this);
        }

        public List<JavaType.Var> findInheritedFields(String clazz) {
            return (List)new FindInheritedFields(clazz).visit(this);
        }

        public List<MethodInvocation> findMethodCalls(String signature) {
            return (List)new FindMethods(signature).visit(this);
        }

        public Set<NameTree> findType(String clazz) {
            return (Set)new FindType(clazz).visit(this);
        }

        public List<Annotation> findAnnotations(String signature) {
            return (List)new FindAnnotations(signature).visit(this);
        }

        public List<Annotation> findAnnotationsOnClass(String signature) {
            FindAnnotations findAnnotations = new FindAnnotations(signature);
            return this.getAnnotations().stream().flatMap(a -> findAnnotations.visitAnnotation((Annotation)a).stream()).collect(Collectors.toList());
        }

        public boolean hasType(String clazz) {
            return (Boolean)new HasType(clazz).visit(this);
        }

        public boolean hasModifier(String modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        @JsonIgnore
        public boolean isEnum() {
            return this.kind instanceof Kind.Enum;
        }

        @JsonIgnore
        public boolean isClass() {
            return this.kind instanceof Kind.Class;
        }

        @JsonIgnore
        public boolean isInterface() {
            return this.kind instanceof Kind.Interface;
        }

        @JsonIgnore
        public boolean isAnnotation() {
            return this.kind instanceof Kind.Annotation;
        }

        public String toString() {
            return "ClassDecl{" + ClassDeclToString.toString(this) + "}";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDecl)) {
                return false;
            }
            ClassDecl other = (ClassDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "modifiers", "kind", "name", "typeParameters", "extendings", "implementings", "body", "type", "comments", "formatting", "markers"})
        public ClassDecl(UUID id, List<Annotation> annotations, List<Modifier> modifiers, Kind kind, Ident name, TypeParameters typeParameters, Extends extendings, Implements implementings, Block<J> body, JavaType.Class type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.annotations = annotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.extendings = extendings;
            this.implementings = implementings;
            this.body = body;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public ClassDecl withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new ClassDecl(this.id, annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        public ClassDecl withKind(Kind kind) {
            return this.kind == kind ? this : new ClassDecl(this.id, this.annotations, this.modifiers, kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public Kind getKind() {
            return this.kind;
        }

        public ClassDecl withName(Ident name) {
            return this.name == name ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public Ident getName() {
            return this.name;
        }

        public ClassDecl withTypeParameters(TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, typeParameters, this.extendings, this.implementings, this.body, this.type, this.comments, this.formatting, this.markers);
        }

        public TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        public ClassDecl withBody(Block<J> body) {
            return this.body == body ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, body, this.type, this.comments, this.formatting, this.markers);
        }

        public Block<J> getBody() {
            return this.body;
        }

        public ClassDecl withType(JavaType.Class type) {
            return this.type == type ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, type, this.comments, this.formatting, this.markers);
        }

        public JavaType.Class getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        @Override
        public ClassDecl withComments(List<Comment> comments) {
            return this.comments == comments ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, comments, this.formatting, this.markers);
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public ClassDecl withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.comments, formatting, this.markers);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ClassDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new ClassDecl(this.id, this.annotations, this.modifiers, this.kind, this.name, this.typeParameters, this.extendings, this.implementings, this.body, this.type, this.comments, this.formatting, markers);
        }

        public static final class Implements
        implements J {
            private final UUID id;
            private final List<TypeTree> from;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Implements)) {
                    return false;
                }
                Implements other = (Implements)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "from", "comments", "formatting", "markers"})
            public Implements(UUID id, List<TypeTree> from, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.from = from;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<TypeTree> getFrom() {
                return this.from;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.ClassDecl.Implements(id=" + this.getId() + ", from=" + this.getFrom() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Implements withFrom(List<TypeTree> from) {
                return this.from == from ? this : new Implements(this.id, from, this.comments, this.formatting, this.markers);
            }

            @Override
            public Implements withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Implements(this.id, this.from, comments, this.formatting, this.markers);
            }

            public Implements withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Implements(this.id, this.from, this.comments, formatting, this.markers);
            }

            public Implements withMarkers(Markers markers) {
                return this.markers == markers ? this : new Implements(this.id, this.from, this.comments, this.formatting, markers);
            }
        }

        public static final class Extends
        implements J {
            private final UUID id;
            private final TypeTree from;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Extends)) {
                    return false;
                }
                Extends other = (Extends)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "from", "comments", "formatting", "markers"})
            public Extends(UUID id, TypeTree from, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.from = from;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public TypeTree getFrom() {
                return this.from;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.ClassDecl.Extends(id=" + this.getId() + ", from=" + this.getFrom() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Extends withFrom(TypeTree from) {
                return this.from == from ? this : new Extends(this.id, from, this.comments, this.formatting, this.markers);
            }

            @Override
            public Extends withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Extends(this.id, this.from, comments, this.formatting, this.markers);
            }

            public Extends withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Extends(this.id, this.from, this.comments, formatting, this.markers);
            }

            public Extends withMarkers(Markers markers) {
                return this.markers == markers ? this : new Extends(this.id, this.from, this.comments, this.formatting, markers);
            }
        }

        public static abstract class Kind
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kind)) {
                    return false;
                }
                Kind other = (Kind)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Kind;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static final class Annotation
            extends Kind {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Annotation)) {
                        return false;
                    }
                    Annotation other = (Annotation)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Annotation;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Annotation(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Annotation(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Annotation withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Annotation(this.id, comments, this.formatting, this.markers);
                }

                public Annotation withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Annotation(this.id, this.comments, formatting, this.markers);
                }

                public Annotation withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Annotation(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Interface
            extends Kind {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Interface)) {
                        return false;
                    }
                    Interface other = (Interface)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Interface;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Interface(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Interface(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Interface withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Interface(this.id, comments, this.formatting, this.markers);
                }

                public Interface withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Interface(this.id, this.comments, formatting, this.markers);
                }

                public Interface withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Interface(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Enum
            extends Kind {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Enum)) {
                        return false;
                    }
                    Enum other = (Enum)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Enum;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Enum(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Enum(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Enum withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Enum(this.id, comments, this.formatting, this.markers);
                }

                public Enum withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Enum(this.id, this.comments, formatting, this.markers);
                }

                public Enum withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Enum(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Class
            extends Kind {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Class)) {
                        return false;
                    }
                    Class other = (Class)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Class;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Class(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.ClassDecl.Kind.Class(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Class withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Class(this.id, comments, this.formatting, this.markers);
                }

                public Class withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Class(this.id, this.comments, formatting, this.markers);
                }

                public Class withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Class(this.id, this.comments, this.formatting, markers);
                }
            }
        }
    }

    public static final class Case
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Expression pattern;
        private final List<Statement> statements;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitCase(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Case)) {
                return false;
            }
            Case other = (Case)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "pattern", "statements", "comments", "formatting", "markers"})
        public Case(UUID id, Expression pattern, List<Statement> statements, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.pattern = pattern;
            this.statements = statements;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getPattern() {
            return this.pattern;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Case(id=" + this.getId() + ", pattern=" + this.getPattern() + ", statements=" + this.getStatements() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Case withPattern(Expression pattern) {
            return this.pattern == pattern ? this : new Case(this.id, pattern, this.statements, this.comments, this.formatting, this.markers);
        }

        public Case withStatements(List<Statement> statements) {
            return this.statements == statements ? this : new Case(this.id, this.pattern, statements, this.comments, this.formatting, this.markers);
        }

        @Override
        public Case withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Case(this.id, this.pattern, this.statements, comments, this.formatting, this.markers);
        }

        public Case withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Case(this.id, this.pattern, this.statements, this.comments, formatting, this.markers);
        }

        public Case withMarkers(Markers markers) {
            return this.markers == markers ? this : new Case(this.id, this.pattern, this.statements, this.comments, this.formatting, markers);
        }
    }

    public static final class Break
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Ident label;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitBreak(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Break)) {
                return false;
            }
            Break other = (Break)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "label", "comments", "formatting", "markers"})
        public Break(UUID id, Ident label, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.label = label;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Ident getLabel() {
            return this.label;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Break(id=" + this.getId() + ", label=" + this.getLabel() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Break withLabel(Ident label) {
            return this.label == label ? this : new Break(this.id, label, this.comments, this.formatting, this.markers);
        }

        @Override
        public Break withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Break(this.id, this.label, comments, this.formatting, this.markers);
        }

        public Break withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Break(this.id, this.label, this.comments, formatting, this.markers);
        }

        public Break withMarkers(Markers markers) {
            return this.markers == markers ? this : new Break(this.id, this.label, this.comments, this.formatting, markers);
        }
    }

    public static final class Block<T extends J>
    implements J,
    Statement {
        private final UUID id;
        @Nullable
        private final Empty statik;
        private final List<T> statements;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;
        private final End end;

        public Block<T> withStatic(Empty statik) {
            return new Block<T>(this.id, statik, this.statements, this.comments, this.formatting, Markers.EMPTY, this.end);
        }

        @Nullable
        public Empty getStatic() {
            return this.statik;
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitBlock(this);
        }

        @JsonIgnore
        public int getIndent() {
            return Formatting.getIndent((String)this.end.getPrefix());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "statik", "statements", "comments", "formatting", "markers", "end"})
        public Block(UUID id, Empty statik, List<T> statements, List<Comment> comments, Formatting formatting, Markers markers, End end) {
            this.id = id;
            this.statik = statik;
            this.statements = statements;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
            this.end = end;
        }

        public UUID getId() {
            return this.id;
        }

        public List<T> getStatements() {
            return this.statements;
        }

        public Block<T> withStatements(List<T> statements) {
            return this.statements == statements ? this : new Block<T>(this.id, this.statik, statements, this.comments, this.formatting, this.markers, this.end);
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        @Override
        public Block<T> withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Block<T>(this.id, this.statik, this.statements, comments, this.formatting, this.markers, this.end);
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Block<T> withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Block<T>(this.id, this.statik, this.statements, this.comments, formatting, this.markers, this.end);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Block<T> withMarkers(Markers markers) {
            return this.markers == markers ? this : new Block<T>(this.id, this.statik, this.statements, this.comments, this.formatting, markers, this.end);
        }

        public End getEnd() {
            return this.end;
        }

        public Block<T> withEnd(End end) {
            return this.end == end ? this : new Block<T>(this.id, this.statik, this.statements, this.comments, this.formatting, this.markers, end);
        }

        public static final class End
        implements J {
            private final UUID id;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof End)) {
                    return false;
                }
                End other = (End)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
            public End(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Block.End(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            @Override
            public End withComments(List<Comment> comments) {
                return this.comments == comments ? this : new End(this.id, comments, this.formatting, this.markers);
            }

            public End withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new End(this.id, this.comments, formatting, this.markers);
            }

            public End withMarkers(Markers markers) {
                return this.markers == markers ? this : new End(this.id, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class Binary
    implements J,
    Expression {
        private final UUID id;
        private final Expression left;
        private final Operator operator;
        private final Expression right;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitBinary(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            ArrayList<Tree> sideEffects = new ArrayList<Tree>(2);
            sideEffects.addAll(this.left.getSideEffects());
            sideEffects.addAll(this.right.getSideEffects());
            return sideEffects;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "left", "operator", "right", "type", "comments", "formatting", "markers"})
        public Binary(UUID id, Expression left, Operator operator, Expression right, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Expression getRight() {
            return this.right;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Binary(id=" + this.getId() + ", left=" + this.getLeft() + ", operator=" + this.getOperator() + ", right=" + this.getRight() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.id, left, this.operator, this.right, this.type, this.comments, this.formatting, this.markers);
        }

        public Binary withOperator(Operator operator) {
            return this.operator == operator ? this : new Binary(this.id, this.left, operator, this.right, this.type, this.comments, this.formatting, this.markers);
        }

        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.id, this.left, this.operator, right, this.type, this.comments, this.formatting, this.markers);
        }

        public Binary withType(JavaType type) {
            return this.type == type ? this : new Binary(this.id, this.left, this.operator, this.right, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public Binary withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Binary(this.id, this.left, this.operator, this.right, this.type, comments, this.formatting, this.markers);
        }

        public Binary withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Binary(this.id, this.left, this.operator, this.right, this.type, this.comments, formatting, this.markers);
        }

        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.id, this.left, this.operator, this.right, this.type, this.comments, this.formatting, markers);
        }

        public static abstract class Operator
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Operator)) {
                    return false;
                }
                Operator other = (Operator)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Operator;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static final class And
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof And)) {
                        return false;
                    }
                    And other = (And)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof And;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public And(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.And(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public And withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new And(this.id, comments, this.formatting, this.markers);
                }

                public And withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new And(this.id, this.comments, formatting, this.markers);
                }

                public And withMarkers(Markers markers) {
                    return this.markers == markers ? this : new And(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Or
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Or)) {
                        return false;
                    }
                    Or other = (Or)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Or;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Or(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.Or(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Or withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Or(this.id, comments, this.formatting, this.markers);
                }

                public Or withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Or(this.id, this.comments, formatting, this.markers);
                }

                public Or withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Or(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class UnsignedRightShift
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof UnsignedRightShift)) {
                        return false;
                    }
                    UnsignedRightShift other = (UnsignedRightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof UnsignedRightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public UnsignedRightShift(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.UnsignedRightShift(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public UnsignedRightShift withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new UnsignedRightShift(this.id, comments, this.formatting, this.markers);
                }

                public UnsignedRightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new UnsignedRightShift(this.id, this.comments, formatting, this.markers);
                }

                public UnsignedRightShift withMarkers(Markers markers) {
                    return this.markers == markers ? this : new UnsignedRightShift(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class RightShift
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RightShift)) {
                        return false;
                    }
                    RightShift other = (RightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof RightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public RightShift(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.RightShift(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public RightShift withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new RightShift(this.id, comments, this.formatting, this.markers);
                }

                public RightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new RightShift(this.id, this.comments, formatting, this.markers);
                }

                public RightShift withMarkers(Markers markers) {
                    return this.markers == markers ? this : new RightShift(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class LeftShift
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LeftShift)) {
                        return false;
                    }
                    LeftShift other = (LeftShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LeftShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public LeftShift(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.LeftShift(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public LeftShift withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new LeftShift(this.id, comments, this.formatting, this.markers);
                }

                public LeftShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LeftShift(this.id, this.comments, formatting, this.markers);
                }

                public LeftShift withMarkers(Markers markers) {
                    return this.markers == markers ? this : new LeftShift(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class BitXor
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitXor)) {
                        return false;
                    }
                    BitXor other = (BitXor)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitXor;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public BitXor(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.BitXor(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public BitXor withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new BitXor(this.id, comments, this.formatting, this.markers);
                }

                public BitXor withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitXor(this.id, this.comments, formatting, this.markers);
                }

                public BitXor withMarkers(Markers markers) {
                    return this.markers == markers ? this : new BitXor(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class BitOr
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitOr)) {
                        return false;
                    }
                    BitOr other = (BitOr)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitOr;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public BitOr(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.BitOr(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public BitOr withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new BitOr(this.id, comments, this.formatting, this.markers);
                }

                public BitOr withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitOr(this.id, this.comments, formatting, this.markers);
                }

                public BitOr withMarkers(Markers markers) {
                    return this.markers == markers ? this : new BitOr(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class BitAnd
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitAnd)) {
                        return false;
                    }
                    BitAnd other = (BitAnd)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitAnd;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public BitAnd(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.BitAnd(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public BitAnd withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new BitAnd(this.id, comments, this.formatting, this.markers);
                }

                public BitAnd withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitAnd(this.id, this.comments, formatting, this.markers);
                }

                public BitAnd withMarkers(Markers markers) {
                    return this.markers == markers ? this : new BitAnd(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class NotEqual
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof NotEqual)) {
                        return false;
                    }
                    NotEqual other = (NotEqual)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof NotEqual;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public NotEqual(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.NotEqual(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public NotEqual withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new NotEqual(this.id, comments, this.formatting, this.markers);
                }

                public NotEqual withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new NotEqual(this.id, this.comments, formatting, this.markers);
                }

                public NotEqual withMarkers(Markers markers) {
                    return this.markers == markers ? this : new NotEqual(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Equal
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Equal)) {
                        return false;
                    }
                    Equal other = (Equal)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Equal;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Equal(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.Equal(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Equal withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Equal(this.id, comments, this.formatting, this.markers);
                }

                public Equal withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Equal(this.id, this.comments, formatting, this.markers);
                }

                public Equal withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Equal(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class GreaterThanOrEqual
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GreaterThanOrEqual)) {
                        return false;
                    }
                    GreaterThanOrEqual other = (GreaterThanOrEqual)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof GreaterThanOrEqual;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public GreaterThanOrEqual(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.GreaterThanOrEqual(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public GreaterThanOrEqual withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new GreaterThanOrEqual(this.id, comments, this.formatting, this.markers);
                }

                public GreaterThanOrEqual withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new GreaterThanOrEqual(this.id, this.comments, formatting, this.markers);
                }

                public GreaterThanOrEqual withMarkers(Markers markers) {
                    return this.markers == markers ? this : new GreaterThanOrEqual(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class LessThanOrEqual
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LessThanOrEqual)) {
                        return false;
                    }
                    LessThanOrEqual other = (LessThanOrEqual)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LessThanOrEqual;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public LessThanOrEqual(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.LessThanOrEqual(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public LessThanOrEqual withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new LessThanOrEqual(this.id, comments, this.formatting, this.markers);
                }

                public LessThanOrEqual withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LessThanOrEqual(this.id, this.comments, formatting, this.markers);
                }

                public LessThanOrEqual withMarkers(Markers markers) {
                    return this.markers == markers ? this : new LessThanOrEqual(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class GreaterThan
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof GreaterThan)) {
                        return false;
                    }
                    GreaterThan other = (GreaterThan)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof GreaterThan;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public GreaterThan(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.GreaterThan(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public GreaterThan withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new GreaterThan(this.id, comments, this.formatting, this.markers);
                }

                public GreaterThan withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new GreaterThan(this.id, this.comments, formatting, this.markers);
                }

                public GreaterThan withMarkers(Markers markers) {
                    return this.markers == markers ? this : new GreaterThan(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class LessThan
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LessThan)) {
                        return false;
                    }
                    LessThan other = (LessThan)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LessThan;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public LessThan(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.LessThan(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public LessThan withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new LessThan(this.id, comments, this.formatting, this.markers);
                }

                public LessThan withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LessThan(this.id, this.comments, formatting, this.markers);
                }

                public LessThan withMarkers(Markers markers) {
                    return this.markers == markers ? this : new LessThan(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Modulo
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Modulo)) {
                        return false;
                    }
                    Modulo other = (Modulo)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Modulo;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Modulo(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.Modulo(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Modulo withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Modulo(this.id, comments, this.formatting, this.markers);
                }

                public Modulo withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Modulo(this.id, this.comments, formatting, this.markers);
                }

                public Modulo withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Modulo(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Division
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Division)) {
                        return false;
                    }
                    Division other = (Division)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Division;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Division(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.Division(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Division withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Division(this.id, comments, this.formatting, this.markers);
                }

                public Division withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Division(this.id, this.comments, formatting, this.markers);
                }

                public Division withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Division(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Multiplication
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Multiplication)) {
                        return false;
                    }
                    Multiplication other = (Multiplication)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Multiplication;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Multiplication(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.Multiplication(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Multiplication withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Multiplication(this.id, comments, this.formatting, this.markers);
                }

                public Multiplication withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Multiplication(this.id, this.comments, formatting, this.markers);
                }

                public Multiplication withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Multiplication(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Subtraction
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Subtraction)) {
                        return false;
                    }
                    Subtraction other = (Subtraction)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Subtraction;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Subtraction(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.Subtraction(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Subtraction withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Subtraction(this.id, comments, this.formatting, this.markers);
                }

                public Subtraction withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Subtraction(this.id, this.comments, formatting, this.markers);
                }

                public Subtraction withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Subtraction(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Addition
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Addition)) {
                        return false;
                    }
                    Addition other = (Addition)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Addition;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Addition(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.Binary.Operator.Addition(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Addition withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Addition(this.id, comments, this.formatting, this.markers);
                }

                public Addition withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Addition(this.id, this.comments, formatting, this.markers);
                }

                public Addition withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Addition(this.id, this.comments, this.formatting, markers);
                }
            }
        }
    }

    public static final class AssignOp
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Expression variable;
        private final Operator operator;
        private final Expression assignment;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAssignOp(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignOp)) {
                return false;
            }
            AssignOp other = (AssignOp)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "variable", "operator", "assignment", "type", "comments", "formatting", "markers"})
        public AssignOp(UUID id, Expression variable, Operator operator, Expression assignment, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getVariable() {
            return this.variable;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Expression getAssignment() {
            return this.assignment;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.AssignOp(id=" + this.getId() + ", variable=" + this.getVariable() + ", operator=" + this.getOperator() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public AssignOp withVariable(Expression variable) {
            return this.variable == variable ? this : new AssignOp(this.id, variable, this.operator, this.assignment, this.type, this.comments, this.formatting, this.markers);
        }

        public AssignOp withOperator(Operator operator) {
            return this.operator == operator ? this : new AssignOp(this.id, this.variable, operator, this.assignment, this.type, this.comments, this.formatting, this.markers);
        }

        public AssignOp withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new AssignOp(this.id, this.variable, this.operator, assignment, this.type, this.comments, this.formatting, this.markers);
        }

        public AssignOp withType(JavaType type) {
            return this.type == type ? this : new AssignOp(this.id, this.variable, this.operator, this.assignment, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public AssignOp withComments(List<Comment> comments) {
            return this.comments == comments ? this : new AssignOp(this.id, this.variable, this.operator, this.assignment, this.type, comments, this.formatting, this.markers);
        }

        public AssignOp withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new AssignOp(this.id, this.variable, this.operator, this.assignment, this.type, this.comments, formatting, this.markers);
        }

        public AssignOp withMarkers(Markers markers) {
            return this.markers == markers ? this : new AssignOp(this.id, this.variable, this.operator, this.assignment, this.type, this.comments, this.formatting, markers);
        }

        public static abstract class Operator
        implements J {
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Operator)) {
                    return false;
                }
                Operator other = (Operator)o;
                return other.canEqual(this);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Operator;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public static final class UnsignedRightShift
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof UnsignedRightShift)) {
                        return false;
                    }
                    UnsignedRightShift other = (UnsignedRightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof UnsignedRightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public UnsignedRightShift(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.UnsignedRightShift(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public UnsignedRightShift withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new UnsignedRightShift(this.id, comments, this.formatting, this.markers);
                }

                public UnsignedRightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new UnsignedRightShift(this.id, this.comments, formatting, this.markers);
                }

                public UnsignedRightShift withMarkers(Markers markers) {
                    return this.markers == markers ? this : new UnsignedRightShift(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class RightShift
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof RightShift)) {
                        return false;
                    }
                    RightShift other = (RightShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof RightShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public RightShift(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.RightShift(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public RightShift withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new RightShift(this.id, comments, this.formatting, this.markers);
                }

                public RightShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new RightShift(this.id, this.comments, formatting, this.markers);
                }

                public RightShift withMarkers(Markers markers) {
                    return this.markers == markers ? this : new RightShift(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class LeftShift
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LeftShift)) {
                        return false;
                    }
                    LeftShift other = (LeftShift)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof LeftShift;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public LeftShift(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.LeftShift(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public LeftShift withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new LeftShift(this.id, comments, this.formatting, this.markers);
                }

                public LeftShift withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new LeftShift(this.id, this.comments, formatting, this.markers);
                }

                public LeftShift withMarkers(Markers markers) {
                    return this.markers == markers ? this : new LeftShift(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class BitXor
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitXor)) {
                        return false;
                    }
                    BitXor other = (BitXor)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitXor;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public BitXor(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.BitXor(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public BitXor withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new BitXor(this.id, comments, this.formatting, this.markers);
                }

                public BitXor withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitXor(this.id, this.comments, formatting, this.markers);
                }

                public BitXor withMarkers(Markers markers) {
                    return this.markers == markers ? this : new BitXor(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class BitOr
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitOr)) {
                        return false;
                    }
                    BitOr other = (BitOr)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitOr;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public BitOr(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.BitOr(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public BitOr withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new BitOr(this.id, comments, this.formatting, this.markers);
                }

                public BitOr withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitOr(this.id, this.comments, formatting, this.markers);
                }

                public BitOr withMarkers(Markers markers) {
                    return this.markers == markers ? this : new BitOr(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class BitAnd
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BitAnd)) {
                        return false;
                    }
                    BitAnd other = (BitAnd)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof BitAnd;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public BitAnd(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.BitAnd(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public BitAnd withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new BitAnd(this.id, comments, this.formatting, this.markers);
                }

                public BitAnd withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new BitAnd(this.id, this.comments, formatting, this.markers);
                }

                public BitAnd withMarkers(Markers markers) {
                    return this.markers == markers ? this : new BitAnd(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Modulo
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Modulo)) {
                        return false;
                    }
                    Modulo other = (Modulo)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Modulo;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Modulo(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Modulo(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Modulo withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Modulo(this.id, comments, this.formatting, this.markers);
                }

                public Modulo withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Modulo(this.id, this.comments, formatting, this.markers);
                }

                public Modulo withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Modulo(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Division
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Division)) {
                        return false;
                    }
                    Division other = (Division)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Division;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Division(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Division(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Division withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Division(this.id, comments, this.formatting, this.markers);
                }

                public Division withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Division(this.id, this.comments, formatting, this.markers);
                }

                public Division withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Division(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Multiplication
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Multiplication)) {
                        return false;
                    }
                    Multiplication other = (Multiplication)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Multiplication;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Multiplication(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Multiplication(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Multiplication withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Multiplication(this.id, comments, this.formatting, this.markers);
                }

                public Multiplication withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Multiplication(this.id, this.comments, formatting, this.markers);
                }

                public Multiplication withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Multiplication(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Subtraction
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Subtraction)) {
                        return false;
                    }
                    Subtraction other = (Subtraction)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Subtraction;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Subtraction(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Subtraction(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Subtraction withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Subtraction(this.id, comments, this.formatting, this.markers);
                }

                public Subtraction withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Subtraction(this.id, this.comments, formatting, this.markers);
                }

                public Subtraction withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Subtraction(this.id, this.comments, this.formatting, markers);
                }
            }

            public static final class Addition
            extends Operator {
                private final UUID id;
                private final List<Comment> comments;
                private final Formatting formatting;
                private final Markers markers;

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Addition)) {
                        return false;
                    }
                    Addition other = (Addition)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    UUID this$id = this.getId();
                    UUID other$id = other.getId();
                    return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Addition;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    UUID $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                    return result;
                }

                @ConstructorProperties(value={"id", "comments", "formatting", "markers"})
                public Addition(UUID id, List<Comment> comments, Formatting formatting, Markers markers) {
                    this.id = id;
                    this.comments = comments;
                    this.formatting = formatting;
                    this.markers = markers;
                }

                public UUID getId() {
                    return this.id;
                }

                @Override
                public List<Comment> getComments() {
                    return this.comments;
                }

                public Formatting getFormatting() {
                    return this.formatting;
                }

                public Markers getMarkers() {
                    return this.markers;
                }

                public String toString() {
                    return "J.AssignOp.Operator.Addition(id=" + this.getId() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
                }

                @Override
                public Addition withComments(List<Comment> comments) {
                    return this.comments == comments ? this : new Addition(this.id, comments, this.formatting, this.markers);
                }

                public Addition withFormatting(Formatting formatting) {
                    return this.formatting == formatting ? this : new Addition(this.id, this.comments, formatting, this.markers);
                }

                public Addition withMarkers(Markers markers) {
                    return this.markers == markers ? this : new Addition(this.id, this.comments, this.formatting, markers);
                }
            }
        }
    }

    public static final class Assign
    implements J,
    Statement,
    Expression {
        private final UUID id;
        private final Expression variable;
        private final Expression assignment;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAssign(this);
        }

        @Override
        @JsonIgnore
        public List<Tree> getSideEffects() {
            return Collections.singletonList(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assign)) {
                return false;
            }
            Assign other = (Assign)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "variable", "assignment", "type", "comments", "formatting", "markers"})
        public Assign(UUID id, Expression variable, Expression assignment, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getVariable() {
            return this.variable;
        }

        public Expression getAssignment() {
            return this.assignment;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Assign(id=" + this.getId() + ", variable=" + this.getVariable() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Assign withVariable(Expression variable) {
            return this.variable == variable ? this : new Assign(this.id, variable, this.assignment, this.type, this.comments, this.formatting, this.markers);
        }

        public Assign withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new Assign(this.id, this.variable, assignment, this.type, this.comments, this.formatting, this.markers);
        }

        public Assign withType(JavaType type) {
            return this.type == type ? this : new Assign(this.id, this.variable, this.assignment, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public Assign withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Assign(this.id, this.variable, this.assignment, this.type, comments, this.formatting, this.markers);
        }

        public Assign withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Assign(this.id, this.variable, this.assignment, this.type, this.comments, formatting, this.markers);
        }

        public Assign withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assign(this.id, this.variable, this.assignment, this.type, this.comments, this.formatting, markers);
        }
    }

    public static final class Assert
    implements J,
    Statement {
        private final UUID id;
        private final Expression condition;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAssert(this);
        }

        @Override
        @JsonIgnore
        public boolean isSemicolonTerminated() {
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assert)) {
                return false;
            }
            Assert other = (Assert)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "condition", "comments", "formatting", "markers"})
        public Assert(UUID id, Expression condition, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.condition = condition;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getCondition() {
            return this.condition;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Assert(id=" + this.getId() + ", condition=" + this.getCondition() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Assert withCondition(Expression condition) {
            return this.condition == condition ? this : new Assert(this.id, condition, this.comments, this.formatting, this.markers);
        }

        @Override
        public Assert withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Assert(this.id, this.condition, comments, this.formatting, this.markers);
        }

        public Assert withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Assert(this.id, this.condition, this.comments, formatting, this.markers);
        }

        public Assert withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assert(this.id, this.condition, this.comments, this.formatting, markers);
        }
    }

    public static final class ArrayType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final TypeTree elementType;
        private final List<Dimension> dimensions;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return this.elementType.getType();
        }

        public ArrayType withType(JavaType type) {
            return this.withElementType((TypeTree)this.elementType.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitArrayType(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayType)) {
                return false;
            }
            ArrayType other = (ArrayType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "elementType", "dimensions", "comments", "formatting", "markers"})
        public ArrayType(UUID id, TypeTree elementType, List<Dimension> dimensions, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.elementType = elementType;
            this.dimensions = dimensions;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public TypeTree getElementType() {
            return this.elementType;
        }

        public List<Dimension> getDimensions() {
            return this.dimensions;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.ArrayType(id=" + this.getId() + ", elementType=" + this.getElementType() + ", dimensions=" + this.getDimensions() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public ArrayType withElementType(TypeTree elementType) {
            return this.elementType == elementType ? this : new ArrayType(this.id, elementType, this.dimensions, this.comments, this.formatting, this.markers);
        }

        public ArrayType withDimensions(List<Dimension> dimensions) {
            return this.dimensions == dimensions ? this : new ArrayType(this.id, this.elementType, dimensions, this.comments, this.formatting, this.markers);
        }

        @Override
        public ArrayType withComments(List<Comment> comments) {
            return this.comments == comments ? this : new ArrayType(this.id, this.elementType, this.dimensions, comments, this.formatting, this.markers);
        }

        public ArrayType withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ArrayType(this.id, this.elementType, this.dimensions, this.comments, formatting, this.markers);
        }

        public ArrayType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayType(this.id, this.elementType, this.dimensions, this.comments, this.formatting, markers);
        }

        public static final class Dimension
        implements J {
            private final UUID id;
            private final Empty inner;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "inner", "comments", "formatting", "markers"})
            public Dimension(UUID id, Empty inner, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.inner = inner;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Empty getInner() {
                return this.inner;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.ArrayType.Dimension(id=" + this.getId() + ", inner=" + this.getInner() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Dimension withInner(Empty inner) {
                return this.inner == inner ? this : new Dimension(this.id, inner, this.comments, this.formatting, this.markers);
            }

            @Override
            public Dimension withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Dimension(this.id, this.inner, comments, this.formatting, this.markers);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.inner, this.comments, formatting, this.markers);
            }

            public Dimension withMarkers(Markers markers) {
                return this.markers == markers ? this : new Dimension(this.id, this.inner, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class ArrayAccess
    implements J,
    Expression {
        private final UUID id;
        private final Expression indexed;
        private final Dimension dimension;
        @Nullable
        private final JavaType type;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitArrayAccess(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "indexed", "dimension", "type", "comments", "formatting", "markers"})
        public ArrayAccess(UUID id, Expression indexed, Dimension dimension, JavaType type, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.indexed = indexed;
            this.dimension = dimension;
            this.type = type;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public Expression getIndexed() {
            return this.indexed;
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        @Override
        public JavaType getType() {
            return this.type;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.ArrayAccess(id=" + this.getId() + ", indexed=" + this.getIndexed() + ", dimension=" + this.getDimension() + ", type=" + this.getType() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public ArrayAccess withIndexed(Expression indexed) {
            return this.indexed == indexed ? this : new ArrayAccess(this.id, indexed, this.dimension, this.type, this.comments, this.formatting, this.markers);
        }

        public ArrayAccess withDimension(Dimension dimension) {
            return this.dimension == dimension ? this : new ArrayAccess(this.id, this.indexed, dimension, this.type, this.comments, this.formatting, this.markers);
        }

        public ArrayAccess withType(JavaType type) {
            return this.type == type ? this : new ArrayAccess(this.id, this.indexed, this.dimension, type, this.comments, this.formatting, this.markers);
        }

        @Override
        public ArrayAccess withComments(List<Comment> comments) {
            return this.comments == comments ? this : new ArrayAccess(this.id, this.indexed, this.dimension, this.type, comments, this.formatting, this.markers);
        }

        public ArrayAccess withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new ArrayAccess(this.id, this.indexed, this.dimension, this.type, this.comments, formatting, this.markers);
        }

        public ArrayAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayAccess(this.id, this.indexed, this.dimension, this.type, this.comments, this.formatting, markers);
        }

        public static final class Dimension
        implements J {
            private final UUID id;
            private final Expression index;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dimension)) {
                    return false;
                }
                Dimension other = (Dimension)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "index", "comments", "formatting", "markers"})
            public Dimension(UUID id, Expression index, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.index = index;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public Expression getIndex() {
                return this.index;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.ArrayAccess.Dimension(id=" + this.getId() + ", index=" + this.getIndex() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Dimension withIndex(Expression index) {
                return this.index == index ? this : new Dimension(this.id, index, this.comments, this.formatting, this.markers);
            }

            @Override
            public Dimension withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Dimension(this.id, this.index, comments, this.formatting, this.markers);
            }

            public Dimension withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Dimension(this.id, this.index, this.comments, formatting, this.markers);
            }

            public Dimension withMarkers(Markers markers) {
                return this.markers == markers ? this : new Dimension(this.id, this.index, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class Annotation
    implements J,
    Expression {
        private final UUID id;
        private final NameTree annotationType;
        @Nullable
        private final Arguments args;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        @JsonIgnore
        public JavaType getType() {
            return this.annotationType.getType();
        }

        public Annotation withType(@Nullable JavaType type) {
            return this.withAnnotationType((NameTree)this.annotationType.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAnnotation(this);
        }

        public static Annotation buildAnnotation(Formatting formatting, JavaType.Class annotationType, List<Expression> arguments) {
            return new Annotation(Tree.randomId(), Ident.build(Tree.randomId(), annotationType.getClassName(), annotationType, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), arguments.isEmpty() ? null : new Arguments(Tree.randomId(), arguments, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), Collections.emptyList(), formatting, Markers.EMPTY);
        }

        public <T extends Tree> Optional<T> whenType(Class<T> treeType) {
            return Optional.empty();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation other = (Annotation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotationType", "args", "comments", "formatting", "markers"})
        public Annotation(UUID id, NameTree annotationType, Arguments args, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.annotationType = annotationType;
            this.args = args;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public NameTree getAnnotationType() {
            return this.annotationType;
        }

        public Arguments getArgs() {
            return this.args;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.Annotation(id=" + this.getId() + ", annotationType=" + this.getAnnotationType() + ", args=" + this.getArgs() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public Annotation withAnnotationType(NameTree annotationType) {
            return this.annotationType == annotationType ? this : new Annotation(this.id, annotationType, this.args, this.comments, this.formatting, this.markers);
        }

        public Annotation withArgs(Arguments args) {
            return this.args == args ? this : new Annotation(this.id, this.annotationType, args, this.comments, this.formatting, this.markers);
        }

        @Override
        public Annotation withComments(List<Comment> comments) {
            return this.comments == comments ? this : new Annotation(this.id, this.annotationType, this.args, comments, this.formatting, this.markers);
        }

        public Annotation withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Annotation(this.id, this.annotationType, this.args, this.comments, formatting, this.markers);
        }

        public Annotation withMarkers(Markers markers) {
            return this.markers == markers ? this : new Annotation(this.id, this.annotationType, this.args, this.comments, this.formatting, markers);
        }

        public static final class Arguments
        implements J {
            private final UUID id;
            private final List<Expression> args;
            private final List<Comment> comments;
            private final Formatting formatting;
            private final Markers markers;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Arguments)) {
                    return false;
                }
                Arguments other = (Arguments)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @ConstructorProperties(value={"id", "args", "comments", "formatting", "markers"})
            public Arguments(UUID id, List<Expression> args, List<Comment> comments, Formatting formatting, Markers markers) {
                this.id = id;
                this.args = args;
                this.comments = comments;
                this.formatting = formatting;
                this.markers = markers;
            }

            public UUID getId() {
                return this.id;
            }

            public List<Expression> getArgs() {
                return this.args;
            }

            @Override
            public List<Comment> getComments() {
                return this.comments;
            }

            public Formatting getFormatting() {
                return this.formatting;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public String toString() {
                return "J.Annotation.Arguments(id=" + this.getId() + ", args=" + this.getArgs() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
            }

            public Arguments withArgs(List<Expression> args) {
                return this.args == args ? this : new Arguments(this.id, args, this.comments, this.formatting, this.markers);
            }

            @Override
            public Arguments withComments(List<Comment> comments) {
                return this.comments == comments ? this : new Arguments(this.id, this.args, comments, this.formatting, this.markers);
            }

            public Arguments withFormatting(Formatting formatting) {
                return this.formatting == formatting ? this : new Arguments(this.id, this.args, this.comments, formatting, this.markers);
            }

            public Arguments withMarkers(Markers markers) {
                return this.markers == markers ? this : new Arguments(this.id, this.args, this.comments, this.formatting, markers);
            }
        }
    }

    public static final class AnnotatedType
    implements J,
    Expression,
    TypeTree {
        private final UUID id;
        private final List<Annotation> annotations;
        private final TypeTree typeExpr;
        private final List<Comment> comments;
        private final Formatting formatting;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return this.typeExpr.getType();
        }

        public AnnotatedType withType(@Nullable JavaType type) {
            return this.withTypeExpr((TypeTree)this.typeExpr.withType(type));
        }

        @Override
        public <R> R acceptJava(JavaSourceVisitor<R> v) {
            return v.visitAnnotatedType(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedType)) {
                return false;
            }
            AnnotatedType other = (AnnotatedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "annotations", "typeExpr", "comments", "formatting", "markers"})
        public AnnotatedType(UUID id, List<Annotation> annotations, TypeTree typeExpr, List<Comment> comments, Formatting formatting, Markers markers) {
            this.id = id;
            this.annotations = annotations;
            this.typeExpr = typeExpr;
            this.comments = comments;
            this.formatting = formatting;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public TypeTree getTypeExpr() {
            return this.typeExpr;
        }

        @Override
        public List<Comment> getComments() {
            return this.comments;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String toString() {
            return "J.AnnotatedType(id=" + this.getId() + ", annotations=" + this.getAnnotations() + ", typeExpr=" + this.getTypeExpr() + ", comments=" + this.getComments() + ", formatting=" + this.getFormatting() + ", markers=" + this.getMarkers() + ")";
        }

        public AnnotatedType withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new AnnotatedType(this.id, annotations, this.typeExpr, this.comments, this.formatting, this.markers);
        }

        public AnnotatedType withTypeExpr(TypeTree typeExpr) {
            return this.typeExpr == typeExpr ? this : new AnnotatedType(this.id, this.annotations, typeExpr, this.comments, this.formatting, this.markers);
        }

        @Override
        public AnnotatedType withComments(List<Comment> comments) {
            return this.comments == comments ? this : new AnnotatedType(this.id, this.annotations, this.typeExpr, comments, this.formatting, this.markers);
        }

        public AnnotatedType withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new AnnotatedType(this.id, this.annotations, this.typeExpr, this.comments, formatting, this.markers);
        }

        public AnnotatedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new AnnotatedType(this.id, this.annotations, this.typeExpr, this.comments, this.formatting, markers);
        }
    }
}

