/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Markers;

public class InsertMethodArgument
extends JavaIsoRefactorVisitor {
    private MethodMatcher methodMatcher;
    private Integer index;
    private String source;

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"pos", (Object)this.index)).and(Validated.required((String)"source", (Object)this.source));
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method)) {
            this.andThen((RefactorVisitor)new Scoped(method, this.index, this.source));
        }
        return super.visitMethodInvocation(method);
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.MethodInvocation scope;
        private final int index;
        private final String source;

        public Scoped(J.MethodInvocation scope, int index, String source) {
            this.scope = scope;
            this.index = index;
            this.source = source;
        }

        public boolean isIdempotent() {
            return false;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
            if (this.scope.isScope(method)) {
                List modifiedArgs = method.getArgs().getArgs().stream().filter(a -> !(a instanceof J.Empty)).collect(Collectors.toCollection(ArrayList::new));
                modifiedArgs.add(this.index, new J.UnparsedSource(Tree.randomId(), this.source, Collections.emptyList(), this.index == 0 ? modifiedArgs.stream().findFirst().map(Tree::getFormatting).orElse(Formatting.EMPTY) : Formatting.format((String)" "), Markers.EMPTY));
                if (this.index == 0 && modifiedArgs.size() > 1) {
                    modifiedArgs.set(1, (Expression)((Expression)modifiedArgs.get(1)).withFormatting(Formatting.format((String)" ")));
                }
                return method.withArgs(method.getArgs().withArgs(modifiedArgs));
            }
            return super.visitMethodInvocation(method);
        }
    }
}

