/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class GenerateSetter {

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.ClassDecl scope;
        private final String fieldName;

        public Scoped(J.ClassDecl scope, String fieldName) {
            this.scope = scope;
            this.fieldName = fieldName;
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl cd = super.visitClassDecl(classDecl);
            if (!classDecl.isScope(this.scope)) {
                return cd;
            }
            J.VariableDecls field = cd.getFields().stream().filter(it -> it.getVars().get(0).getSimpleName().equals(this.fieldName)).findAny().orElse(null);
            if (field == null) {
                return cd;
            }
            JavaType.Class type = TypeUtils.asClass(classDecl.getType());
            if (type != null) {
                String fieldTypeString;
                JavaType.Class classType = field.getTypeAsClass();
                if (classType != null) {
                    fieldTypeString = classType.getFullyQualifiedName();
                } else {
                    assert (field.getTypeExpr() != null);
                    fieldTypeString = field.getTypeExpr().print();
                }
                MethodMatcher setterMatcher = new MethodMatcher(type.getFullyQualifiedName() + " set" + StringUtils.capitalize((String)this.fieldName) + "(" + fieldTypeString + ")");
                boolean setterAlreadyExists = cd.getMethods().stream().anyMatch(it -> setterMatcher.matches((J.MethodDecl)it, classDecl));
                if (setterAlreadyExists) {
                    return cd;
                }
                J.VariableDecls.NamedVar fieldVar = field.getVars().get(0);
                JavaType fieldType = fieldVar.getType();
                J.Ident valueArgument = J.Ident.build(Tree.randomId(), "value", fieldType, Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY);
                Expression assignmentExp = fieldVar.getSimpleName().equals("value") ? new J.FieldAccess(Tree.randomId(), J.Ident.build(Tree.randomId(), "this", cd.getType(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), fieldVar.getName(), fieldType, Collections.emptyList(), Formatting.format((String)"", (String)" "), Markers.EMPTY) : fieldVar.getName().withFormatting(Formatting.format((String)"", (String)" "));
                J.MethodDecl setMethod = new J.MethodDecl(Tree.randomId(), Collections.emptyList(), Collections.singletonList(new J.Modifier.Public(Tree.randomId(), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY)), null, (TypeTree)JavaType.Primitive.Void.toTypeTree().withFormatting(Formatting.format((String)" ")), J.Ident.build(Tree.randomId(), "set" + StringUtils.capitalize((String)this.fieldName), null, Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY), new J.MethodDecl.Parameters(Tree.randomId(), Collections.singletonList(new J.VariableDecls(Tree.randomId(), Collections.emptyList(), Collections.emptyList(), field.getTypeExpr(), null, Collections.emptyList(), Collections.singletonList(new J.VariableDecls.NamedVar(Tree.randomId(), valueArgument, Collections.emptyList(), null, fieldType, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY)), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY)), Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY), null, new J.Block<Statement>(Tree.randomId(), null, Collections.singletonList(new J.Assign(Tree.randomId(), assignmentExp, valueArgument, null, Collections.emptyList(), Formatting.format((String)"\n    "), Markers.EMPTY)), Collections.emptyList(), Formatting.format((String)" "), Markers.EMPTY, new J.Block.End(Tree.randomId(), Collections.emptyList(), Formatting.format((String)"\n"), Markers.EMPTY)), null, Collections.emptyList(), Formatting.format((String)"\n\n"), Markers.EMPTY);
                this.andThen((RefactorVisitor)new AutoFormat(setMethod));
                J.Block<J> body = cd.getBody();
                ArrayList<J> statements = new ArrayList<J>(body.getStatements());
                statements.add(setMethod);
                cd = cd.withBody(body.withStatements(statements));
            }
            return cd;
        }
    }
}

