/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaType;

public class TypeUtils {
    private TypeUtils() {
    }

    public static List<JavaType.Var> getVisibleSupertypeMembers(@Nullable JavaType type) {
        JavaType.Class classType = TypeUtils.asClass(type);
        return classType == null ? Collections.emptyList() : classType.getVisibleSupertypeMembers();
    }

    public static boolean isString(@Nullable JavaType type) {
        return type == JavaType.Primitive.String || type instanceof JavaType.Class && "java.lang.String".equals(((JavaType.Class)type).getFullyQualifiedName());
    }

    public static boolean isOfClassType(@Nullable JavaType type, String fqn) {
        JavaType.Class classType = TypeUtils.asClass(type);
        return classType != null && classType.getFullyQualifiedName().equals(fqn);
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from) {
        if (from == JavaType.Class.OBJECT) {
            return to == JavaType.Class.OBJECT;
        }
        JavaType.Class classTo = TypeUtils.asClass(to);
        JavaType.Class classFrom = TypeUtils.asClass(from);
        if (classTo == null || classFrom == null) {
            return false;
        }
        if (classTo.getFullyQualifiedName().equals(classFrom.getFullyQualifiedName()) || TypeUtils.isAssignableTo(to, classFrom.getSupertype()) || classFrom.getInterfaces().stream().anyMatch(i -> TypeUtils.isAssignableTo(to, i))) {
            return true;
        }
        try {
            Class<?> classFromReflect = Class.forName(classFrom.getFullyQualifiedName(), false, TypeUtils.class.getClassLoader());
            if (classFromReflect.getSuperclass() != null && TypeUtils.isAssignableTo(to, JavaType.Class.build(classFromReflect.getSuperclass().getName()))) {
                return true;
            }
            return Arrays.stream(classFromReflect.getInterfaces()).anyMatch(i -> TypeUtils.isAssignableTo(to, JavaType.Class.build(i.getName())));
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @Nullable
    public static JavaType.Class asClass(@Nullable JavaType type) {
        return type instanceof JavaType.Class ? (JavaType.Class)type : null;
    }

    @Nullable
    public static JavaType.Array asArray(@Nullable JavaType type) {
        return type instanceof JavaType.Array ? (JavaType.Array)type : null;
    }

    @Nullable
    public static JavaType.GenericTypeVariable asGeneric(@Nullable JavaType type) {
        return type instanceof JavaType.GenericTypeVariable ? (JavaType.GenericTypeVariable)type : null;
    }

    @Nullable
    public static JavaType.Method asMethod(@Nullable JavaType type) {
        return type instanceof JavaType.Method ? (JavaType.Method)type : null;
    }

    @Nullable
    public static JavaType.Primitive asPrimitive(@Nullable JavaType type) {
        return type instanceof JavaType.Primitive ? (JavaType.Primitive)type : null;
    }

    @Nullable
    public static JavaType.FullyQualified asFullyQualified(@Nullable JavaType type) {
        return type instanceof JavaType.FullyQualified ? (JavaType.FullyQualified)type : null;
    }

    public static boolean hasElementType(@Nullable JavaType type, String fullyQualifiedName) {
        if (type instanceof JavaType.Array) {
            return TypeUtils.hasElementType(((JavaType.Array)type).getElemType(), fullyQualifiedName);
        }
        if (type instanceof JavaType.Class) {
            return ((JavaType.Class)type).getFullyQualifiedName().equals(fullyQualifiedName);
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            return ((JavaType.GenericTypeVariable)type).getFullyQualifiedName().equals(fullyQualifiedName);
        }
        return false;
    }

    static boolean deepEquals(List<? extends JavaType> ts1, List<? extends JavaType> ts2) {
        if (ts1.size() != ts2.size()) {
            return false;
        }
        for (int i = 0; i < ts1.size(); ++i) {
            JavaType t1 = ts1.get(i);
            JavaType t2 = ts2.get(i);
            if (!(t1 == null ? t2 != null : !TypeUtils.deepEquals(t1, t2))) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals(@Nullable JavaType t, @Nullable JavaType t2) {
        return t == null ? t2 == null : t == t2 || t.deepEquals(t2);
    }
}

