/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.style.DeclarationOrderStyle;
import org.openrewrite.java.tree.J;

public class OrderDeclarations
extends JavaIsoRefactorVisitor {
    @Nullable
    private DeclarationOrderStyle.Layout layout;

    @Override
    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
        this.andThen((RefactorVisitor)new Scoped(classDecl, this.layout));
        return classDecl;
    }

    public void setLayout(@Nullable DeclarationOrderStyle.Layout layout) {
        this.layout = layout;
    }

    public boolean isIdempotent() {
        return false;
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.ClassDecl scope;
        @Nullable
        private DeclarationOrderStyle.Layout layout;

        public Scoped(J.ClassDecl scope, @Nullable DeclarationOrderStyle.Layout layout) {
            this.scope = scope;
            this.layout = layout;
            this.setCursoringOn();
        }

        public Scoped(J.ClassDecl scope) {
            this(scope, null);
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
            if (this.layout == null) {
                this.layout = Optional.ofNullable((DeclarationOrderStyle)cu.getStyle(DeclarationOrderStyle.class)).map(style -> {
                    this.layout = style.getLayout();
                    return this.layout;
                }).orElse(DeclarationOrderStyle.Layout.DEFAULT);
            }
            return super.visitCompilationUnit(cu);
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = super.visitClassDecl(classDecl);
            if (this.getCursor().isScopeInPath((Tree)this.scope)) {
                assert (this.layout != null);
                this.layout.reset();
                c.getBody().getStatements().forEach(this.layout::accept);
                List<J> orderedDeclarations = this.layout.orderedDeclarations();
                int orderedDeclarationsSize = orderedDeclarations.size();
                for (int i = 0; i < orderedDeclarationsSize; ++i) {
                    J orderedDeclaration = orderedDeclarations.get(i);
                    if (!(orderedDeclaration instanceof J.MethodDecl)) continue;
                    orderedDeclarations.set(i, (J)orderedDeclaration.withFormatting(orderedDeclaration.getFormatting().withMinimumBlankLines(1)));
                }
                this.andThen((RefactorVisitor)new AutoFormat(orderedDeclarations.toArray(new J[0])));
                c = c.withBody(c.getBody().withStatements(orderedDeclarations));
            }
            return c;
        }
    }
}

