/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.ShiftFormatRightVisitor;
import org.openrewrite.java.search.FindIndentJava;
import org.openrewrite.java.tree.J;
import org.openrewrite.refactor.Formatter;

public class JavaFormatter
extends Formatter {
    public JavaFormatter(J.CompilationUnit cu) {
        super((Tree)cu, FindIndentJava::new);
    }

    public Formatting format(Tree relativeToEnclosing) {
        Tree[] siblings = new Tree[]{};
        if (relativeToEnclosing instanceof J.Block) {
            siblings = ((J.Block)relativeToEnclosing).getStatements().toArray(new Tree[0]);
        } else if (relativeToEnclosing instanceof J.Case) {
            siblings = ((J.Case)relativeToEnclosing).getStatements().toArray(new Tree[0]);
        }
        Formatter.Result indentation = this.findIndent(JavaFormatter.enclosingIndent(relativeToEnclosing), siblings);
        return Formatting.format((String)indentation.getPrefix());
    }

    public Formatting format(Cursor cursor) {
        return this.format(cursor.firstEnclosing(J.Block.class));
    }

    public ShiftFormatRightVisitor shiftRight(Tree moving, Tree into, Tree enclosesBoth) {
        int shift = JavaFormatter.enclosingIndent(into) - this.findIndent(JavaFormatter.enclosingIndent(enclosesBoth), new Tree[]{moving}).getEnclosingIndent();
        return new ShiftFormatRightVisitor(moving, shift, this.wholeSourceIndent().isIndentedWithSpaces());
    }

    public static int enclosingIndent(Tree enclosesBoth) {
        AtomicBoolean dropWhile = new AtomicBoolean(false);
        AtomicBoolean takeWhile = new AtomicBoolean(true);
        return enclosesBoth instanceof J.Block ? ((J.Block)enclosesBoth).getIndent() : (int)enclosesBoth.getPrefix().chars().filter(c -> {
            dropWhile.set(dropWhile.get() || c != 10 && c != 13);
            return dropWhile.get();
        }).filter(c -> {
            takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
            return takeWhile.get();
        }).count();
    }

    public boolean isIndentedWithSpaces() {
        return this.wholeSourceIndent().isIndentedWithSpaces();
    }
}

