/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.util.Collection;
import java.util.stream.StreamSupport;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AbstractJavaSourceVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class PrintJava
extends AbstractJavaSourceVisitor<String> {
    public String defaultTo(Tree t) {
        return "";
    }

    public String reduce(String r1, String r2) {
        return r1 + r2;
    }

    String visit(Collection<? extends Tree> nodes, String suffixBetween) {
        return this.visit(nodes, suffixBetween, "");
    }

    String visit(Collection<? extends Tree> nodes, String suffixBetween, String suffixEnd) {
        String acc = "";
        Tree[] array = nodes.toArray(new Tree[0]);
        for (int i = 0; i < array.length; ++i) {
            Tree node = array[i];
            acc = this.reduce(acc, (String)this.visit(node) + (i == array.length - 1 ? suffixEnd : suffixBetween));
        }
        return acc;
    }

    String visitStatements(Collection<? extends Tree> statements) {
        return statements.stream().map(this::fmtStatement).reduce("", this::reduce);
    }

    private String fmtStatement(Tree statement) {
        String semicolonOrEmpty = statement instanceof Statement && ((Statement)statement).isSemicolonTerminated() || statement instanceof J.MethodDecl && ((J.MethodDecl)statement).isAbstract() ? ";" : "";
        return (String)this.visit(statement) + semicolonOrEmpty;
    }

    private String fmt(@Nullable Tree tree, @Nullable String code) {
        return tree == null || code == null ? "" : tree.getPrefix() + code + tree.getSuffix();
    }

    String visitModifiers(Iterable<J.Modifier> modifiers) {
        return StreamSupport.stream(modifiers.spliterator(), false).map(mod -> {
            String keyword = "";
            if (mod instanceof J.Modifier.Public) {
                keyword = "public";
            } else if (mod instanceof J.Modifier.Protected) {
                keyword = "protected";
            } else if (mod instanceof J.Modifier.Private) {
                keyword = "private";
            } else if (mod instanceof J.Modifier.Abstract) {
                keyword = "abstract";
            } else if (mod instanceof J.Modifier.Native) {
                keyword = "native";
            } else if (mod instanceof J.Modifier.Static) {
                keyword = "static";
            } else if (mod instanceof J.Modifier.Strictfp) {
                keyword = "strictfp";
            } else if (mod instanceof J.Modifier.Final) {
                keyword = "final";
            } else if (mod instanceof J.Modifier.Transient) {
                keyword = "transient";
            } else if (mod instanceof J.Modifier.Volatile) {
                keyword = "volatile";
            } else if (mod instanceof J.Modifier.Default) {
                keyword = "default";
            } else if (mod instanceof J.Modifier.Synchronized) {
                keyword = "synchronized";
            }
            return this.fmt((Tree)mod, keyword);
        }).reduce("", this::reduce);
    }

    String visitDims(Collection<J.VariableDecls.Dimension> dims) {
        return dims.stream().map(d -> this.fmt((Tree)d, "[" + (String)this.visit(d.getWhitespace()) + "]")).reduce("", this::reduce);
    }

    @Override
    public String visitAnnotatedType(J.AnnotatedType annotatedType) {
        return this.fmt(annotatedType, this.visit(annotatedType.getAnnotations(), "") + (String)this.visit(annotatedType.getTypeExpr()));
    }

    @Override
    public String visitAnnotation(J.Annotation annotation) {
        String args = annotation.getArgs() == null ? "" : this.fmt(annotation.getArgs(), "(" + this.visit(annotation.getArgs().getArgs(), ",") + ")");
        return this.fmt(annotation, "@" + (String)this.visit(annotation.getAnnotationType()) + args);
    }

    @Override
    public String visitArrayAccess(J.ArrayAccess arrayAccess) {
        String dimension = this.fmt(arrayAccess.getDimension(), "[" + (String)this.visit(arrayAccess.getDimension().getIndex()) + "]");
        return this.fmt(arrayAccess, (String)this.visit(arrayAccess.getIndexed()) + dimension);
    }

    @Override
    public String visitArrayType(J.ArrayType arrayType) {
        String dimension = arrayType.getDimensions().stream().map(d -> this.fmt((Tree)d, "[" + (String)this.visit(d.getInner()) + "]")).reduce("", this::reduce);
        return this.fmt(arrayType, (String)this.visit(arrayType.getElementType()) + dimension);
    }

    @Override
    public String visitAssert(J.Assert azzert) {
        return this.fmt(azzert, "assert" + (String)this.visit(azzert.getCondition()));
    }

    @Override
    public String visitAssign(J.Assign assign) {
        return this.fmt(assign, (String)this.visit(assign.getVariable()) + "=" + (String)this.visit(assign.getAssignment()));
    }

    @Override
    public String visitAssignOp(J.AssignOp assignOp) {
        String keyword = "";
        if (assignOp.getOperator() instanceof J.AssignOp.Operator.Addition) {
            keyword = "+=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.Subtraction) {
            keyword = "-=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.Multiplication) {
            keyword = "*=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.Division) {
            keyword = "/=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.Modulo) {
            keyword = "%=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.BitAnd) {
            keyword = "&=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.BitOr) {
            keyword = "|=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.BitXor) {
            keyword = "^=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.LeftShift) {
            keyword = "<<=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.RightShift) {
            keyword = ">>=";
        } else if (assignOp.getOperator() instanceof J.AssignOp.Operator.UnsignedRightShift) {
            keyword = ">>>=";
        }
        return this.fmt(assignOp, (String)this.visit(assignOp.getVariable()) + this.fmt(assignOp.getOperator(), keyword) + (String)this.visit(assignOp.getAssignment()));
    }

    @Override
    public String visitBinary(J.Binary binary) {
        String keyword = "";
        if (binary.getOperator() instanceof J.Binary.Operator.Addition) {
            keyword = "+";
        } else if (binary.getOperator() instanceof J.Binary.Operator.Subtraction) {
            keyword = "-";
        } else if (binary.getOperator() instanceof J.Binary.Operator.Multiplication) {
            keyword = "*";
        } else if (binary.getOperator() instanceof J.Binary.Operator.Division) {
            keyword = "/";
        } else if (binary.getOperator() instanceof J.Binary.Operator.Modulo) {
            keyword = "%";
        } else if (binary.getOperator() instanceof J.Binary.Operator.LessThan) {
            keyword = "<";
        } else if (binary.getOperator() instanceof J.Binary.Operator.GreaterThan) {
            keyword = ">";
        } else if (binary.getOperator() instanceof J.Binary.Operator.LessThanOrEqual) {
            keyword = "<=";
        } else if (binary.getOperator() instanceof J.Binary.Operator.GreaterThanOrEqual) {
            keyword = ">=";
        } else if (binary.getOperator() instanceof J.Binary.Operator.Equal) {
            keyword = "==";
        } else if (binary.getOperator() instanceof J.Binary.Operator.NotEqual) {
            keyword = "!=";
        } else if (binary.getOperator() instanceof J.Binary.Operator.BitAnd) {
            keyword = "&";
        } else if (binary.getOperator() instanceof J.Binary.Operator.BitOr) {
            keyword = "|";
        } else if (binary.getOperator() instanceof J.Binary.Operator.BitXor) {
            keyword = "^";
        } else if (binary.getOperator() instanceof J.Binary.Operator.LeftShift) {
            keyword = "<<";
        } else if (binary.getOperator() instanceof J.Binary.Operator.RightShift) {
            keyword = ">>";
        } else if (binary.getOperator() instanceof J.Binary.Operator.UnsignedRightShift) {
            keyword = ">>>";
        } else if (binary.getOperator() instanceof J.Binary.Operator.Or) {
            keyword = "||";
        } else if (binary.getOperator() instanceof J.Binary.Operator.And) {
            keyword = "&&";
        }
        return this.fmt(binary, (String)this.visit(binary.getLeft()) + this.fmt(binary.getOperator(), keyword) + (String)this.visit(binary.getRight()));
    }

    @Override
    public String visitBlock(J.Block<J> block) {
        return this.fmt(block, (block.getAfterStatic() == null ? "" : "static") + (String)this.visit(block.getAfterStatic()) + "{" + this.visitStatements(block.getStatements()) + block.getEnd().getPrefix() + "}");
    }

    @Override
    public String visitBreak(J.Break breakStatement) {
        return this.fmt(breakStatement, "break" + (String)this.visit(breakStatement.getLabel()));
    }

    @Override
    public String visitCase(J.Case caze) {
        return this.fmt(caze, (String)this.visit(caze.getPattern()) + ":" + this.visitStatements(caze.getStatements()));
    }

    @Override
    public String visitCatch(J.Try.Catch catzh) {
        return this.fmt(catzh, "catch" + (String)this.visit(catzh.getParam()) + (String)this.visit(catzh.getBody()));
    }

    @Override
    public String visitClassDecl(J.ClassDecl classDecl) {
        String modifiers = this.visitModifiers(classDecl.getModifiers());
        String kind = "";
        if (classDecl.getKind() instanceof J.ClassDecl.Kind.Class) {
            kind = "class";
        } else if (classDecl.getKind() instanceof J.ClassDecl.Kind.Enum) {
            kind = "enum";
        } else if (classDecl.getKind() instanceof J.ClassDecl.Kind.Interface) {
            kind = "interface";
        } else if (classDecl.getKind() instanceof J.ClassDecl.Kind.Annotation) {
            kind = "@interface";
        }
        return this.fmt(classDecl, (String)this.visit(classDecl.getAnnotations()) + modifiers + this.fmt(classDecl.getKind(), kind) + (String)this.visit(classDecl.getName()) + (String)this.visit(classDecl.getTypeParameters()) + (classDecl.getExtends() == null ? "" : this.fmt(classDecl.getExtends(), "extends" + (String)this.visit(classDecl.getExtends().getFrom()))) + (classDecl.getImplements() == null ? "" : this.fmt(classDecl.getImplements(), (classDecl.getKind() instanceof J.ClassDecl.Kind.Interface ? "extends" : "implements") + this.visit(classDecl.getImplements().getFrom(), ","))) + (String)this.visit(classDecl.getBody()));
    }

    @Override
    public String visitCompilationUnit(J.CompilationUnit cu) {
        return this.fmt(cu, (cu.getPackageDecl() == null ? "" : (String)this.visit(cu.getPackageDecl()) + ";") + this.visit(cu.getImports(), ";", ";") + (String)this.visit(cu.getClasses())) + (String)this.visit(cu.getEof());
    }

    @Override
    public String visitContinue(J.Continue continueStatement) {
        return this.fmt(continueStatement, "continue" + (String)this.visit(continueStatement.getLabel()));
    }

    @Override
    public String visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
        return this.fmt(doWhileLoop, "do" + this.fmtStatement(doWhileLoop.getBody()) + this.fmt(doWhileLoop.getWhileCondition(), "while") + (String)this.visit(doWhileLoop.getWhileCondition().getCondition()));
    }

    @Override
    public String visitEmpty(J.Empty empty) {
        return this.fmt(empty, "");
    }

    @Override
    public String visitEnumValue(J.EnumValue enoom) {
        String init = "";
        J.NewClass initializer = enoom.getInitializer();
        if (initializer != null) {
            if (initializer.getArgs() != null) {
                init = this.fmt(initializer.getArgs(), "(" + this.visit(initializer.getArgs().getArgs(), ",") + ")");
            }
            init = this.fmt(initializer, init + (String)this.visit(initializer.getBody()));
        }
        return this.fmt(enoom, (String)this.visit(enoom.getName()) + init);
    }

    @Override
    public String visitEnumValueSet(J.EnumValueSet enums) {
        return this.fmt(enums, this.visit(enums.getEnums(), ",") + (enums.isTerminatedWithSemicolon() ? ";" : ""));
    }

    @Override
    public String visitFieldAccess(J.FieldAccess fieldAccess) {
        return this.fmt(fieldAccess, (String)this.visit(fieldAccess.getTarget()) + "." + (String)this.visit(fieldAccess.getName()));
    }

    @Override
    public String visitFinally(J.Try.Finally finallie) {
        return this.fmt(finallie, "finally" + (String)this.visit(finallie.getBody()));
    }

    @Override
    public String visitForLoop(J.ForLoop forLoop) {
        J.ForLoop.Control ctrl = forLoop.getControl();
        String expr = this.fmt(ctrl, "(" + (String)this.visit(ctrl.getInit()) + ";" + (String)this.visit(ctrl.getCondition()) + ";" + this.visit(ctrl.getUpdate(), ",", "") + ")");
        return this.fmt(forLoop, "for" + expr + this.fmtStatement(forLoop.getBody()));
    }

    @Override
    public String visitForEachLoop(J.ForEachLoop forEachLoop) {
        J.ForEachLoop.Control ctrl = forEachLoop.getControl();
        String expr = this.fmt(ctrl, "(" + (String)this.visit(ctrl.getVariable()) + ":" + (String)this.visit(ctrl.getIterable()) + ")");
        return this.fmt(forEachLoop, "for" + expr + this.fmtStatement(forEachLoop.getBody()));
    }

    @Override
    public String visitIdentifier(J.Ident ident) {
        return this.fmt(ident, ident.getSimpleName());
    }

    @Override
    public String visitIf(J.If iff) {
        String elsePart = iff.getElsePart() == null ? "" : this.fmt(iff.getElsePart(), "else" + this.fmtStatement(iff.getElsePart().getStatement()));
        return this.fmt(iff, "if" + (String)this.visit(iff.getIfCondition()) + this.fmtStatement(iff.getThenPart()) + elsePart);
    }

    @Override
    public String visitImport(J.Import impoort) {
        return this.fmt(impoort, "import" + (impoort.isStatic() ? " static" : "") + (String)this.visit(impoort.getQualid()));
    }

    @Override
    public String visitInstanceOf(J.InstanceOf instanceOf) {
        return this.fmt(instanceOf, (String)this.visit(instanceOf.getExpr()) + "instanceof" + (String)this.visit(instanceOf.getClazz()));
    }

    @Override
    public String visitLabel(J.Label label) {
        return this.fmt(label, (String)this.visit(label.getLabel()) + (String)this.visit(label.getBeforeColon()) + ":" + (String)this.visit(label.getStatement()));
    }

    @Override
    public String visitLambda(J.Lambda lambda) {
        String params = this.visit(lambda.getParamSet().getParams(), ",");
        String paramSet = this.fmt(lambda.getParamSet(), lambda.getParamSet().isParenthesized() ? "(" + params + ")" : params);
        return this.fmt(lambda, paramSet + this.fmt(lambda.getArrow(), "->") + (String)this.visit(lambda.getBody()));
    }

    @Override
    public String visitLiteral(J.Literal literal) {
        return this.fmt(literal, literal.getValueSource());
    }

    @Override
    public String visitMemberReference(J.MemberReference memberRef) {
        return this.fmt(memberRef, (String)this.visit(memberRef.getContaining()) + "::" + (String)this.visit(memberRef.getTypeParameters()) + (String)this.visit(memberRef.getReference()));
    }

    @Override
    public String visitMethod(J.MethodDecl method) {
        String modifiers = this.visitModifiers(method.getModifiers());
        String params = this.fmt(method.getParams(), "(" + this.visit(method.getParams().getParams(), ",")) + ")";
        String defaultValue = method.getDefaultValue() == null ? "" : this.fmt(method.getDefaultValue(), "default" + (String)this.visit(method.getDefaultValue().getValue()));
        String thrown = method.getThrows() == null ? "" : this.fmt(method.getThrows(), "throws" + this.visit(method.getThrows().getExceptions(), ","));
        return this.fmt(method, (String)this.visit(method.getAnnotations()) + modifiers + (String)this.visit(method.getTypeParameters()) + (String)this.visit(method.getReturnTypeExpr()) + (String)this.visit(method.getName()) + params + thrown + (String)this.visit(method.getBody()) + defaultValue);
    }

    @Override
    public String visitMethodInvocation(J.MethodInvocation method) {
        String args = this.fmt(method.getArgs(), "(" + this.visit(method.getArgs().getArgs(), ",") + ")");
        String typeParams = method.getTypeParameters() == null ? "" : this.fmt(method.getTypeParameters(), "<" + this.visit(method.getTypeParameters().getParams(), ",") + ">");
        String selectSeparator = method.getSelect() == null ? "" : ".";
        return this.fmt(method, (String)this.visit(method.getSelect()) + selectSeparator + typeParams + (String)this.visit(method.getName()) + args);
    }

    @Override
    public String visitMultiCatch(J.MultiCatch multiCatch) {
        return this.fmt(multiCatch, this.visit(multiCatch.getAlternatives(), "|"));
    }

    @Override
    public String visitMultiVariable(J.VariableDecls multiVariable) {
        String modifiers = this.visitModifiers(multiVariable.getModifiers());
        String varargs = multiVariable.getVarargs() == null ? "" : this.fmt(multiVariable.getVarargs(), "...");
        return this.fmt(multiVariable, (String)this.visit(multiVariable.getAnnotations()) + modifiers + (String)this.visit(multiVariable.getTypeExpr()) + this.visitDims(multiVariable.getDimensionsBeforeName()) + varargs + this.visit(multiVariable.getVars(), ","));
    }

    @Override
    public String visitNewArray(J.NewArray newArray) {
        String typeExpr = newArray.getTypeExpr() == null ? "" : "new" + (String)this.visit(newArray.getTypeExpr());
        String dimensions = newArray.getDimensions().stream().map(d -> this.fmt((Tree)d, "[" + (String)this.visit(d.getSize()) + "]")).reduce("", this::reduce);
        String init = newArray.getInitializer() == null ? "" : this.fmt(newArray.getInitializer(), "{" + this.visit(newArray.getInitializer().getElements(), ",") + "}");
        return this.fmt(newArray, typeExpr + dimensions + init);
    }

    @Override
    public String visitNewClass(J.NewClass newClass) {
        String encl = newClass.getEncl() == null ? "" : (String)this.visit(newClass.getEncl()) + ".";
        String nooh = newClass.getNooh() == null ? "" : this.fmt(newClass.getNooh(), "");
        String args = newClass.getArgs() == null ? "" : this.fmt(newClass.getArgs(), "(" + this.visit(newClass.getArgs().getArgs(), ",") + ")");
        return this.fmt(newClass, encl + nooh + "new" + (String)this.visit(newClass.getClazz()) + args + (String)this.visit(newClass.getBody()));
    }

    @Override
    public String visitPackage(J.Package pkg) {
        return this.fmt(pkg, "package" + (String)this.visit(pkg.getExpr()) + (String)this.visit(pkg.getBeforeSemicolon()));
    }

    @Override
    public String visitParameterizedType(J.ParameterizedType type) {
        return this.fmt(type, (String)this.visit(type.getClazz()) + (String)this.visit(type.getTypeParameters()));
    }

    @Override
    public String visitPrimitive(J.Primitive primitive) {
        String keyword;
        switch (primitive.getType()) {
            case Boolean: {
                keyword = "boolean";
                break;
            }
            case Byte: {
                keyword = "byte";
                break;
            }
            case Char: {
                keyword = "char";
                break;
            }
            case Double: {
                keyword = "double";
                break;
            }
            case Float: {
                keyword = "float";
                break;
            }
            case Int: {
                keyword = "int";
                break;
            }
            case Long: {
                keyword = "long";
                break;
            }
            case Short: {
                keyword = "short";
                break;
            }
            case Void: {
                keyword = "void";
                break;
            }
            case String: {
                keyword = "String";
                break;
            }
            case Wildcard: {
                keyword = "*";
                break;
            }
            case None: {
                throw new IllegalStateException("Unable to print None primitive");
            }
            case Null: {
                throw new IllegalStateException("Unable to print Null primitive");
            }
            default: {
                throw new IllegalStateException("Unable to print non-primitive type");
            }
        }
        return this.fmt(primitive, keyword);
    }

    @Override
    public <T extends J> String visitParentheses(J.Parentheses<T> parens) {
        return this.fmt(parens, "(" + (String)this.visit((Tree)parens.getTree()) + ")");
    }

    @Override
    public String visitReturn(J.Return retrn) {
        return this.fmt(retrn, "return" + (String)this.visit(retrn.getExpr()));
    }

    @Override
    public String visitSwitch(J.Switch switzh) {
        return this.fmt(switzh, "switch" + (String)this.visit(switzh.getSelector()) + (String)this.visit(switzh.getCases()));
    }

    @Override
    public String visitSynchronized(J.Synchronized synch) {
        return this.fmt(synch, "synchronized" + (String)this.visit(synch.getLock()) + (String)this.visit(synch.getBody()));
    }

    @Override
    public String visitTernary(J.Ternary ternary) {
        return this.fmt(ternary, (String)this.visit(ternary.getCondition()) + "?" + (String)this.visit(ternary.getTruePart()) + ":" + (String)this.visit(ternary.getFalsePart()));
    }

    @Override
    public String visitThrow(J.Throw thrown) {
        return this.fmt(thrown, "throw" + (String)this.visit(thrown.getException()));
    }

    @Override
    public String visitTry(J.Try tryable) {
        String resources = tryable.getResources() == null ? "" : this.fmt(tryable.getResources(), "(" + this.visit(tryable.getResources().getDecls(), ";") + ")");
        return this.fmt(tryable, "try" + resources + (String)this.visit(tryable.getBody()) + (String)this.visit(tryable.getCatches()) + (String)this.visit(tryable.getFinally()));
    }

    @Override
    public String visitTypeCast(J.TypeCast typeCast) {
        return this.fmt(typeCast, (String)this.visit(typeCast.getClazz()) + (String)this.visit(typeCast.getExpr()));
    }

    @Override
    public String visitTypeParameters(J.TypeParameters typeParams) {
        return this.fmt(typeParams, "<" + this.visit(typeParams.getParams(), ",", "") + ">");
    }

    @Override
    public String visitTypeParameter(J.TypeParameter typeParam) {
        String bounds = typeParam.getBounds() == null ? "" : this.fmt(typeParam.getBounds(), "extends" + this.visit(typeParam.getBounds().getTypes(), "&"));
        return this.fmt(typeParam, this.visit(typeParam.getAnnotations(), "") + (String)this.visit(typeParam.getName()) + bounds);
    }

    @Override
    public String visitUnary(J.Unary unary) {
        String code = "";
        if (unary.getOperator() instanceof J.Unary.Operator.PreIncrement) {
            code = "++" + (String)this.visit(unary.getExpr());
        } else if (unary.getOperator() instanceof J.Unary.Operator.PreDecrement) {
            code = "--" + (String)this.visit(unary.getExpr());
        } else if (unary.getOperator() instanceof J.Unary.Operator.PostIncrement) {
            code = (String)this.visit(unary.getExpr()) + this.fmt(unary.getOperator(), "++");
        } else if (unary.getOperator() instanceof J.Unary.Operator.PostDecrement) {
            code = (String)this.visit(unary.getExpr()) + this.fmt(unary.getOperator(), "--");
        } else if (unary.getOperator() instanceof J.Unary.Operator.Positive) {
            code = "+" + (String)this.visit(unary.getExpr());
        } else if (unary.getOperator() instanceof J.Unary.Operator.Negative) {
            code = "-" + (String)this.visit(unary.getExpr());
        } else if (unary.getOperator() instanceof J.Unary.Operator.Complement) {
            code = "~" + (String)this.visit(unary.getExpr());
        } else if (unary.getOperator() instanceof J.Unary.Operator.Not) {
            code = "!" + (String)this.visit(unary.getExpr());
        }
        return this.fmt(unary, code);
    }

    @Override
    public String visitUnparsedSource(J.UnparsedSource unparsed) {
        return this.fmt(unparsed, unparsed.getSource());
    }

    @Override
    public String visitVariable(J.VariableDecls.NamedVar variable) {
        return this.fmt(variable, (String)this.visit(variable.getName()) + (String)this.visit(variable.getAfterName()) + this.visitDims(variable.getDimensionsAfterName()) + (variable.getInitializer() == null ? "" : "=" + (String)this.visit(variable.getInitializer())) + (String)this.visit(variable.getBeforeComma()));
    }

    @Override
    public String visitWhileLoop(J.WhileLoop whileLoop) {
        return this.fmt(whileLoop, "while" + (String)this.visit(whileLoop.getCondition()) + this.fmtStatement(whileLoop.getBody()));
    }

    @Override
    public String visitWildcard(J.Wildcard wildcard) {
        String bound = "";
        if (wildcard.getBound() instanceof J.Wildcard.Bound.Extends) {
            bound = this.fmt(wildcard.getBound(), "extends");
        } else if (wildcard.getBound() instanceof J.Wildcard.Bound.Super) {
            bound = this.fmt(wildcard.getBound(), "super");
        }
        return this.fmt(wildcard, "?" + bound + (String)this.visit(wildcard.getBoundedType()));
    }
}

