/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AspectjUtils;
import org.openrewrite.java.FormalParameterVisitor;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.AspectJLexer;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParser;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MethodMatcher {
    private Pattern targetTypePattern;
    private Pattern methodNamePattern;
    private Pattern argumentPattern;

    public MethodMatcher(String signature) {
        RefactorMethodSignatureParser parser = new RefactorMethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new AspectJLexer((CharStream)CharStreams.fromString((String)signature))));
        new RefactorMethodSignatureParserBaseVisitor<Void>(){

            @Override
            public Void visitMethodPattern(RefactorMethodSignatureParser.MethodPatternContext ctx) {
                MethodMatcher.this.targetTypePattern = Pattern.compile((String)new TypeVisitor().visitTargetTypePattern(ctx.targetTypePattern()));
                MethodMatcher.this.methodNamePattern = Pattern.compile(ctx.simpleNamePattern().children.stream().map(c -> AspectjUtils.aspectjNameToPattern(c.toString())).collect(Collectors.joining("")));
                MethodMatcher.this.argumentPattern = Pattern.compile(new FormalParameterVisitor().visitFormalParametersPattern(ctx.formalParametersPattern()));
                return null;
            }
        }.visit((ParseTree)parser.methodPattern());
    }

    public boolean matches(J.MethodDecl method, J.ClassDecl enclosing) {
        if (enclosing.getType() == null) {
            return false;
        }
        String signaturePattern = method.getParams().getParams().stream().map(v -> {
            if (v instanceof J.VariableDecls) {
                J.VariableDecls vd = (J.VariableDecls)v;
                if (vd.getTypeAsClass() != null) {
                    return vd.getTypeAsClass();
                }
                return vd.getTypeExpr() != null ? vd.getTypeExpr().getType() : null;
            }
            return null;
        }).filter(Objects::nonNull).map(this::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","));
        return this.matchesTargetType(TypeUtils.asClass(enclosing.getType())) && this.methodNamePattern.matcher(method.getSimpleName()).matches() && this.argumentPattern.matcher(signaturePattern).matches();
    }

    public boolean matches(J.MethodInvocation method) {
        if (method.getType() == null || method.getType().getDeclaringType() == null) {
            return false;
        }
        if (method.getType().getResolvedSignature() == null) {
            return false;
        }
        String resolvedSignaturePattern = method.getType().getResolvedSignature().getParamTypes().stream().map(this::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","));
        return this.matchesTargetType(method.getType().getDeclaringType()) && this.methodNamePattern.matcher(method.getSimpleName()).matches() && this.argumentPattern.matcher(resolvedSignaturePattern).matches();
    }

    public boolean matches(J.NewClass constructor) {
        if (constructor.getType() == null) {
            return false;
        }
        String signaturePattern = Optional.ofNullable(constructor.getArgs()).map(args -> args.getArgs().stream().map(Expression::getType).map(this::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).orElse("");
        JavaType.Class type = TypeUtils.asClass(constructor.getType());
        assert (type != null);
        return this.matchesTargetType(type) && this.methodNamePattern.matcher(type.getClassName()).matches() && this.argumentPattern.matcher(signaturePattern).matches();
    }

    boolean matchesTargetType(@Nullable JavaType.FullyQualified type) {
        JavaType.Class asClass = TypeUtils.asClass(type);
        return type != null && (this.targetTypePattern.matcher(type.getFullyQualifiedName()).matches() || type != JavaType.Class.OBJECT && (asClass == null || this.matchesTargetType(asClass.getSupertype() == null ? JavaType.Class.OBJECT : asClass.getSupertype())));
    }

    @Nullable
    private String typePattern(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.Class) {
            return ((JavaType.Class)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array) {
            return this.typePattern(((JavaType.Array)type).getElemType()) + "[]";
        }
        return null;
    }

    public Pattern getTargetTypePattern() {
        return this.targetTypePattern;
    }

    public Pattern getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public Pattern getArgumentPattern() {
        return this.argumentPattern;
    }
}

