/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AbstractJavaSourceVisitor;
import org.openrewrite.java.FillTypeAttributions;
import org.openrewrite.java.JavaFormatter;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.ShiftFormatRightVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class TreeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TreeBuilder.class);
    private static final Pattern whitespacePrefixPattern = Pattern.compile("^\\s*");
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");
    private final J.CompilationUnit cu;

    public TreeBuilder(J.CompilationUnit cu) {
        this.cu = cu;
    }

    public static <T extends TypeTree & Expression> T buildName(String fullyQualifiedName) {
        return TreeBuilder.buildName(fullyQualifiedName, Formatting.EMPTY);
    }

    public static <T extends TypeTree & Expression> T buildName(String fullyQualifiedName, Formatting fmt) {
        return TreeBuilder.buildName(fullyQualifiedName, fmt, Tree.randomId());
    }

    public static <T extends TypeTree & Expression> T buildName(String fullyQualifiedName, Formatting fmt, UUID id) {
        String[] parts = fullyQualifiedName.split("\\.");
        String fullName = "";
        Expression expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = J.Ident.build(Tree.randomId(), part, null, Formatting.EMPTY);
                continue;
            }
            fullName = fullName + "." + part;
            Matcher whitespacePrefix = whitespacePrefixPattern.matcher(part);
            Formatting identFmt = whitespacePrefix.matches() ? Formatting.format((String)whitespacePrefix.group(0)) : Formatting.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Formatting partFmt = i == parts.length - 1 ? Formatting.EMPTY : Formatting.format((String)"", (String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(i == parts.length - 1 ? id : Tree.randomId(), expr, J.Ident.build(Tree.randomId(), part.trim(), null, identFmt), Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.Class.build(fullName) : null, partFmt);
        }
        return (T)((TypeTree)expr.withFormatting(fmt));
    }

    public J buildDeclaration(J.ClassDecl insertionScope, String snippet, JavaType ... types) {
        JavaParser javaParser = this.cu.buildParser(new String[0]);
        String scopeVariables = insertionScope.getFields().stream().flatMap(field -> field.getVars().stream().map(v -> TreeBuilder.variableDefinitionSource(field, v))).collect(Collectors.joining(";\n  ", "  // variables visible in the insertion scope\n  ", ";\n")) + "\n";
        if (insertionScope.getFields().isEmpty()) {
            scopeVariables = "";
        }
        JavaType.Class[] imports = (JavaType.Class[])Arrays.stream(types).filter(it -> it instanceof JavaType.Class).map(it -> (JavaType.Class)it).toArray(JavaType.Class[]::new);
        String source = Arrays.stream(imports).map(i -> "import " + i.getFullyQualifiedName() + ";").collect(Collectors.joining("\n", "", "\n\n")) + "class CodeSnippet {\n" + scopeVariables + StringUtils.trimIndent((String)snippet) + "\n}";
        if (logger.isDebugEnabled()) {
            logger.debug("Building code snippet using synthetic class:");
            logger.debug(source);
        }
        J.CompilationUnit cu = javaParser.parse(source).get(0);
        List<J> statements = cu.getClasses().get(0).getBody().getStatements();
        return (J)new FillTypeAttributions(imports).visit(statements.get(statements.size() - 1));
    }

    public J.ClassDecl buildInnerClassDeclaration(J.ClassDecl insertionScope, String classDeclarationSnippet, JavaType ... types) {
        J.ClassDecl cd = (J.ClassDecl)this.buildDeclaration(insertionScope, classDeclarationSnippet, types);
        JavaType.Class clazz = cd.getType();
        if (insertionScope.getType() != null && clazz != null) {
            JavaType.Class newClazz = JavaType.Class.build(insertionScope.getType().getFullyQualifiedName() + "." + cd.getSimpleName());
            return cd.withType(newClazz);
        }
        return cd;
    }

    public J.VariableDecls buildFieldDeclaration(J.ClassDecl insertionScope, String fieldDeclarationSnippet, JavaType ... types) {
        return (J.VariableDecls)this.buildDeclaration(insertionScope, fieldDeclarationSnippet, types);
    }

    public J.MethodDecl buildMethodDeclaration(J.ClassDecl insertionScope, String methodDeclarationSnippet, JavaType ... types) {
        return (J.MethodDecl)this.buildDeclaration(insertionScope, methodDeclarationSnippet, types);
    }

    public <T extends J> List<T> buildSnippet(Cursor insertionScope, String snippet, JavaType.Class ... imports) {
        JavaParser javaParser = this.cu.buildParser(new String[0]);
        String source = Arrays.stream(imports).map(i -> "import " + i.getFullyQualifiedName() + ";").collect(Collectors.joining("\n", "", "\n\n")) + "class CodeSnippet {\n" + ((List)new ListScopeVariables(insertionScope).visit(this.cu)).stream().collect(Collectors.joining(";\n  ", "  // variables visible in the insertion scope\n  ", ";\n")) + "\n  // the contents of this block are the snippet\n  {\n" + StringUtils.trimIndent((String)snippet) + "\n  }\n}";
        if (logger.isDebugEnabled()) {
            logger.debug("Building code snippet using synthetic class:");
            logger.debug(source);
        }
        J.CompilationUnit cu = javaParser.parse(source).get(0);
        List<J> statements = cu.getClasses().get(0).getBody().getStatements();
        J.Block block = (J.Block)statements.get(statements.size() - 1);
        JavaFormatter formatter = new JavaFormatter(cu);
        return block.getStatements().stream().map(stat -> {
            ShiftFormatRightVisitor shiftRight = new ShiftFormatRightVisitor((Tree)stat, JavaFormatter.enclosingIndent(insertionScope.getTree()) + formatter.findIndent(JavaFormatter.enclosingIndent(insertionScope.getTree()), new Tree[]{stat}).getEnclosingIndent(), formatter.isIndentedWithSpaces());
            return (J)shiftRight.visit((Tree)stat);
        }).collect(Collectors.toList());
    }

    private static String variableDefinitionSource(J.VariableDecls variableDecls, J.VariableDecls.NamedVar variable) {
        JavaType type = variableDecls.getTypeExpr() == null ? variable.getType() : variableDecls.getTypeExpr().getType();
        String typeName = "";
        if (type instanceof JavaType.Class) {
            typeName = ((JavaType.Class)type).getFullyQualifiedName();
        } else if (type instanceof JavaType.ShallowClass) {
            typeName = ((JavaType.ShallowClass)type).getFullyQualifiedName();
        } else if (type instanceof JavaType.GenericTypeVariable) {
            typeName = ((JavaType.GenericTypeVariable)type).getFullyQualifiedName();
        } else if (type instanceof JavaType.Primitive) {
            typeName = ((JavaType.Primitive)type).getKeyword();
        }
        return "static " + typeName + " " + variable.getSimpleName();
    }

    private static class ListScopeVariables
    extends AbstractJavaSourceVisitor<List<String>> {
        @Nullable
        private final Cursor scope;

        private ListScopeVariables(@Nullable Cursor scope) {
            this.scope = scope;
            this.setCursoringOn();
        }

        public List<String> defaultTo(@Nullable Tree t) {
            return Collections.emptyList();
        }

        @Override
        public List<String> visitCompilationUnit(J.CompilationUnit cu) {
            return this.scope == null ? Collections.emptyList() : (List)super.visitCompilationUnit(cu);
        }

        @Override
        public List<String> visitVariable(J.VariableDecls.NamedVar variable) {
            if (this.isInSameNameScope(this.scope)) {
                return Collections.singletonList(TreeBuilder.variableDefinitionSource((J.VariableDecls)this.getCursor().getParentOrThrow().getTree(), variable));
            }
            return (List)super.visitVariable(variable);
        }
    }
}

