/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.LinkedHashSet;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class ChangeMethodTargetToStatic
extends JavaRefactorVisitor {
    private MethodMatcher methodMatcher;
    private String targetType;

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"target.type", (Object)this.targetType));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method)) {
            this.andThen((RefactorVisitor)new Scoped(method, this.targetType));
        }
        return super.visitMethodInvocation(method);
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final J.MethodInvocation scope;
        private final String targetType;

        public Scoped(J.MethodInvocation scope, String clazz) {
            this.scope = scope;
            this.targetType = clazz;
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"to", (String)this.targetType);
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method) {
            if (this.scope.isScope(method)) {
                JavaType.Class classType = JavaType.Class.build(this.targetType);
                J.MethodInvocation m = method.withSelect(J.Ident.build(Tree.randomId(), classType.getClassName(), classType, method.getSelect() == null ? Formatting.EMPTY : method.getSelect().getFormatting()));
                this.maybeAddImport(this.targetType);
                JavaType.Method transformedType = null;
                if (method.getType() != null) {
                    this.maybeRemoveImport(method.getType().getDeclaringType());
                    transformedType = method.getType().withDeclaringType(classType);
                    if (!method.getType().hasFlags(Flag.Static)) {
                        LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                        flags.add(Flag.Static);
                        transformedType = transformedType.withFlags(flags);
                    }
                }
                return m.withType(transformedType);
            }
            return super.visitMethodInvocation(method);
        }
    }
}

