/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

public class GenerateSetter
extends JavaRefactorVisitor {

    public static class Scoped
    extends JavaRefactorVisitor {
        private final JavaType.Class clazz;
        private final String fieldName;

        public Scoped(JavaType.Class clazz, String fieldName) {
            this.fieldName = fieldName;
            this.clazz = clazz;
        }

        @Override
        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl cd = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
            JavaType.Class type = classDecl.getType();
            if (type == null || !this.clazz.getFullyQualifiedName().equals(type.getFullyQualifiedName())) {
                return cd;
            }
            J.VariableDecls field = cd.getFields().stream().filter(it -> it.getVars().get(0).getSimpleName().equals(this.fieldName)).findAny().orElse(null);
            if (field == null) {
                return cd;
            }
            assert (field.getTypeAsClass() != null);
            assert (field.getTypeExpr() != null);
            MethodMatcher setterMatcher = new MethodMatcher(type.getFullyQualifiedName() + " set" + StringUtils.capitalize((String)this.fieldName) + "(" + field.getTypeAsClass().getFullyQualifiedName() + ")");
            boolean setterAlreadyExists = cd.getMethods().stream().anyMatch(it -> setterMatcher.matches((J.MethodDecl)it, classDecl));
            if (setterAlreadyExists) {
                return cd;
            }
            J.VariableDecls.NamedVar fieldVar = field.getVars().get(0);
            JavaType fieldType = fieldVar.getType();
            J.Ident valueArgument = J.Ident.build(Tree.randomId(), "value", fieldType, Formatting.format((String)" "));
            Expression assignmentExp = fieldVar.getSimpleName().equals("value") ? new J.FieldAccess(Tree.randomId(), J.Ident.build(Tree.randomId(), "this", cd.getType(), Formatting.EMPTY), fieldVar.getName(), fieldType, Formatting.format((String)"", (String)" ")) : fieldVar.getName().withFormatting(Formatting.format((String)"", (String)" "));
            J.MethodDecl setMethod = new J.MethodDecl(Tree.randomId(), Collections.emptyList(), Collections.singletonList(new J.Modifier.Public(Tree.randomId(), Formatting.EMPTY)), null, (TypeTree)JavaType.Primitive.Void.toTypeTree().withFormatting(Formatting.format((String)" ")), J.Ident.build(Tree.randomId(), "set" + StringUtils.capitalize((String)this.fieldName), null, Formatting.format((String)" ")), new J.MethodDecl.Parameters(Tree.randomId(), Collections.singletonList(new J.VariableDecls(Tree.randomId(), Collections.emptyList(), Collections.emptyList(), field.getTypeExpr(), null, Collections.emptyList(), Collections.singletonList(new J.VariableDecls.NamedVar(Tree.randomId(), valueArgument, Collections.emptyList(), null, fieldType, Formatting.EMPTY)), Formatting.EMPTY)), Formatting.EMPTY), null, new J.Block<Statement>(Tree.randomId(), null, Collections.singletonList(new J.Assign(Tree.randomId(), assignmentExp, valueArgument, null, Formatting.format((String)"\n    "))), Formatting.format((String)" "), new J.Block.End(Tree.randomId(), Formatting.format((String)"\n"))), null, Formatting.format((String)"\n\n"));
            this.andThen((RefactorVisitor)new AutoFormat(setMethod));
            J.Block<J> body = cd.getBody();
            ArrayList<J> statements = new ArrayList<J>(body.getStatements());
            statements.add(setMethod);
            cd = cd.withBody(body.withStatements(statements));
            return cd;
        }
    }
}

