/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeType
extends JavaRefactorVisitor {
    private String type;
    private JavaType.Class targetType;

    public void setType(String type) {
        this.type = type;
    }

    public void setTargetType(String targetType) {
        this.targetType = JavaType.Class.build(targetType);
    }

    public void setTargetType(JavaType.Class targetType) {
        this.targetType = targetType;
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type).and(Validated.required((String)"target.type", (Object)this.targetType.getFullyQualifiedName()));
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String[])new String[]{"type", this.type, "target.type", this.targetType.getFullyQualifiedName()});
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        this.maybeAddImport(this.targetType);
        this.maybeRemoveImport(this.type);
        return super.visitCompilationUnit(cu);
    }

    @Override
    public J visitTypeName(NameTree name) {
        JavaType.Class oldTypeAsClass = TypeUtils.asClass(name.getType());
        NameTree n = (NameTree)this.refactor(name, x$0 -> super.visitTypeName((NameTree)x$0));
        if (!(name instanceof TypeTree) && oldTypeAsClass != null && oldTypeAsClass.getFullyQualifiedName().equals(this.type)) {
            n = (NameTree)n.withType(this.targetType);
        }
        return n;
    }

    @Override
    public J visitAnnotation(J.Annotation annotation) {
        J.Annotation a = (J.Annotation)this.refactor(annotation, x$0 -> super.visitAnnotation((J.Annotation)x$0));
        return a.withAnnotationType(this.transformName(a.getAnnotationType()));
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType) {
        J.ArrayType a = (J.ArrayType)this.refactor(arrayType, x$0 -> super.visitArrayType((J.ArrayType)x$0));
        return a.withElementType(this.transformName(a.getElementType()));
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
        if (c.getExtends() != null) {
            c = c.withExtends(c.getExtends().withFrom(this.transformName(c.getExtends().getFrom())));
        }
        if (c.getImplements() != null) {
            c = c.withImplements(c.getImplements().withFrom(this.transformNames(c.getImplements().getFrom())));
        }
        return c;
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess) {
        J.FieldAccess f = (J.FieldAccess)this.refactor(fieldAccess, x$0 -> super.visitFieldAccess((J.FieldAccess)x$0));
        if (f.isFullyQualifiedClassReference(this.type)) {
            return TreeBuilder.buildName(this.targetType.getFullyQualifiedName(), f.getFormatting(), f.getId());
        }
        return f;
    }

    @Override
    public J visitIdentifier(J.Ident ident) {
        J.Ident i = (J.Ident)this.refactor(ident, x$0 -> super.visitIdentifier((J.Ident)x$0));
        JavaType.Class originalType = JavaType.Class.build(this.type);
        if (TypeUtils.isOfClassType(i.getType(), this.type) && i.getSimpleName().equals(originalType.getClassName())) {
            i = i.withName(this.targetType.getClassName());
            i = i.withType(this.targetType);
        }
        return i;
    }

    @Override
    public J visitMethod(J.MethodDecl method) {
        J.MethodDecl m = (J.MethodDecl)this.refactor(method, x$0 -> super.visitMethod((J.MethodDecl)x$0));
        return m.withThrows((m = m.withReturnTypeExpr(this.transformName(m.getReturnTypeExpr()))).getThrows() == null ? null : m.getThrows().withExceptions(this.transformNames(m.getThrows().getExceptions())));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        JavaType.Class selectType;
        J.MethodInvocation m = (J.MethodInvocation)this.refactor(method, x$0 -> super.visitMethodInvocation((J.MethodInvocation)x$0));
        if (method.getSelect() instanceof NameTree && m.getType() != null && m.getType().hasFlags(Flag.Static)) {
            m = m.withSelect(this.transformName(m.getSelect()));
        }
        if (m.getSelect() != null && (selectType = TypeUtils.asClass(m.getSelect().getType())) != null && selectType.getFullyQualifiedName().equals(this.type)) {
            m = m.withSelect((Expression)m.getSelect().withType(this.targetType));
        }
        return m;
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch) {
        J.MultiCatch m = (J.MultiCatch)this.refactor(multiCatch, x$0 -> super.visitMultiCatch((J.MultiCatch)x$0));
        return m.withAlternatives(this.transformNames(m.getAlternatives()));
    }

    @Override
    public J visitMultiVariable(J.VariableDecls multiVariable) {
        if (multiVariable.getTypeExpr() instanceof J.MultiCatch) {
            return super.visitMultiVariable(multiVariable);
        }
        J.VariableDecls m = (J.VariableDecls)this.refactor(multiVariable, x$0 -> super.visitMultiVariable((J.VariableDecls)x$0));
        return m.withTypeExpr(this.transformName(m.getTypeExpr()));
    }

    @Override
    public J visitVariable(J.VariableDecls.NamedVar variable) {
        J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.refactor(variable, x$0 -> super.visitVariable((J.VariableDecls.NamedVar)x$0));
        JavaType.Class varType = TypeUtils.asClass(variable.getType());
        if (varType != null && varType.getFullyQualifiedName().equals(this.type)) {
            v = v.withType(this.targetType).withName(v.getName().withType(this.targetType));
        }
        return v;
    }

    @Override
    public J visitNewArray(J.NewArray newArray) {
        J.NewArray n = (J.NewArray)this.refactor(newArray, x$0 -> super.visitNewArray((J.NewArray)x$0));
        return n.withTypeExpr(this.transformName(n.getTypeExpr()));
    }

    @Override
    public J visitNewClass(J.NewClass newClass) {
        J.NewClass n = (J.NewClass)this.refactor(newClass, x$0 -> super.visitNewClass((J.NewClass)x$0));
        return n.withClazz(this.transformName(n.getClazz()));
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast) {
        J.TypeCast t = (J.TypeCast)this.refactor(typeCast, x$0 -> super.visitTypeCast((J.TypeCast)x$0));
        return t.withClazz(t.getClazz().withTree(this.transformName(t.getClazz().getTree())));
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam) {
        J.TypeParameter t;
        t = t.withBounds((t = (J.TypeParameter)this.refactor(typeParam, x$0 -> super.visitTypeParameter((J.TypeParameter)x$0))).getBounds() == null ? null : t.getBounds().withTypes(this.transformNames(t.getBounds().getTypes())));
        return t.withName(this.transformName(t.getName()));
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard) {
        J.Wildcard w = (J.Wildcard)this.refactor(wildcard, x$0 -> super.visitWildcard((J.Wildcard)x$0));
        return w.withBoundedType(this.transformName(w.getBoundedType()));
    }

    private <T extends Tree> T transformName(@Nullable T nameField) {
        JavaType.Class nameTreeClass;
        if (nameField instanceof NameTree && (nameTreeClass = TypeUtils.asClass(((NameTree)nameField).getType())) != null && nameTreeClass.getFullyQualifiedName().equals(this.type)) {
            return (T)J.Ident.build(Tree.randomId(), this.targetType.getClassName(), this.targetType, nameField.getFormatting());
        }
        return nameField;
    }

    private <T extends Tree> List<T> transformNames(@Nullable List<T> trees) {
        if (trees == null) {
            return null;
        }
        boolean atLeastOneChanged = false;
        ArrayList<Tree> transformed = new ArrayList<Tree>();
        for (Tree tree : trees) {
            JavaType.Class nodeTypeAsClass;
            if (tree instanceof NameTree && (nodeTypeAsClass = TypeUtils.asClass(((NameTree)tree).getType())) != null && nodeTypeAsClass.getFullyQualifiedName().equals(this.type)) {
                atLeastOneChanged = true;
                transformed.add(J.Ident.build(Tree.randomId(), this.targetType.getClassName(), this.targetType, tree.getFormatting()));
                continue;
            }
            transformed.add(tree);
        }
        return atLeastOneChanged ? transformed : trees;
    }
}

