/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class InsertMethodArgument
extends JavaRefactorVisitor {
    private final J.MethodInvocation scope;
    private final int pos;
    private final String source;

    public InsertMethodArgument(J.MethodInvocation scope, int pos, String source) {
        super("java.InsertMethodArgument", new String[0]);
        this.scope = scope;
        this.pos = pos;
        this.source = source;
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.scope.isScope(method)) {
            List modifiedArgs = method.getArgs().getArgs().stream().filter(a -> !(a instanceof J.Empty)).collect(Collectors.toCollection(ArrayList::new));
            modifiedArgs.add(this.pos, new J.UnparsedSource(Tree.randomId(), this.source, this.pos == 0 ? modifiedArgs.stream().findFirst().map(Tree::getFormatting).orElse(Formatting.EMPTY) : Formatting.format((String)" ")));
            if (this.pos == 0 && modifiedArgs.size() > 1) {
                modifiedArgs.set(1, (Expression)((Expression)modifiedArgs.get(1)).withFormatting(Formatting.format((String)" ")));
            }
            return method.withArgs(method.getArgs().withArgs(modifiedArgs));
        }
        return super.visitMethodInvocation(method);
    }
}

