/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class DeleteMethodArgument
extends JavaRefactorVisitor {
    private final J.MethodInvocation scope;
    private final int pos;

    public DeleteMethodArgument(J.MethodInvocation scope, int pos) {
        super("java.DeleteMethodArgument", new String[0]);
        this.scope = scope;
        this.pos = pos;
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        List<Expression> originalArgs = method.getArgs().getArgs();
        if (this.scope.isScope(method) && originalArgs.stream().filter(a -> !(a instanceof J.Empty)).count() >= (long)(this.pos + 1)) {
            List<Expression> args = new ArrayList<Expression>(method.getArgs().getArgs());
            args.remove(this.pos);
            if (args.isEmpty()) {
                args = Collections.singletonList(new J.Empty(Tree.randomId(), Formatting.EMPTY));
            }
            return method.withArgs(method.getArgs().withArgs(args));
        }
        return super.visitMethodInvocation(method);
    }
}

