/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.stream.Collectors;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeFieldType
extends JavaRefactorVisitor {
    private final J.VariableDecls scope;
    private final String targetType;

    public ChangeFieldType(J.VariableDecls scope, String targetType) {
        super("java.ChangeFieldType", "to", targetType);
        this.scope = scope;
        this.targetType = targetType;
    }

    @Override
    public J visitMultiVariable(J.VariableDecls multiVariable) {
        JavaType.Class originalType = multiVariable.getTypeAsClass();
        J.VariableDecls mv = (J.VariableDecls)this.refactor(multiVariable, x$0 -> super.visitMultiVariable((J.VariableDecls)x$0));
        if (this.scope.isScope(multiVariable) && originalType != null && !originalType.getFullyQualifiedName().equals(this.targetType)) {
            JavaType.Class type = JavaType.Class.build(this.targetType);
            this.maybeAddImport(this.targetType);
            this.maybeRemoveImport(originalType);
            mv = mv.withTypeExpr(mv.getTypeExpr() == null ? null : J.Ident.build(mv.getTypeExpr().getId(), type.getClassName(), type, mv.getTypeExpr().getFormatting())).withVars(mv.getVars().stream().map(var -> {
                JavaType.Class varType = TypeUtils.asClass(var.getType());
                if (varType != null && !varType.equals(type)) {
                    return var.withType(type).withName(var.getName().withType(type));
                }
                return var;
            }).collect(Collectors.toList()));
        }
        return mv;
    }
}

