/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import org.openrewrite.Cursor;
import org.openrewrite.java.JavaRetrieveCursorVisitor;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.J;

public class RenameVariable
extends ScopedJavaRefactorVisitor {
    private final String toName;
    private Cursor scopeCursor;
    private String scopeVariableName;

    public RenameVariable(J.VariableDecls.NamedVar scope, String toName) {
        super(scope.getId());
        this.toName = toName;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        this.scopeCursor = (Cursor)new JavaRetrieveCursorVisitor(this.getScope()).visit(cu);
        this.scopeVariableName = ((J.VariableDecls.NamedVar)this.scopeCursor.getTree()).getSimpleName();
        return super.visitCompilationUnit(cu);
    }

    @Override
    public J visitIdentifier(J.Ident ident) {
        if (ident.getSimpleName().equals(this.scopeVariableName) && this.isInSameNameScope(this.scopeCursor, this.getCursor()) && !(this.getCursor().getParentOrThrow().getTree() instanceof J.FieldAccess)) {
            return ident.withName(this.toName);
        }
        return super.visitIdentifier(ident);
    }
}

