/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

class RemoveUnusedImports
extends JavaRefactorVisitor {
    private final int classCountToUseStarImport;
    private final int nameCountToUseStarImport;

    RemoveUnusedImports(int classCountToUseStarImport, int nameCountToUseStarImport) {
        this.classCountToUseStarImport = classCountToUseStarImport;
        this.nameCountToUseStarImport = nameCountToUseStarImport;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        Map typesByPackage = (Map)new TypesByPackage().visit(cu);
        Map methodsByTypeName = (Map)new MethodsByType().visit(cu);
        boolean changed = false;
        ArrayList<J.Import> importsWithoutUnused = new ArrayList<J.Import>();
        for (J.Import anImport : cu.getImports()) {
            if (anImport.isStatic()) {
                Set methods = (Set)methodsByTypeName.get(anImport.getTypeName());
                if (methods == null) {
                    changed = true;
                    continue;
                }
                if ("*".equals(anImport.getQualid().getSimpleName())) {
                    if (methods.size() < this.nameCountToUseStarImport) {
                        methods.stream().sorted().forEach(method -> importsWithoutUnused.add(anImport.withQualid(anImport.getQualid().withName(anImport.getQualid().getName().withName((String)method)))));
                        changed = true;
                        continue;
                    }
                    importsWithoutUnused.add(anImport);
                    continue;
                }
                importsWithoutUnused.add(anImport);
                continue;
            }
            Set types = (Set)typesByPackage.get(anImport.getPackageName());
            if (types == null) {
                changed = true;
                continue;
            }
            if ("*".equals(anImport.getQualid().getSimpleName())) {
                if (types.size() < this.classCountToUseStarImport) {
                    types.stream().map(JavaType.FullyQualified::getClassName).sorted().forEach(typeClassName -> importsWithoutUnused.add(anImport.withQualid(anImport.getQualid().withName(anImport.getQualid().getName().withName((String)typeClassName)))));
                    changed = true;
                    continue;
                }
                importsWithoutUnused.add(anImport);
                continue;
            }
            importsWithoutUnused.add(anImport);
        }
        return changed ? cu.withImports(importsWithoutUnused) : cu;
    }

    static class MethodsByType
    extends JavaSourceVisitor<Map<String, Set<String>>> {
        MethodsByType() {
        }

        public Map<String, Set<String>> reduce(Map<String, Set<String>> r1, Map<String, Set<String>> r2) {
            if (r1.isEmpty()) {
                return r2;
            }
            for (Map.Entry<String, Set<String>> r2Entry : r2.entrySet()) {
                r1.compute(r2Entry.getKey(), (pkg, types) -> Stream.concat(types == null ? Stream.empty() : types.stream(), ((Set)r2Entry.getValue()).stream()).collect(Collectors.toSet()));
            }
            return r1;
        }

        public Map<String, Set<String>> defaultTo(Tree t) {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Set<String>> visitMethodInvocation(J.MethodInvocation method) {
            JavaType.Method type;
            if (method.getSelect() == null && (type = method.getType()) != null && type.hasFlags(Flag.Static)) {
                HashMap<String, Set<String>> typeByPackage = new HashMap<String, Set<String>>();
                typeByPackage.put(type.getDeclaringType().getFullyQualifiedName(), Collections.singleton(type.getName()));
                return typeByPackage;
            }
            return (Map)super.visitMethodInvocation(method);
        }
    }

    static class TypesByPackage
    extends JavaSourceVisitor<Map<String, Set<JavaType.Class>>> {
        TypesByPackage() {
            this.setCursoringOn();
        }

        public Map<String, Set<JavaType.Class>> reduce(Map<String, Set<JavaType.Class>> r1, Map<String, Set<JavaType.Class>> r2) {
            if (r1.isEmpty()) {
                return r2;
            }
            for (Map.Entry<String, Set<JavaType.Class>> r2Entry : r2.entrySet()) {
                r1.compute(r2Entry.getKey(), (pkg, types) -> Stream.concat(types == null ? Stream.empty() : types.stream(), ((Set)r2Entry.getValue()).stream()).collect(Collectors.toSet()));
            }
            return r1;
        }

        public Map<String, Set<JavaType.Class>> defaultTo(Tree t) {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Set<JavaType.Class>> visitTypeName(NameTree name) {
            JavaType.Class clazz;
            if (this.getCursor().firstEnclosing(J.Import.class) == null && (clazz = TypeUtils.asClass(name.getType())) != null) {
                HashMap<String, Set<JavaType.Class>> typeByPackage = new HashMap<String, Set<JavaType.Class>>();
                typeByPackage.put(clazz.getPackageName(), Collections.singleton(clazz));
                return typeByPackage;
            }
            return (Map)super.visitTypeName(name);
        }
    }
}

