/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class ChangeMethodName
extends JavaRefactorVisitor {
    private MethodMatcher methodMatcher;
    private String name;

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"name", (Object)this.name));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method)) {
            this.andThen(new Scoped(method, this.name));
        }
        return super.visitMethodInvocation(method);
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final J.MethodInvocation scope;
        private final String name;

        public Scoped(J.MethodInvocation scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"name", (String)this.name);
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method) {
            return this.scope.isScope(method) && !method.getSimpleName().equals(this.name) ? method.withName(method.getName().withName(this.name)) : super.visitMethodInvocation(method);
        }
    }
}

