/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava25;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@MinimumJava25
class UnnamedVariableTest
implements RewriteTest {
    UnnamedVariableTest() {
    }

    @Test
    void unnamedVariableInForLoop() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\n\nclass Test {\n    void test(List<String> list) {\n        int total = 0;\n        for (var _ : list) {\n            total++;\n        }\n    }\n}\n")});
    }

    @Test
    void unnamedVariableInCatchBlock() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        try {\n            int x = Integer.parseInt(\"123\");\n        } catch (NumberFormatException _) {\n            System.out.println(\"Bad number format\");\n        }\n    }\n}\n")});
    }

    @Test
    void unnamedVariableInTryWithResources() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.FileReader;\n\nclass Test {\n    void test(String path) {\n        try (var _ = new FileReader(path)) {\n            System.out.println(\"Critical section\");\n        }\n    }\n}\n")});
    }

    @Test
    void unnamedVariableInLambda() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.function.BiFunction;\n\nclass Test {\n    void test() {\n        BiFunction<Integer, Integer, Integer> func = (x, _) -> x * 2;\n    }\n}\n")});
    }

    @Test
    void multipleUnnamedVariablesInLambda() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface TriConsumer<T, U, V> {\n    void accept(T t, U u, V v);\n}\n\nclass Test {\n    void test() {\n        TriConsumer<String, String, String> consumer = (_, _, third) ->\n            System.out.println(third);\n    }\n}\n", after -> after.afterRecipe(cu -> {
            J.MethodDeclaration md = (J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(1)).getBody().getStatements().getFirst();
            J.VariableDeclarations vd = (J.VariableDeclarations)md.getBody().getStatements().getFirst();
            J.Lambda lambda = (J.Lambda)((J.VariableDeclarations.NamedVariable)vd.getVariables().getFirst()).getInitializer();
            List lambdaParams = lambda.getParameters().getParameters();
            org.assertj.core.api.Assertions.assertThat((Object)((J)lambdaParams.getFirst())).isNotEqualTo(lambdaParams.get(1));
            org.assertj.core.api.Assertions.assertThat((boolean)SemanticallyEqual.areEqual((J)((J)lambdaParams.getFirst()), (J)((J)lambdaParams.get(1)))).isTrue();
        }))});
    }

    @Test
    void unnamedPatternInInstanceof() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test(Object obj) {\n        if (obj instanceof String _) {\n            System.out.println(\"It's a String\");\n        }\n    }\n}\n")});
    }

    @Test
    void unnamedPatternInSwitch() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String test(Object obj) {\n        return switch (obj) {\n            case Integer _ -> \"It's an Integer\";\n            case Long _ -> \"It's a Long\";\n            case Double _ -> \"It's a Double\";\n            default -> \"It's something else\";\n        };\n    }\n}\n")});
    }

    @Test
    void unnamedPatternWithGuard() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String test(Object obj) {\n        return switch (obj) {\n            case String _ when obj.toString().length() > 5 -> \"Long string\";\n            case String _ -> \"Short string\";\n            default -> \"Not a string\";\n        };\n    }\n}\n")});
    }

    @Test
    void unnamedVariableInRecordPattern() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"record Point(int x, int y) {}\n\nclass Test {\n    void test(Object obj) {\n        if (obj instanceof Point(int x, _)) {\n            System.out.println(\"x = \" + x);\n        }\n    }\n}\n")});
    }

    @Test
    void nestedUnnamedPatterns() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"record Box<T>(T content) {}\n\nclass Test {\n    void test(Object obj) {\n        if (obj instanceof Box(Box(_))) {\n            System.out.println(\"Nested box\");\n        }\n    }\n}\n")});
    }

    @Test
    void unnamedVariableInLocalDeclaration() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Queue;\nimport java.util.LinkedList;\n\nclass Test {\n    void test() {\n        Queue<String> queue = new LinkedList<>();\n        queue.offer(\"first\");\n        queue.offer(\"second\");\n\n        var _ = queue.poll();\n        var second = queue.poll();\n        System.out.println(second);\n    }\n}\n")});
    }

    @Test
    void unnamedVariableWithSideEffects() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    int counter = 0;\n\n    int increment() {\n        return ++counter;\n    }\n\n    void test() {\n        var _ = increment();\n        var _ = increment();\n        System.out.println(\"Counter incremented twice\");\n    }\n}\n")});
    }

    @Test
    void unnamedPatternInSwitchWithMultipleLabels() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"sealed interface Shape permits Circle, Rectangle, Square {}\nrecord Circle(double radius) implements Shape {}\nrecord Rectangle(double width, double height) implements Shape {}\nrecord Square(double side) implements Shape {}\n\nclass Test {\n    String test(Shape shape) {\n        return switch (shape) {\n            case Circle _, Square _ -> \"Round or square\";\n            case Rectangle _ -> \"Rectangular\";\n        };\n    }\n}\n")});
    }

    @Test
    void unnamedVariableInMethodParameter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.function.Consumer;\n\nclass Test {\n    void process(Consumer<String> _) {\n        System.out.println(\"Processing consumer\");\n    }\n\n    void test() {\n        process(s -> System.out.println(s));\n    }\n}\n")});
    }
}

