/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class SwitchTest
implements RewriteTest {
    SwitchTest() {
    }

    @Test
    void singleCase() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n   void test() {\n       int n;\n       switch(n) {\n          case 0: break;\n       }\n   }\n}\n")});
    }

    @Test
    void defaultCase() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n   void test() {\n       int n;\n       switch(n) {\n           default: System.out.println(\"default!\");\n       }\n   }\n}\n")});
    }

    @Test
    void noCases() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n   void test() {\n       int n;\n       switch(n) {}\n   }\n}\n")});
    }

    @Test
    void multipleCases() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n   void test() {\n       int n;\n       switch(n) {\n           case 0: {\n              break;\n           }\n           case 1: {\n              break;\n           }\n       }\n   }\n}\n")});
    }

    @Test
    void multipleSwitchStatements() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    void test(int i) {\n        switch (i) {\n            case 1:\n                System.out.println(\"1\");\n            default:\n                throw new IllegalStateException(\"Unexpected value: \" + i);\n        }\n        switch (i) {\n            case 1:\n                System.out.println(\"1\");\n            default:\n                throw new IllegalStateException(\"Unexpected value: \" + i);\n        }\n    }\n}\n")});
    }
}

