/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

class TypeUtilsTest
implements RewriteTest {
    TypeUtilsTest() {
    }

    static Consumer<SourceSpec<J.CompilationUnit>> typeIsPresent() {
        return s -> s.afterRecipe(cu -> {
            JavaType.Method fooMethodType = ((J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isPresent();
        });
    }

    @Test
    void isOverrideBasicInterface() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface {\n    void foo();\n}\n"), Assertions.java((String)"class Clazz implements Interface {\n    @Override void foo() { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideBasicInheritance() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Superclass {\n    void foo() { }\n}\n"), Assertions.java((String)"class Clazz extends Superclass {\n    @Override void foo() { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideOnlyVisible() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"package foo;\npublic class Superclass {\n    void foo() { }\n}\n"), Assertions.java((String)"package bar;\nimport foo.Superclass;\nclass Clazz extends Superclass {\n    public void foo() { }\n}\n", s -> s.afterRecipe(cu -> {
            JavaType.Method fooMethodType = ((J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isEmpty();
        }))});
    }

    @Test
    void isOverrideParameterizedInterface() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Comparator;\n\nclass TestComparator implements Comparator<String> {\n    @Override public int compare(String o1, String o2) {\n        return 0;\n    }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideParameterizedMethod() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface {\n    <T> void foo(T t);\n}\n"), Assertions.java((String)"class Clazz implements Interface {\n    @Override <T> void foo(T t) { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideConsidersTypeParameterPositions() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface <T, Y> {\n     void foo(Y y, T t);\n}\n"), Assertions.java((String)"class Clazz implements Interface<Integer, String> {\n    void foo(Integer t, String y) { }\n\n    @Override\n    void foo(String y, Integer t) { }\n}\n", s -> s.afterRecipe(cu -> {
            List methods = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(0)).getMethodType())).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(1)).getMethodType())).isPresent();
        }))});
    }

    @Test
    void arrayIsFullyQualifiedOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Integer[][] integer1;\n    Integer[] integer2;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Object)multiVariable.getTypeExpression().getType()).isInstanceOf(JavaType.Array.class);
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfClassType((JavaType)multiVariable.getTypeExpression().getType(), (String)"java.lang.Integer")).isTrue();
                return super.visitVariableDeclarations(multiVariable, o);
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Object)variable.getVariableType().getType()).isInstanceOf(JavaType.Array.class);
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isFullyQualifiedOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Integer integer1;\n    Integer integer2;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Object)variable.getVariableType().getType()).isInstanceOf(JavaType.Class.class);
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isParameterizedTypeOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<Integer> li;\n    java.util.List<Object> lo;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Object o) {
                J.VariableDeclarations.NamedVariable li = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)classDecl.getBody().getStatements().get(0)).getVariables().get(0);
                J.VariableDeclarations.NamedVariable lo = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)classDecl.getBody().getStatements().get(1)).getVariables().get(0);
                JavaType.Parameterized listIntegerType = (JavaType.Parameterized)li.getVariableType().getType();
                JavaType.Parameterized listObjectType = (JavaType.Parameterized)lo.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)listIntegerType.getType(), (JavaType)listIntegerType)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)listObjectType, (JavaType)listIntegerType)).isFalse();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)listIntegerType, (JavaType)listObjectType)).isFalse();
                return classDecl;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToWildcard() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<?> l = new java.util.ArrayList<String>();\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType.Parameterized wildcardList = (JavaType.Parameterized)variable.getVariableType().getType();
                JavaType.FullyQualified rawList = wildcardList.getType();
                JavaType.Parameterized stringArrayList = (JavaType.Parameterized)variable.getInitializer().getType();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)wildcardList, (JavaType)stringArrayList)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)wildcardList, (JavaType)stringArrayList)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)wildcardList, (JavaType)rawList)).isTrue();
                return variable;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isParameterizedTypeWithShallowClassesOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<Integer> integer1;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType varType = variable.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((Object)varType).isInstanceOf(JavaType.Parameterized.class);
                JavaType.Parameterized shallowParameterizedType = new JavaType.Parameterized(null, (JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.util.List"), Collections.singletonList(JavaType.ShallowClass.build((String)"java.lang.Integer")));
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)varType, (JavaType)shallowParameterizedType)).isTrue();
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToGenericTypeVariable() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Map;\nimport java.util.function.Supplier;\n\nclass Test {\n    <K, V> void m(Supplier<? extends Map<K, ? extends V>> map) {\n    }\n    void foo() {\n        Map<String, Integer> map = null;\n        m(() -> map);\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Object o) {
                JavaType paramType = (JavaType)method.getMethodType().getParameterTypes().get(0);
                org.assertj.core.api.Assertions.assertThat((Object)paramType).isInstanceOf(JavaType.Parameterized.class);
                JavaType argType = ((Expression)method.getArguments().get(0)).getType();
                org.assertj.core.api.Assertions.assertThat((Object)argType).isInstanceOf(JavaType.Parameterized.class);
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)paramType, (JavaType)argType)).isTrue();
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    @MinimumJava11
    void isAssignableToGenericTypeVariable2() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Collection;\nimport java.util.List;\n\nclass Test {\n    public <T extends Collection<String>> T test() {\n        return (T) get();\n    }\n    public List<String> get() {\n        return List.of(\"a\", \"b\", \"c\");\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Object o) {
                if (method.getSimpleName().equals("test")) {
                    J.Return return_ = (J.Return)method.getBody().getStatements().get(0);
                    J.TypeCast cast = (J.TypeCast)return_.getExpression();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)cast.getType(), (JavaType)cast.getExpression().getType(), (TypeUtils.TypePosition)TypeUtils.TypePosition.Invariant)).isFalse();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)cast.getType(), (JavaType)cast.getExpression().getType(), (TypeUtils.TypePosition)TypeUtils.TypePosition.Out)).isTrue();
                }
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToGenericTypeVariable3() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Collection;\nimport java.util.List;\n\nimport static java.util.Collections.singletonList;\n\nclass Test<T extends Collection<String>> {\n\n    void consumeClass(T collection) {\n    }\n\n    <T extends Collection<String>> void consumeMethod(T collection) {\n    }\n\n    void test() {\n        List<String> list = singletonList(\"hello\");\n        consumeMethod(null);\n        consumeClass(null);\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Object o) {
                if (method.getSimpleName().equals("test")) {
                    J.Block block = (J.Block)this.getCursor().getParentTreeCursor().getValue();
                    J.MethodDeclaration consumeClass = (J.MethodDeclaration)block.getStatements().get(0);
                    J.MethodDeclaration consumeMethod = (J.MethodDeclaration)block.getStatements().get(1);
                    J.VariableDeclarations.NamedVariable list = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)method.getBody().getStatements().get(0)).getVariables().get(0);
                    JavaType consumeClassParamType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)consumeClass.getParameters().get(0)).getVariables().get(0)).getType();
                    JavaType consumeMethodParamType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)consumeMethod.getParameters().get(0)).getVariables().get(0)).getType();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)consumeClassParamType, (JavaType)list.getType(), (TypeUtils.TypePosition)TypeUtils.TypePosition.Out)).isTrue();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)consumeMethodParamType, (JavaType)list.getType(), (TypeUtils.TypePosition)TypeUtils.TypePosition.Out)).isTrue();
                }
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToLong() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToInt() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToShort() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToChar() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToByte() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToDouble() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToFloat() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToBoolean() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.Boolean));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Boolean, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Boolean, (JavaType)JavaType.Primitive.Boolean));
    }

    @Test
    void isAssignableToNone() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.None));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.None, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.None, (JavaType)JavaType.Primitive.None));
    }

    @Test
    void isAssignableToVoid() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.Void));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Void, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Void, (JavaType)JavaType.Primitive.Void));
    }

    @Test
    void isAssignableToString() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.String));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.String, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.String, (JavaType)JavaType.Primitive.String));
    }

    @Test
    void isAssignableToPrimitiveArrays() {
        JavaType.Array intArray = new JavaType.Array(null, (JavaType)JavaType.Primitive.Int, null);
        JavaType.Array longArray = new JavaType.Array(null, (JavaType)JavaType.Primitive.Long, null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)intArray, (JavaType)intArray));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)longArray, (JavaType)intArray));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)intArray, (JavaType)longArray));
    }

    @Test
    void isAssignableToNonPrimitiveArrays() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Object[] oa;\n    String[] sa;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Object o) {
                J.VariableDeclarations oa = (J.VariableDeclarations)classDecl.getBody().getStatements().get(0);
                J.VariableDeclarations sa = (J.VariableDeclarations)classDecl.getBody().getStatements().get(1);
                JavaType objectArray = oa.getType();
                JavaType stringArray = sa.getType();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)objectArray, (JavaType)objectArray));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)stringArray, (JavaType)objectArray));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)objectArray, (JavaType)stringArray));
                return classDecl;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableFromIntersection() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.Serializable;\n\nclass Test {\n    Object o1 = (Serializable & Runnable) null;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType variableType = variable.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((Object)variableType).satisfies(new ThrowingConsumer[]{type -> org.assertj.core.api.Assertions.assertThat((Object)type).isInstanceOf(JavaType.Class.class), type -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)type).getFullyQualifiedName()).isEqualTo("java.lang.Object")});
                J.TypeCast typeCast = (J.TypeCast)variable.getInitializer();
                org.assertj.core.api.Assertions.assertThat((Object)typeCast.getType()).satisfies(new ThrowingConsumer[]{type -> org.assertj.core.api.Assertions.assertThat((Object)type).isInstanceOf(JavaType.Intersection.class), type -> org.assertj.core.api.Assertions.assertThat((List)((JavaType.Intersection)type).getBounds()).satisfiesExactly(new ThrowingConsumer[]{bound -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)bound).getFullyQualifiedName()).isEqualTo("java.io.Serializable"), bound -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)bound).getFullyQualifiedName()).isEqualTo("java.lang.Runnable")}), type -> org.assertj.core.api.Assertions.assertThat((List)((JavaType.Intersection)type).getBounds()).allSatisfy(bound -> {
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)bound, (JavaType)type)).isTrue();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((String)((JavaType.FullyQualified)bound).getFullyQualifiedName(), (JavaType)type)).isTrue();
                }), type -> org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.Object"), (JavaType)type)).isTrue(), type -> org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((String)"java.lang.Object", (JavaType)type)).isTrue()});
                return variable;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isWellFormedType() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                org.assertj.core.api.Assertions.assertThat((Collection)cu.getTypesInUse().getTypesInUse()).allMatch(TypeUtils::isWellFormedType);
                return cu;
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.io.Serializable;\n\nclass Test {\n    static <T extends Serializable &\n            Comparable<T>> T method0() {\n        return null;\n    }\n\n    static <T extends Serializable> T method1() {\n        return null;\n    }\n}\n")});
    }
}

