/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MinimumJava17;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class InstanceOfTest
implements RewriteTest {
    InstanceOfTest() {
    }

    @Test
    void instanceOf() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test(Object o) {\n        boolean b = o instanceof String;\n    }\n}\n")});
    }

    @MinimumJava17
    @Test
    void patternMatch() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n  public void match(Collection<?> c) {\n        if (c instanceof List<?> l) {\n            System.out.println(\"List\");\n        } else if (c instanceof Set<?> s) {\n            System.out.println(\"Set\");\n        }\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaVisitor<Integer>(){

            public J visitInstanceOf(J.InstanceOf instanceOf, Integer integer) {
                org.assertj.core.api.Assertions.assertThat((Object)instanceOf.getPattern()).isNotNull();
                return instanceOf;
            }
        }.visit((Tree)cu, (Object)0)))});
    }
}

