/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class ImportTest
implements RewriteTest {
    ImportTest() {
    }

    @Test
    void typeName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import static java.util.Map.Entry;\nimport java.util.Map.Entry;\n\nimport java.util.List;\nimport java.util.*;\n\nimport static java.nio.charset.StandardCharsets.UTF_8;\nimport static java.util.Collections.emptyList;\n", spec -> spec.afterRecipe(cu -> org.assertj.core.api.Assertions.assertThat(cu.getImports().stream().map(J.Import::getTypeName)).containsExactly((Object[])new String[]{"java.util.Map$Entry", "java.util.Map$Entry", "java.util.List", "java.util.*", "java.nio.charset.StandardCharsets", "java.util.Collections"})))});
    }

    @Test
    void packageName() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"    import static java.util.Map.Entry;\n    import java.util.Map.Entry;\n\n    import java.util.List;\n    import java.util.*;\n\n    import static java.nio.charset.StandardCharsets.UTF_8;\n    import static java.util.Collections.emptyList;\n", spec -> spec.afterRecipe(cu -> org.assertj.core.api.Assertions.assertThat(cu.getImports().stream().map(J.Import::getPackageName)).containsExactly((Object[])new String[]{"java.util", "java.util", "java.util", "java.util", "java.nio.charset", "java.util"})))});
    }

    @Test
    void classImport() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\npublic class A {}\n")});
    }

    @Test
    void starImport() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\npublic class A {}\n")});
    }

    @Test
    void compare() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import b.B;\nimport c.c.C;\n", spec -> spec.afterRecipe(cu -> {
            J.Import b = (J.Import)cu.getImports().get(0);
            J.Import c = (J.Import)cu.getImports().get(1);
            org.assertj.core.api.Assertions.assertThat((int)b.compareTo(c)).isLessThan(0);
            org.assertj.core.api.Assertions.assertThat((int)c.compareTo(b)).isGreaterThan(0);
        }))});
    }

    @Test
    void compareSamePackageDifferentNameLengths() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"    import org.springframework.context.annotation.Bean;\n    import org.springframework.context.annotation.Configuration;\n", spec -> spec.afterRecipe(cu -> {
            J.Import b = (J.Import)cu.getImports().get(0);
            J.Import c = (J.Import)cu.getImports().get(1);
            org.assertj.core.api.Assertions.assertThat((int)b.compareTo(c)).isLessThan(0);
            org.assertj.core.api.Assertions.assertThat((int)c.compareTo(b)).isGreaterThan(0);
        }))});
    }

    @Test
    void uppercasePackage() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"    package org.openrewrite.BadPackage;\n\n    public class Foo {\n        public static class Bar {\n        }\n    }\n", spec -> spec.afterRecipe(cu -> org.assertj.core.api.Assertions.assertThat((String)cu.getPackageDeclaration().getPackageName()).isEqualTo("org.openrewrite.BadPackage"))), Assertions.java((String)"    package org.openrewrite;\n\n    import org.openrewrite.BadPackage.Foo;\n    import org.openrewrite.BadPackage.Foo.Bar;\n\n    public class Bar {\n        private Foo foo;\n    }\n\n", spec -> spec.afterRecipe(cu -> {
            org.assertj.core.api.Assertions.assertThat((String)((J.Import)cu.getImports().get(0)).getPackageName()).isEqualTo("org.openrewrite.BadPackage");
            org.assertj.core.api.Assertions.assertThat((String)((J.Import)cu.getImports().get(1)).getPackageName()).isEqualTo("org.openrewrite.BadPackage");
        }))});
    }
}

