/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.JavaTreeTest;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/tree/TypeParameterAndWildcardTest;", "Lorg/openrewrite/java/tree/JavaTreeTest;", "annotatedTypeParametersOnReturnTypeExpression", "", "jp", "Lorg/openrewrite/java/JavaParser;", "annotatedTypeParametersOnWildcardBounds", "emptyWildcard", "extendsAndSuper", "multipleExtends", "wildcardExtends", "rewrite-java-tck"})
public interface TypeParameterAndWildcardTest
extends JavaTreeTest {
    @Test
    public void annotatedTypeParametersOnWildcardBounds(@NotNull JavaParser var1);

    @Test
    public void annotatedTypeParametersOnReturnTypeExpression(@NotNull JavaParser var1);

    @Test
    public void extendsAndSuper(@NotNull JavaParser var1);

    @Test
    public void multipleExtends(@NotNull JavaParser var1);

    @Test
    public void wildcardExtends(@NotNull JavaParser var1);

    @Test
    public void emptyWildcard(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void annotatedTypeParametersOnWildcardBounds(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            interface B {}\n            class A {\n                List<? extends @NotNull B> checks;\n            }\n        ", new String[0]);
        }

        @Test
        public static void annotatedTypeParametersOnReturnTypeExpression(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            interface B {}\n            class A {\n                public List<\n                    @NotNull(groups = Prioritized.P1.class)\n                    @javax.validation.Valid\n                    B> foo() {\n                    return null;\n                }\n            }\n        ", new String[0]);
        }

        @Test
        public static void extendsAndSuper(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            interface B {}\n            interface C {}\n            public class A {\n                public <P  extends B> void foo(List<P> out, List<? super C> in) {}\n            }\n        ", new String[0]);
        }

        @Test
        public static void multipleExtends(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            interface B {}\n            interface C {}\n            public class A< T extends  B & C > {}\n        ", new String[0]);
        }

        @Test
        public static void wildcardExtends(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.*;\n            interface B {}\n            public class A {\n                List< ?  extends  B > bs;\n            }\n        ", new String[0]);
        }

        @Test
        public static void emptyWildcard(@NotNull TypeParameterAndWildcardTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.*;\n            public class A {\n                List< ? > a;\n            }\n        ", new String[0]);
        }
    }
}

