/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.FindDeprecatedMethods;
import org.openrewrite.java.search.FindDeprecatedUses;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/search/FindDeprecatedMethodsTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "dontMatchWhenMethodDoesntMatch", "jp", "Lorg/openrewrite/java/JavaParser;", "findDeprecations", "hasImport", "ignoreDeprecationsInDeprecatedClass", "ignoreDeprecationsInDeprecatedMethod", "matchOnMethod", "noNPEWhenUsedFromDeprecatedUses", "onlyFoo", "rewrite-java-tck"})
public interface FindDeprecatedMethodsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void ignoreDeprecationsInDeprecatedMethod();

    @Test
    public void ignoreDeprecationsInDeprecatedClass(@NotNull JavaParser var1);

    @Test
    public void findDeprecations(@NotNull JavaParser var1);

    @Test
    public void matchOnMethod(@NotNull JavaParser var1);

    @Test
    public void dontMatchWhenMethodDoesntMatch(@NotNull JavaParser var1);

    @Test
    public void noNPEWhenUsedFromDeprecatedUses();

    @Test
    public void onlyFoo();

    @Test
    public void hasImport();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull FindDeprecatedMethodsTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new FindDeprecatedMethods(null, null));
        }

        @Test
        public static void ignoreDeprecationsInDeprecatedMethod(@NotNull FindDeprecatedMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        test(n + 1);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::ignoreDeprecationsInDeprecatedMethod$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void ignoreDeprecationsInDeprecatedClass(@NotNull FindDeprecatedMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            @Deprecated\n            class Test {\n                @Deprecated\n                void test(int n) {\n                }\n                \n                Test() {\n                    int n = 1;\n                    if(n == 1) {\n                        test(n + 1);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::ignoreDeprecationsInDeprecatedClass$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void findDeprecations(@NotNull FindDeprecatedMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        test(n + 1);\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        /*~~>*/test(n + 1);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void matchOnMethod(@NotNull FindDeprecatedMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        test(n + 1);\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        /*~~>*/test(n + 1);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::matchOnMethod$lambda$2, sourceSpecsArray);
        }

        @Test
        public static void dontMatchWhenMethodDoesntMatch(@NotNull FindDeprecatedMethodsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        test(n + 1);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::dontMatchWhenMethodDoesntMatch$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void noNPEWhenUsedFromDeprecatedUses(@NotNull FindDeprecatedMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        test(n + 1);\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    if(n == 1) {\n                        /*~~>*/test(n + 1);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::noNPEWhenUsedFromDeprecatedUses$lambda$4, sourceSpecsArray);
        }

        @Test
        public static void onlyFoo(@NotNull FindDeprecatedMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    @Deprecated\n                    void test(int n) {\n                        if(n == 1) {\n                            test(n + 1);\n                        }\n                    }\n                    \n                    @Deprecated\n                    void foo(int n) {\n                        if(n == 1) {\n                            foo(n + 1);\n                        }\n                    }\n                }\n            ", (String)"\n                class Test {\n                    @Deprecated\n                    void test(int n) {\n                        if(n == 1) {\n                            test(n + 1);\n                        }\n                    }\n                    \n                    @Deprecated\n                    void foo(int n) {\n                        if(n == 1) {\n                            /*~~>*/foo(n + 1);\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::onlyFoo$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void hasImport(@NotNull FindDeprecatedMethodsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package com.yourorg;\n            \n            public class Foo {\n                @Deprecated\n                public void foo() {\n                }\n            }\n            \n        "), Assertions.java((String)"\n            import com.yourorg.Foo;\n            \n            class A {\n                void a() {\n                    new Foo().foo();\n                }\n            }\n        ", (String)"\n            import com.yourorg.Foo;\n            \n            class A {\n                void a() {\n                    /*~~>*/new Foo().foo();\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::hasImport$lambda$6, sourceSpecsArray);
        }

        private static void ignoreDeprecationsInDeprecatedMethod$lambda$0(RecipeSpec spec) {
            spec.recipe((Recipe)new FindDeprecatedMethods(null, Boolean.valueOf(true)));
        }

        private static void ignoreDeprecationsInDeprecatedClass$lambda$1(RecipeSpec spec) {
            spec.recipe((Recipe)new FindDeprecatedMethods(null, Boolean.valueOf(true)));
        }

        private static void matchOnMethod$lambda$2(RecipeSpec spec) {
            spec.recipe((Recipe)new FindDeprecatedMethods("java.lang.* *(..)", Boolean.valueOf(false)));
        }

        private static void dontMatchWhenMethodDoesntMatch$lambda$3(RecipeSpec spec) {
            spec.recipe((Recipe)new FindDeprecatedMethods("org.junit.jupiter.api.* *(..)", Boolean.valueOf(false)));
        }

        private static void noNPEWhenUsedFromDeprecatedUses$lambda$4(RecipeSpec spec) {
            spec.recipe((Recipe)new FindDeprecatedUses(null, null, null));
        }

        private static void onlyFoo$lambda$5(RecipeSpec spec) {
            spec.recipe((Recipe)new FindDeprecatedMethods("*..* foo(..)", Boolean.valueOf(false)));
        }

        private static void hasImport$lambda$6(RecipeSpec spec) {
            spec.recipe((Recipe)new FindDeprecatedMethods("", null));
        }
    }
}

