/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AssertionsKt;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTypeGoat;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.internal.JavaReflectionTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaSourceSetTest;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J(\u0010\u0005\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/marker/JavaSourceSetTest;", "", "buildJavaSourceSet", "", "doesNotDuplicateTypesInCache", "newUniqueTypes", "uniqueTypes", "", "Lorg/openrewrite/java/tree/JavaType;", "root", "report", "", "shadedJar", "shallowTypes", "rewrite-java-tck"})
public interface JavaSourceSetTest {
    @Test
    public void buildJavaSourceSet();

    @Test
    public void shallowTypes();

    @Test
    public void shadedJar();

    @Disabled
    @Test
    public void doesNotDuplicateTypesInCache();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @Test
        public static void buildJavaSourceSet(@NotNull JavaSourceSetTest $this) {
            void $this$associateByTo$iv$iv;
            JavaTypeCache typeCache = new JavaTypeCache();
            JavaSourceSet jss = JavaSourceSet.build((String)"main", (Collection)CollectionsKt.emptyList(), (JavaTypeCache)typeCache, (boolean)false);
            List list = jss.getClasspath();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jss.classpath");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.toString(), element$iv$iv);
            }
            Map typesBySignature = destination$iv$iv;
            Assertions.assertThat(typesBySignature.get("java.lang.Object")).isInstanceOf(JavaType.Class.class);
            Assertions.assertThat(typesBySignature.get("java.util.List")).isInstanceOf(JavaType.Class.class);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void shallowTypes(@NotNull JavaSourceSetTest $this) {
            void $this$associateByTo$iv$iv;
            JavaTypeCache typeCache = new JavaTypeCache();
            JavaSourceSet jss = JavaSourceSet.build((String)"main", (Collection)CollectionsKt.emptyList(), (JavaTypeCache)typeCache, (boolean)false);
            List list = jss.getClasspath();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jss.classpath");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.toString(), element$iv$iv);
            }
            Map typesBySignature = destination$iv$iv;
            Assertions.assertThat(typesBySignature.get("java.lang.Object")).isInstanceOf(JavaType.ShallowClass.class);
            Assertions.assertThat(typesBySignature.get("java.util.List")).isInstanceOf(JavaType.ShallowClass.class);
        }

        @Test
        public static void shadedJar(@NotNull JavaSourceSetTest $this) {
            JavaTypeCache typeCache = new JavaTypeCache();
            String[] stringArray = new String[]{"hbase-shaded-client"};
            List shaded2 = JavaSourceSet.build((String)"test", (Collection)JavaParser.dependenciesFromClasspath((String[])stringArray), (JavaTypeCache)typeCache, (boolean)false).getClasspath().stream().filter(arg_0 -> DefaultImpls.shadedJar$lambda$2(shadedJar.shaded.1.INSTANCE, arg_0)).collect(Collectors.toList());
            Assertions.assertThat(shaded2).isNotEmpty();
            Assertions.assertThat(shaded2.get(0)).isInstanceOf(JavaType.ShallowClass.class);
        }

        @Disabled
        @Test
        public static void doesNotDuplicateTypesInCache(@NotNull JavaSourceSetTest $this) {
            Object v2;
            Set<JavaType> uniqueTypes;
            block1: {
                JavaTypeCache typeCache = new JavaTypeCache();
                Set<JavaType> set = Collections.newSetFromMap(new IdentityHashMap());
                Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(IdentityHashMap())");
                uniqueTypes = set;
                JavaType reflectiveGoat = new JavaReflectionTypeMapping(typeCache).type((Type)((Object)JavaTypeGoat.class));
                Intrinsics.checkNotNullExpressionValue((Object)reflectiveGoat, (String)"reflectiveGoat");
                DefaultImpls.newUniqueTypes$default($this, uniqueTypes, reflectiveGoat, false, 4, null);
                List list = JavaSourceSet.build((String)"main", (Collection)JavaParser.runtimeClasspath(), (JavaTypeCache)typeCache, (boolean)true).getClasspath();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"build(\"main\", JavaParser\u2026e)\n            .classpath");
                Iterable iterable = list;
                for (Object t : iterable) {
                    JavaType.FullyQualified it = (JavaType.FullyQualified)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)"JavaTypeGoat", (Object)it.getClassName())) continue;
                    v2 = t;
                    break block1;
                }
                v2 = null;
            }
            Intrinsics.checkNotNull(v2);
            JavaType.FullyQualified classpathGoat = v2;
            DefaultImpls.newUniqueTypes($this, uniqueTypes, (JavaType)classpathGoat, true);
        }

        private static void newUniqueTypes(JavaSourceSetTest $this, Set<JavaType> uniqueTypes, JavaType root, boolean report) {
            Ref.BooleanRef newUnique = new Ref.BooleanRef();
            new JavaTypeVisitor<Integer>(uniqueTypes, report, newUnique){
                final /* synthetic */ Set<JavaType> $uniqueTypes;
                final /* synthetic */ boolean $report;
                final /* synthetic */ Ref.BooleanRef $newUnique;
                {
                    this.$uniqueTypes = $uniqueTypes;
                    this.$report = $report;
                    this.$newUnique = $newUnique;
                }

                @Nullable
                public JavaType visit(@Nullable JavaType javaType, int p) {
                    if (javaType != null && this.$uniqueTypes.add(javaType)) {
                        if (this.$report) {
                            this.$newUnique.element = true;
                            System.out.println(javaType);
                        }
                        return super.visit(javaType, (Object)p);
                    }
                    return javaType;
                }
            }.visit(root, 0);
            if (report && newUnique.element) {
                AssertionsKt.fail$default((String)"Found new unique types there should have been none.", null, (int)2, null);
                throw new KotlinNothingValueException();
            }
        }

        public static /* synthetic */ void newUniqueTypes$default(JavaSourceSetTest javaSourceSetTest, Set set, JavaType javaType, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newUniqueTypes");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            DefaultImpls.newUniqueTypes(javaSourceSetTest, set, javaType, bl);
        }

        private static boolean shadedJar$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

