/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.controlflow.Guard;
import org.openrewrite.java.controlflow.GuardTest;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/controlflow/GuardTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "does not flag arbitrary parentheses as guards", "identifies guards", "identifies guards for control parentheses with missing type information", "identifies guards with binary expressions", "identifies guards with field accesses", "identifies guards with methods with parameters", "identifies guards with missing type information", "rewrite-java-tck"})
public interface GuardTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void identifies guards();

    @Test
    public void identifies guards with binary expressions();

    @Test
    public void identifies guards with methods with parameters();

    @Test
    public void identifies guards with field accesses();

    @Test
    public void identifies guards with missing type information();

    @Test
    public void identifies guards for control parentheses with missing type information();

    @Test
    public void does not flag arbitrary parentheses as guards();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull GuardTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::defaults$lambda$0));
        }

        @Test
        public static void identifies guards(@NotNull GuardTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean boolLiteral();\n                abstract Boolean boolObject();\n\n                void test() {\n                    if (boolLiteral()) {\n                        // ...\n                    }\n                    if (boolObject()) {\n                        // ...\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract /*~~>*/boolean boolLiteral();\n                abstract /*~~>*/Boolean boolObject();\n\n                void test() {\n                    if (/*~~>*/boolLiteral()) {\n                        // ...\n                    }\n                    if (/*~~>*/boolObject()) {\n                        // ...\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void identifies guards with binary expressions(@NotNull GuardTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean boolPrim();\n                abstract Boolean boolObject();\n\n                void test() {\n                    if (boolPrim()) {\n                        // ...\n                    }\n                    if (boolObject() || boolPrim()) {\n                        // ...\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract /*~~>*/boolean boolPrim();\n                abstract /*~~>*/Boolean boolObject();\n\n                void test() {\n                    if (/*~~>*/boolPrim()) {\n                        // ...\n                    }\n                    if (/*~~>*//*~~>*/boolObject() || /*~~>*/boolPrim()) {\n                        // ...\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void identifies guards with methods with parameters(@NotNull GuardTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n\n                void test(boolean x, Boolean y) {\n                    if (x) {\n                        // ...\n                    }\n                    if (y) {\n                        // ...\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n\n                void test(/*~~>*/boolean /*~~>*/x, /*~~>*/Boolean /*~~>*/y) {\n                    if (/*~~>*/x) {\n                        // ...\n                    }\n                    if (/*~~>*/y) {\n                        // ...\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void identifies guards with field accesses(@NotNull GuardTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                private boolean x;\n                private Boolean y;\n\n                void test() {\n                    if (x) {\n                        // ...\n                    }\n                    if (y) {\n                        // ...\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                private /*~~>*/boolean /*~~>*/x;\n                private /*~~>*/Boolean /*~~>*/y;\n\n                void test() {\n                    if (/*~~>*/x) {\n                        // ...\n                    }\n                    if (/*~~>*/y) {\n                        // ...\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void identifies guards with missing type information(@NotNull GuardTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        if (potato) {\n            // ...\n        }\n        if ((potato)) {\n            // ...\n        }\n        if (potato && turnip) {\n            // ...\n        }\n        if (potato && turnip || squash) {\n            // ...\n        }\n        int a = 1, b = 2;\n        if ((a = turnip) == b) {\n            // ..\n        }\n        horse.equals(donkey);\n        boolean farmFresh = tomato;\n        boolean farmFreshAndFancyFree = (chicken);\n        boolean farmFreshEggs = true;\n        farmFreshEggs = chicken.layEggs();\n        while (farming) {\n            // ...\n        }\n        for (int i = 0; areMoreCabbages(); i++) {\n            // ...\n        }\n    }\n}", (String)"class Test {\n    void test() {\n        if (/*~~>*/potato) {\n            // ...\n        }\n        if (/*~~>*/(/*~~>*/potato)) {\n            // ...\n        }\n        if (/*~~>*//*~~>*/potato && /*~~>*/turnip) {\n            // ...\n        }\n        if (/*~~>*//*~~>*//*~~>*/potato && /*~~>*/turnip || /*~~>*/squash) {\n            // ...\n        }\n        int a = 1, b = 2;\n        if (/*~~>*/(a = turnip) == b) {\n            // ..\n        }\n        /*~~>*/horse.equals(donkey);\n        /*~~>*/boolean /*~~>*/farmFresh = /*~~>*/tomato;\n        /*~~>*/boolean /*~~>*/farmFreshAndFancyFree = /*~~>*/(/*~~>*/chicken);\n        /*~~>*/boolean /*~~>*/farmFreshEggs = /*~~>*/true;\n        /*~~>*//*~~>*/farmFreshEggs = /*~~>*/chicken.layEggs();\n        while (/*~~>*/farming) {\n            // ...\n        }\n        for (int i = 0; /*~~>*/areMoreCabbages(); i++) {\n            // ...\n        }\n    }\n}")};
            $this.rewriteRun(DefaultImpls::identifies_guards_with_missing_type_information$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void identifies guards for control parentheses with missing type information(@NotNull GuardTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        if ((potato)) {\n            // ...\n        }\n    }\n}", (String)"class Test {\n    void test() {\n        if (/*~~>*/(/*~~>*/potato)) {\n            // ...\n        }\n    }\n}")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void does not flag arbitrary parentheses as guards(@NotNull GuardTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        int a = (potato);\n        int b = (a = turnip);\n    }\n}")};
            $this.rewriteRun(sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda$0() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public Expression visitExpression(@NotNull Expression expression, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Expression expression2 = Guard.from((Cursor)this.getCursor()).map(arg_0 -> defaults.1.1.visitExpression$lambda$0((Function1)new Function1<Guard, Expression>(expression){
                        final /* synthetic */ Expression $expression;
                        {
                            this.$expression = $expression;
                            super(1);
                        }

                        public final Expression invoke(Guard it) {
                            return (Expression)this.$expression.withMarkers(this.$expression.getMarkers().searchResult());
                        }
                    }, arg_0)).orElse(expression);
                    Intrinsics.checkNotNullExpressionValue((Object)expression2, (String)"expression: Expression, \u2026      .orElse(expression)");
                    return expression2;
                }

                private static final Expression visitExpression$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Expression)$tmp0.invoke(p0);
                }
            };
        }

        private static void identifies_guards_with_missing_type_information$lambda$1(RecipeSpec spec) {
            spec.typeValidationOptions(TypeValidation.none());
        }
    }
}

