/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.UseStandardCharset;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/cleanup/UseStandardCharsetTest;", "Lorg/openrewrite/test/RewriteTest;", "changeCharsetForName", "", "convertAnyValidName", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "notAStandardCharset", "rewrite-java-tck"})
public interface UseStandardCharsetTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void notAStandardCharset();

    @Test
    public void changeCharsetForName();

    @Test
    public void convertAnyValidName();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull UseStandardCharsetTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new UseStandardCharset());
        }

        @Test
        public static void notAStandardCharset(@NotNull UseStandardCharsetTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.nio.charset.Charset;\n\n            class Test {\n                Charset WINDOWS_1252 = Charset.forName(\"Windows-1252\");\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void changeCharsetForName(@NotNull UseStandardCharsetTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.nio.charset.Charset;\n\n            class Test {\n                Charset US_ASCII = Charset.forName(\"US-ASCII\");\n                Charset ISO_8859_1 = Charset.forName(\"ISO-8859-1\");\n                Charset UTF_8 = Charset.forName(\"UTF-8\");\n                Charset UTF_16 = Charset.forName(\"UTF-16\");\n                Charset UTF_16BE = Charset.forName(\"UTF-16BE\");\n                Charset UTF_16LE = Charset.forName(\"UTF-16LE\");\n            }\n            ", (String)"\n            import java.nio.charset.Charset;\n            import java.nio.charset.StandardCharsets;\n\n            class Test {\n                Charset US_ASCII = StandardCharsets.US_ASCII;\n                Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;\n                Charset UTF_8 = StandardCharsets.UTF_8;\n                Charset UTF_16 = StandardCharsets.UTF_16;\n                Charset UTF_16BE = StandardCharsets.UTF_16BE;\n                Charset UTF_16LE = StandardCharsets.UTF_16LE;\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void convertAnyValidName(@NotNull UseStandardCharsetTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.nio.charset.Charset;\n\n            class Test {\n                Charset UTF_8_A = Charset.forName(\"utf-8\");\n                Charset UTF_8_B = Charset.forName(\"utf8\");\n                Charset UTF_8_C = Charset.forName(\"UTF8\");\n            }\n            ", (String)"\n            import java.nio.charset.Charset;\n            import java.nio.charset.StandardCharsets;\n\n            class Test {\n                Charset UTF_8_A = StandardCharsets.UTF_8;\n                Charset UTF_8_B = StandardCharsets.UTF_8;\n                Charset UTF_8_C = StandardCharsets.UTF_8;\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

