/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.cleanup.ControlFlowIndentation;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/cleanup/ControlFlowIndentationTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "elseIf", "jp", "Lorg/openrewrite/java/JavaParser;", "leavesIndentationAloneWhenBlocksAreExplicit", "removesIndentationFromStatementAfterIfElse", "removesIndentationFromStatementAfterLoop", "removesIndentationFromStatementAroundIf", "rewrite-java-tck"})
public interface ControlFlowIndentationTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void removesIndentationFromStatementAroundIf();

    @Test
    public void leavesIndentationAloneWhenBlocksAreExplicit();

    @Test
    public void removesIndentationFromStatementAfterIfElse();

    @Test
    public void elseIf(@NotNull JavaParser var1);

    @Test
    public void removesIndentationFromStatementAfterLoop();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull ControlFlowIndentationTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ControlFlowIndentation());
        }

        @Test
        public static void removesIndentationFromStatementAroundIf(@NotNull ControlFlowIndentationTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                {\n                        foo(); // This should be left alone because it does not come after control flow\n                    if(true)\n                    foo();\n                        foo();\n                }\n                \n                static void foo() { \n                // There's no control flow in this method body, so its indentation should remain untouched\n                            int a = 0;\n                        }\n            }\n        ", (String)"\n            class A {\n                {\n                        foo(); // This should be left alone because it does not come after control flow\n                    if(true)\n                        foo();\n                    foo();\n                }\n                \n                static void foo() { \n                // There's no control flow in this method body, so its indentation should remain untouched\n                            int a = 0;\n                        }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void leavesIndentationAloneWhenBlocksAreExplicit(@NotNull ControlFlowIndentationTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                {\n                    if(true) {\n                            foo();\n                    } else if(true) {\n                            foo();\n                    } else {\n                            foo();\n                    }\n                            foo();\n                }\n                \n                static void foo(){}\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removesIndentationFromStatementAfterIfElse(@NotNull ControlFlowIndentationTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                {\n                    if(true) {\n                        foo();\n                    } else\n                        foo();\n                        foo();\n                }\n                \n                static void foo(){}\n            }\n        ", (String)"\n            class A {\n                {\n                    if(true) {\n                        foo();\n                    } else\n                        foo();\n                    foo();\n                }\n                \n                static void foo(){}\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void elseIf(@NotNull ControlFlowIndentationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                {\n                    if(true){\n                        foo();\n                    } else if(false)\n                    foo();\n                    else {\n                        foo();\n                    }\n                }\n                static void foo(){}\n            }\n        ", (String)"\n            class A {\n                {\n                    if(true){\n                        foo();\n                    } else if(false)\n                        foo();\n                    else {\n                        foo();\n                    }\n                }\n                static void foo(){}\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removesIndentationFromStatementAfterLoop(@NotNull ControlFlowIndentationTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                {\n                    while(false)\n                        foo();\n                        foo();\n                }\n                \n                static void foo(){}\n            }\n        ", (String)"\n            class A {\n                {\n                    while(false)\n                        foo();\n                    foo();\n                }\n                \n                static void foo(){}\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

