/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.AddOrUpdateAnnotationAttribute;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/AddOrUpdateAnnotationAttributeTest;", "Lorg/openrewrite/test/RewriteTest;", "addNamedAttribute", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addValueAttribute", "dontChangeWhenSetToAddOnly", "implicitValueToExplicitValue", "preserveExistingAttributes", "replaceAttribute", "updateValueAttribute", "rewrite-java-tck"})
public interface AddOrUpdateAnnotationAttributeTest
extends RewriteTest {
    @Test
    public void addValueAttribute(@NotNull JavaParser var1);

    @Test
    public void updateValueAttribute(@NotNull JavaParser var1);

    @Test
    public void addNamedAttribute(@NotNull JavaParser var1);

    @Test
    public void replaceAttribute(@NotNull JavaParser var1);

    @Test
    public void preserveExistingAttributes(@NotNull JavaParser var1);

    @Test
    public void implicitValueToExplicitValue(@NotNull JavaParser var1);

    @Test
    public void dontChangeWhenSetToAddOnly();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void addValueAttribute(@NotNull AddOrUpdateAnnotationAttributeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.example;\n            public @interface Foo {\n                String value() default \"\";\n            }\n        "), Assertions.java((String)"\n            import org.example.Foo;\n            \n            @Foo\n            public class A {\n            }\n        ", (String)"\n            import org.example.Foo;\n            \n            @Foo(\"hello\")\n            public class A {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::addValueAttribute$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void updateValueAttribute(@NotNull AddOrUpdateAnnotationAttributeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.example;\n            public @interface Foo {\n                String value() default \"\";\n            }\n        "), Assertions.java((String)"\n            import org.example.Foo;\n            \n            @Foo(\"goodbye\")\n            public class A {\n            }\n        ", (String)"\n            import org.example.Foo;\n            \n            @Foo(\"hello\")\n            public class A {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::updateValueAttribute$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void addNamedAttribute(@NotNull AddOrUpdateAnnotationAttributeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.junit;\n            public @interface Test {\n                long timeout() default 0L;\n            }\n        "), Assertions.java((String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n                \n                @Test\n                void foo() {\n                }\n            }\n        ", (String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n                \n                @Test(timeout = 500)\n                void foo() {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::addNamedAttribute$lambda$2, sourceSpecsArray);
        }

        @Test
        public static void replaceAttribute(@NotNull AddOrUpdateAnnotationAttributeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.junit;\n            public @interface Test {\n                long timeout() default 0L;\n            }\n        "), Assertions.java((String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n                \n                @Test(timeout = 1)\n                void foo() {\n                }\n            }\n        ", (String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n                \n                @Test(timeout = 500)\n                void foo() {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::replaceAttribute$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void preserveExistingAttributes(@NotNull AddOrUpdateAnnotationAttributeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.junit;\n            public @interface Test {\n                long timeout() default 0L;\n                String foo() default \"\";\n            }\n        "), Assertions.java((String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n                \n                @Test(foo = \"\")\n                void foo() {\n                }\n            }\n        ", (String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n                \n                @Test(timeout = 500, foo = \"\")\n                void foo() {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::preserveExistingAttributes$lambda$4, sourceSpecsArray);
        }

        @Test
        public static void implicitValueToExplicitValue(@NotNull AddOrUpdateAnnotationAttributeTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.junit;\n            public @interface Test {\n                long other() default 0L;\n                String value() default \"\";\n            }\n        "), Assertions.java((String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n            \n                @Test(\"foo\")\n                void foo() {\n                }\n            }\n        ", (String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n            \n                @Test(other = 1, value = \"foo\")\n                void foo() {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::implicitValueToExplicitValue$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void dontChangeWhenSetToAddOnly(@NotNull AddOrUpdateAnnotationAttributeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.junit;\n            public @interface Test {\n                long other() default 0L;\n                String value() default \"\";\n            }\n        "), Assertions.java((String)"\n            import org.junit.Test;\n            \n            class SomeTestClass {\n                @Test(other = 0)\n                void foo() {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::dontChangeWhenSetToAddOnly$lambda$6, sourceSpecsArray);
        }

        private static void addValueAttribute$lambda$0(RecipeSpec spec) {
            spec.recipe((Recipe)new AddOrUpdateAnnotationAttribute("org.example.Foo", null, "hello", null));
        }

        private static void updateValueAttribute$lambda$1(RecipeSpec spec) {
            spec.recipe((Recipe)new AddOrUpdateAnnotationAttribute("org.example.Foo", null, "hello", null));
        }

        private static void addNamedAttribute$lambda$2(RecipeSpec spec) {
            spec.recipe((Recipe)new AddOrUpdateAnnotationAttribute("org.junit.Test", "timeout", "500", null));
        }

        private static void replaceAttribute$lambda$3(RecipeSpec spec) {
            spec.recipe((Recipe)new AddOrUpdateAnnotationAttribute("org.junit.Test", "timeout", "500", null));
        }

        private static void preserveExistingAttributes$lambda$4(RecipeSpec spec) {
            spec.recipe((Recipe)new AddOrUpdateAnnotationAttribute("org.junit.Test", "timeout", "500", null));
        }

        private static void implicitValueToExplicitValue$lambda$5(RecipeSpec spec) {
            spec.recipe((Recipe)new AddOrUpdateAnnotationAttribute("org.junit.Test", "other", "1", null)).cycles(3);
        }

        private static void dontChangeWhenSetToAddOnly$lambda$6(RecipeSpec spec) {
            spec.recipe((Recipe)new AddOrUpdateAnnotationAttribute("org.junit.Test", "other", "1", Boolean.valueOf(true)));
        }
    }
}

