/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.format.Spaces;
import org.openrewrite.java.format.TabsAndIndents;
import org.openrewrite.java.format.WrappingAndBraces;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0017\u00a8\u0006\u001f"}, d2={"Lorg/openrewrite/java/format/WrappingAndBracesTest;", "Lorg/openrewrite/test/RewriteTest;", "annotatedClassDecl", "", "annotatedClassDeclAlreadyCorrect", "annotatedClassDeclWithModifiers", "annotatedConstructor", "annotatedMethod", "annotatedMethodWithModifier", "annotatedMethodWithModifiers", "annotatedMethodWithTypeParameter", "annotatedVariableAlreadyCorrect", "annotatedVariableDecl", "annotatedVariableDeclInMethodDeclaration", "annotatedVariableDeclWithModifier", "blockEndOnOwnLine", "blockLevelStatements", "conditionalsShouldStartOnNewLines", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "elseNotOnNewLine", "elseOnNewLine", "multipleAnnotatedMethod", "namedStyles", "", "Lorg/openrewrite/style/NamedStyles;", "styles", "", "Lorg/openrewrite/style/Style;", "retainTrailingComments", "rewrite-java-tck"})
public interface WrappingAndBracesTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @NotNull
    public Iterable<NamedStyles> namedStyles(@NotNull Collection<? extends Style> var1);

    @Test
    public void conditionalsShouldStartOnNewLines();

    @Test
    public void blockLevelStatements();

    @Test
    public void blockEndOnOwnLine();

    @Test
    public void annotatedMethod();

    @Test
    public void annotatedMethodWithModifier();

    @Test
    public void annotatedMethodWithModifiers();

    @Test
    public void annotatedMethodWithTypeParameter();

    @Test
    public void multipleAnnotatedMethod();

    @Test
    public void annotatedConstructor();

    @Test
    public void annotatedClassDecl();

    @Test
    public void annotatedClassDeclAlreadyCorrect();

    @Test
    public void annotatedClassDeclWithModifiers();

    @Test
    public void annotatedVariableDecl();

    @Test
    public void annotatedVariableAlreadyCorrect();

    @Test
    public void annotatedVariableDeclWithModifier();

    @Test
    public void annotatedVariableDeclInMethodDeclaration();

    @Test
    public void retainTrailingComments();

    @Test
    public void elseOnNewLine();

    @Test
    public void elseNotOnNewLine();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull WrappingAndBracesTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::defaults$lambda$0));
        }

        @NotNull
        public static Iterable<NamedStyles> namedStyles(@NotNull WrappingAndBracesTest $this, @NotNull Collection<? extends Style> styles) {
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            return CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "Test", "test", "test", SetsKt.emptySet(), styles));
        }

        @Test
        public static void conditionalsShouldStartOnNewLines(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    if (1 == 2) {\n                    } if (1 == 3) {\n                    }\n                }\n            }\n            ", (String)"\n            class Test {\n                void test() {\n                    if (1 == 2) {\n                    }\n                    if (1 == 3) {\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::conditionalsShouldStartOnNewLines$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void blockLevelStatements(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                {        int n = 0;\n                    n++;\n                }\n            }\n            ", (String)"\n            public class Test {\n                {\n                    int n = 0;\n                    n++;\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void blockEndOnOwnLine(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n = 0;}\n            ", (String)"\n            class Test {\n                int n = 0;\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedMethod(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"}) Object method() {\n                    return new Object();\n                }\n            }\n            ", (String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"})\n             Object method() {\n                    return new Object();\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedMethodWithModifier(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"}) public Object method() {\n                    return new Object();\n                }\n            }\n            ", (String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"})\n             public Object method() {\n                    return new Object();\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedMethodWithModifiers(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"}) public final Object method() {\n                    return new Object();\n                }\n            }\n            ", (String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"})\n             public final Object method() {\n                    return new Object();\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedMethodWithTypeParameter(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"}) <T> T method() {\n                    return null;\n                }\n            }\n            ", (String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"})\n             <T> T method() {\n                    return null;\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multipleAnnotatedMethod(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"}) @Deprecated Object method() {\n                    return new Object();\n                }\n            }\n            ", (String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"})\n             @Deprecated\n             Object method() {\n                    return new Object();\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedConstructor(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"}) @Deprecated Test() {\n                }\n            }\n            ", (String)"\n            public class Test {\n                @SuppressWarnings({\"ALL\"})\n             @Deprecated\n             Test() {\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedClassDecl(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            @SuppressWarnings({\"ALL\"}) class Test {\n            }\n            ", (String)"\n            @SuppressWarnings({\"ALL\"})\n             class Test {\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedClassDeclAlreadyCorrect(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            @SuppressWarnings({\"ALL\"}) \n            class Test {\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedClassDeclWithModifiers(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            @SuppressWarnings({\"ALL\"}) public class Test {\n            }\n            ", (String)"\n            @SuppressWarnings({\"ALL\"})\n             public class Test {\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedVariableDecl(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                public void doSomething() {\n                    @SuppressWarnings(\"ALL\") int foo;        \n                }\n            }\n            ", (String)"\n            public class Test {\n                public void doSomething() {\n                    @SuppressWarnings(\"ALL\")\n             int foo;        \n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedVariableAlreadyCorrect(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                public void doSomething() {\n                    @SuppressWarnings(\"ALL\")\n                    int foo;        \n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedVariableDeclWithModifier(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                @SuppressWarnings(\"ALL\") private int foo;        \n            }\n            ", (String)"\n            public class Test {\n                @SuppressWarnings(\"ALL\")\n             private int foo;        \n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedVariableDeclInMethodDeclaration(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                public void doSomething(@SuppressWarnings(\"ALL\") int foo) {\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void retainTrailingComments(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n            int m; /* comment */ int n;}\n            ", (String)"\n            public class Test {\n            int m; /* comment */\n            int n;\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void elseOnNewLine(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                void method(int arg0) {\n                    if (arg0 == 0) {\n                        System.out.println(\"if\");\n                    } else if (arg0 == 1) {\n                        System.out.println(\"else if\");\n                    } else {\n                        System.out.println(\"else\");\n                    }\n                }\n            }\n            ", (String)"\n            public class Test {\n                void method(int arg0) {\n                    if (arg0 == 0) {\n                        System.out.println(\"if\");\n                    }\n                    else if (arg0 == 1) {\n                        System.out.println(\"else if\");\n                    }\n                    else {\n                        System.out.println(\"else\");\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.elseOnNewLine$lambda$5($this, arg_0), sourceSpecsArray);
        }

        @Test
        public static void elseNotOnNewLine(@NotNull WrappingAndBracesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public class Test {\n                void method(int arg0) {\n                    if (arg0 == 0) {\n                        System.out.println(\"if\");\n                    }\n                    else if (arg0 == 1) {\n                        System.out.println(\"else if\");\n                    }\n                    else {\n                        System.out.println(\"else\");\n                    }\n                }\n            }\n            ", (String)"\n            public class Test {\n                void method(int arg0) {\n                    if (arg0 == 0) {\n                        System.out.println(\"if\");\n                    } else if (arg0 == 1) {\n                        System.out.println(\"else if\");\n                    } else {\n                        System.out.println(\"else\");\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.elseNotOnNewLine$lambda$9($this, arg_0), sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda$0() {
            return (TreeVisitor)new WrappingAndBracesVisitor(new WrappingAndBracesStyle(new WrappingAndBracesStyle.IfStatement(Boolean.valueOf(false))));
        }

        private static void conditionalsShouldStartOnNewLines$lambda$1(RecipeSpec spec) {
            spec.recipe(new WrappingAndBraces().doNext((Recipe)new TabsAndIndents()));
        }

        private static TreeVisitor elseOnNewLine$lambda$5$lambda$4() {
            return (TreeVisitor)new WrappingAndBracesVisitor(new WrappingAndBracesStyle(new WrappingAndBracesStyle.IfStatement(Boolean.valueOf(true))));
        }

        /*
         * WARNING - void declaration
         */
        private static void elseOnNewLine$lambda$5(WrappingAndBracesTest this$0, RecipeSpec spec) {
            void $this$elseOnNewLine_u24lambda_u245_u24lambda_u243_u24lambda_u242;
            void $this$elseOnNewLine_u24lambda_u245_u24lambda_u243;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SpacesStyle spacesStyle = IntelliJ.spaces();
            WrappingAndBracesTest wrappingAndBracesTest = this$0;
            JavaParser.Builder builder = JavaParser.fromJavaVersion();
            RecipeSpec recipeSpec = spec;
            boolean bl = false;
            SpacesStyle.BeforeKeywords beforeKeywords = $this$elseOnNewLine_u24lambda_u245_u24lambda_u243.getBeforeKeywords();
            void var5_8 = $this$elseOnNewLine_u24lambda_u245_u24lambda_u243;
            boolean bl2 = false;
            SpacesStyle spacesStyle2 = var5_8.withBeforeKeywords($this$elseOnNewLine_u24lambda_u245_u24lambda_u243_u24lambda_u242.withElseKeyword(Boolean.valueOf(true)));
            recipeSpec.parser((Parser.Builder)builder.styles(wrappingAndBracesTest.namedStyles(CollectionsKt.listOf((Object)spacesStyle2)))).recipe(RewriteTest.toRecipe(DefaultImpls::elseOnNewLine$lambda$5$lambda$4).doNext((Recipe)new TabsAndIndents()));
        }

        private static TreeVisitor elseNotOnNewLine$lambda$9$lambda$8() {
            return (TreeVisitor)new WrappingAndBracesVisitor(new WrappingAndBracesStyle(new WrappingAndBracesStyle.IfStatement(Boolean.valueOf(false))));
        }

        /*
         * WARNING - void declaration
         */
        private static void elseNotOnNewLine$lambda$9(WrappingAndBracesTest this$0, RecipeSpec spec) {
            void $this$elseNotOnNewLine_u24lambda_u249_u24lambda_u247_u24lambda_u246;
            void $this$elseNotOnNewLine_u24lambda_u249_u24lambda_u247;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SpacesStyle spacesStyle = IntelliJ.spaces();
            WrappingAndBracesTest wrappingAndBracesTest = this$0;
            JavaParser.Builder builder = JavaParser.fromJavaVersion();
            RecipeSpec recipeSpec = spec;
            boolean bl = false;
            SpacesStyle.BeforeKeywords beforeKeywords = $this$elseNotOnNewLine_u24lambda_u249_u24lambda_u247.getBeforeKeywords();
            void var5_8 = $this$elseNotOnNewLine_u24lambda_u249_u24lambda_u247;
            boolean bl2 = false;
            SpacesStyle spacesStyle2 = var5_8.withBeforeKeywords($this$elseNotOnNewLine_u24lambda_u249_u24lambda_u247_u24lambda_u246.withElseKeyword(Boolean.valueOf(true)));
            recipeSpec.parser((Parser.Builder)builder.styles(wrappingAndBracesTest.namedStyles(CollectionsKt.listOf((Object)spacesStyle2)))).recipe(RewriteTest.toRecipe(DefaultImpls::elseNotOnNewLine$lambda$9$lambda$8).doNext((Recipe)new Spaces()).doNext((Recipe)new TabsAndIndents()));
        }
    }
}

