/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.MethodNameCasing;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017\u00a8\u0006\u0018"}, d2={"Lorg/openrewrite/java/cleanup/MethodNameCasingTest;", "Lorg/openrewrite/test/RewriteTest;", "applyChangeToTest", "", "changeCamelCaseMethodWithFirstLetterUpperCase", "changeMethodDeclaration", "changeMethodInvocations", "changeMethodNameWhenOverride", "changeNameOfMethodWithArrayArgument", "correctMethodNameCasing", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotApplyToTest", "doNotRenamePublicMethods", "doesNotRenameMethodInvocationsWhenTheMethodDeclarationsClassTypeIsNull", "dontChangeCorrectlyCasedMethods", "keepCamelCaseWhenRemovingLeadingUnderscore", "keepCamelCaseWhenRemovingLeadingUnderscore2", "nameExistsInInnerClass", "newNameExists", "okToRenamePublicMethods", "snakeCaseToCamelCase", "unknownParameterTypes", "rewrite-java-tck"})
public interface MethodNameCasingTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void correctMethodNameCasing();

    @Test
    public void doNotRenamePublicMethods();

    @Test
    public void okToRenamePublicMethods();

    @Test
    public void doNotApplyToTest();

    @Test
    public void applyChangeToTest();

    @Test
    public void changeMethodDeclaration();

    @Test
    public void changeCamelCaseMethodWithFirstLetterUpperCase();

    @Test
    public void changeMethodInvocations();

    @Test
    public void dontChangeCorrectlyCasedMethods();

    @Test
    public void changeMethodNameWhenOverride();

    @Test
    public void newNameExists();

    @Test
    public void nameExistsInInnerClass();

    @Test
    public void snakeCaseToCamelCase();

    @Test
    public void doesNotRenameMethodInvocationsWhenTheMethodDeclarationsClassTypeIsNull();

    @Test
    public void keepCamelCaseWhenRemovingLeadingUnderscore();

    @Test
    public void keepCamelCaseWhenRemovingLeadingUnderscore2();

    @Test
    public void changeNameOfMethodWithArrayArgument();

    @Test
    public void unknownParameterTypes();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull MethodNameCasingTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new MethodNameCasing(Boolean.valueOf(false), Boolean.valueOf(false)));
        }

        @Test
        public static void correctMethodNameCasing(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private String getFoo_bar() {\n                    return \"foobar\";\n                }\n            }\n        ", (String)"\n            class Test {\n                private String getFooBar() {\n                    return \"foobar\";\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRenamePublicMethods(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public void getFoo_bar(){}\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void okToRenamePublicMethods(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public void getFoo_bar(){}\n            }\n        ", (String)"\n            class Test {\n                public void getFooBar(){}\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::okToRenamePublicMethods$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void doNotApplyToTest(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[1];
            SourceSpecs[] sourceSpecsArray2 = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void MyMethod_with_\u00fcber() {\n                    }\n                }\n            ")};
            sourceSpecsArray[0] = Assertions.srcTestJava((SourceSpecs[])sourceSpecsArray2);
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void applyChangeToTest(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[1];
            SourceSpecs[] sourceSpecsArray2 = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void MyMethod_with_\u00fcber() {\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void myMethodWithUber() {\n                    }\n                }\n            ")};
            sourceSpecsArray[0] = Assertions.srcTestJava((SourceSpecs[])sourceSpecsArray2);
            $this.rewriteRun(DefaultImpls::applyChangeToTest$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void changeMethodDeclaration(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void MyMethod_with_\u00fcber() {\n                }\n            }\n        ", (String)"\n            class Test {\n                void myMethodWithUber() {\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void changeCamelCaseMethodWithFirstLetterUpperCase(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void MyMethod() {\n                }\n            }\n        ", (String)"\n            class Test {\n                void myMethod() {\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void changeMethodInvocations(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void MyMethod_with_\u00fcber() {\n                }\n            }\n        ", (String)"\n            class Test {\n                void myMethodWithUber() {\n                }\n            }\n        "), Assertions.java((String)"\n            class A {\n                void test() {\n                    new Test().MyMethod_with_\u00fcber();\n                }\n            }\n        ", (String)"\n            class A {\n                void test() {\n                    new Test().myMethodWithUber();\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void dontChangeCorrectlyCasedMethods(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void dontChange() {\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void changeMethodNameWhenOverride(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class ParentClass {\n                void _method() {\n                }\n            }\n        ", (String)"\n            class ParentClass {\n                void method() {\n                }\n            }\n        "), Assertions.java((String)"\n            class Test extends ParentClass {\n                @Override\n                void _method() {\n                }\n            }\n        ", (String)"\n            class Test extends ParentClass {\n                @Override\n                void method() {\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void newNameExists(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void _method() {\n                }\n                void method() {\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void nameExistsInInnerClass(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void _method(){}\n                \n                private static class M {\n                    void _method(){}\n                }\n            }\n        ", (String)"\n            class T {\n                void method(){}\n                \n                private static class M {\n                    void method(){}\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void snakeCaseToCamelCase(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                private static int SOME_METHOD() {\n                  return 1;\n                }\n                private static int some_method_2() {\n                  return 1;\n                }\n                private static int some_\u00fcber_method() {\n                  return 1;\n                }\n                public static void anotherMethod() {\n                  int i = SOME_METHOD();\n                  i = some_method_2();\n                  i = some_\u00fcber_method();\n                }\n            }\n        ", (String)"\n            class T {\n                private static int someMethod() {\n                  return 1;\n                }\n                private static int someMethod2() {\n                  return 1;\n                }\n                private static int someUberMethod() {\n                  return 1;\n                }\n                public static void anotherMethod() {\n                  int i = someMethod();\n                  i = someMethod2();\n                  i = someUberMethod();\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doesNotRenameMethodInvocationsWhenTheMethodDeclarationsClassTypeIsNull(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package abc;\n            class T {\n                public static int MyMethod() {return -1;}\n                public static void anotherMethod() {\n                    int i = MyMethod();\n                }\n            }\n            ", (String)"\n            package abc;\n            class T {\n                public static int MyMethod() {return -1;}\n                public static void anotherMethod() {\n                    int i = MyMethod();\n                }\n            }\n            ")};
            $this.rewriteRun(DefaultImpls::doesNotRenameMethodInvocationsWhenTheMethodDeclarationsClassTypeIsNull$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void keepCamelCaseWhenRemovingLeadingUnderscore(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private void _theMethod() {\n                \n                }\n            }\n        ", (String)"\n            class Test {\n                private void theMethod() {\n                \n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void keepCamelCaseWhenRemovingLeadingUnderscore2(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            \n            class Test {\n                private List<String> _getNames() {\n                    List<String> result = new ArrayList<>();\n                    result.add(\"Alice\");\n                    result.add(\"Bob\");\n                    result.add(\"Carol\");\n                    return result;\n                }\n                \n                public void run() {\n                    for (String n: _getNames()) {\n                        System.out.println(n);\n                    }\n                }\n            }\n        ", (String)"\n            import java.util.*;\n            \n            class Test {\n                private List<String> getNames() {\n                    List<String> result = new ArrayList<>();\n                    result.add(\"Alice\");\n                    result.add(\"Bob\");\n                    result.add(\"Carol\");\n                    return result;\n                }\n                \n                public void run() {\n                    for (String n: getNames()) {\n                        System.out.println(n);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void changeNameOfMethodWithArrayArgument(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            \n            class Test {\n                private List<String> _getNames(String[] names) {\n                    List<String> result = new ArrayList<>(Arrays.asList(names));\n                    return result;\n                }\n            }\n        ", (String)"\n            import java.util.*;\n            \n            class Test {\n                private List<String> getNames(String[] names) {\n                    List<String> result = new ArrayList<>(Arrays.asList(names));\n                    return result;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void unknownParameterTypes(@NotNull MethodNameCasingTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private void _foo(Unknown u) {\n                }\n            }\n        ", (String)"\n            class Test {\n                private void foo(Unknown u) {\n                }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::unknownParameterTypes$lambda$4, sourceSpecsArray);
        }

        private static void okToRenamePublicMethods$lambda$0(RecipeSpec spec) {
            spec.recipe((Recipe)new MethodNameCasing(Boolean.valueOf(true), Boolean.valueOf(true)));
        }

        private static void applyChangeToTest$lambda$1(RecipeSpec spec) {
            spec.recipe((Recipe)new MethodNameCasing(Boolean.valueOf(true), Boolean.valueOf(false)));
        }

        private static TreeVisitor doesNotRenameMethodInvocationsWhenTheMethodDeclarationsClassTypeIsNull$lambda$3$lambda$2() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p).withType(null);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclarat\u2026ssDecl, p).withType(null)");
                    return classDeclaration;
                }
            };
        }

        private static void doesNotRenameMethodInvocationsWhenTheMethodDeclarationsClassTypeIsNull$lambda$3(RecipeSpec spec) {
            spec.typeValidationOptions(TypeValidation.none()).recipe(RewriteTest.toRecipe(DefaultImpls::doesNotRenameMethodInvocationsWhenTheMethodDeclarationsClassTypeIsNull$lambda$3$lambda$2).doNext((Recipe)new MethodNameCasing(Boolean.valueOf(true), Boolean.valueOf(false))));
        }

        private static void unknownParameterTypes$lambda$4(RecipeSpec spec) {
            spec.typeValidationOptions(TypeValidation.none());
        }
    }
}

