/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.UriCreatedWithHttpScheme;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017\u00a8\u0006\u0015"}, d2={"Lorg/openrewrite/java/search/UriCreatedWithHttpSchemeTest;", "Lorg/openrewrite/test/RewriteTest;", "arbitrary method call chains are not dataflow", "", "arbitrary method calls are not dataflow", "javaParser", "Lorg/openrewrite/java/JavaParser;", "dataflow through ternary operator", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "example of negative taint tracking", "example of taint tracking", "example of taint tracking through an alternate flow path", "find insecure uri", "reassignment breaks data flow path", "reassignment in always evaluated path breaks data flow path", "reassignment within block does not break path", "replace is a barrier guard", "special case toString on String type is DataFlow", "zero step flow is still considered and fixed", "rewrite-java-tck"})
public interface UriCreatedWithHttpSchemeTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void find insecure uri();

    @Test
    public void replace is a barrier guard();

    @Test
    public void reassignment breaks data flow path();

    @Test
    @Disabled(value="MISSING: Assignment dominance of conditional that will always evaluate to true")
    public void reassignment in always evaluated path breaks data flow path();

    @Test
    public void reassignment within block does not break path(@NotNull JavaParser var1);

    @Test
    public void dataflow through ternary operator(@NotNull JavaParser var1);

    @Test
    public void example of taint tracking(@NotNull JavaParser var1);

    @Test
    public void example of taint tracking through an alternate flow path(@NotNull JavaParser var1);

    @Test
    public void example of negative taint tracking(@NotNull JavaParser var1);

    @Test
    public void arbitrary method calls are not dataflow(@NotNull JavaParser var1);

    @Test
    public void arbitrary method call chains are not dataflow();

    @Test
    public void special case toString on String type is DataFlow();

    @Test
    public void zero step flow is still considered and fixed();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull UriCreatedWithHttpSchemeTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new UriCreatedWithHttpScheme());
        }

        @Test
        public static void find insecure uri(@NotNull UriCreatedWithHttpSchemeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        String t = s;\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n                }\n            ", (String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"https://test\";\n                        String t = s;\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replace is a barrier guard(@NotNull UriCreatedWithHttpSchemeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        s = s.replace(\"http://\", \"https://\");\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void reassignment breaks data flow path(@NotNull UriCreatedWithHttpSchemeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        s = \"https://example.com\";\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        @Disabled(value="MISSING: Assignment dominance of conditional that will always evaluate to true")
        public static void reassignment in always evaluated path breaks data flow path(@NotNull UriCreatedWithHttpSchemeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        if (true) {\n                            s = \"https://example.com\";\n                        }\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void reassignment within block does not break path(@NotNull UriCreatedWithHttpSchemeTest $this, @NotNull JavaParser javaParser) {
            Intrinsics.checkNotNullParameter((Object)javaParser, (String)"javaParser");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        if(System.currentTimeMillis() > 0) {\n                            s = \"https://example.com\";\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ", (String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"https://test\";\n                        if(System.currentTimeMillis() > 0) {\n                            s = \"https://example.com\";\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void dataflow through ternary operator(@NotNull UriCreatedWithHttpSchemeTest $this, @NotNull JavaParser javaParser) {
            Intrinsics.checkNotNullParameter((Object)javaParser, (String)"javaParser");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        String t = true ? s : null;\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n                }\n            ", (String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"https://test\";\n                        String t = true ? s : null;\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void example of taint tracking(@NotNull UriCreatedWithHttpSchemeTest $this, @NotNull JavaParser javaParser) {
            Intrinsics.checkNotNullParameter((Object)javaParser, (String)"javaParser");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\" + File.separator;\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ", (String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"https://test\" + File.separator;\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void example of taint tracking through an alternate flow path(@NotNull UriCreatedWithHttpSchemeTest $this, @NotNull JavaParser javaParser) {
            Intrinsics.checkNotNullParameter((Object)javaParser, (String)"javaParser");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        if (System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s + \"/home\"));\n                        } else {\n                            System.out.println(URI.create(s + \"/away\"));\n                        }\n                    }\n                }\n            ", (String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"https://test\";\n                        if (System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s + \"/home\"));\n                        } else {\n                            System.out.println(URI.create(s + \"/away\"));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void example of negative taint tracking(@NotNull UriCreatedWithHttpSchemeTest $this, @NotNull JavaParser javaParser) {
            Intrinsics.checkNotNullParameter((Object)javaParser, (String)"javaParser");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"https://example.com/?redirect=\" + \"http://test\";\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(s));\n                        } else {\n                            System.out.println(URI.create(s));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void arbitrary method calls are not dataflow(@NotNull UriCreatedWithHttpSchemeTest $this, @NotNull JavaParser javaParser) {
            Intrinsics.checkNotNullParameter((Object)javaParser, (String)"javaParser");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        String t = someMethod(s);\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n\n                    String someMethod(String input) {\n                        return null;\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void arbitrary method call chains are not dataflow(@NotNull UriCreatedWithHttpSchemeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.net.URI;\n                import java.util.Locale;\n                class Test {\n                    void test() {\n                        String s = \"http://test\";\n                        String t = s.toLowerCase(Locale.ROOT);\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void special case toString on String type is DataFlow(@NotNull UriCreatedWithHttpSchemeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.net.URI;\n                import java.util.Locale;\n                @SuppressWarnings(\"RedundantSuppression\")\n                class Test {\n                    @SuppressWarnings(\"StringOperationCanBeSimplified\")\n                    void test() {\n                        String s = \"http://test\";\n                        String t = s.toString();\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n                }\n            ", (String)"\n                import java.io.File;\n                import java.net.URI;\n                import java.util.Locale;\n                @SuppressWarnings(\"RedundantSuppression\")\n                class Test {\n                    @SuppressWarnings(\"StringOperationCanBeSimplified\")\n                    void test() {\n                        String s = \"https://test\";\n                        String t = s.toString();\n                        if(System.currentTimeMillis() > 0) {\n                            System.out.println(URI.create(t));\n                        } else {\n                            System.out.println(URI.create(t));\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void zero step flow is still considered and fixed(@NotNull UriCreatedWithHttpSchemeTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        URI uri = URI.create(\"http://test\");\n                    }\n                }\n            ", (String)"\n                import java.net.URI;\n                class Test {\n                    void test() {\n                        URI uri = URI.create(\"https://test\");\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

