/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.CovariantEquals;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/cleanup/CovariantEqualsTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "ignoreIfAtLeastOneExistingNonCovariantEqualsMethod", "ignoreIfNoExistingEqualsMethod", "renameExistingParameterNameWhenParameterNameIsDefaultTemplateName", "replaceEqualsBasedOnTypeSignature", "replaceEqualsMaintainsExistingAnnotations", "replaceMultiStatementReturnBody", "replaceWithNonCovariantEquals", "replaceWithNonCovariantEqualsWhenNested", "rewrite-java-tck"})
public interface CovariantEqualsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void replaceWithNonCovariantEquals();

    @Test
    public void replaceMultiStatementReturnBody();

    @Test
    public void replaceEqualsBasedOnTypeSignature();

    @Test
    public void replaceEqualsMaintainsExistingAnnotations();

    @Test
    public void replaceWithNonCovariantEqualsWhenNested();

    @Test
    public void renameExistingParameterNameWhenParameterNameIsDefaultTemplateName();

    @Test
    public void ignoreIfAtLeastOneExistingNonCovariantEqualsMethod();

    @Test
    public void ignoreIfNoExistingEqualsMethod();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull CovariantEqualsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new CovariantEquals());
        }

        @Test
        public static void replaceWithNonCovariantEquals(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n\n                public boolean equals(Test tee) {\n                    return n == tee.n;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n\n                @Override\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    Test tee = (Test) obj;\n                    return n == tee.n;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceMultiStatementReturnBody(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                String id;\n\n                public boolean equals(A other) {\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ", (String)"\n            class A {\n                String id;\n\n                @Override\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    A other = (A) obj;\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceEqualsBasedOnTypeSignature(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n                public void placeholder(Test test) {}\n                public void placeholder(Object test) {}\n\n                public boolean equals(Number test) {\n                    return false;\n                }\n\n                public boolean equals(Test test) {\n                    return n == test.n;\n                }\n\n                public boolean equals() {\n                    return false;\n                }\n\n                public boolean equals(String test) {\n                    return false;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n                public void placeholder(Test test) {}\n                public void placeholder(Object test) {}\n\n                public boolean equals(Number test) {\n                    return false;\n                }\n\n                @Override\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    Test test = (Test) obj;\n                    return n == test.n;\n                }\n\n                public boolean equals() {\n                    return false;\n                }\n\n                public boolean equals(String test) {\n                    return false;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceEqualsMaintainsExistingAnnotations(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                String id;\n\n                @SuppressWarnings(\"all\")\n                public boolean equals(A other) {\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ", (String)"\n            class A {\n                String id;\n\n                @Override\n                @SuppressWarnings(\"all\")\n                public boolean equals(Object obj) {\n                    if (obj == this) return true;\n                    if (obj == null || getClass() != obj.getClass()) return false;\n                    A other = (A) obj;\n                    boolean isEqual = id.equals(other.id);\n                    return isEqual;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void replaceWithNonCovariantEqualsWhenNested(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                class B {\n                    int n;\n\n                    public boolean equals(B bee) {\n                        return n == bee.n;\n                    }\n                }\n            }\n        ", (String)"\n            class A {\n                class B {\n                    int n;\n\n                    @Override\n                    public boolean equals(Object obj) {\n                        if (obj == this) return true;\n                        if (obj == null || getClass() != obj.getClass()) return false;\n                        B bee = (B) obj;\n                        return n == bee.n;\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameExistingParameterNameWhenParameterNameIsDefaultTemplateName(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int n;\n\n                public boolean equals(Test obj) {\n                    return n == obj.n;\n                }\n            }\n        ", (String)"\n            class Test {\n                int n;\n\n                @Override\n                public boolean equals(Object other) {\n                    if (other == this) return true;\n                    if (other == null || getClass() != other.getClass()) return false;\n                    Test obj = (Test) other;\n                    return n == obj.n;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void ignoreIfAtLeastOneExistingNonCovariantEqualsMethod(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public boolean equals(Test t) {\n                    return false;\n                }\n\n                public boolean equals(Object i) {\n                    return false;\n                }\n                \n                public boolean equals(Object i, Test t) {\n                    return false;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void ignoreIfNoExistingEqualsMethod(@NotNull CovariantEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {}\n            \n            class B {\n                B() {}\n                public void placeholder(B t) {}\n                public void placeholder(Object t) {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

