/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.ReferentialEqualityToObjectEquals;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/cleanup/ReferentialEqualityToObjectEqualsTest;", "Lorg/openrewrite/test/RewriteTest;", "bothSidesOverrideEquals", "", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotModifyWithinEqualsMethod", "doesNotModifyBoxedTypes", "doesNotModifyClassComparisons", "doesNotModifyEnumComparison", "onlyOneSideOverridesEquals", "typeDoesNotOverrideEquals", "rewrite-java-tck"})
public interface ReferentialEqualityToObjectEqualsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void doesNotModifyBoxedTypes();

    @Test
    public void doesNotModifyEnumComparison();

    @Test
    public void doesNotModifyClassComparisons();

    @Test
    public void typeDoesNotOverrideEquals();

    @Test
    public void onlyOneSideOverridesEquals();

    @Test
    public void doNotModifyWithinEqualsMethod();

    @Test
    public void bothSidesOverrideEquals();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull ReferentialEqualityToObjectEqualsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ReferentialEqualityToObjectEquals());
        }

        @Test
        public static void doesNotModifyBoxedTypes(@NotNull ReferentialEqualityToObjectEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class C {\n                char c = 'c';\n                boolean isC(Integer value){\n                    return value == c || value == 99;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doesNotModifyEnumComparison(@NotNull ReferentialEqualityToObjectEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class B {\n                  private void method() {\n                    if(Foo.FOO == Foo.BAR) {}\n                  }\n                  enum Foo {FOO, BAR}\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doesNotModifyClassComparisons(@NotNull ReferentialEqualityToObjectEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class A {\n                    void check() {\n                        B b = new B();\n                        if(b == this) {}\n                    }\n                    \n                    class B {\n                        @Override\n                        public boolean equals(Object anObject) {return true;}\n                    }\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void typeDoesNotOverrideEquals(@NotNull ReferentialEqualityToObjectEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    B b1 = new B();\n                    if (a1 == b1) {}\n                }\n                class A {}\n                class B {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void onlyOneSideOverridesEquals(@NotNull ReferentialEqualityToObjectEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    B b1 = new B();\n                    if (a1 == b1) {}\n                }\n                class A {\n                    @Override\n                    public boolean equals(Object anObject) {return true;}\n                }\n                class B {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotModifyWithinEqualsMethod(@NotNull ReferentialEqualityToObjectEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                String s1;\n                String s2;\n                @Override\n                public boolean equals(Object obj) {\n                    if (s1 != s2) {}\n                    if (s1 == s2) {}\n                    return super.equals(obj);\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void bothSidesOverrideEquals(@NotNull ReferentialEqualityToObjectEqualsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    A a2 = new A();\n                    if (a1 == a2) {}\n                }\n                class A {\n                    @Override\n                    public boolean equals(Object anObject) {return true;}\n                }\n            }\n        ", (String)"\n            class T {\n                void doSomething() {\n                    A a1 = new A();\n                    A a2 = new A();\n                    if (a1.equals(a2)) {}\n                }\n                class A {\n                    @Override\n                    public boolean equals(Object anObject) {return true;}\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

