/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.MinimumSwitchCases;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/cleanup/MinimumSwitchCasesTest;", "Lorg/openrewrite/test/RewriteTest;", "defaultOnly", "", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "importsOnEnum", "noCases", "onePrimitive", "oneString", "primitiveAndDefault", "removeBreaksFromCaseBody", "stringAndDefault", "twoPrimitives", "twoStrings", "rewrite-java-tck"})
public interface MinimumSwitchCasesTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void primitiveAndDefault();

    @Test
    public void twoPrimitives();

    @Test
    public void stringAndDefault();

    @Test
    public void twoStrings();

    @Test
    public void onePrimitive();

    @Test
    public void oneString();

    @Test
    public void noCases();

    @Test
    public void importsOnEnum();

    @Test
    public void removeBreaksFromCaseBody();

    @Test
    public void defaultOnly();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull MinimumSwitchCasesTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new MinimumSwitchCases());
        }

        @Test
        public static void primitiveAndDefault(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    int variable;\n                    void test() {\n                        switch (variable) {\n                          case 0:\n                              doSomething();\n                              break;\n                          default:\n                              doSomethingElse();\n                              break;\n                        }\n                    }\n                    void doSomething() {}\n                    void doSomethingElse() {}\n                }\n            ", (String)"\n                class Test {\n                    int variable;\n                    void test() {\n                        if (variable == 0) {\n                            doSomething();\n                        } else {\n                            doSomethingElse();\n                        }\n                    }\n                    void doSomething() {}\n                    void doSomethingElse() {}\n                }\n            ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void twoPrimitives(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int variable;\n                void test() {\n                    switch (variable) {\n                      case 0:\n                          doSomething();\n                          break;\n                      case 1:\n                          doSomethingElse();\n                          break;\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ", (String)"\n            class Test {\n                int variable;\n                void test() {\n                    if (variable == 0) {\n                        doSomething();\n                    } else if (variable == 1) {\n                        doSomethingElse();\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void stringAndDefault(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\":\n                          doSomething();\n                          break;\n                      default:\n                          doSomethingElse();\n                          break;\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    } else {\n                        doSomethingElse();\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void twoStrings(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\":\n                          doSomething();\n                          break;\n                      case \"jon\":\n                          doSomethingElse();\n                          break;\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    } else if (\"jon\".equals(name)) {\n                        doSomethingElse();\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void onePrimitive(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int variable;\n                void test() {\n                    switch (variable) {\n                      case 0:\n                          doSomething();\n                          break;\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ", (String)"\n            class Test {\n                int variable;\n                void test() {\n                    if (variable == 0) {\n                        doSomething();\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void oneString(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\":\n                          doSomething();\n                          break;\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void noCases(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int variable;\n                void test() {\n                    switch (variable) {\n                    }\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void importsOnEnum(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.time.DayOfWeek;\n\n            class Test {\n                DayOfWeek day;\n\n                void test() {\n                    switch(day) {\n                        case MONDAY:\n                            someMethod();\n                            break;\n                    }\n                    switch(day) {\n                        case MONDAY:\n                            someMethod();\n                        default:\n                            someMethod();\n                            break;\n                    }\n                    switch (day) {\n                        case MONDAY:\n                            someMethod();\n                            break;\n                        case TUESDAY:\n                            someMethod();\n                            break;\n                    }\n                }\n\n                void someMethod() {\n                }\n            }\n        ", (String)"\n            import java.time.DayOfWeek;\n\n            class Test {\n                DayOfWeek day;\n\n                void test() {\n                    if (day == DayOfWeek.MONDAY) {\n                        someMethod();\n                    }\n                    if (day == DayOfWeek.MONDAY) {\n                        someMethod();\n                    } else {\n                        someMethod();\n                    }\n                    if (day == DayOfWeek.MONDAY) {\n                        someMethod();\n                    } else if (day == DayOfWeek.TUESDAY) {\n                        someMethod();\n                    }\n                }\n\n                void someMethod() {\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeBreaksFromCaseBody(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String name;\n                void test() {\n                    switch (name) {\n                      case \"jonathan\": {\n                          doSomething();\n                          break;\n                      }\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ", (String)"\n            class Test {\n                String name;\n                void test() {\n                    if (\"jonathan\".equals(name)) {\n                        doSomething();\n                    }\n                }\n                void doSomething() {}\n                void doSomethingElse() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void defaultOnly(@NotNull MinimumSwitchCasesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            enum Test {\n                A, B, C;\n        \n                @Override\n                public String toString() {\n                    String s;\n                    switch (this) {\n                        default:\n                            s = this.name();\n                            break;\n                    }\n                    switch(this) {\n                        default:\n                            return s;\n                    }\n                }\n            }\n        ", (String)"\n            enum Test {\n                A, B, C;\n        \n                @Override\n                public String toString() {\n                    String s;\n                    s = this.name();\n                    return s;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

