/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.FindMissingTypes;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/FindMissingTypesTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "missingAnnotationType", "newClass", "variableDeclaration", "jp", "Lorg/openrewrite/java/JavaParser;", "rewrite-java-tck"})
public interface FindMissingTypesTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void missingAnnotationType();

    @Test
    public void variableDeclaration(@NotNull JavaParser var1);

    @Test
    public void newClass();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull FindMissingTypesTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new FindMissingTypes()).typeValidationOptions(TypeValidation.none());
        }

        @Test
        public static void missingAnnotationType(@NotNull FindMissingTypesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import org.junit.Test;\n            \n            class A {\n                @Test\n                void foo() {}\n            }\n        ", (String)"\n            import org.junit.Test;\n\n            class A {\n                @/*~~(Identifier type is missing or malformed)~~>*/Test\n                void foo() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void variableDeclaration(@NotNull FindMissingTypesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                {\n                    Foo f;\n                }\n            }\n        ", (String)"\n            class A {\n                {\n                    /*~~(Identifier type is missing or malformed)~~>*/Foo f;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void newClass(@NotNull FindMissingTypesTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import some.org.Unknown;\n            \n            class A {\n                {\n                    Object o = new Unknown();\n                }\n            }\n        ", (String)"\n            import some.org.Unknown;\n            \n            class A {\n                {\n                    Object o = /*~~(NewClass type is missing or malformed)~~>*/new Unknown();\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }
    }
}

