/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.ChangePackage;
import org.openrewrite.java.ChangePackageTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u001f\bf\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\r\u001a\u00020\bH\u0017J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000f\u001a\u00020\bH\u0017J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u001b\u001a\u00020\bH\u0017J\b\u0010\u001c\u001a\u00020\bH\u0017J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u001e\u001a\u00020\bH\u0017J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\"\u001a\u00020\bH\u0017J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010'\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010(\u001a\u00020\bH\u0017J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010+\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010,\u001a\u00020\bH\u0017J\b\u0010-\u001a\u00020\bH\u0017J\b\u0010.\u001a\u00020\bH\u0017J\b\u0010/\u001a\u00020\bH\u0017J\b\u00100\u001a\u00020\bH\u0017J\b\u00101\u001a\u00020\bH\u0017J\u0010\u00102\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00064"}, d2={"Lorg/openrewrite/java/ChangePackageTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "Lorg/openrewrite/test/RewriteTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "annotation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "array", "assignment", "boundedGenericType", "changeTypeWithInnerClass", "checkValidation", "classDecl", "classReference", "classTypeParameter", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "dontAddImportWhenNoChangesWereMade", "lambda", "method", "methodInvocationTypeParametersAndWildcard", "methodSelect", "moveToSubPackageDoNotRemoveImport", "moveToSubPackageRemoveImport", "multiCatch", "multiDimensionalArray", "multiVariable", "newClass", "parameterizedType", "removePackage", "renameImport", "renamePackage", "renamePackageNonRecursive", "renamePackageRecursive", "renamePackageRecursiveImported", "renameSingleSegmentPackage", "staticImport", "typeCast", "typeParameter", "typesInUseContainsOneMethodTypeReference", "typesInUseContainsOneTypeReference", "updateClassPrefixWithEmptyPackage", "updateImportPrefixWithEmptyPackage", "updateMethodType", "updateVariableType", "updatesImplements", "Companion", "rewrite-java-tck"})
public interface ChangePackageTest
extends JavaRecipeTest,
RewriteTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangePackageTest$Companion.$$INSTANCE;

    @NotNull
    public Recipe getRecipe();

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void renamePackageNonRecursive(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenNoChangesWereMade(@NotNull JavaParser var1);

    @Test
    public void renameImport(@NotNull JavaParser var1);

    @Test
    public void typesInUseContainsOneTypeReference();

    @Test
    public void typesInUseContainsOneMethodTypeReference();

    @Test
    public void updateMethodType();

    @Test
    public void updateVariableType();

    @Test
    public void renamePackage(@NotNull JavaParser var1);

    @Test
    public void renamePackageRecursive(@NotNull JavaParser var1);

    @Test
    public void renamePackageRecursiveImported(@NotNull JavaParser var1);

    @Test
    public void typeParameter(@NotNull JavaParser var1);

    @Test
    public void classTypeParameter(@NotNull JavaParser var1);

    @Test
    public void boundedGenericType();

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void multiDimensionalArray();

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void updatesImplements(@NotNull JavaParser var1);

    @Test
    public void moveToSubPackageRemoveImport();

    @Test
    public void moveToSubPackageDoNotRemoveImport();

    @Test
    public void lambda(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void assignment(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void parameterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Test
    public void classReference(@NotNull JavaParser var1);

    @Test
    public void methodSelect(@NotNull JavaParser var1);

    @Test
    public void staticImport(@NotNull JavaParser var1);

    @Test
    public void changeTypeWithInnerClass(@NotNull JavaParser var1);

    @Test
    public void updateImportPrefixWithEmptyPackage();

    @Test
    public void updateClassPrefixWithEmptyPackage();

    @Test
    public void renameSingleSegmentPackage();

    @Test
    public void removePackage();

    @Test
    public void checkValidation();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/ChangePackageTest$Companion;", "", "()V", "testClass", "", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String testClass;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            testClass = "package org.openrewrite;\npublic class Test extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull ChangePackageTest this_) {
            return (Recipe)new ChangePackage("org.openrewrite", "org.openrewrite.test", null);
        }

        public static void defaults(@NotNull ChangePackageTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(this_.getRecipe());
        }

        @Test
        public static void renamePackageNonRecursive(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)new ChangePackage("org.openrewrite", "org.openrewrite.test", Boolean.valueOf(false)), null, "\n            package org.openrewrite.internal;\n            class Test {\n            }\n        ", null, 20, null);
        }

        @Test
        public static void dontAddImportWhenNoChangesWereMade(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "\n            public class B {}\n        ", null, 22, null);
        }

        @Test
        public static void renameImport(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public class Test {\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import org.openrewrite.Test;\n            \n            class A {\n            }\n        ", stringArray2, " \n            import org.openrewrite.test.Test;\n            \n            class A {\n            }\n        ", 0, 0, null, renameImport.1.INSTANCE, 454, null);
        }

        @Test
        public static void typesInUseContainsOneTypeReference(@NotNull ChangePackageTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test a;\n                Test b;\n                Test c;\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test a;\n                Test b;\n                Test c;\n            }\n        ", 0, 0, null, typesInUseContainsOneTypeReference.1.INSTANCE, 455, null);
        }

        @Test
        public static void typesInUseContainsOneMethodTypeReference(@NotNull ChangePackageTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import org.openrewrite.Test;\n            \n            public class A {\n                void method() {\n                    Test a = test(null);\n                    Test b = test(null);\n                    Test c = test(null);\n                }\n                \n                Test test(Test test) {\n                    return test;\n                }\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                void method() {\n                    Test a = test(null);\n                    Test b = test(null);\n                    Test c = test(null);\n                }\n                \n                Test test(Test test) {\n                    return test;\n                }\n            }\n        ", 0, 0, null, typesInUseContainsOneMethodTypeReference.1.INSTANCE, 455, null);
        }

        @Test
        public static void updateMethodType(@NotNull ChangePackageTest this_) {
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public class Test {\n            }\n            ", "\n            package org.foo;\n            \n            import org.openrewrite.Test;\n            \n            public class Example {\n                public static Test method(Test test) {\n                    return test;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import org.openrewrite.Test;\n            import org.foo.Example;\n            \n            public class A {\n                Test local = Example.method(null);\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            import org.foo.Example;\n            \n            public class A {\n                Test local = Example.method(null);\n            }\n        ", 0, 0, null, updateMethodType.1.INSTANCE, 455, null);
        }

        @Test
        public static void updateVariableType(@NotNull ChangePackageTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test a;\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test a;\n            }\n        ", 0, 0, null, updateVariableType.1.INSTANCE, 455, null);
        }

        @Test
        public static void renamePackage(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            package org.openrewrite;\n            class Test {\n            }\n        ", null, " \n            package org.openrewrite.test;\n            class Test {\n            }\n        ", 0, 0, null, renamePackage.1.INSTANCE, 470, null);
        }

        @Test
        public static void renamePackageRecursive(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            package org.openrewrite.internal;\n            class Test {\n            }\n        ", null, " \n            package org.openrewrite.test.internal;\n            class Test {\n            }\n        ", 0, 0, null, renamePackageRecursive.1.INSTANCE, 470, null);
        }

        @Test
        public static void renamePackageRecursiveImported(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangePackage changePackage = new ChangePackage("org.openrewrite", "org.openrewrite.test", Boolean.valueOf(true));
            String[] stringArray = new String[]{"\n            package org.openrewrite.other;\n            public class Test {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changePackage, null, "\n            import org.openrewrite.other.Test;\n            class A {\n                Test test = null;\n            }\n        ", stringArray2, " \n            import org.openrewrite.test.other.Test;\n            class A {\n                Test test = null;\n            }\n        ", 0, 0, null, renamePackageRecursiveImported.1.INSTANCE, 452, null);
        }

        @Test
        public static void typeParameter(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public class Test {\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import org.openrewrite.Test;\n            import java.util.List;\n            \n            class A {\n                List<Test> list;\n            }\n        ", stringArray2, " \n            import org.openrewrite.test.Test;\n            import java.util.List;\n            \n            class A {\n                List<Test> list;\n            }\n        ", 0, 0, null, typeParameter.1.INSTANCE, 454, null);
        }

        @Test
        public static void classTypeParameter(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public class Test {\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import org.openrewrite.Test;\n            \n            class A<T extends Test> {\n            }\n        ", stringArray2, " \n            import org.openrewrite.test.Test;\n            \n            class A<T extends Test> {\n            }\n        ", 0, 0, null, classTypeParameter.1.INSTANCE, 454, null);
        }

        @Test
        public static void boundedGenericType(@NotNull ChangePackageTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import org.openrewrite.Test;\n            \n            public class A {\n                <T extends Test> T method(T t) {\n                    return t;\n                }\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                <T extends Test> T method(T t) {\n                    return t;\n                }\n            }\n        ", 0, 0, null, boundedGenericType.1.INSTANCE, 455, null);
        }

        @Test
        public static void annotation(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package org.openrewrite;\n                \n                import java.lang.annotation.ElementType;\n                import java.lang.annotation.Retention;\n                import java.lang.annotation.RetentionPolicy;\n                import java.lang.annotation.Target;\n                \n                @Target({ElementType.TYPE, ElementType.METHOD})\n                @Retention(RetentionPolicy.RUNTIME)\n                public @interface Test {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import org.openrewrite.Test;\n            public class A {\n                @Test\n                void method() {}\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            public class A {\n                @Test\n                void method() {}\n            }\n        ", 0, 0, null, annotation.1.INSTANCE, 454, null);
        }

        @Test
        public static void array(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class B {\n               org.openrewrite.Test[] a = new org.openrewrite.Test[0];\n            }\n        ", stringArray2, "\n            public class B {\n               org.openrewrite.test.Test[] a = new org.openrewrite.test.Test[0];\n            }\n        ", 0, 0, null, array.1.INSTANCE, 454, null);
        }

        @Test
        public static void multiDimensionalArray(@NotNull ChangePackageTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test[][] multiDimensionalArray;\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test[][] multiDimensionalArray;\n            }\n        ", 0, 0, null, multiDimensionalArray.1.INSTANCE, 455, null);
        }

        @Test
        public static void classDecl(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass, "public interface I1 {}"};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class B extends org.openrewrite.Test implements I1 {}\n        ", stringArray2, "\n            public class B extends org.openrewrite.test.Test implements I1 {}\n        ", 0, 0, null, classDecl.1.INSTANCE, 454, null);
        }

        @Test
        public static void updatesImplements(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package org.openrewrite;\n                public interface Oi{}\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            package org.openrewrite;\n            \n            public class Mi implements org.openrewrite.Oi {\n            }\n        ", stringArray2, "\n            package org.openrewrite.test;\n            \n            public class Mi implements org.openrewrite.test.Oi {\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void moveToSubPackageRemoveImport(@NotNull ChangePackageTest this_) {
            ChangePackage changePackage = new ChangePackage("com.acme.project", "com.acme.product", null);
            String[] stringArray = new String[]{"\n            package com.acme.product;\n\n            public class RunnableFactory {\n                public static Runnable getRunnable() {\n                    return null;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)changePackage, null, "\n            package com.acme.project;\n\n            import com.acme.product.RunnableFactory;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ", stringArray2, "\n            package com.acme.product;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @Test
        public static void moveToSubPackageDoNotRemoveImport(@NotNull ChangePackageTest this_) {
            ChangePackage changePackage = new ChangePackage("com.acme.project", "com.acme.product", Boolean.valueOf(true));
            String[] stringArray = new String[]{"\n            package com.acme.product;\n\n            public class RunnableFactory {\n                public static Runnable getRunnable() {\n                    return null;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)changePackage, null, "\n            package com.acme.project.other;\n\n            import com.acme.product.RunnableFactory;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ", stringArray2, "\n            package com.acme.product.other;\n            \n            import com.acme.product.RunnableFactory;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    RunnableFactory.getRunnable().run();\n                }\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @Test
        public static void lambda(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite;\n            public interface Procedure {\n                void execute();\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import org.openrewrite.Procedure;\n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {});\n                }\n                abstract void worker(Procedure procedure);\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Procedure;\n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {});\n                }\n                abstract void worker(Procedure procedure);\n            }\n        ", 0, 0, null, lambda.1.INSTANCE, 455, null);
        }

        @Test
        public static void method(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class A {\n               public org.openrewrite.Test foo() { return null; }\n            }\n        ", stringArray2, "\n            public class A {\n               public org.openrewrite.test.Test foo() { return null; }\n            }\n        ", 0, 0, null, method.1.INSTANCE, 454, null);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass, "\n            package org.openrewrite;\n            public class ThingOne {            \n            }\n        ", "\n            package org.openrewrite;\n            public class ThingTwo {\n                public static ThingOne getThingOne() {\n                    return new ThingOne();\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import java.util.List;\n            import org.openrewrite.ThingOne;\n            import org.openrewrite.ThingTwo;\n            public class B {\n                public <T extends org.openrewrite.Test> T generic(T n, List<? super org.openrewrite.Test> in) {\n                    return null;\n                }\n                public void test() {\n                    org.openrewrite.Test.stat();\n                    this.<org.openrewrite.Test>generic(null, null);\n                    ThingOne t1 = ThingTwo.getThingOne();\n                }\n            }\n        ", stringArray2, "\n            import java.util.List;\n            import org.openrewrite.test.ThingOne;\n            import org.openrewrite.test.ThingTwo;\n            public class B {\n                public <T extends org.openrewrite.test.Test> T generic(T n, List<? super org.openrewrite.test.Test> in) {\n                    return null;\n                }\n                public void test() {\n                    org.openrewrite.test.Test.stat();\n                    this.<org.openrewrite.test.Test>generic(null, null);\n                    ThingOne t1 = ThingTwo.getThingOne();\n                }\n            }\n        ", 0, 0, null, methodInvocationTypeParametersAndWildcard.1.INSTANCE, 454, null);
        }

        @Test
        public static void multiCatch(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class B {\n               public void test() {\n                   try {System.out.println();}\n                   catch(org.openrewrite.Test | RuntimeException ignored) {}\n               }\n            }\n        ", stringArray2, "\n            public class B {\n               public void test() {\n                   try {System.out.println();}\n                   catch(org.openrewrite.test.Test | RuntimeException ignored) {}\n               }\n            }\n        ", 0, 0, null, multiCatch.1.INSTANCE, 454, null);
        }

        @Test
        public static void multiVariable(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class B {\n               org.openrewrite.Test f1, f2;\n            }\n        ", stringArray2, "\n            public class B {\n               org.openrewrite.test.Test f1, f2;\n            }\n        ", 0, 0, null, multiVariable.1.INSTANCE, 454, null);
        }

        @Test
        public static void assignment(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            public class B {\n               org.openrewrite.Test t;\n               void method(org.openrewrite.Test param) {\n                   t = param;\n               }\n            }\n        ", stringArray2, "\n            public class B {\n               org.openrewrite.test.Test t;\n               void method(org.openrewrite.test.Test param) {\n                   t = param;\n               }\n            }\n        ", 0, 0, null, assignment.1.INSTANCE, 455, null);
        }

        @Test
        public static void newClass(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class B {\n               org.openrewrite.Test test = new org.openrewrite.Test();\n            }\n        ", stringArray2, "\n            public class B {\n               org.openrewrite.test.Test test = new org.openrewrite.test.Test();\n            }\n        ", 0, 0, null, newClass.1.INSTANCE, 454, null);
        }

        @Test
        public static void parameterizedType(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class B {\n               Map<org.openrewrite.Test, org.openrewrite.Test> m;\n            }\n        ", stringArray2, "\n            public class B {\n               Map<org.openrewrite.test.Test, org.openrewrite.test.Test> m;\n            }\n        ", 0, 0, null, parameterizedType.1.INSTANCE, 454, null);
        }

        @Test
        public static void typeCast(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import org.openrewrite.Test;\n            \n            public class A {\n                Test method(Object obj) {\n                    return (Test) obj;\n                }\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            \n            public class A {\n                Test method(Object obj) {\n                    return (Test) obj;\n                }\n            }\n        ", 0, 0, null, typeCast.1.INSTANCE, 454, null);
        }

        @Test
        public static void classReference(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import org.openrewrite.Test;\n            public class Test {\n                Class<?> clazz = Test.class;\n            }\n        ", stringArray2, "\n            import org.openrewrite.test.Test;\n            public class Test {\n                Class<?> clazz = Test.class;\n            }\n        ", 0, 0, null, classReference.1.INSTANCE, 454, null);
        }

        @Test
        public static void methodSelect(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            public class B {\n               org.openrewrite.Test test = null;\n               public void getFoo() { test.foo(); }\n            }\n        ", stringArray2, "\n            public class B {\n               org.openrewrite.test.Test test = null;\n               public void getFoo() { test.foo(); }\n            }\n        ", 0, 0, null, methodSelect.1.INSTANCE, 454, null);
        }

        @Test
        public static void staticImport(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangePackageTest$Companion.testClass};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import static org.openrewrite.Test.stat;\n\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", stringArray2, "\n            import static org.openrewrite.test.Test.stat;\n\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", 0, 0, null, staticImport.1.INSTANCE, 454, null);
        }

        @Test
        public static void changeTypeWithInnerClass(@NotNull ChangePackageTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangePackage changePackage = new ChangePackage("com.acme.product", "com.acme.product.v2", null);
            String[] stringArray = new String[]{"\n                package com.acme.product;\n                \n                public class OuterClass {\n                    public static class InnerClass {\n                \n                    }\n                }\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)changePackage, null, "\n            package de;\n            \n            import com.acme.product.OuterClass.InnerClass;\n            import com.acme.product.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ", stringArray2, "\n            package de;\n\n            import com.acme.product.v2.OuterClass.InnerClass;\n            import com.acme.product.v2.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @Test
        public static void updateImportPrefixWithEmptyPackage(@NotNull ChangePackageTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            \n            import java.util.List;\n            \n            class Test {\n            }\n            ", (String)"\n            import java.util.List;\n            \n            class Test {\n            }\n            ")};
            this_.rewriteRun(DefaultImpls::updateImportPrefixWithEmptyPackage$lambda-0, sourceSpecsArray);
        }

        @Test
        public static void updateClassPrefixWithEmptyPackage(@NotNull ChangePackageTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package a.b;\n            \n            class Test {\n            }\n            ", (String)"\n            class Test {\n            }\n            ")};
            this_.rewriteRun(DefaultImpls::updateClassPrefixWithEmptyPackage$lambda-1, sourceSpecsArray);
        }

        @Test
        public static void renameSingleSegmentPackage(@NotNull ChangePackageTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package x;\n            \n            class A {\n            }\n        ", (String)"\n            package y;\n            \n            class A {\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::renameSingleSegmentPackage$lambda-2, sourceSpecsArray);
        }

        @Test
        public static void removePackage(@NotNull ChangePackageTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package x.y.z;\n            \n            class A {\n            }\n        ", (String)"\n            package x;\n            \n            class A {\n            }\n        ")};
            this_.rewriteRun(DefaultImpls::removePackage$lambda-3, sourceSpecsArray);
        }

        @Test
        public static void checkValidation(@NotNull ChangePackageTest this_) {
            ChangePackage recipe2 = new ChangePackage(null, null, null);
            Validated valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(2);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newPackageName");
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(1)).getProperty()).isEqualTo("oldPackageName");
            recipe2 = new ChangePackage(null, "java.lang.String", null);
            valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("oldPackageName");
            recipe2 = new ChangePackage("java.lang.String", null, null);
            valid = recipe2.validate();
            org.assertj.core.api.Assertions.assertThat((boolean)valid.isValid()).isFalse();
            org.assertj.core.api.Assertions.assertThat((List)valid.failures()).hasSize(1);
            org.assertj.core.api.Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newPackageName");
        }

        @NotNull
        public static JavaParser getParser(@NotNull ChangePackageTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ChangePackageTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ChangePackageTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ChangePackageTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull ChangePackageTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ChangePackageTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangePackageTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangePackageTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ChangePackageTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ChangePackageTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ChangePackageTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ChangePackageTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ChangePackageTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ChangePackageTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        private static void updateImportPrefixWithEmptyPackage$lambda-0(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("a.b", "", Boolean.valueOf(false)));
        }

        private static void updateClassPrefixWithEmptyPackage$lambda-1(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("a.b", "", Boolean.valueOf(false)));
        }

        private static void renameSingleSegmentPackage$lambda-2(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("x", "y", Boolean.valueOf(false)));
        }

        private static void removePackage$lambda-3(RecipeSpec spec) {
            spec.recipe((Recipe)new ChangePackage("x.y.z", "x", Boolean.valueOf(false)));
        }
    }
}

