/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.FindImports;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/search/FindImportsTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "exactMatch", "starImport", "starImportMatchesExact", "typeMatcherOnImports", "rewrite-java-tck"})
public interface FindImportsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void typeMatcherOnImports();

    @Test
    public void exactMatch();

    @Test
    public void starImport();

    @Test
    public void starImportMatchesExact();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull FindImportsTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new FindImports("java.util..*"));
        }

        @Test
        public static void typeMatcherOnImports(@NotNull FindImportsTest this_) {
            org.assertj.core.api.Assertions.assertThat((boolean)new TypeMatcher("java.util..*").matchesPackage("java.util.List")).isTrue();
            org.assertj.core.api.Assertions.assertThat((boolean)new TypeMatcher("java.util..*").matchesPackage("java.util.concurrent.*")).isTrue();
            org.assertj.core.api.Assertions.assertThat((boolean)new TypeMatcher("java.util..*").matchesPackage("java.util.*")).isTrue();
            org.assertj.core.api.Assertions.assertThat((boolean)new TypeMatcher("java.util.List").matchesPackage("java.util.*")).isTrue();
        }

        @Test
        public static void exactMatch(@NotNull FindImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                  import java.util.concurrent.atomic.AtomicBoolean;\n                  class Test {\n                  }\n              ", (String)"\n                  /*~~>*/import java.util.concurrent.atomic.AtomicBoolean;\n                  class Test {\n                  }\n              ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void starImport(@NotNull FindImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                  import java.util.concurrent.atomic.*;\n                  class Test {\n                  }\n              ", (String)"\n                  /*~~>*/import java.util.concurrent.atomic.*;\n                  class Test {\n                  }\n              ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void starImportMatchesExact(@NotNull FindImportsTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                  import java.util.*;\n                  class Test {\n                  }\n              ", (String)"\n                  /*~~>*/import java.util.*;\n                  class Test {\n                  }\n              ")};
            this_.rewriteRun(DefaultImpls::starImportMatchesExact$lambda-0, sourceSpecsArray);
        }

        private static void starImportMatchesExact$lambda-0(RecipeSpec spec) {
            spec.recipe((Recipe)new FindImports("java.util.List"));
        }
    }
}

