/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.ReplaceLambdaWithMethodReference;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/java/cleanup/ReplaceLambdaWithMethodReferenceTest;", "Lorg/openrewrite/test/RewriteTest;", "castType", "", "containsMultipleStatements", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotReplaceInvocationWhichAcceptsArgument", "functionMultiParamReference", "functionReference", "instanceOf", "isEqualToNull", "lambdaReturnsFunctionalInterface", "multipleMethodInvocations", "nonStaticMethods", "notEqualToNull", "returnExpressionIsNotAMethodInvocation", "staticMethods", "systemOutPrint", "systemOutPrintInBlock", "typeCastOnMethodInvocationReturnType", "voidMethodReference", "rewrite-java-tck"})
public interface ReplaceLambdaWithMethodReferenceTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void multipleMethodInvocations();

    @Test
    public void containsMultipleStatements();

    @Test
    public void typeCastOnMethodInvocationReturnType();

    @Test
    public void instanceOf();

    @Test
    public void functionMultiParamReference();

    @Test
    public void nonStaticMethods();

    @Test
    public void staticMethods();

    @Test
    public void systemOutPrint();

    @Test
    public void systemOutPrintInBlock();

    @Test
    public void castType();

    @Test
    public void notEqualToNull();

    @Test
    public void isEqualToNull();

    @Test
    public void voidMethodReference();

    @Test
    public void functionReference();

    @Test
    public void returnExpressionIsNotAMethodInvocation();

    @Test
    public void lambdaReturnsFunctionalInterface();

    @Test
    public void doNotReplaceInvocationWhichAcceptsArgument();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull ReplaceLambdaWithMethodReferenceTest this_, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new ReplaceLambdaWithMethodReference());
        }

        @Test
        public static void multipleMethodInvocations(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.nio.file.Path;\n            import java.nio.file.Paths;\n            import java.util.List;import java.util.stream.Collectors;\n            \n            class Test {\n                Path path = Paths.get(\"\");\n                List<String> method(List<String> l) {\n                    return l.stream()\n                        .filter(s -> path.getFileName().toString().equals(s))\n                        .collect(Collectors.toList());\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void containsMultipleStatements(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            class Test {\n                List<Integer> even(List<Integer> l) {\n                    return l.stream().map(n -> {\n                        if (n % 2 == 0) return n;\n                        return n * 2;\n                    }).collect(Collectors.toList());\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void typeCastOnMethodInvocationReturnType(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n            import java.util.stream.Stream;\n\n            class Test {\n                public void foo() {\n                    List<String> bar = Stream.of(\"A\", \"b\")\n                            .map(s -> (String) s.toLowerCase())\n                            .collect(Collectors.toList());\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void instanceOf(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.test;\n            public class CheckType {\n            }\n        "), Assertions.java((String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> method(List<Object> input) {\n                    return input.stream().filter(n -> n instanceof CheckType).collect(Collectors.toList());\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> method(List<Object> input) {\n                    return input.stream().filter(CheckType.class::isInstance).collect(Collectors.toList());\n                }\n            }\n        ", DefaultImpls::instanceOf$lambda-1)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void functionMultiParamReference(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public interface ObservableValue<T> {\n            }\n        "), Assertions.java((String)"\n            @FunctionalInterface\n            public interface ChangeListener<T> {\n                void changed(ObservableValue<? extends T> observable, T oldValue, T newValue);\n            }\n        "), Assertions.java((String)"\n            import java.util.function.Function;\n            class Test {\n            \n                ChangeListener listener = (o, oldVal, newVal) -> {\n                    onChange(o, oldVal, newVal);\n                };\n                \n                protected void onChange(ObservableValue<?> o, Object oldVal, Object newVal) {\n                    String strVal = newVal.toString();\n                    System.out.println(strVal);\n                }\n            }\n        ", (String)"\n            import java.util.function.Function;\n            class Test {\n            \n                ChangeListener listener = this::onChange;\n                \n                protected void onChange(ObservableValue<?> o, Object oldVal, Object newVal) {\n                    String strVal = newVal.toString();\n                    System.out.println(strVal);\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void nonStaticMethods(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collections;\n            class Test {\n                Runnable r = () -> run();\n                public void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Test t = new Test();\n                Runnable r = () -> t.run();\n            }\n        ", (String)"\n            import java.util.Collections;\n            class Test {\n                Runnable r = this::run;\n                public void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Test t = new Test();\n                Runnable r = t::run;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void staticMethods(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.Collections;\n            class Test {\n                Runnable r = () -> run();\n                public static void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Runnable r = () -> Test.run();\n            }\n        ", (String)"\n            import java.util.Collections;\n            class Test {\n                Runnable r = Test::run;\n                public static void run() {\n                    Collections.singletonList(1).forEach(n -> run());\n                }\n            }\n            \n            class Test2 {\n                Runnable r = Test::run;\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void systemOutPrint(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    input.forEach(x -> System.out.println(x));\n                }\n            }\n        ", (String)"\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    input.forEach(System.out::println);\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void systemOutPrintInBlock(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    input.forEach(x -> { System.out.println(x); });\n                }\n            }\n        ", (String)"\n            import java.util.List;\n\n            class Test {\n                void method(List<Integer> input) {\n                    input.forEach(System.out::println);\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void castType(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package org.test;\n            public class CheckType {\n            }\n        "), Assertions.java((String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(CheckType.class::isInstance)\n                        .map(o -> (CheckType) o)\n                        .collect(Collectors.toList());\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            import org.test.CheckType;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(CheckType.class::isInstance)\n                        .map(CheckType.class::cast)\n                        .collect(Collectors.toList());\n                }\n            }\n        ", DefaultImpls::castType$lambda-3)};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void notEqualToNull(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(o -> o != null)\n                        .collect(Collectors.toList());\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            import java.util.Objects;\n            import java.util.stream.Collectors;\n\n            class Test {\n                List<Object> filter(List<Object> l) {\n                    return l.stream()\n                        .filter(Objects::nonNull)\n                        .collect(Collectors.toList());\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void isEqualToNull(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.stream.Collectors;\n\n            class Test {\n                boolean containsNull(List<Object> l) {\n                    return l.stream()\n                        .anyMatch(o -> o == null);\n                }\n            }\n        ", (String)"\n            import java.util.List;\n            import java.util.Objects;\n            import java.util.stream.Collectors;\n\n            class Test {\n                boolean containsNull(List<Object> l) {\n                    return l.stream()\n                        .anyMatch(Objects::isNull);\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void voidMethodReference(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                Runnable r = () -> {\n                    this.execute();\n                };\n\n                void execute() {}\n            }\n        ", (String)"\n            class Test {\n                Runnable r = this::execute;\n\n                void execute() {}\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void functionReference(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.function.Function;\n\n            class Test {\n                Function<Integer, String> f = (i) -> {\n                    return this.execute(i);\n                };\n                \n                String execute(Integer i) {\n                    return i.toString();\n                }\n            }\n        ", (String)"\n            import java.util.function.Function;\n\n            class Test {\n                Function<Integer, String> f = this::execute;\n                \n                String execute(Integer i) {\n                    return i.toString();\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void returnExpressionIsNotAMethodInvocation(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class T {\n                public void killBatchJob() {\n                    return deleteSparkBatchRequest()\n                            .map(resp -> {\n                                return this;\n                            })\n                            .defaultIfEmpty(this);\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void lambdaReturnsFunctionalInterface(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package abc;\n            @FunctionalInterface\n            public interface MyFunction {\n                String get();\n            }\n        "), Assertions.java((String)"\n            package abc;\n            \n            class M {\n                MyFunction getFunction(String fcn) {\n                    return () -> fcn;\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotReplaceInvocationWhichAcceptsArgument(@NotNull ReplaceLambdaWithMethodReferenceTest this_) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n\n            class A {\n                void foo() {\n                    new ArrayList<List<Integer>>().stream()\n                            .map(it -> it.addAll(Arrays.asList(1, 2, 3)));\n                }\n            }\n        ")};
            this_.rewriteRun(sourceSpecsArray);
        }

        private static void instanceOf$lambda-1$lambda-0(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            Expression expression = ((J.Return)e2).getExpression();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            Expression expression2 = ((J.MethodInvocation)expression).getSelect();
            if (expression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            Object e3 = ((J.MethodInvocation)expression2).getArguments().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MemberReference");
            }
            Expression expression3 = ((J.MemberReference)e3).getContaining();
            if (expression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            Expression expression4 = ((J.FieldAccess)expression3).getTarget();
            if (expression4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            }
            JavaType javaType = ((J.Identifier)expression4).getType();
            Intrinsics.checkNotNull((Object)javaType);
            String value = javaType.toString();
            org.assertj.core.api.Assertions.assertThat((String)value).isEqualTo("org.test.CheckType");
        }

        private static void instanceOf$lambda-1(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::instanceOf$lambda-1$lambda-0);
        }

        private static void castType$lambda-3$lambda-2(J.CompilationUnit cu) {
            Object e = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            }
            J.Block block2 = ((J.MethodDeclaration)e).getBody();
            Intrinsics.checkNotNull((Object)block2);
            Object e2 = block2.getStatements().get(0);
            if (e2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            Expression expression = ((J.Return)e2).getExpression();
            if (expression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            Expression expression2 = ((J.MethodInvocation)expression).getSelect();
            if (expression2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodInvocation");
            }
            Object e3 = ((J.MethodInvocation)expression2).getArguments().get(0);
            if (e3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MemberReference");
            }
            Expression expression3 = ((J.MemberReference)e3).getContaining();
            if (expression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.FieldAccess");
            }
            Expression expression4 = ((J.FieldAccess)expression3).getTarget();
            if (expression4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Identifier");
            }
            JavaType javaType = ((J.Identifier)expression4).getType();
            Intrinsics.checkNotNull((Object)javaType);
            String value = javaType.toString();
            org.assertj.core.api.Assertions.assertThat((String)value).isEqualTo("org.test.CheckType");
        }

        private static void castType$lambda-3(SourceSpec spec) {
            spec.afterRecipe(DefaultImpls::castType$lambda-3$lambda-2);
        }
    }
}

