/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.ChangeTypeTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b'\bf\u0018\u0000 C2\u00020\u0001:\u0001CJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u0014\u001a\u00020\u0007H\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u0010\u001b\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010 \u001a\u00020\u0007H\u0017J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010&\u001a\u00020\u0007H\u0017J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u0010(\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u0010*\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0012\u0010+\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u00100\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u00101\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u00102\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0012\u00103\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0012\u00104\u001a\u00020\u00072\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u00105\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u00106\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u00107\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u00108\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u00109\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010?\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010@\u001a\u00020\u0007H\u0017J\b\u0010A\u001a\u00020\u0007H\u0017J\u0010\u0010B\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006D"}, d2={"Lorg/openrewrite/java/ChangeTypeTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/ChangeType;", "getRecipe", "()Lorg/openrewrite/java/ChangeType;", "allowJavaLangSubpackages", "", "jp", "Lorg/openrewrite/java/JavaParser;", "annotation", "array", "array2", "assignment", "boundedGenericType", "changeConstructor", "changeInnerClassToOuterClass", "changeStaticFieldAccess", "changeTypeInTypeDeclaration", "changeTypeWithInnerClass", "checkValidation", "classDecl", "classReference", "classToPrimitive", "doNotAddJavaLangWrapperImports", "doNotChangeTypeInTypeDeclaration", "dontAddImportWhenNoChangesWereMade", "filePathMatchWithNoMatchedClassFqn", "tempDir", "Ljava/nio/file/Path;", "fullyQualifiedName", "importOrdering", "javadocs", "lambda", "method", "methodInvocationTypeParametersAndWildcard", "methodSelect", "multiCatch", "multiDimensionalArray", "multiVariable", "multipleLevelsOfInnerClasses", "newClass", "onlyChangeTypeMissingPublicModifier", "onlyChangeTypeWithoutMatchedFilePath", "onlyUpdateApplicableImport", "parameterizedType", "primitiveToClass", "renameClass", "renameClassAndFilePath", "renameInnerClass", "renamePackage", "renamePackageAndFilePath", "renamePackageAndInnerClassName", "replaceWithNestedType", "simpleName", "staticConstant", "staticImport", "staticImports2", "ternary", "typeCast", "unnecessaryImport", "updateAssignments", "updateClassPrefixWithEmptyPackage", "updateImportPrefixWithEmptyPackage", "updateMethodType", "updateVariableType", "uppercaseInPackage", "Companion", "rewrite-java-tck"})
public interface ChangeTypeTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangeTypeTest$Companion.$$INSTANCE;

    @NotNull
    public ChangeType getRecipe();

    @Test
    public void doNotAddJavaLangWrapperImports(@NotNull JavaParser var1);

    @Test
    public void allowJavaLangSubpackages(@NotNull JavaParser var1);

    @Test
    public void unnecessaryImport(@NotNull JavaParser var1);

    @Test
    public void changeInnerClassToOuterClass(@NotNull JavaParser var1);

    @Test
    public void changeStaticFieldAccess(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenNoChangesWereMade(@NotNull JavaParser var1);

    @Test
    public void replaceWithNestedType(@NotNull JavaParser var1);

    @Test
    public void simpleName(@NotNull JavaParser var1);

    @Test
    public void fullyQualifiedName(@NotNull JavaParser var1);

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array2(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void multiDimensionalArray();

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void updateAssignments(@NotNull JavaParser var1);

    @Test
    public void parameterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Test
    public void classReference(@NotNull JavaParser var1);

    @Test
    public void methodSelect(@NotNull JavaParser var1);

    @Test
    public void staticImport(@NotNull JavaParser var1);

    @Test
    public void staticImports2(@NotNull JavaParser var1);

    @Test
    public void staticConstant(@NotNull JavaParser var1);

    @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
    @Test
    public void primitiveToClass(@NotNull JavaParser var1);

    @Test
    public void classToPrimitive(@NotNull JavaParser var1);

    @Test
    public void importOrdering(@NotNull JavaParser var1);

    @Test
    public void changeTypeWithInnerClass(@NotNull JavaParser var1);

    @Test
    public void uppercaseInPackage(@NotNull JavaParser var1);

    @Test
    public void lambda(@NotNull JavaParser var1);

    @Test
    public void assignment(@NotNull JavaParser var1);

    @Test
    public void ternary(@NotNull JavaParser var1);

    @Test
    public void changeTypeInTypeDeclaration(@NotNull JavaParser var1);

    @Test
    public void doNotChangeTypeInTypeDeclaration(@NotNull JavaParser var1);

    @Test
    public void javadocs();

    @Test
    public void onlyUpdateApplicableImport(@NotNull JavaParser var1);

    @Test
    public void filePathMatchWithNoMatchedClassFqn(@TempDir @NotNull Path var1);

    @Test
    public void onlyChangeTypeMissingPublicModifier(@TempDir @NotNull Path var1);

    @Test
    public void onlyChangeTypeWithoutMatchedFilePath(@TempDir @NotNull Path var1);

    @Test
    public void renameClassAndFilePath(@TempDir @NotNull Path var1);

    @Test
    public void renamePackageAndFilePath(@TempDir @NotNull Path var1);

    @Test
    public void renamePackageAndInnerClassName(@TempDir @NotNull Path var1);

    @Test
    public void updateImportPrefixWithEmptyPackage(@NotNull JavaParser var1);

    @Test
    public void updateClassPrefixWithEmptyPackage(@NotNull JavaParser var1);

    @Test
    public void renameInnerClass(@NotNull JavaParser var1);

    @Test
    public void multipleLevelsOfInnerClasses(@TempDir @NotNull Path var1);

    @Test
    public void renamePackage(@NotNull JavaParser var1);

    @Test
    public void renameClass(@NotNull JavaParser var1);

    @Test
    public void updateMethodType();

    @Test
    public void updateVariableType();

    @Test
    public void boundedGenericType();

    @Test
    public void changeConstructor();

    @Test
    public void checkValidation();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/ChangeTypeTest$Companion;", "", "()V", "a1", "", "a2", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String a1;
        @NotNull
        private static final String a2;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            a1 = "package a;\npublic class A1 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
            a2 = "package a;\npublic class A2 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ChangeType getRecipe(@NotNull ChangeTypeTest this_) {
            return new ChangeType("a.A1", "a.A2", Boolean.valueOf(true));
        }

        @Test
        public static void doNotAddJavaLangWrapperImports(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("java.lang.Integer", "java.lang.Long", Boolean.valueOf(true)), null, "public class ThinkPositive { private Integer fred = 1;}", null, "public class ThinkPositive { private Long fred = 1;}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void allowJavaLangSubpackages(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("java.util.logging.LoggingMXBean", "java.lang.management.PlatformLoggingMXBean", Boolean.valueOf(true)), null, "\n            import java.util.logging.LoggingMXBean;\n\n            class Test {\n                static void method() {\n                    LoggingMXBean loggingBean = null;\n                }\n            }\n        ", null, "\n            import java.lang.management.PlatformLoggingMXBean;\n\n            class Test {\n                static void method() {\n                    PlatformLoggingMXBean loggingBean = null;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void unnecessaryImport(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package test;\n\npublic class Outer {\n    public static Outer of() {\n        return new Outer();\n    }\n\n    public static class Inner {\n    }\n}"};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)new ChangeType("test.Outer.Inner", "java.util.ArrayList", Boolean.valueOf(true)), null, "\n            import test.Outer;\n            \n            class Test {\n                private Outer p = Outer.of();\n                private Outer p2 = test.Outer.of();\n            }\n        ", stringArray, 4, null);
        }

        @Test
        public static void changeInnerClassToOuterClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("java.util.Map$Entry", "java.util.List", Boolean.valueOf(true)), null, "\n            import java.util.Map;\n            import java.util.Map.Entry;\n            \n            class Test {\n                Entry p;\n                Map.Entry p2;\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n                List p;\n                List p2;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void changeStaticFieldAccess(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("java.io.File", "my.pkg.List", Boolean.valueOf(true)), null, "\n            import java.io.File;\n            \n            class Test {\n                String p = File.separator;\n            }\n        ", null, "\n            import my.pkg.List;\n            \n            class Test {\n                String p = List.separator;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void dontAddImportWhenNoChangesWereMade(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, null, "public class B {}", null, 22, null);
        }

        @Test
        public static void replaceWithNestedType(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("java.io.File", "java.util.Map$Entry", Boolean.valueOf(true)), null, "\n            import java.io.File;\n            \n            class Test {\n                File p;\n            }\n        ", null, "\n            import java.util.Map;\n            \n            class Test {\n                Map.Entry p;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void simpleName(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B extends A1 {}\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B extends A2 {}\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void fullyQualifiedName(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "public class B extends a.A1 {}", stringArray2, "public class B extends a.A2 {}", 0, 0, null, null, 966, null);
        }

        @Test
        public static void annotation(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType("a.b.c.A1", "a.b.d.A2", Boolean.valueOf(true));
            String[] stringArray = new String[]{"package a.b.c;\npublic @interface A1 {}", "package a.b.d;\npublic @interface A2 {}"};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "@a.b.c.A1 public class B {}", stringArray2, "@a.b.d.A2 public class B {}", 0, 0, null, null, 964, null);
        }

        @Test
        public static void array2(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType("com.acme.product.Pojo", "com.acme.product.v2.Pojo", Boolean.valueOf(true));
            String[] stringArray = new String[]{"\n            package com.acme.product;\n            \n            public class Pojo {\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package com.acme.project.impl;\n            \n            import com.acme.product.Pojo;\n            \n            public class UsePojo2 {\n                Pojo[] p;\n            \n                void run() {\n                    p[0] = null;\n                }\n            }\n        ", stringArray2, "\n            package com.acme.project.impl;\n            \n            import com.acme.product.v2.Pojo;\n            \n            public class UsePojo2 {\n                Pojo[] p;\n            \n                void run() {\n                    p[0] = null;\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void array(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               A2[] a = new A2[0];\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void multiDimensionalArray(@NotNull ChangeTypeTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import a.A1;\n            \n            public class A {\n                A1[][] multiDimensionalArray;\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class A {\n                A2[][] multiDimensionalArray;\n            }\n        ", 0, 0, null, multiDimensionalArray.1.INSTANCE, 455, null);
        }

        @Test
        public static void classDecl(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2, "public interface I1 {}", "public interface I2 {}"};
            Recipe recipe3 = recipe2;
            recipe2 = this_.getRecipe().doNext((Recipe)new ChangeType("I1", "I2", Boolean.valueOf(true)));
            JavaRecipeTest javaRecipeTest = this_;
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"doNext(\n            Chan\u20261\", \"I2\", true)\n        )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, null, "\n            import a.A1;\n            \n            public class B extends A1 implements I1 {}\n        ", (String[])recipe3, "\n            import a.A2;\n            \n            public class B extends A2 implements I2 {}\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void method(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               public A2 foo() throws A2 { return null; }\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in);\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, true);\n               }\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               public <T extends A2> T generic(T n, List<? super A2> in);\n               public void test() {\n                   A2.stat();\n                   this.<A2>generic(null, true);\n               }\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void multiCatch(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               public void test() {\n                   try {}\n                   catch(A2 | RuntimeException e) {}\n               }\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void multiVariable(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               A1 f1, f2;\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               A2 f1, f2;\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void newClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               A1 a = new A1();\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               A2 a = new A2();\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void updateAssignments(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n\n            class B {\n                void method(A1 param) {\n                    A1 a = param;\n                }\n            }\n        ", stringArray2, "\n            import a.A2;\n\n            class B {\n                void method(A2 param) {\n                    A2 a = param;\n                }\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void parameterizedType(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               Map<A1, A1> m;\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               Map<A2, A2> m;\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void typeCast(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               A1 a = (A1) null;\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               A2 a = (A2) null;\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void classReference(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class A {\n                Class<?> clazz = A1.class;\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class A {\n                Class<?> clazz = A2.class;\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void methodSelect(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import a.A1;\n            \n            public class B {\n               A1 a = null;\n               public void test() { a.foo(); }\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B {\n               A2 a = null;\n               public void test() { a.foo(); }\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void staticImport(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, null, "\n            import static a.A1.stat;\n            \n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", stringArray2, "\n            import static a.A2.stat;\n            \n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", 0, 0, null, null, 966, null);
        }

        @Test
        public static void staticImports2(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType("com.acme.product.RunnableFactory", "com.acme.product.v2.RunnableFactory", Boolean.valueOf(true));
            String[] stringArray = new String[]{"\n            package com.acme.product;\n            \n            public class RunnableFactory {\n                public static String getString() {\n                    return \"hello\";\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package com.acme.project.impl;\n            \n            import static com.acme.product.RunnableFactory.getString;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    getString().toLowerCase();\n                }\n            }\n        ", stringArray2, "\n            package com.acme.project.impl;\n            \n            import static com.acme.product.v2.RunnableFactory.getString;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    getString().toLowerCase();\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void staticConstant(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType("com.acme.product.RunnableFactory", "com.acme.product.v2.RunnableFactory", Boolean.valueOf(true));
            String[] stringArray = new String[]{"\n            package com.acme.product;\n            \n            public class RunnableFactory {\n                public static final String CONSTANT = \"hello\";\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package com.acme.project.impl;\n            \n            import static com.acme.product.RunnableFactory.CONSTANT;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    System.out.println(CONSTANT + \" fred.\");\n                }\n            }\n        ", stringArray2, "\n            package com.acme.project.impl;\n            \n            import static com.acme.product.v2.RunnableFactory.CONSTANT;\n            \n            public class StaticImportWorker {\n                public void work() {\n                    System.out.println(CONSTANT + \" fred.\");\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
        @Test
        public static void primitiveToClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("int", "java.lang.Integer", Boolean.valueOf(true)), null, "\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ", null, "\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void classToPrimitive(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("java.lang.Integer", "int", Boolean.valueOf(true)), null, "\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ", null, "\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void importOrdering(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType("com.yourorg.a.A", "com.myorg.b.B", Boolean.valueOf(true));
            String[] stringArray = new String[]{"\n            package com.yourorg.a;\n            public class A {}\n        ", "\n            package com.myorg.b;\n            public class B {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package com.myorg;\n\n            import java.util.ArrayList;\n            import com.yourorg.a.A;\n            import java.util.List;\n            \n            public class Foo {\n                List<A> a = new ArrayList<>();\n            }\n        ", stringArray2, "\n            package com.myorg;\n\n            import com.myorg.b.B;\n\n            import java.util.ArrayList;\n            import java.util.List;\n            \n            public class Foo {\n                List<B> a = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void changeTypeWithInnerClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType[]{"\n                package com.acme.product;\n                \n                public class OuterClass {\n                    public static class InnerClass {\n                \n                    }\n                }\n            "};
            ChangeType changeType2 = changeType;
            changeType = new ChangeType("com.acme.product.OuterClass", "com.acme.product.v2.OuterClass", Boolean.valueOf(true));
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package de;\n            \n            import com.acme.product.OuterClass.InnerClass;\n            import com.acme.product.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ", (String[])changeType2, "\n            package de;\n\n            import com.acme.product.v2.OuterClass.InnerClass;\n            import com.acme.product.v2.OuterClass;\n            \n            public class UseInnerClass {\n                public String work() {\n                    return new InnerClass().toString();\n                }\n            \n                public String work2() {\n                    return new OuterClass().toString();\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void uppercaseInPackage(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType[]{"\n                package com.acme.product.util.accessDecision;\n                \n                public enum AccessVote {\n                    ABSTAIN\n                }\n            "};
            ChangeType changeType2 = changeType;
            changeType = new ChangeType("com.acme.product.util.accessDecision.AccessVote", "com.acme.product.v2.util.accessDecision.AccessVote", Boolean.valueOf(true));
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package de;\n            \n            import com.acme.product.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote() {\n                    return AccessVote.ABSTAIN;\n                }\n            }\n        ", (String[])changeType2, "\n            package de;\n\n            import com.acme.product.v2.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote() {\n                    return AccessVote.ABSTAIN;\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void lambda(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType[]{"\n                package com.acme.product;\n                public interface Procedure {\n                    void execute();\n                }\n            "};
            ChangeType changeType2 = changeType;
            changeType = new ChangeType("com.acme.product.Procedure", "com.acme.product.Procedure2", Boolean.valueOf(true));
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            import com.acme.product.Procedure;\n            \n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {\n                    });\n                }\n                abstract void worker(Procedure callback);\n            }\n        ", (String[])changeType2, "\n            import com.acme.product.Procedure2;\n            \n            public abstract class Worker {\n                void callWorker() {\n                    worker(() -> {\n                    });\n                }\n                abstract void worker(Procedure2 callback);\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void assignment(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType[]{"\n                package com.acme.product.util.accessDecision;\n                \n                public enum AccessVote {\n                    ABSTAIN,\n                    GRANT\n                }\n            "};
            ChangeType changeType2 = changeType;
            changeType = new ChangeType("com.acme.product.util.accessDecision.AccessVote", "com.acme.product.v2.util.accessDecision.AccessVote", Boolean.valueOf(true));
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package de;\n            \n            import com.acme.product.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    AccessVote fred;\n                    fred = (AccessVote) input;\n                    return fred;\n                }\n            }\n        ", (String[])changeType2, "\n            package de;\n\n            import com.acme.product.v2.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    AccessVote fred;\n                    fred = (AccessVote) input;\n                    return fred;\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void ternary(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType[]{"\n                package com.acme.product.util.accessDecision;\n                \n                public enum AccessVote {\n                    ABSTAIN,\n                    GRANT\n                }\n            "};
            ChangeType changeType2 = changeType;
            changeType = new ChangeType("com.acme.product.util.accessDecision.AccessVote", "com.acme.product.v2.util.accessDecision.AccessVote", Boolean.valueOf(true));
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            package de;\n            \n            import com.acme.product.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    return input == null ? AccessVote.GRANT : AccessVote.ABSTAIN;\n                }\n            }\n        ", (String[])changeType2, "\n            package de;\n\n            import com.acme.product.v2.util.accessDecision.AccessVote;\n\n            public class ProjectVoter {\n                public AccessVote vote(Object input) {\n                    return input == null ? AccessVote.GRANT : AccessVote.ABSTAIN;\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void changeTypeInTypeDeclaration(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)new ChangeType("de.Class2", "de.Class1", Boolean.valueOf(false)), null, "\n            package de;\n            public class Class2 {}\n        ", null, "\n            package de;\n            public class Class1 {}\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doNotChangeTypeInTypeDeclaration(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, (Recipe)new ChangeType("de.Class2", "de.Class1", Boolean.valueOf(true)), null, "\n            package de;\n            public class Class2 {}\n        ", null, 20, null);
        }

        @Test
        public static void javadocs(@NotNull ChangeTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new ChangeType("java.util.List", "java.util.Collection", Boolean.valueOf(true)), null, "\n            import java.util.List;\n            \n            /**\n             * {@link List} here\n             */\n            class Test {\n                int n;\n            }\n        ", null, "\n            import java.util.Collection;\n            \n            /**\n             * {@link Collection} here\n             */\n            class Test {\n                int n;\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void onlyUpdateApplicableImport(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType[]{"\n            package com.acme.product.factory;\n\n            public class V1Factory {\n                public static String getItem() {\n                    return \"V1Factory\";\n                }\n            }\n        ", "\n            package com.acme.product.factory;\n\n            public class V2Factory {\n                public static String getItem() {\n                    return \"V2Factory\";\n                }\n            }\n        "};
            ChangeType changeType2 = changeType;
            changeType = new ChangeType("com.acme.product.factory.V1Factory", "com.acme.product.factory.V1FactoryA", Boolean.valueOf(true));
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)changeType, null, "\n            import com.acme.product.factory.V1Factory;\n\n            import static com.acme.product.factory.V2Factory.getItem;\n\n            public class UseFactories {\n                static class MyV1Factory extends V1Factory {\n                    static String getMyItemInherited() {\n                        return getItem();\n                    }\n                }\n\n                static String getMyItemStaticImport() {\n                    return getItem();\n                }\n            }\n        ", (String[])changeType2, "\n            import com.acme.product.factory.V1FactoryA;\n\n            import static com.acme.product.factory.V2Factory.getItem;\n\n            public class UseFactories {\n                static class MyV1Factory extends V1FactoryA {\n                    static String getMyItemInherited() {\n                        return getItem();\n                    }\n                }\n\n                static String getMyItemStaticImport() {\n                    return getItem();\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void filePathMatchWithNoMatchedClassFqn(@NotNull ChangeTypeTest this_, @TempDir @NotNull Path tempDir) {
            void $this$filePathMatchWithNoMatchedClassFqn_u24lambda_u2d0;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            ExecutionContext executionContext = null;
            Recipe recipe2 = (Recipe)new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false));
            Parser parser = null;
            RecipeTest recipeTest = this_;
            boolean bl = false;
            $this$filePathMatchWithNoMatchedClassFqn_u24lambda_u2d0.toFile().getParentFile().mkdirs();
            File file = $this$filePathMatchWithNoMatchedClassFqn_u24lambda_u2d0.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a;\npublic class NoMatch {\n}", null, (int)2, null);
            Unit unit = Unit.INSTANCE;
            File file2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir.resolve(\"a/b/Ori\u2026ent())\n        }.toFile()");
            RecipeTest.DefaultImpls.assertUnchangedBase$default((RecipeTest)recipeTest, parser, (Recipe)recipe2, executionContext, (File)file2, null, null, (int)53, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void onlyChangeTypeMissingPublicModifier(@NotNull ChangeTypeTest this_, @TempDir @NotNull Path tempDir) {
            void $this$onlyChangeTypeMissingPublicModifier_u24lambda_u2d1;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            ExecutionContext executionContext = null;
            Recipe recipe2 = (Recipe)new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false));
            JavaParser javaParser = null;
            JavaRecipeTest javaRecipeTest = this_;
            boolean bl = false;
            $this$onlyChangeTypeMissingPublicModifier_u24lambda_u2d1.toFile().getParentFile().mkdirs();
            File file = $this$onlyChangeTypeMissingPublicModifier_u24lambda_u2d1.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\nclass Original {\n}", null, (int)2, null);
            Unit unit = Unit.INSTANCE;
            File file2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir.resolve(\"a/b/Ori\u2026ent())\n        }.toFile()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, recipe2, executionContext, file2, null, null, "package x.y;\nclass Target {\n}", 0, 0, null, onlyChangeTypeMissingPublicModifier.2.INSTANCE, 949, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void onlyChangeTypeWithoutMatchedFilePath(@NotNull ChangeTypeTest this_, @TempDir @NotNull Path tempDir) {
            void $this$onlyChangeTypeWithoutMatchedFilePath_u24lambda_u2d2;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/NoMatch.java");
            ExecutionContext executionContext = null;
            Recipe recipe2 = (Recipe)new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false));
            JavaParser javaParser = null;
            JavaRecipeTest javaRecipeTest = this_;
            boolean bl = false;
            $this$onlyChangeTypeWithoutMatchedFilePath_u24lambda_u2d2.toFile().getParentFile().mkdirs();
            File file = $this$onlyChangeTypeWithoutMatchedFilePath_u24lambda_u2d2.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class Original {\n}", null, (int)2, null);
            Unit unit = Unit.INSTANCE;
            File file2 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempDir.resolve(\"a/b/NoM\u2026ent())\n        }.toFile()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, recipe2, executionContext, file2, null, null, "package x.y;\npublic class Target {\n}", 0, 0, null, onlyChangeTypeWithoutMatchedFilePath.2.INSTANCE, 949, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void renameClassAndFilePath(@NotNull ChangeTypeTest this_, @TempDir @NotNull Path tempDir) {
            void $this$renameClassAndFilePath_u24lambda_u2d3;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            JavaParser javaParser = this_.getParser();
            boolean bl = false;
            $this$renameClassAndFilePath_u24lambda_u2d3.toFile().getParentFile().mkdirs();
            File file = $this$renameClassAndFilePath_u24lambda_u2d3.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class Original {\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.Original", "x.y.Target", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)renameClassAndFilePath.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/Original.java b/x/y/Target.java\nsimilarity index 0%\nrename from a/b/Original.java\nrename to x/y/Target.java\nindex 49dd697..65e689d 100644\n--- a/a/b/Original.java\n+++ b/x/y/Target.java\n@@ -1,3 +1,3 @@ org.openrewrite.java.ChangeType\n-package a.b;\n-public class Original {\n+package x.y;\n+public class Target {\n }\n\\ No newline at end of file" + '\n');
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void renamePackageAndFilePath(@NotNull ChangeTypeTest this_, @TempDir @NotNull Path tempDir) {
            void $this$renamePackageAndFilePath_u24lambda_u2d4;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/Original.java");
            JavaParser javaParser = this_.getParser();
            boolean bl = false;
            $this$renamePackageAndFilePath_u24lambda_u2d4.toFile().getParentFile().mkdirs();
            File file = $this$renamePackageAndFilePath_u24lambda_u2d4.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class Original {\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.Original", "x.y.Original", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)renamePackageAndFilePath.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/Original.java b/x/y/Original.java\nsimilarity index 0%\nrename from a/b/Original.java\nrename to x/y/Original.java\nindex 49dd697..02e6a06 100644\n--- a/a/b/Original.java\n+++ b/x/y/Original.java\n@@ -1,3 +1,3 @@ org.openrewrite.java.ChangeType\n-package a.b;\n+package x.y;\n public class Original {\n }\n\\ No newline at end of file" + '\n');
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void renamePackageAndInnerClassName(@NotNull ChangeTypeTest this_, @TempDir @NotNull Path tempDir) {
            void $this$renamePackageAndInnerClassName_u24lambda_u2d5;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/C.java");
            JavaParser javaParser = this_.getParser();
            boolean bl = false;
            $this$renamePackageAndInnerClassName_u24lambda_u2d5.toFile().getParentFile().mkdirs();
            File file = $this$renamePackageAndInnerClassName_u24lambda_u2d5.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class C {\n    public static class Original {\n    }\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.C$Original", "x.y.C$Target", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)renamePackageAndInnerClassName.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/C.java b/x/y/C.java\nsimilarity index 0%\nrename from a/b/C.java\nrename to x/y/C.java\nindex 7b428dc..56a5c53 100644\n--- a/a/b/C.java\n+++ b/x/y/C.java\n@@ -1,5 +1,5 @@ org.openrewrite.java.ChangeType\n-package a.b;\n+package x.y;\n public class C {\n-    public static class Original {\n+    public static class Target {\n     }\n }\n\\ No newline at end of file" + '\n');
        }

        @Test
        public static void updateImportPrefixWithEmptyPackage(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new ChangeType("a.b.Original", "Target", Boolean.valueOf(false)), null, "\n            package a.b;\n            \n            import java.util.List;\n            \n            class Original {\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Target {\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void updateClassPrefixWithEmptyPackage(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new ChangeType("a.b.Original", "Target", Boolean.valueOf(false)), null, "\n            package a.b;\n            \n            class Original {\n            }\n        ", null, "\n            class Target {\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void renameInnerClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new ChangeType("a.b.C$Original", "a.b.C$Target", Boolean.valueOf(false)), null, "\n            package a.b;\n            public class C {\n                public static class Original {\n                }\n            }\n        ", null, "\n            package a.b;\n            public class C {\n                public static class Target {\n                }\n            }\n        ", 0, 0, null, null, 981, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void multipleLevelsOfInnerClasses(@NotNull ChangeTypeTest this_, @TempDir @NotNull Path tempDir) {
            void $this$multipleLevelsOfInnerClasses_u24lambda_u2d6;
            Path path;
            Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
            Path path2 = path = tempDir.resolve("a/b/C.java");
            JavaParser javaParser = this_.getParser();
            boolean bl = false;
            $this$multipleLevelsOfInnerClasses_u24lambda_u2d6.toFile().getParentFile().mkdirs();
            File file = $this$multipleLevelsOfInnerClasses_u24lambda_u2d6.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
            FilesKt.writeText$default((File)file, (String)"package a.b;\npublic class C {\n    public static class D {\n        public static class Original {\n        }\n    }\n}", null, (int)2, null);
            List sources = javaParser.parse((Iterable)CollectionsKt.listOf((Object)path), tempDir, (ExecutionContext)new InMemoryExecutionContext());
            List results2 = new ChangeType("a.b.C$D$Original", "x.y.C$D$Target", Boolean.valueOf(false)).run(sources).getResults();
            Intrinsics.checkNotNullExpressionValue((Object)results2, (String)"results");
            Assertions.assertThat((String)CollectionsKt.joinToString$default((Iterable)results2, (CharSequence)"", null, null, (int)0, null, (Function1)multipleLevelsOfInnerClasses.1.INSTANCE, (int)30, null)).isEqualTo("diff --git a/a/b/C.java b/x/y/C.java\nsimilarity index 0%\nrename from a/b/C.java\nrename to x/y/C.java\nindex 22bd92f..816d6b1 100644\n--- a/a/b/C.java\n+++ b/x/y/C.java\n@@ -1,7 +1,7 @@ org.openrewrite.java.ChangeType\n-package a.b;\n+package x.y;\n public class C {\n     public static class D {\n-        public static class Original {\n+        public static class Target {\n         }\n     }\n }\n\\ No newline at end of file" + '\n');
        }

        @Test
        public static void renamePackage(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new ChangeType("a.b.Original", "x.y.Original", Boolean.valueOf(false)), null, "\n            package a.b;\n            class Original {\n            }\n        ", null, "\n            package x.y;\n            class Original {\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void renameClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new ChangeType("a.b.Original", "a.b.Target", Boolean.valueOf(false)), null, "\n            package a.b;\n            class Original {\n            }\n        ", null, "\n            package a.b;\n            class Target {\n            }\n        ", 0, 0, null, null, 981, null);
        }

        @Test
        public static void updateMethodType(@NotNull ChangeTypeTest this_) {
            ChangeType changeType = new ChangeType("a.A1", "a.A2", Boolean.valueOf(false));
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 {\n            }\n            ", "\n            package org.foo;\n            \n            import a.A1;\n            \n            public class Example {\n                public A1 method(A1 a1) {\n                    return a1;\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)changeType, null, "\n            import a.A1;\n            import org.foo.Example;\n            \n            public class Test {\n                A1 local = new Example().method(null);\n            }\n        ", stringArray2, "\n            import a.A2;\n            import org.foo.Example;\n            \n            public class Test {\n                A2 local = new Example().method(null);\n            }\n        ", 0, 0, null, updateMethodType.1.INSTANCE, 453, null);
        }

        @Test
        public static void updateVariableType(@NotNull ChangeTypeTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import a.A1;\n            \n            public class Test {\n                A1 a;\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class Test {\n                A2 a;\n            }\n        ", 0, 0, null, updateVariableType.1.INSTANCE, 455, null);
        }

        @Test
        public static void boundedGenericType(@NotNull ChangeTypeTest this_) {
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, null, "\n            import a.A1;\n            \n            public class Test {\n                <T extends A1> T method(T t) {\n                    return t;\n                }\n            }\n        ", stringArray2, "\n            import a.A2;\n            \n            public class Test {\n                <T extends A2> T method(T t) {\n                    return t;\n                }\n            }\n        ", 0, 0, null, boundedGenericType.1.INSTANCE, 455, null);
        }

        @Test
        public static void changeConstructor(@NotNull ChangeTypeTest this_) {
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, (Recipe)new ChangeType("a.A1", "a.A2", Boolean.valueOf(false)), null, "\n            package a;\n            \n            public class A1 {\n                public A1() {\n                }\n            }\n        ", null, "\n            package a;\n            \n            public class A2 {\n                public A2() {\n                }\n            }\n        ", 0, 0, null, changeConstructor.1.INSTANCE, 469, null);
        }

        @Test
        public static void checkValidation(@NotNull ChangeTypeTest this_) {
            ChangeType recipe2 = new ChangeType(null, null, Boolean.valueOf(true));
            Validated valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newFullyQualifiedTypeName");
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(1)).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType(null, "java.lang.String", Boolean.valueOf(true));
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType("java.lang.String", null, Boolean.valueOf(true));
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newFullyQualifiedTypeName");
        }

        @NotNull
        public static JavaParser getParser(@NotNull ChangeTypeTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ChangeTypeTest this_) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ChangeTypeTest this_) {
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ChangeTypeTest this_) {
            JavaRecipeTest.DefaultImpls.afterRecipe(this_);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ChangeTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ChangeTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ChangeTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ChangeTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ChangeTypeTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ChangeTypeTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }
    }
}

